<?xml version="1.0" encoding="UTF-8"?>
<!--
Schematron
Generated by CoreFiling: generator revision 605498
Fri Oct 31 11:17:08 GMT 2025
-->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="exslt">
  <sch:title>Schematron for MTR</sch:title>
  <sch:ns prefix="hd" uri="http://www.govtalk.gov.uk/CM/envelope"/>
  <sch:ns prefix="dsig" uri="http://www.w3.org/2000/09/xmldsig#"/>
  <sch:ns prefix="MTR" uri="http://www.govtalk.gov.uk/taxation/SA/SA100/25-26/1"/>
    <sch:pattern id="p2">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:IRheader/MTR:Keys/MTR:Key">
        <sch:assert test="count(../../../../../hd:GovTalkDetails/hd:Keys/hd:Key[@Type = current()/@Type and . = current()]) &gt; 0" id="a_header.r1004" diagnostics="errorCode.header.r1004 transactional.header.r1004 transactional.en.header.r1004 ">Keys in the IR header must also exist in the GovTalk header with the same value</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p1">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:IRheader">
        <sch:assert test="count(MTR:Keys/MTR:Key) &gt; 0" id="a_header.r1005" diagnostics="errorCode.header.r1005 transactional.header.r1005 transactional.en.header.r1005 ">At least one key must exist in the IRheader</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p5">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:YourPersonalDetails/MTR:DateOfBirth">
        <sch:assert test="(round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(&quot;2026-04-05&quot;)) div 86400))" id="a_ITF1-TAXPAYER-DATE-OF-BIRTH.0" diagnostics="errorCode.ITF1-TAXPAYER-DATE-OF-BIRTH.0 transactional.ITF1-TAXPAYER-DATE-OF-BIRTH.0 transactional.en.ITF1-TAXPAYER-DATE-OF-BIRTH.0 ">[YPD1] must be on or before the end of the return year.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p6">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:YourPersonalDetails/MTR:NewAddress/MTR:AddressLine4">
        <sch:assert test="../MTR:AddressLine1 and ../MTR:AddressLine2 and ../MTR:AddressLine3" id="a_Included_in_ITF-TAXPAYER-ADDRESS-TEXT-3.1" diagnostics="errorCode.Included_in_ITF-TAXPAYER-ADDRESS-TEXT-3.1 transactional.Included_in_ITF-TAXPAYER-ADDRESS-TEXT-3.1 transactional.en.Included_in_ITF-TAXPAYER-ADDRESS-TEXT-3.1 ">If [A14] present then [A11], [A12] and [A13] must be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p7">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:YourPersonalDetails/MTR:NewAddress/MTR:EffectiveFrom">
        <sch:assert test="(round(date:seconds(normalize-space(.)) div 86400) &lt;= round(date:seconds(normalize-space(date:date())) div 86400))" id="a_ITF-EFFECTIVE-DATE.0" diagnostics="errorCode.ITF-EFFECTIVE-DATE.0 transactional.ITF-EFFECTIVE-DATE.0 transactional.en.ITF-EFFECTIVE-DATE.0 ">[YPD2] must be on or before the current date.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p8">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:YourTaxReturn/MTR:EmploymentSchedule">
        <sch:assert test="../MTR:NumberOfEmploymentSchedules" id="a_ITF4-EMPLOYMENT-SCH-REQD-SIG.0" diagnostics="errorCode.ITF4-EMPLOYMENT-SCH-REQD-SIG.0 transactional.ITF4-EMPLOYMENT-SCH-REQD-SIG.0 transactional.en.ITF4-EMPLOYMENT-SCH-REQD-SIG.0 ">If [YTR1.1A] is present, [YTR1.1B] must be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p9">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:YourTaxReturn/MTR:FullSelfEmploymentSchedule">
        <sch:assert test="../MTR:NumberOfFullSelfEmploymentSchedules" id="a_RTN-SELF-EMPLOYMENT-QTY.0" diagnostics="errorCode.RTN-SELF-EMPLOYMENT-QTY.0 transactional.RTN-SELF-EMPLOYMENT-QTY.0 transactional.en.RTN-SELF-EMPLOYMENT-QTY.0 ">Number of full self employment schedules should be present if [YTR2.2A]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p10">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:YourTaxReturn/MTR:ShortSelfEmploymentSchedule">
        <sch:assert test="../MTR:NumberOfShortSelfEmploymentSchedules" id="a_ITF-SHORT-SELF-E-SCH-REQD-SIG.0" diagnostics="errorCode.ITF-SHORT-SELF-E-SCH-REQD-SIG.0 transactional.ITF-SHORT-SELF-E-SCH-REQD-SIG.0 transactional.en.ITF-SHORT-SELF-E-SCH-REQD-SIG.0 ">If [YTR2A.2A] present then [YTR2A.2B] must be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p11">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:YourTaxReturn/MTR:FullPartnershipSchedule">
        <sch:assert test="../MTR:NumberOfFullPartnershipSchedules" id="a_RTN-PARTNER-INCOME-QTY.0" diagnostics="errorCode.RTN-PARTNER-INCOME-QTY.0 transactional.RTN-PARTNER-INCOME-QTY.0 transactional.en.RTN-PARTNER-INCOME-QTY.0 ">Number of full partnership schedules should be present if [YTR3.3A]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p12">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:YourTaxReturn/MTR:ShortPartnershipSchedule">
        <sch:assert test="../MTR:NumberOfShortPartnershipSchedules" id="a_ITF4-SHORT-PSHIP-SCH-REQD-SIG.0" diagnostics="errorCode.ITF4-SHORT-PSHIP-SCH-REQD-SIG.0 transactional.ITF4-SHORT-PSHIP-SCH-REQD-SIG.0 transactional.en.ITF4-SHORT-PSHIP-SCH-REQD-SIG.0 ">If [YTR3A.3A] present then [YTR3A.3B] must be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p13">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:StudentLoanRepayments/MTR:StudentLoanRepaymentDeductedAmount">
        <sch:assert test="../MTR:IncomeContingentStudentLoanNotification = &apos;yes&apos;" id="a_MPL4-STUDENT-LOAN-EMPT-DED-AMO.0" diagnostics="errorCode.MPL4-STUDENT-LOAN-EMPT-DED-AMO.0 transactional.MPL4-STUDENT-LOAN-EMPT-DED-AMO.0 transactional.en.MPL4-STUDENT-LOAN-EMPT-DED-AMO.0 ">If [SLR2] is present, [SLR1] should be 'yes'.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p14">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:StudentLoanRepayments/MTR:PostgraduateLoanRepaymentDeductedAmount">
        <sch:assert test="../MTR:IncomeContingentStudentLoanNotification = &apos;yes&apos;" id="a_ITF-PGL-EMPT-DED-AMO.0" diagnostics="errorCode.ITF-PGL-EMPT-DED-AMO.0 transactional.ITF-PGL-EMPT-DED-AMO.0 transactional.en.ITF-PGL-EMPT-DED-AMO.0 ">If [SLR3] is present, [SLR1] should be 'yes'.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p15">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:StudentLoanRepayments/MTR:PlanType">
        <sch:assert test="../MTR:IncomeContingentStudentLoanNotification" id="a_ITF-STUDENT-LOAN-PLAN-TYPE-NO.0" diagnostics="errorCode.ITF-STUDENT-LOAN-PLAN-TYPE-NO.0 transactional.ITF-STUDENT-LOAN-PLAN-TYPE-NO.0 transactional.en.ITF-STUDENT-LOAN-PLAN-TYPE-NO.0 ">If [SLRPT] is present then [SLR1] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p16">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:StudentLoanRepayments/MTR:PostgraduateLoanPlanType">
        <sch:assert test="../MTR:IncomeContingentStudentLoanNotification" id="a_ITF-PGL-PLAN-TYPE-NO.0" diagnostics="errorCode.ITF-PGL-PLAN-TYPE-NO.0 transactional.ITF-PGL-PLAN-TYPE-NO.0 transactional.en.ITF-PGL-PLAN-TYPE-NO.0 ">If [PGLRPT] is present, [SLR1] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p17">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:Income/MTR:UKInterestAndDividends/MTR:UntaxedForeignInterest">
        <sch:assert test=". &lt;= 2000" id="a_ITF-FRGN-INV-INT-PAID-GROSS.0" diagnostics="errorCode.ITF-FRGN-INV-INT-PAID-GROSS.0 transactional.ITF-FRGN-INV-INT-PAID-GROSS.0 transactional.en.ITF-FRGN-INV-INT-PAID-GROSS.0 ">[INC3] is valid only if this does not exceed [£2,000]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p18">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:Income/MTR:UKInterestAndDividends/MTR:TaxTakenOffForeignDividends">
        <sch:assert test="((.) - (sum(../MTR:ForeignDividends) + 1) &lt; 0.001)" id="a_ITF-FOREIGN-DIV-TAX-PAID-AMT.0" diagnostics="errorCode.ITF-FOREIGN-DIV-TAX-PAID-AMT.0 transactional.ITF-FOREIGN-DIV-TAX-PAID-AMT.0 transactional.en.ITF-FOREIGN-DIV-TAX-PAID-AMT.0 ">[INC7] should not exceed ( [INC6] + £1 )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p19">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:Income/MTR:StateBenefits/MTR:AnnualStatePension">
        <sch:assert test=". &lt; 99999" id="a_ITF-STATE-RETIREMENT-PENSION.0" diagnostics="errorCode.ITF-STATE-RETIREMENT-PENSION.0 transactional.ITF-STATE-RETIREMENT-PENSION.0 transactional.en.ITF-STATE-RETIREMENT-PENSION.0 ">[INC8] should be less than [£99,999]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p20">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:Income/MTR:StateBenefits/MTR:TaxTakenOffPensionLumpSum">
        <sch:assert test=". &lt;= ((0.45 * sum(../MTR:StatePensionLumpSum)) + 1.0001)" id="a_ITF-STATE-PENSION-LS-TAX-AMT.0" diagnostics="errorCode.ITF-STATE-PENSION-LS-TAX-AMT.0 transactional.ITF-STATE-PENSION-LS-TAX-AMT.0 transactional.en.ITF-STATE-PENSION-LS-TAX-AMT.0 ">[INC10] is valid only if this does not exceed ( ( [45%] times [INC9] ) plus 1.00 )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p21">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:Income/MTR:StateBenefits/MTR:TaxTakenOffPensionsAndRetirementAnnuities">
        <sch:assert test=". &lt;= sum(../MTR:OtherPensionsAndRetirementAnnuities)" id="a_ITF2-OTHER-PENSION-TAX-PAID-1.0" diagnostics="errorCode.ITF2-OTHER-PENSION-TAX-PAID-1.0 transactional.ITF2-OTHER-PENSION-TAX-PAID-1.0 transactional.en.ITF2-OTHER-PENSION-TAX-PAID-1.0 ">[INC12] should not exceed [INC11]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p22">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:Income/MTR:StateBenefits/MTR:TaxTakenOffIncapacityBenefit">
        <sch:assert test="../MTR:IncapacityBenefit" id="a_ITF-TAX-DED-INCAPACITY-BENEFIT.0" diagnostics="errorCode.ITF-TAX-DED-INCAPACITY-BENEFIT.0 transactional.ITF-TAX-DED-INCAPACITY-BENEFIT.0 transactional.en.ITF-TAX-DED-INCAPACITY-BENEFIT.0 ">If tax taken off incapacity benefit is present the following should be true: [INC13]</sch:assert>
        <sch:assert test=". &lt;= sum(../MTR:IncapacityBenefit)" id="a_ITF-TAX-DED-INCAPACITY-BENEFIT.1" diagnostics="errorCode.ITF-TAX-DED-INCAPACITY-BENEFIT.1 transactional.ITF-TAX-DED-INCAPACITY-BENEFIT.1 transactional.en.ITF-TAX-DED-INCAPACITY-BENEFIT.1 ">[INC14] should not exceed [INC13]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p23">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:Income/MTR:StateBenefits/MTR:JobseekersAllowance">
        <sch:assert test=". &lt; 99999" id="a_ITF-JOBSEEKERS-ALLCE-AMT.0" diagnostics="errorCode.ITF-JOBSEEKERS-ALLCE-AMT.0 transactional.ITF-JOBSEEKERS-ALLCE-AMT.0 transactional.en.ITF-JOBSEEKERS-ALLCE-AMT.0 ">[INC15] should be less than [£99,999]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p25">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:Income/MTR:OtherUKIncome/MTR:OtherTaxableIncomeDetails/MTR:TaxTakenOffOtherTaxableIncome">
        <sch:assert test=". &lt;= ../MTR:OtherTaxableIncome" id="a_ITF3-OTHER-INCOME-TAX-DEDUCTED.1" diagnostics="errorCode.ITF3-OTHER-INCOME-TAX-DEDUCTED.1 transactional.ITF3-OTHER-INCOME-TAX-DEDUCTED.1 transactional.en.ITF3-OTHER-INCOME-TAX-DEDUCTED.1 ">[INC19] should not exceed [INC17]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p24">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:Income/MTR:OtherUKIncome">
        <sch:assert test="not(MTR:OtherTaxableIncomeDetails/MTR:OtherTaxableIncome or MTR:DeemedIncomeOrBenefits) 
                  or 
                MTR:DescriptionOfOtherIncome" id="a_ITF-OTHER_DEEMED-INC_BENS-DESC.1" diagnostics="errorCode.ITF-OTHER_DEEMED-INC_BENS-DESC.1 transactional.ITF-OTHER_DEEMED-INC_BENS-DESC.1 transactional.en.ITF-OTHER_DEEMED-INC_BENS-DESC.1 ">description of other income should be present if [INC17] or [INC20]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p26">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:TaxReliefs/MTR:Pensions/MTR:OneOffRegisteredPensionSchemesPayments">
        <sch:assert test=". &lt;= sum(../MTR:PaymentsToRegisteredPensionSchemes)" id="a_ITF-GROSS-STKHOLD-ONE-OFF.0" diagnostics="errorCode.ITF-GROSS-STKHOLD-ONE-OFF.0 transactional.ITF-GROSS-STKHOLD-ONE-OFF.0 transactional.en.ITF-GROSS-STKHOLD-ONE-OFF.0 ">[REL1.1] should not exceed [REL1]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p27">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:TaxReliefs/MTR:CharitableGiving/MTR:OneOffGiftAidPayments">
        <sch:assert test=". &lt;= sum(../MTR:GiftAidPaymentsMadeInYear)" id="a_ITF-GIFT-AID-AMOUNT.1" diagnostics="errorCode.ITF-GIFT-AID-AMOUNT.1 transactional.ITF-GIFT-AID-AMOUNT.1 transactional.en.ITF-GIFT-AID-AMOUNT.1 ">[REL6] shoold not exceed [REL5]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p28">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:TaxReliefs/MTR:CharitableGiving/MTR:GiftAidPaymentsCarriedBackToPreviousYear">
        <sch:assert test=". &lt;= sum(../MTR:GiftAidPaymentsMadeInYear)" id="a_ITF-GIFT-AID-PAID-PREV-YR-AMT.1" diagnostics="errorCode.ITF-GIFT-AID-PAID-PREV-YR-AMT.1 transactional.ITF-GIFT-AID-PAID-PREV-YR-AMT.1 transactional.en.ITF-GIFT-AID-PAID-PREV-YR-AMT.1 ">[REL7] should not exceed [REL5]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p29">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:TaxReliefs/MTR:BlindPersonsAllowance/MTR:BlindPersonsAllowanceDetails/MTR:SurplusBlindPersonsAllowanceToSpouse">
        <sch:assert test="not(../../../../../MTR:SA110/MTR:SurplusAllowances/MTR:SurplusBlindPersonsAllowance)" id="a_ITF-SURPLUS-BPA-TO-SPOUSE-SIG.1" diagnostics="errorCode.ITF-SURPLUS-BPA-TO-SPOUSE-SIG.1 transactional.ITF-SURPLUS-BPA-TO-SPOUSE-SIG.1 transactional.en.ITF-SURPLUS-BPA-TO-SPOUSE-SIG.1 ">If [REL16] is present [CAL12] must be absent</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p30">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:TaxReliefs/MTR:BlindPersonsAllowance/MTR:BlindPersonsAllowanceDetails/MTR:LocalAuthorityName">
        <sch:assert test="../MTR:RegisteredBlind" id="a_ITF-BPA-LOCAL-AUTHORITY.1" diagnostics="errorCode.ITF-BPA-LOCAL-AUTHORITY.1 transactional.ITF-BPA-LOCAL-AUTHORITY.1 transactional.en.ITF-BPA-LOCAL-AUTHORITY.1 ">if [REL14] is present, [REL13] should also be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p31">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:TaxReliefs/MTR:BlindPersonsAllowance/MTR:SurplusBlindPersonsAllowanceFromSpouse">
        <sch:assert test="../../../../MTR:SA110/MTR:SurplusAllowances/MTR:SurplusBlindPersonsAllowance" id="a_ITF-SURPLUS-BPA-FROM-SPSE-SIG.0" diagnostics="errorCode.ITF-SURPLUS-BPA-FROM-SPSE-SIG.0 transactional.ITF-SURPLUS-BPA-FROM-SPSE-SIG.0 transactional.en.ITF-SURPLUS-BPA-FROM-SPSE-SIG.0 ">[CAL12] Must be present if [REL15] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p33">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:HighIncomeChildBenefitCharge/MTR:NumberOfChildren">
        <sch:assert test=". &lt;= 0 or ../MTR:AmountReceived" id="a_ITF-CHILD-BENEFIT-CHILDREN-NUM.0" diagnostics="errorCode.ITF-CHILD-BENEFIT-CHILDREN-NUM.0 transactional.ITF-CHILD-BENEFIT-CHILDREN-NUM.0 transactional.en.ITF-CHILD-BENEFIT-CHILDREN-NUM.0 ">If [CBC2] is present and greater than 0, then [CBC1] must be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p34">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:HighIncomeChildBenefitCharge/MTR:DateStoppedReceivingAllChildBenefitPayments">
        <sch:assert test="../MTR:AmountReceived" id="a_ITF-CHILD-BENEFIT-CEASED-PYT.0" diagnostics="errorCode.ITF-CHILD-BENEFIT-CEASED-PYT.0 transactional.ITF-CHILD-BENEFIT-CEASED-PYT.0 transactional.en.ITF-CHILD-BENEFIT-CEASED-PYT.0 ">[CBC1] should be present if [CBC3] is present</sch:assert>
        <sch:assert test="../MTR:NumberOfChildren" id="a_ITF-CHILD-BENEFIT-CEASED-PYT.1" diagnostics="errorCode.ITF-CHILD-BENEFIT-CEASED-PYT.1 transactional.ITF-CHILD-BENEFIT-CEASED-PYT.1 transactional.en.ITF-CHILD-BENEFIT-CEASED-PYT.1 ">[CBC2] should be present if [CBC3] is present</sch:assert>
        <sch:assert test="(round(date:seconds(normalize-space(concat(2025, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))
                  and
                (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2026, &quot;-04-05&quot;))) div 86400))" id="a_ITF-CHILD-BENEFIT-CEASED-PYT.2" diagnostics="errorCode.ITF-CHILD-BENEFIT-CEASED-PYT.2 transactional.ITF-CHILD-BENEFIT-CEASED-PYT.2 transactional.en.ITF-CHILD-BENEFIT-CEASED-PYT.2 ">[CBC3] should be within the current return year</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p32">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:HighIncomeChildBenefitCharge">
        <sch:assert test="MTR:AmountReceived or MTR:NumberOfChildren" id="a_RIM-HIGH-INCOME-CB-CHARGE.0" diagnostics="errorCode.RIM-HIGH-INCOME-CB-CHARGE.0 transactional.RIM-HIGH-INCOME-CB-CHARGE.0 transactional.en.RIM-HIGH-INCOME-CB-CHARGE.0 ">If [CBC1-3] is present the following should be true: [CBC1] is present or [CBC2] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p35">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:WinterFuelPaymentOrPensionsAgeWinterHeatingPaymentReceived">
        <sch:assert test=". &lt;= 310" id="a_ITF-WFP-PAWHP.0" diagnostics="errorCode.ITF-WFP-PAWHP.0 transactional.ITF-WFP-PAWHP.0 transactional.en.ITF-WFP-PAWHP.0 ">[WFHP1] is valid only if this does not exceed [£310]</sch:assert>
        <sch:assert test=". &gt;= 100" id="a_ITF-WFP-PAWHP.1" diagnostics="errorCode.ITF-WFP-PAWHP.1 transactional.ITF-WFP-PAWHP.1 transactional.en.ITF-WFP-PAWHP.1 ">[WFHP1] is valid only when greater than or equal to [£100]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p36">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:MarriageAllowance/MTR:SpouseFirstName">
        <sch:assert test="../../MTR:MarriageAllowanceTransferredOut" id="a_ITF-MA-PARTNER-FIRST-NAME.0" diagnostics="errorCode.ITF-MA-PARTNER-FIRST-NAME.0 transactional.ITF-MA-PARTNER-FIRST-NAME.0 transactional.en.ITF-MA-PARTNER-FIRST-NAME.0 ">[MAT-OUT] should be present if [MAT1] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p37">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:MarriageAllowance/MTR:DateOfMarriageOrCivilPartnership">
        <sch:assert test="(round(date:seconds(normalize-space(.)) div 86400) &lt;= round(date:seconds(normalize-space(&quot;2026-04-05&quot;)) div 86400))" id="a_ITF-MA-PARTNERSHIP-DATE.0" diagnostics="errorCode.ITF-MA-PARTNERSHIP-DATE.0 transactional.ITF-MA-PARTNERSHIP-DATE.0 transactional.en.ITF-MA-PARTNERSHIP-DATE.0 ">[MAT5] is valid only if this is on or before [5 April 2026]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p39">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:FinishingYourTaxReturn/MTR:PaidTooMuch/MTR:PaymentDetails/MTR:NomineeDetails/MTR:NomineeAddress">
        <sch:assert test="not(MTR:ShortLine) or (count(MTR:Line) = 3)" id="a_ITF1-NOMINEE-ADDRESS.0" diagnostics="errorCode.ITF1-NOMINEE-ADDRESS.0 transactional.ITF1-NOMINEE-ADDRESS.0 transactional.en.ITF1-NOMINEE-ADDRESS.0 ">If line 4 is present lines 1,2 &amp; 3 must be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p38">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:FinishingYourTaxReturn/MTR:PaidTooMuch/MTR:PaymentDetails/MTR:NomineeDetails">
        <sch:assert test="../MTR:BankAccountDetails/MTR:AccountHolderOrNomineeName" id="a_ITF-NAME-OF-ACCOUNT.0" diagnostics="errorCode.ITF-NAME-OF-ACCOUNT.0 transactional.ITF-NAME-OF-ACCOUNT.0 transactional.en.ITF-NAME-OF-ACCOUNT.0 ">[FIN10] and [FIN12-FIN13] are present. [FIN5] must be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p40">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:FinishingYourTaxReturn/MTR:TaxAdviser/MTR:TaxAdviserAddress">
        <sch:assert test="not(MTR:ShortLine) or (count(MTR:Line) = 3)" id="a_ITF4-AGENT-CONTACT-ADDRESS.0" diagnostics="errorCode.ITF4-AGENT-CONTACT-ADDRESS.0 transactional.ITF4-AGENT-CONTACT-ADDRESS.0 transactional.en.ITF4-AGENT-CONTACT-ADDRESS.0 ">If line 4 is present lines 1,2 &amp; 3 must be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p41">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:FinishingYourTaxReturn/MTR:SigningYourForm/MTR:AddressOfPersonSigning">
        <sch:assert test="not(MTR:ShortLine) or (count(MTR:Line) = 3)" id="a_ITF-ALT-SIGNEE-ADDRESS.0" diagnostics="errorCode.ITF-ALT-SIGNEE-ADDRESS.0 transactional.ITF-ALT-SIGNEE-ADDRESS.0 transactional.en.ITF-ALT-SIGNEE-ADDRESS.0 ">If line 4 is present lines 1,2 &amp; 3 must be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p42">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100/MTR:ChargeableEventGains">
        <sch:assert test="not ( ../../MTR:SA101/MTR:LifeInsuranceGains/MTR:LifeInsuranceGainsNoTaxTreatedAsPaid/MTR:NumberOfYears or ../../MTR:SA101/MTR:LifeInsuranceGains/MTR:LifeInsuranceGainsTaxTreatedAsPaid/MTR:NumberOfYears or ../../MTR:SA101/MTR:LifeInsuranceGains/MTR:LifeInsuranceGainsFromVoidedISAs/MTR:NumberOfYears or ../../MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:NumberOfYearsSincePolicyMade )" id="a_ITF-CEG-INPUT-AMOUNT.1" diagnostics="errorCode.ITF-CEG-INPUT-AMOUNT.1 transactional.ITF-CEG-INPUT-AMOUNT.1 transactional.en.ITF-CEG-INPUT-AMOUNT.1 ">If Box1A present then boxes [AOI7], [AOI5], [AOI9] and [FOR44] must be absent</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p4">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA100">
        <sch:assert test="not(MTR:YourTaxReturn/MTR:MinisterOfReligionSchedule) or MTR:YourTaxReturn/MTR:NumberOfMinisterOfReligionSchedules" id="a_SA100.0" diagnostics="errorCode.SA100.0 transactional.SA100.0 transactional.en.SA100.0 ">Number of Minister of Religion Schedules should be present if [YTR1A.1A] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p44">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:LifeInsuranceGains/MTR:LifeInsuranceGainsTaxTreatedAsPaid/MTR:NumberOfYears">
        <sch:assert test="../MTR:AmountOfGain" id="a_ITF-CEG-WITH-NOTL-NUMBER-YEARS.1" diagnostics="errorCode.ITF-CEG-WITH-NOTL-NUMBER-YEARS.1 transactional.ITF-CEG-WITH-NOTL-NUMBER-YEARS.1 transactional.en.ITF-CEG-WITH-NOTL-NUMBER-YEARS.1 ">If number of years is present the following should be true: [AOI4]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p45">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:LifeInsuranceGains/MTR:LifeInsuranceGainsNoTaxTreatedAsPaid/MTR:NumberOfYears">
        <sch:assert test="../MTR:AmountOfGain" id="a_ITF-NOS-YEARS-CEG-WITHOUT-NOTL.1" diagnostics="errorCode.ITF-NOS-YEARS-CEG-WITHOUT-NOTL.1 transactional.ITF-NOS-YEARS-CEG-WITHOUT-NOTL.1 transactional.en.ITF-NOS-YEARS-CEG-WITHOUT-NOTL.1 ">If number of years is present the following should be true: [AOI6]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p46">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:LifeInsuranceGains/MTR:LifeInsuranceGainsFromVoidedISAs/MTR:NumberOfYears">
        <sch:assert test="../MTR:AmountOfGain" id="a_ITF3-NOS-YEARS-GAINS-VOID-ISA.1" diagnostics="errorCode.ITF3-NOS-YEARS-GAINS-VOID-ISA.1 transactional.ITF3-NOS-YEARS-GAINS-VOID-ISA.1 transactional.en.ITF3-NOS-YEARS-GAINS-VOID-ISA.1 ">If number of years  is present the following should be true: [AOI8]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p47">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:LifeInsuranceGains/MTR:TaxTakenOffGainsFromVoidedISAs">
        <sch:assert test="../MTR:LifeInsuranceGainsFromVoidedISAs/MTR:AmountOfGain" id="a_ITF3-VOID-ISA-TAX-DEDUCTED.0" diagnostics="errorCode.ITF3-VOID-ISA-TAX-DEDUCTED.0 transactional.ITF3-VOID-ISA-TAX-DEDUCTED.0 transactional.en.ITF3-VOID-ISA-TAX-DEDUCTED.0 ">If [AOI10] is present the following should be true: [AOI8] is present</sch:assert>
        <sch:assert test="((.) - (((sum(../MTR:LifeInsuranceGainsFromVoidedISAs/MTR:AmountOfGain) * 0.2) + 1)) &lt; 0.001)" id="a_ITF3-VOID-ISA-TAX-DEDUCTED.1" diagnostics="errorCode.ITF3-VOID-ISA-TAX-DEDUCTED.1 transactional.ITF3-VOID-ISA-TAX-DEDUCTED.1 transactional.en.ITF3-VOID-ISA-TAX-DEDUCTED.1 ">[AOI10] is valid only if this does not exceed ( ( [AOI8] times [20%] ) plus 1 )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p48">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:BusinessTaxedIncome/MTR:TaxYearIncomeToBeTaxed">
        <sch:assert test="(number(substring(string(.) , 1 , 4)) - number(substring(string(.) , 6 , 2))) mod 100 = 99" id="a_ITF-BUS-RCPTS-TAXED-IN-YEAR.0" diagnostics="errorCode.ITF-BUS-RCPTS-TAXED-IN-YEAR.0 transactional.ITF-BUS-RCPTS-TAXED-IN-YEAR.0 transactional.en.ITF-BUS-RCPTS-TAXED-IN-YEAR.0 ">Must be a valid pair of consecutive years in the format YYYY YY</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p49">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:SharesEmploymentCompensationsAndDeductions/MTR:TaxTakenOffLumpSumsLeftBlank">
        <sch:assert test="not(sum(../MTR:LumpSums/MTR:TaxTakenOff) &gt; 0)" id="a_MPL2-TOT-TAX-DED-FROM-LUMP-SUM.1" diagnostics="errorCode.MPL2-TOT-TAX-DED-FROM-LUMP-SUM.1 transactional.MPL2-TOT-TAX-DED-FROM-LUMP-SUM.1 transactional.en.MPL2-TOT-TAX-DED-FROM-LUMP-SUM.1 ">[ASE7] must be absent if there is an entry greater than zero in box [ASE6]</sch:assert>
        <sch:assert test="((sum(../../../MTR:SA102/MTR:Employment/MTR:TaxTakenOffPay)) - (0) &gt;= 0.001)" id="a_MPL-LUMP-SUM-TAX-INCLUDED-SIG.1" diagnostics="errorCode.MPL-LUMP-SUM-TAX-INCLUDED-SIG.1 transactional.MPL-LUMP-SUM-TAX-INCLUDED-SIG.1 transactional.en.MPL-LUMP-SUM-TAX-INCLUDED-SIG.1 ">If [ASE7] is present [EMP2] must be greater than zero</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p50">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:SharesEmploymentCompensationsAndDeductions/MTR:CompensationAndLumpSumExemption">
        <sch:assert test=". &lt;= 30000" id="a_MPL-LUMP-SUM-EXEMPTION.1" diagnostics="errorCode.MPL-LUMP-SUM-EXEMPTION.1 transactional.MPL-LUMP-SUM-EXEMPTION.1 transactional.en.MPL-LUMP-SUM-EXEMPTION.1 ">[ASE9] should not exceed [£30,000]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p51">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:SharesEmploymentCompensationsAndDeductions/MTR:SeafarersEarningsDeduction">
        <sch:assert test="((.) - (1.00 + sum(../../../MTR:SA102M/MTR:TaxableIncome/MTR:TaxableIncomeMinusExpenses) + sum(../../../MTR:SA102/MTR:Employment/MTR:PayFromEmployment) + sum(../../../MTR:SA102/MTR:Employment/MTR:TipsAndOtherPayments) + sum(../../../MTR:SA102/MTR:Benefits/MTR:CompanyCarsAndVansBenefit) + sum(../../../MTR:SA102/MTR:Benefits/MTR:FuelForCarsAndVans) + sum(../../../MTR:SA102/MTR:Benefits/MTR:PrivateMedicalDentalInsurance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:VouchersCreditCardsExcessMileageAllowance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:GoodsEtcProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:AccommodationProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:OtherBenefits) + sum(../../../MTR:SA102/MTR:Benefits/MTR:ExpensesPaymentsReceived) + sum(../MTR:LumpSums/MTR:LumpSumSalariesAndOtherPayments) + sum(../MTR:LumpSums/MTR:LumpSumsOrBenefitsFromRetirementSchemes) + sum(../MTR:LumpSums/MTR:RedundancyAndOtherCompensationPayments) - ( sum(../MTR:NonUKTaxableForeignEarnings) + sum(../../../MTR:SA102/MTR:Expenses/MTR:ProfessionalFeesAndSubscriptions) + sum(../../../MTR:SA102/MTR:Expenses/MTR:FixedExpensesDeductions) + sum(../../../MTR:SA102/MTR:Expenses/MTR:OtherExpensesAndCapitalAllowances) + sum(../../../MTR:SA102/MTR:Expenses/MTR:BusinessTravelAndSubsistence) )) &lt; 0.001)" id="a_MPL3-FOREIGN-EARNINGS-DEDN.1" diagnostics="errorCode.MPL3-FOREIGN-EARNINGS-DEDN.1 transactional.MPL3-FOREIGN-EARNINGS-DEDN.1 transactional.en.MPL3-FOREIGN-EARNINGS-DEDN.1 ">If there is an entry in [ASE11] it must not exceed by more than £1 the total of boxes( [MOR38] +  [EMP1] + [EMP3] + [EMP9] + [EMP10] + [EMP11] + [EMP12] + [EMP13] + [EMP14] + [EMP15] + [EMP16] + [ASE3] + [ASE4] + [ASE5]) less ( [ASE12] + [EMP19] + [EMP18] + [EMP20] + [EMP17])</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p52">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:SharesEmploymentCompensationsAndDeductions/MTR:NonUKTaxableForeignEarnings">
        <sch:assert test="((.) - (1.00 + sum(../../../MTR:SA102M/MTR:TaxableIncome/MTR:TaxableIncomeMinusExpenses) +  sum(../../../MTR:SA102/MTR:Employment/MTR:PayFromEmployment) + sum(../../../MTR:SA102/MTR:Employment/MTR:TipsAndOtherPayments) + sum(../../../MTR:SA102/MTR:Benefits/MTR:CompanyCarsAndVansBenefit) + sum(../../../MTR:SA102/MTR:Benefits/MTR:FuelForCarsAndVans) + sum(../../../MTR:SA102/MTR:Benefits/MTR:PrivateMedicalDentalInsurance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:VouchersCreditCardsExcessMileageAllowance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:GoodsEtcProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:AccommodationProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:OtherBenefits) + sum(../../../MTR:SA102/MTR:Benefits/MTR:ExpensesPaymentsReceived) + sum(../MTR:LumpSums/MTR:LumpSumSalariesAndOtherPayments) + sum(../MTR:LumpSums/MTR:LumpSumsOrBenefitsFromRetirementSchemes) + sum(../MTR:LumpSums/MTR:RedundancyAndOtherCompensationPayments)) &lt; 0.001)" id="a_MPL3-FOREIGN-EARNINGS-NOT-TXBL.1" diagnostics="errorCode.MPL3-FOREIGN-EARNINGS-NOT-TXBL.1 transactional.MPL3-FOREIGN-EARNINGS-NOT-TXBL.1 transactional.en.MPL3-FOREIGN-EARNINGS-NOT-TXBL.1 ">If there is an entry in [ASE12] it must not exceed by more than £1  the total of boxes [MOR38] +  [EMP1] + [EMP3] + [EMP9] + [EMP10] + [EMP11] + [EMP12] + [EMP13] + [EMP14] + [EMP15] + [EMP16] + [ASE3] + [ASE4] + [ASE5] (error 429)</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p53">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:SharesEmploymentCompensationsAndDeductions/MTR:ForeignTaxNoForeignTaxCreditReliefClaim">
        <sch:assert test="(
  (((( sum(../../../MTR:SA102M/MTR:TaxableIncome/MTR:TaxableIncomeMinusExpenses) + sum(../../../MTR:SA102/MTR:Employment/MTR:PayFromEmployment) + sum(../../../MTR:SA102/MTR:Employment/MTR:TipsAndOtherPayments) + sum(../../../MTR:SA102/MTR:Benefits/MTR:CompanyCarsAndVansBenefit) + sum(../../../MTR:SA102/MTR:Benefits/MTR:FuelForCarsAndVans) + sum(../../../MTR:SA102/MTR:Benefits/MTR:PrivateMedicalDentalInsurance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:VouchersCreditCardsExcessMileageAllowance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:GoodsEtcProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:AccommodationProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:OtherBenefits) + sum(../../../MTR:SA102/MTR:Benefits/MTR:ExpensesPaymentsReceived) + sum(../MTR:LumpSums/MTR:LumpSumSalariesAndOtherPayments) + sum(../MTR:LumpSums/MTR:LumpSumsOrBenefitsFromRetirementSchemes) + sum(../MTR:LumpSums/MTR:RedundancyAndOtherCompensationPayments) ) - ( sum(../MTR:NonUKTaxableForeignEarnings) + sum(../../../MTR:SA102/MTR:Expenses/MTR:BusinessTravelAndSubsistence) + sum(../../../MTR:SA102/MTR:Expenses/MTR:FixedExpensesDeductions) + sum(../../../MTR:SA102/MTR:Expenses/MTR:ProfessionalFeesAndSubscriptions) + sum(../../../MTR:SA102/MTR:Expenses/MTR:OtherExpensesAndCapitalAllowances) + sum(../MTR:SeafarersEarningsDeduction) ))) - (0) &lt;= -0.001) and ((.) - (1) &lt; 0.001)
) 
or 
(
  (((( sum(../../../MTR:SA102M/MTR:TaxableIncome/MTR:TaxableIncomeMinusExpenses) + sum(../../../MTR:SA102/MTR:Employment/MTR:PayFromEmployment) + sum(../../../MTR:SA102/MTR:Employment/MTR:TipsAndOtherPayments) + sum(../../../MTR:SA102/MTR:Benefits/MTR:CompanyCarsAndVansBenefit) + sum(../../../MTR:SA102/MTR:Benefits/MTR:FuelForCarsAndVans) + sum(../../../MTR:SA102/MTR:Benefits/MTR:PrivateMedicalDentalInsurance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:VouchersCreditCardsExcessMileageAllowance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:GoodsEtcProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:AccommodationProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:OtherBenefits) + sum(../../../MTR:SA102/MTR:Benefits/MTR:ExpensesPaymentsReceived) + sum(../MTR:LumpSums/MTR:LumpSumSalariesAndOtherPayments) + sum(../MTR:LumpSums/MTR:LumpSumsOrBenefitsFromRetirementSchemes) + sum(../MTR:LumpSums/MTR:RedundancyAndOtherCompensationPayments) ) - ( sum(../MTR:NonUKTaxableForeignEarnings) + sum(../../../MTR:SA102/MTR:Expenses/MTR:BusinessTravelAndSubsistence) + sum(../../../MTR:SA102/MTR:Expenses/MTR:FixedExpensesDeductions) + sum(../../../MTR:SA102/MTR:Expenses/MTR:ProfessionalFeesAndSubscriptions) + sum(../../../MTR:SA102/MTR:Expenses/MTR:OtherExpensesAndCapitalAllowances) + sum(../MTR:SeafarersEarningsDeduction) ))) - (0) &gt; -0.001) and ((.) - (1 + (( sum(../../../MTR:SA102M/MTR:TaxableIncome/MTR:TaxableIncomeMinusExpenses) + sum(../../../MTR:SA102/MTR:Employment/MTR:PayFromEmployment) + sum(../../../MTR:SA102/MTR:Employment/MTR:TipsAndOtherPayments) + sum(../../../MTR:SA102/MTR:Benefits/MTR:CompanyCarsAndVansBenefit) + sum(../../../MTR:SA102/MTR:Benefits/MTR:FuelForCarsAndVans) + sum(../../../MTR:SA102/MTR:Benefits/MTR:PrivateMedicalDentalInsurance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:VouchersCreditCardsExcessMileageAllowance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:GoodsEtcProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:AccommodationProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:OtherBenefits) + sum(../../../MTR:SA102/MTR:Benefits/MTR:ExpensesPaymentsReceived) + sum(../MTR:LumpSums/MTR:LumpSumSalariesAndOtherPayments) + sum(../MTR:LumpSums/MTR:LumpSumsOrBenefitsFromRetirementSchemes) + sum(../MTR:LumpSums/MTR:RedundancyAndOtherCompensationPayments) ) - ( sum(../MTR:NonUKTaxableForeignEarnings) + sum(../../../MTR:SA102/MTR:Expenses/MTR:BusinessTravelAndSubsistence) + sum(../../../MTR:SA102/MTR:Expenses/MTR:FixedExpensesDeductions) + sum(../../../MTR:SA102/MTR:Expenses/MTR:ProfessionalFeesAndSubscriptions) + sum(../../../MTR:SA102/MTR:Expenses/MTR:OtherExpensesAndCapitalAllowances) + sum(../MTR:SeafarersEarningsDeduction) ))) &lt; 0.001)
)" id="a_MPL3-FOREIGN-TAX.1" diagnostics="errorCode.MPL3-FOREIGN-TAX.1 transactional.MPL3-FOREIGN-TAX.1 transactional.en.MPL3-FOREIGN-TAX.1 ">If there is an entry in box [ASE13] it must not exceed by more than £1 the total of ( [MOR38] + [EMP1] + [EMP3] + [EMP9] + [EMP10] + [EMP11] + [EMP12] + [EMP13] + [EMP14] + [EMP15] + [EMP16] + [ASE3] + [ASE4] + [ASE5] ) less ( [ASE12] + [EMP17] + [EMP18] + [EMP19] + [EMP20] + [ASE11]). If the sum is negative treat as zero.(error 431)</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p54">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherTaxReliefs/MTR:VentureCapitalTrustShareSubscriptions">
        <sch:assert test=". &lt;= 200000" id="a_ITF-VENT-CAP-TRUST-SHARE-SUBS.0" diagnostics="errorCode.ITF-VENT-CAP-TRUST-SHARE-SUBS.0 transactional.ITF-VENT-CAP-TRUST-SHARE-SUBS.0 transactional.en.ITF-VENT-CAP-TRUST-SHARE-SUBS.0 ">
venture capital trust share subscriptions is valid if and only if this does not exceed [£200,000]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p55">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherTaxReliefs/MTR:EnterpriseInvestmentSchemeShareSubscriptions">
        <sch:assert test=". &lt;= 2000000" id="a_ITF-EIS-RELIEF-CLAIMED.0" diagnostics="errorCode.ITF-EIS-RELIEF-CLAIMED.0 transactional.ITF-EIS-RELIEF-CLAIMED.0 transactional.en.ITF-EIS-RELIEF-CLAIMED.0 ">[AOR2] should not exceed [£2,000,000]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p56">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherTaxReliefs/MTR:MaintenanceOrAlimonyPayments">
        <sch:assert test=". &lt;= 4360" id="a_ITF-ALIMONY-NEW-RULES-RELIEF.0" diagnostics="errorCode.ITF-ALIMONY-NEW-RULES-RELIEF.0 transactional.ITF-ALIMONY-NEW-RULES-RELIEF.0 transactional.en.ITF-ALIMONY-NEW-RULES-RELIEF.0 ">[AOR7] is valid only if this does not exceed [£4,360]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p57">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherTaxReliefs/MTR:TradeUnionEtcDeathBenefitPayments">
        <sch:assert test=". &lt;= 100" id="a_ITF-TRADE-UNION-DEATH-BENEFITS.0" diagnostics="errorCode.ITF-TRADE-UNION-DEATH-BENEFITS.0 transactional.ITF-TRADE-UNION-DEATH-BENEFITS.0 transactional.en.ITF-TRADE-UNION-DEATH-BENEFITS.0 ">Must not exceed [£100]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p58">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherTaxReliefs/MTR:SeedEnterpriseInvestmentSchemeAmount">
        <sch:assert test=". &lt;= 200000" id="a_ITF-SEED-EIS-AMT.0" diagnostics="errorCode.ITF-SEED-EIS-AMT.0 transactional.ITF-SEED-EIS-AMT.0 transactional.en.ITF-SEED-EIS-AMT.0 ">[AOR10] is valid only if this does not exceed [£200,000].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p59">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:AgeRelatedMarriedCouplesAllowance/MTR:HigherEarner/MTR:SpousesName">
        <sch:assert test="(translate(../MTR:SpousesDateOfBirth,&apos;-&apos;,&apos;&apos;) &lt; 19350406) or (translate(../MTR:PreviousSpousesDateOfBirth,&apos;-&apos;,&apos;&apos;) &lt; 19350406) or (translate(../../../../MTR:SA100/MTR:YourPersonalDetails/MTR:DateOfBirth,&apos;-&apos;,&apos;&apos;) &lt; 19350406)" id="a_ITF4-WIFES-NAME.0" diagnostics="errorCode.ITF4-WIFES-NAME.0 transactional.ITF4-WIFES-NAME.0 transactional.en.ITF4-WIFES-NAME.0 ">If [MCA1] present then at least one of [MCA2], [MCA5] or [YPD1] must be present with a date before 6th April 1935</sch:assert>
        <sch:assert test="not(../../../../MTR:SA100/MTR:MarriageAllowance/MTR:SpouseFirstName)" id="a_ITF4-WIFES-NAME.1" diagnostics="errorCode.ITF4-WIFES-NAME.1 transactional.ITF4-WIFES-NAME.1 transactional.en.ITF4-WIFES-NAME.1 ">[MCA1] should not be present if [MAT1] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p60">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:AgeRelatedMarriedCouplesAllowance/MTR:HigherEarner/MTR:SpousesDateOfBirth">
        <sch:assert test="(round(date:seconds(normalize-space((.))) div 86400) &lt; round(date:seconds(normalize-space(&quot;1935-04-06&quot;)) div 86400))" id="a_ITF-SPOUSES-BIRTH-DATE.1" diagnostics="errorCode.ITF-SPOUSES-BIRTH-DATE.1 transactional.ITF-SPOUSES-BIRTH-DATE.1 transactional.en.ITF-SPOUSES-BIRTH-DATE.1 ">[MCA2] must be before 6th April 1935</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p61">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:AgeRelatedMarriedCouplesAllowance/MTR:HigherEarner/MTR:AllMinimumAllowanceTransferToOther">
        <sch:assert test="((.) and not (../MTR:HalfMinimumAllowanceTransferToOther))" id="a_ITF-WHOLE-ALLOCN-TO-WIFE-SIG.2" diagnostics="errorCode.ITF-WHOLE-ALLOCN-TO-WIFE-SIG.2 transactional.ITF-WHOLE-ALLOCN-TO-WIFE-SIG.2 transactional.en.ITF-WHOLE-ALLOCN-TO-WIFE-SIG.2 ">If present, [MCA3] must be absent</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p62">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:AgeRelatedMarriedCouplesAllowance/MTR:LowerEarner/MTR:SpousesName">
        <sch:assert test="not(../../../../MTR:SA100/MTR:MarriageAllowance/MTR:SpouseFirstName)" id="a_ITF4-PERSNL-HUSBANDS-NAME.0" diagnostics="errorCode.ITF4-PERSNL-HUSBANDS-NAME.0 transactional.ITF4-PERSNL-HUSBANDS-NAME.0 transactional.en.ITF4-PERSNL-HUSBANDS-NAME.0 ">[MCA8] should not be present if [MAT1] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p63">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:AgeRelatedMarriedCouplesAllowance/MTR:DateOfMarriageOrCivilPartnership">
        <sch:assert test="(round(date:seconds(normalize-space(concat(2025, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))
                  and
                (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2026, &quot;-04-05&quot;))) div 86400))" id="a_ITF-MARRIAGE-DATE.1" diagnostics="errorCode.ITF-MARRIAGE-DATE.1 transactional.ITF-MARRIAGE-DATE.1 transactional.en.ITF-MARRIAGE-DATE.1 ">[MCA9] should be within the current return year</sch:assert>
        <sch:assert test="../MTR:HigherEarner/MTR:SpousesName or ../MTR:LowerEarner/MTR:SpousesName" id="a_ITF-MARRIAGE-DATE.2" diagnostics="errorCode.ITF-MARRIAGE-DATE.2 transactional.ITF-MARRIAGE-DATE.2 transactional.en.ITF-MARRIAGE-DATE.2 ">If [MCA9] is present either [MCA1] or [MCA8] must be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p64">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:AgeRelatedMarriedCouplesAllowance/MTR:SurplusAllowanceFromSpouse">
        <sch:assert test="../../../MTR:SA110/MTR:SurplusAllowances/MTR:SurplusMarriedCouplesAllowance" id="a_ITF-SOMEONE-ELSES-ALLCES-SIG.1" diagnostics="errorCode.ITF-SOMEONE-ELSES-ALLCES-SIG.1 transactional.ITF-SOMEONE-ELSES-ALLCES-SIG.1 transactional.en.ITF-SOMEONE-ELSES-ALLCES-SIG.1 ">[CAL13] must be present if [MCA10] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p65">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:AgeRelatedMarriedCouplesAllowance/MTR:SurplusAllowanceToSpouse">
        <sch:assert test="not(../../../MTR:SA110/MTR:SurplusAllowances/MTR:SurplusMarriedCouplesAllowance)" id="a_ITF-TRANS-ALLCES-TO-SPOUSE-SIG.1" diagnostics="errorCode.ITF-TRANS-ALLCES-TO-SPOUSE-SIG.1 transactional.ITF-TRANS-ALLCES-TO-SPOUSE-SIG.1 transactional.en.ITF-TRANS-ALLCES-TO-SPOUSE-SIG.1 ">If [MCA11] is present [CAL13] must be absent</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p66">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherInformation/MTR:IncomeTaxLosses/MTR:NextYearsTradingAndCapitalLossesRelief">
        <sch:assert test="not((.)) or ../MTR:YearForWhichReliefClaimed" id="a_ITF-FY-LOSS-RELIEF-AMT.0" diagnostics="errorCode.ITF-FY-LOSS-RELIEF-AMT.0 transactional.ITF-FY-LOSS-RELIEF-AMT.0 transactional.en.ITF-FY-LOSS-RELIEF-AMT.0 ">[AIL5] should be present if [AIL3] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p67">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherInformation/MTR:IncomeTaxLosses/MTR:NextYearsUncappedLossRelief">
        <sch:assert test="((.) - (sum(../MTR:NextYearsTradingAndCapitalLossesRelief)) &lt; 0.001)" id="a_ITF-FY-UNCAPP-LOSS-RELIEF-AMT.0" diagnostics="errorCode.ITF-FY-UNCAPP-LOSS-RELIEF-AMT.0 transactional.ITF-FY-UNCAPP-LOSS-RELIEF-AMT.0 transactional.en.ITF-FY-UNCAPP-LOSS-RELIEF-AMT.0 ">[AIL4] is valid only if this does not exceed [AIL3].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p68">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherInformation/MTR:IncomeTaxLosses/MTR:YearForWhichReliefClaimed">
        <sch:assert test="(number(substring(string(.) , 1 , 4)) - number(substring(string(.) , 6 , 2))) mod 100 = 99" id="a_ITF-FY-LOSS-RELIEF-SOURCE-YEAR.0" diagnostics="errorCode.ITF-FY-LOSS-RELIEF-SOURCE-YEAR.0 transactional.ITF-FY-LOSS-RELIEF-SOURCE-YEAR.0 transactional.en.ITF-FY-LOSS-RELIEF-SOURCE-YEAR.0 ">Must be a valid pair of consecutive years in the format YYYY YY</sch:assert>
        <sch:assert test="../MTR:NextYearsTradingAndCapitalLossesRelief" id="a_ITF-FY-LOSS-RELIEF-SOURCE-YEAR.1" diagnostics="errorCode.ITF-FY-LOSS-RELIEF-SOURCE-YEAR.1 transactional.ITF-FY-LOSS-RELIEF-SOURCE-YEAR.1 transactional.en.ITF-FY-LOSS-RELIEF-SOURCE-YEAR.1 ">If year for which relief claimed is present the following should be true: [AIL3]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p69">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherInformation/MTR:PensionTaxAndLumpSums/MTR:AnnualAllowanceTaxPaidByPensionScheme">
        <sch:assert test=". &lt; sum(../MTR:AmountSavedExceedingAnnualAllowance)" id="a_PEN-ANNL-ALLCE-TAX-PAID-AMT.0" diagnostics="errorCode.PEN-ANNL-ALLCE-TAX-PAID-AMT.0 transactional.PEN-ANNL-ALLCE-TAX-PAID-AMT.0 transactional.en.PEN-ANNL-ALLCE-TAX-PAID-AMT.0 ">[AIL11] is valid if and only if this is less than [AIL10]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p70">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherInformation/MTR:PensionTaxAndLumpSums/MTR:TaxPaidByPensionSchemeOnOTC">
        <sch:assert test="../MTR:PensionBenefitTransferredSubjectToOTC" id="a_PEN-BEN-OVERSEAS-TRANS-TAX.0" diagnostics="errorCode.PEN-BEN-OVERSEAS-TRANS-TAX.0 transactional.PEN-BEN-OVERSEAS-TRANS-TAX.0 transactional.en.PEN-BEN-OVERSEAS-TRANS-TAX.0 ">If [AIL11.2] is present [AIL11.1] should be present</sch:assert>
        <sch:assert test="not(../MTR:PensionBenefitTransferredSubjectToOTC) or (. &lt;= sum(../MTR:PensionBenefitTransferredSubjectToOTC))" id="a_PEN-BEN-OVERSEAS-TRANS-TAX.1" diagnostics="errorCode.PEN-BEN-OVERSEAS-TRANS-TAX.1 transactional.PEN-BEN-OVERSEAS-TRANS-TAX.1 transactional.en.PEN-BEN-OVERSEAS-TRANS-TAX.1 ">[AIL11.2] is valid only if this does not exceed [AIL11.1]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p71">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherInformation/MTR:PensionTaxAndLumpSums/MTR:ForeignTaxPaidOnUnauthorisedPayment">
        <sch:assert test="../MTR:UnauthorisedPaymentNotSubjectToSurcharge or ../MTR:UnauthorisedPaymentSubjectToSurcharge" id="a_PEN-FRGN-TAX-ON-PAYTS-PAID-AMT.0" diagnostics="errorCode.PEN-FRGN-TAX-ON-PAYTS-PAID-AMT.0 transactional.PEN-FRGN-TAX-ON-PAYTS-PAID-AMT.0 transactional.en.PEN-FRGN-TAX-ON-PAYTS-PAID-AMT.0 ">If [AIL15] is present the following should be true: [AIL13] is present or [AIL14] is present</sch:assert>
        <sch:assert test="not(../MTR:UnauthorisedPaymentNotSubjectToSurcharge or ../MTR:UnauthorisedPaymentSubjectToSurcharge) or ((.) - ((sum(../MTR:UnauthorisedPaymentNotSubjectToSurcharge) + sum(../MTR:UnauthorisedPaymentSubjectToSurcharge))) &lt;= -0.001)" id="a_PEN-FRGN-TAX-ON-PAYTS-PAID-AMT.1" diagnostics="errorCode.PEN-FRGN-TAX-ON-PAYTS-PAID-AMT.1 transactional.PEN-FRGN-TAX-ON-PAYTS-PAID-AMT.1 transactional.en.PEN-FRGN-TAX-ON-PAYTS-PAID-AMT.1 ">[AIL15] is valid only if this is less than ( [AIL13] plus [AIL14] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p72">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101/MTR:OtherInformation/MTR:TaxAvoidanceSchemes/MTR:ExpectedAdvantageTaxYear">
        <sch:assert test="(number(substring(string(.) , 1 , 4)) - number(substring(string(.) , 6 , 2))) mod 100 = 99" id="a_ITF-AVOIDANCE-SCHEME-YEAR.0" diagnostics="errorCode.ITF-AVOIDANCE-SCHEME-YEAR.0 transactional.ITF-AVOIDANCE-SCHEME-YEAR.0 transactional.en.ITF-AVOIDANCE-SCHEME-YEAR.0 ">[AIL20] must be a valid pair of consecutive years in the format YYYY-YY.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p43">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA101">
        <sch:assert test="not(((sum(MTR:SharesEmploymentCompensationsAndDeductions/MTR:SeafarersEarningsDeduction)) - (0) &gt;= 0.001))
            or
          ../MTR:SA100/MTR:FinishingYourTaxReturn/MTR:SigningYourForm/MTR:OtherInformationSpace" id="a_PRE-CALC.h" diagnostics="errorCode.PRE-CALC.h transactional.PRE-CALC.h transactional.en.PRE-CALC.h ">If [ASE11] is present and greater than zero then [FIN19] must be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p73">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102/MTR:Employment/MTR:PayrolledBenefits">
        <sch:assert test=". &lt;= sum(../MTR:PayFromEmployment)" id="a_MPL-PYRLD-BIK-SLR.0" diagnostics="errorCode.MPL-PYRLD-BIK-SLR.0 transactional.MPL-PYRLD-BIK-SLR.0 transactional.en.MPL-PYRLD-BIK-SLR.0 ">[EMP1.1] is valid only if this does not exceed [EMP1]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p74">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102/MTR:Employment/MTR:TaxTakenOffPay">
        <sch:assert test="(1 &lt; count(../../../MTR:SA102/MTR:Employment)) or . &gt;= 0 or (../../../MTR:SA102M/MTR:Income/MTR:TaxTakenOffSalaryStipend[. &gt; 0])" id="a_MPL2-TAX-DEDUCTED-AT-SOURCE.1" diagnostics="errorCode.MPL2-TAX-DEDUCTED-AT-SOURCE.1 transactional.MPL2-TAX-DEDUCTED-AT-SOURCE.1 transactional.en.MPL2-TAX-DEDUCTED-AT-SOURCE.1 ">May be negative if more than one set of [SA102] employment pages present. Must not be negative if only one set of [SA102] employment pages present unless there is also a positive value on a [SA102M] minister of religion page box [MOR3].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p75">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102/MTR:Employment/MTR:CompanyDirector">
        <sch:assert test="not((.) = &apos;yes&apos;) or ../MTR:CloseCompany" id="a_MPL-COMPANY-DIRECTOR-SIGNAL.0" diagnostics="errorCode.MPL-COMPANY-DIRECTOR-SIGNAL.0 transactional.MPL-COMPANY-DIRECTOR-SIGNAL.0 transactional.en.MPL-COMPANY-DIRECTOR-SIGNAL.0 ">[EMP7] should be present if [EMP6] equals 'yes'</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p76">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102/MTR:Employment/MTR:DateCeasedBeingADirector">
        <sch:assert test="../MTR:CompanyDirector = &apos;yes&apos;" id="a_MPL-COMPANY-DIRECTOR-CEASED.0" diagnostics="errorCode.MPL-COMPANY-DIRECTOR-CEASED.0 transactional.MPL-COMPANY-DIRECTOR-CEASED.0 transactional.en.MPL-COMPANY-DIRECTOR-CEASED.0 ">[EMP6] should equal 'yes' if [EMP6.1] is present</sch:assert>
        <sch:assert test="(round(date:seconds(normalize-space(concat(2025, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))
                  and
                (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2026, &quot;-04-05&quot;))) div 86400))" id="a_MPL-COMPANY-DIRECTOR-CEASED.1" diagnostics="errorCode.MPL-COMPANY-DIRECTOR-CEASED.1 transactional.MPL-COMPANY-DIRECTOR-CEASED.1 transactional.en.MPL-COMPANY-DIRECTOR-CEASED.1 ">[EMP6.1] should be within the current return year</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p77">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102/MTR:Employment/MTR:CloseCompany">
        <sch:assert test="not((.) = &apos;yes&apos;) or ../MTR:CloseCompanyName" id="a_MPL-CLOSE-COMPANY-DIRECTOR-SIG.0" diagnostics="errorCode.MPL-CLOSE-COMPANY-DIRECTOR-SIG.0 transactional.MPL-CLOSE-COMPANY-DIRECTOR-SIG.0 transactional.en.MPL-CLOSE-COMPANY-DIRECTOR-SIG.0 ">[EMP7.1] should be present if [EMP7] equals 'yes'</sch:assert>
        <sch:assert test="not((.) = &apos;yes&apos;) or ../MTR:CompanyRegistrationNo" id="a_MPL-CLOSE-COMPANY-DIRECTOR-SIG.1" diagnostics="errorCode.MPL-CLOSE-COMPANY-DIRECTOR-SIG.1 transactional.MPL-CLOSE-COMPANY-DIRECTOR-SIG.1 transactional.en.MPL-CLOSE-COMPANY-DIRECTOR-SIG.1 ">[EMP7.2] should be present if [EMP7] equals 'yes'</sch:assert>
        <sch:assert test="not((.) = &apos;yes&apos;) or ../MTR:CloseCompanyDividend" id="a_MPL-CLOSE-COMPANY-DIRECTOR-SIG.2" diagnostics="errorCode.MPL-CLOSE-COMPANY-DIRECTOR-SIG.2 transactional.MPL-CLOSE-COMPANY-DIRECTOR-SIG.2 transactional.en.MPL-CLOSE-COMPANY-DIRECTOR-SIG.2 ">[EMP7.3] should be present if [EMP7] equals 'yes'</sch:assert>
        <sch:assert test="not((.) = &apos;yes&apos;) or ../MTR:PercentageShareholding" id="a_MPL-CLOSE-COMPANY-DIRECTOR-SIG.3" diagnostics="errorCode.MPL-CLOSE-COMPANY-DIRECTOR-SIG.3 transactional.MPL-CLOSE-COMPANY-DIRECTOR-SIG.3 transactional.en.MPL-CLOSE-COMPANY-DIRECTOR-SIG.3 ">[EMP7.4] should be present if [EMP7] equals 'yes'</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p78">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102/MTR:Expenses/MTR:FixedExpensesDeductions">
        <sch:assert test=". &lt;= 1132" id="a_MPL-FIXED-DEDUCTION-EXPENSES.0" diagnostics="errorCode.MPL-FIXED-DEDUCTION-EXPENSES.0 transactional.MPL-FIXED-DEDUCTION-EXPENSES.0 transactional.en.MPL-FIXED-DEDUCTION-EXPENSES.0 ">[EMP18] is valid only if this does not exceed [£1,132]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p80">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:Income/MTR:PayrolledBenefits">
        <sch:assert test=". &lt;= sum(../MTR:SalaryOrStipend)" id="a_MOR4-PYRLD-BIK-SLR.0" diagnostics="errorCode.MOR4-PYRLD-BIK-SLR.0 transactional.MOR4-PYRLD-BIK-SLR.0 transactional.en.MOR4-PYRLD-BIK-SLR.0 ">[MOR2.1] is valid only if this does not exceed [MOR2]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p81">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:Income/MTR:TaxTakenOffSalaryStipend">
        <sch:assert test="../MTR:SalaryOrStipend" id="a_MOR4-SALARY-STIPEND-TAX-AMO.1" diagnostics="errorCode.MOR4-SALARY-STIPEND-TAX-AMO.1 transactional.MOR4-SALARY-STIPEND-TAX-AMO.1 transactional.en.MOR4-SALARY-STIPEND-TAX-AMO.1 ">If [MOR3] is present, [MOR2] should be present</sch:assert>
        <sch:assert test="(1 &lt; count(../../../MTR:SA102M)) or . &gt;= 0 or (../../../MTR:SA102/MTR:Employment/MTR:TaxTakenOffPay[. &gt; 0])" id="a_MOR4-SALARY-STIPEND-TAX-AMO.2" diagnostics="errorCode.MOR4-SALARY-STIPEND-TAX-AMO.2 transactional.MOR4-SALARY-STIPEND-TAX-AMO.2 transactional.en.MOR4-SALARY-STIPEND-TAX-AMO.2 ">May be negative if more than one set of [SA102M] minister of religion pages present. Must not be negative if only one set of [SA102M] minister of religion pages present unless there is also a positive value on a [SA102] employment page box [EMP2].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p82">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:Income/MTR:TaxTakenOffRoundSumExpenses">
        <sch:assert test="../MTR:RoundSumExpensesAndRentAllowances" id="a_MOR4-ROUND-SUM-RENT-TAX-AMOUNT.1" diagnostics="errorCode.MOR4-ROUND-SUM-RENT-TAX-AMOUNT.1 transactional.MOR4-ROUND-SUM-RENT-TAX-AMOUNT.1 transactional.en.MOR4-ROUND-SUM-RENT-TAX-AMOUNT.1 ">If tax taken off box 8 is present the following should be true: [MOR8]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p83">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:Income/MTR:TaxTakenOffOtherIncome">
        <sch:assert test="../MTR:OtherIncomeFromPost" id="a_MOR4-MOR-OTHER-INC-BC-TAX-AMO.1" diagnostics="errorCode.MOR4-MOR-OTHER-INC-BC-TAX-AMO.1 transactional.MOR4-MOR-OTHER-INC-BC-TAX-AMO.1 transactional.en.MOR4-MOR-OTHER-INC-BC-TAX-AMO.1 ">If tax taken off other income is present the following should be true: [MOR10]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p84">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:Income/MTR:TotalIncomeAsMinisterOfReligion">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:SalaryOrStipend) + sum(../MTR:FeesAndOfferings) + sum(../MTR:VicarageManseExpenses) + sum(../MTR:PersonalExpensesEtcPaid) + sum(../MTR:ExcessMileageAllowanceEtc) + sum(../MTR:RoundSumExpensesAndRentAllowances) + sum(../MTR:OtherIncomeFromPost)))) &lt; 0.001)" id="a_MOR4-MOR-INCOME-TOT.0" diagnostics="errorCode.MOR4-MOR-INCOME-TOT.0 transactional.MOR4-MOR-INCOME-TOT.0 transactional.en.MOR4-MOR-INCOME-TOT.0 ">[MOR12] is valid only if this equals ( The sum of [MOR2], [MOR4], [MOR5], [MOR6], [MOR7], [MOR8], and [MOR10] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p85">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:BenefitsAndExpensePaymentsToYou/MTR:TotalBenefitsAndExpenses">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:VicarageServicesBenefit) + sum(../MTR:CarProvided) + sum(../MTR:FuelForCarProvided) + sum(../MTR:InterestFreeLoans) + sum(../MTR:ExpensesPaymentsMade) + sum(../MTR:OtherBenefits)))) &lt; 0.001)" id="a_MOR4-MOR-BENEFIT-TOT.1" diagnostics="errorCode.MOR4-MOR-BENEFIT-TOT.1 transactional.MOR4-MOR-BENEFIT-TOT.1 transactional.en.MOR4-MOR-BENEFIT-TOT.1 ">[MOR19] should equal ( The sum of [MOR13], [MOR14], [MOR15], [MOR16], [MOR17], and [MOR18] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p86">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:IncomeBenefitsAndExpensesReceived">
        <sch:assert test="((.) - ((sum(../MTR:Income/MTR:TotalIncomeAsMinisterOfReligion) + sum(../MTR:BenefitsAndExpensePaymentsToYou/MTR:TotalBenefitsAndExpenses))) &lt; 0.001)" id="a_MOR4-MOR-TAXABLE-INC-TOT.0" diagnostics="errorCode.MOR4-MOR-TAXABLE-INC-TOT.0 transactional.MOR4-MOR-TAXABLE-INC-TOT.0 transactional.en.MOR4-MOR-TAXABLE-INC-TOT.0 ">[MOR20] should not exceed ( [MOR12] plus [MOR19] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p87">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:ExpensesPaidByYou/MTR:TotalExpensesPaid">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:RentExpenses) + sum(../MTR:MaintenanceAndRepairsEtc) + sum(../MTR:TravellingExpensesAndCapitalAllowances) + sum(../MTR:SecretarialAssistance) + sum(../MTR:OtherExpenses)))) &lt; 0.001)" id="a_MOR4-MOR-TOTAL-EXPENSE-AMO.1" diagnostics="errorCode.MOR4-MOR-TOTAL-EXPENSE-AMO.1 transactional.MOR4-MOR-TOTAL-EXPENSE-AMO.1 transactional.en.MOR4-MOR-TOTAL-EXPENSE-AMO.1 ">
total expenses paid is valid if and only if this equals ( The sum of [MOR23], [MOR22], [MOR21], [MOR24], and [MOR25] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p88">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:ServiceBenefitCap/MTR:GrossIncome">
        <sch:assert test="((.) - (sum(../../MTR:IncomeBenefitsAndExpensesReceived) - (sum(../../MTR:Income/MTR:VicarageManseExpenses) + sum(../../MTR:BenefitsAndExpensePaymentsToYou/MTR:VicarageServicesBenefit))) &lt; 0.001)" id="a_MOR4-SBCC-GROSS-INCOME-AMT.0" diagnostics="errorCode.MOR4-SBCC-GROSS-INCOME-AMT.0 transactional.MOR4-SBCC-GROSS-INCOME-AMT.0 transactional.en.MOR4-SBCC-GROSS-INCOME-AMT.0 ">If present, [MOR27] must not exceed  [MOR20] - ([MOR5] + [MOR13]) </sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p89">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:ServiceBenefitCap/MTR:NetIncome">
        <sch:assert test="(math:abs((.) - (((sum(../MTR:GrossIncome) + sum(../MTR:BackpayReceivedAfterYearEnd)) - (sum(../../MTR:ExpensesPaidByYou/MTR:TotalExpensesPaid) + sum(../MTR:EarlierYearsBackpayReceivedInYear) + sum(../MTR:PensionSchemePayments))))) &lt; 0.001)" id="a_MOR4-SBCC-NET-INCOME-AMT.1" diagnostics="errorCode.MOR4-SBCC-NET-INCOME-AMT.1 transactional.MOR4-SBCC-NET-INCOME-AMT.1 transactional.en.MOR4-SBCC-NET-INCOME-AMT.1 ">[MOR31] should equal ( ( [MOR27] plus [MOR28] ) minus ( The sum of [MOR26], [MOR29], and [MOR30] ) )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p90">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:ServiceBenefitCap/MTR:TenPercentOfNetIncome">
        <sch:assert test="not(../MTR:NetIncome) or ((.) - ((sum(../MTR:NetIncome) div 10) + 1.00) &lt; 0.001)" id="a_MOR4-SBCC-10PC-NET-INCOME-AMT.1" diagnostics="errorCode.MOR4-SBCC-10PC-NET-INCOME-AMT.1 transactional.MOR4-SBCC-10PC-NET-INCOME-AMT.1 transactional.en.MOR4-SBCC-10PC-NET-INCOME-AMT.1 ">If [MOR31] present, it must be less than or equal to ([MOR31] x 10%) + £1</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p91">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:ServiceBenefitCap/MTR:PaymentsMadeAndServiceBenefitReceived">
        <sch:assert test="(math:abs((.) - ((sum(../../MTR:Income/MTR:VicarageManseExpenses) + sum(../../MTR:BenefitsAndExpensePaymentsToYou/MTR:VicarageServicesBenefit)))) &lt; 0.001)" id="a_MOR4-SBCC-SERVICE-BEN-RECD-AMT.1" diagnostics="errorCode.MOR4-SBCC-SERVICE-BEN-RECD-AMT.1 transactional.MOR4-SBCC-SERVICE-BEN-RECD-AMT.1 transactional.en.MOR4-SBCC-SERVICE-BEN-RECD-AMT.1 ">[MOR34] should equal ( [MOR5] plus [MOR13] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p92">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:ServiceBenefitCap/MTR:ServiceBenefitCap">
        <sch:assert test="(math:abs((number(.)) - (sum(../MTR:AmountPaidTowardServiceBenefit) + sum(../MTR:PaymentsMadeAndServiceBenefitReceived) - sum(../MTR:TenPercentOfNetIncome))) &lt; 0.001) or (((sum(../MTR:AmountPaidTowardServiceBenefit) + sum(../MTR:PaymentsMadeAndServiceBenefitReceived) - sum(../MTR:TenPercentOfNetIncome)) - (0) &lt;= -0.001) and number(.) = 0)" id="a_MOR4-SERVICE-BEN-CAP-EXP-AMO.1" diagnostics="errorCode.MOR4-SERVICE-BEN-CAP-EXP-AMO.1 transactional.MOR4-SERVICE-BEN-CAP-EXP-AMO.1 transactional.en.MOR4-SERVICE-BEN-CAP-EXP-AMO.1 ">[MOR35] should equal ( [MOR33] plus [MOR34] minus [MOR32] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p93">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:OtherIncome/MTR:TaxTakenOfOtherIncome">
        <sch:assert test=". &lt;= sum(../MTR:ChaplaincyAndOtherIncome)" id="a_MOR4-OTHER-MNSTRY-TAX-TOT.2" diagnostics="errorCode.MOR4-OTHER-MNSTRY-TAX-TOT.2 transactional.MOR4-OTHER-MNSTRY-TAX-TOT.2 transactional.en.MOR4-OTHER-MNSTRY-TAX-TOT.2 ">
tax taken of other income is valid if and only if this does not exceed [MOR36]</sch:assert>
        <sch:assert test="../MTR:ChaplaincyAndOtherIncome" id="a_MOR4-OTHER-MNSTRY-TAX-TOT.3" diagnostics="errorCode.MOR4-OTHER-MNSTRY-TAX-TOT.3 transactional.MOR4-OTHER-MNSTRY-TAX-TOT.3 transactional.en.MOR4-OTHER-MNSTRY-TAX-TOT.3 ">If tax taken of other income is present the following should be true: [MOR36]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p94">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:TaxableIncome/MTR:TaxableIncomeMinusExpenses">
        <sch:assert test="(math:abs((.) - (((sum(../../MTR:IncomeBenefitsAndExpensesReceived) + sum(../../MTR:OtherIncome/MTR:ChaplaincyAndOtherIncome)) - (sum(../../MTR:ExpensesPaidByYou/MTR:TotalExpensesPaid) + sum(../../MTR:ServiceBenefitCap/MTR:ServiceBenefitCap))))) &lt; 0.001)" id="a_MOR-MOR-TOTAL-TAXABLE-INCOME.1" diagnostics="errorCode.MOR-MOR-TOTAL-TAXABLE-INCOME.1 transactional.MOR-MOR-TOTAL-TAXABLE-INCOME.1 transactional.en.MOR-MOR-TOTAL-TAXABLE-INCOME.1 ">
taxable income minus expenses is valid if and only if this equals ( ( [MOR20] plus [MOR36] ) minus ( [MOR26] plus [MOR35] ) )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p95">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M/MTR:TaxableIncome/MTR:TotalTaxTakenOff">
        <sch:assert test="(math:abs((.) - ((sum(../../MTR:Income/MTR:TaxTakenOffSalaryStipend) + sum(../../MTR:Income/MTR:TaxTakenOffRoundSumExpenses) + sum(../../MTR:Income/MTR:TaxTakenOffOtherIncome) + sum(../../MTR:OtherIncome/MTR:TaxTakenOfOtherIncome)))) &lt; 0.001)" id="a_MOR-MOR-TOTAL-TAX-PAID.1" diagnostics="errorCode.MOR-MOR-TOTAL-TAX-PAID.1 transactional.MOR-MOR-TOTAL-TAX-PAID.1 transactional.en.MOR-MOR-TOTAL-TAX-PAID.1 ">[MOR39] should equal ( The sum of [MOR3], [MOR9], [MOR11], and [MOR37] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p79">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA102M">
        <sch:assert test="not(MTR:BenefitsAndExpensePaymentsToYou/MTR:VicarageServicesBenefit or MTR:BenefitsAndExpensePaymentsToYou/MTR:CarProvided or MTR:BenefitsAndExpensePaymentsToYou/MTR:FuelForCarProvided or MTR:BenefitsAndExpensePaymentsToYou/MTR:InterestFreeLoans or MTR:BenefitsAndExpensePaymentsToYou/MTR:ExpensesPaymentsMade or MTR:BenefitsAndExpensePaymentsToYou/MTR:OtherBenefits) or MTR:BenefitsAndExpensePaymentsToYou/MTR:TotalBenefitsAndExpenses" id="a_SA102M.1" diagnostics="errorCode.SA102M.1 transactional.SA102M.1 transactional.en.SA102M.1 ">total benefits and expenses should be present if [MOR13] or [MOR14] or [MOR15] or [MOR16] or [MOR17] or [MOR18]</sch:assert>
        <sch:assert test="not(MTR:Income/MTR:TotalIncomeAsMinisterOfReligion or MTR:BenefitsAndExpensePaymentsToYou/MTR:TotalBenefitsAndExpenses) or MTR:IncomeBenefitsAndExpensesReceived" id="a_SA102M.2" diagnostics="errorCode.SA102M.2 transactional.SA102M.2 transactional.en.SA102M.2 ">income, benefits and expenses received should be present if [MOR12] or [MOR19]</sch:assert>
        <sch:assert test="not(MTR:ExpensesPaidByYou/MTR:TravellingExpensesAndCapitalAllowances or MTR:ExpensesPaidByYou/MTR:MaintenanceAndRepairsEtc or MTR:ExpensesPaidByYou/MTR:RentExpenses or MTR:ExpensesPaidByYou/MTR:SecretarialAssistance or MTR:ExpensesPaidByYou/MTR:OtherExpenses) or MTR:ExpensesPaidByYou/MTR:TotalExpensesPaid" id="a_SA102M.3" diagnostics="errorCode.SA102M.3 transactional.SA102M.3 transactional.en.SA102M.3 ">total expenses paid should be present if [MOR21] or [MOR22] or [MOR23] or [MOR24] or [MOR25]</sch:assert>
        <sch:assert test="not(((((sum(MTR:IncomeBenefitsAndExpensesReceived) + sum(MTR:OtherIncome/MTR:ChaplaincyAndOtherIncome)) - (sum(MTR:ExpensesPaidByYou/MTR:TotalExpensesPaid) + sum(MTR:ServiceBenefitCap/MTR:ServiceBenefitCap)))) - (0) &gt;= 0.001)) or MTR:TaxableIncome/MTR:TaxableIncomeMinusExpenses" id="a_SA102M.5" diagnostics="errorCode.SA102M.5 transactional.SA102M.5 transactional.en.SA102M.5 ">taxable income minus expenses should be present if ( ( [MOR20] plus [MOR36] ) minus ( [MOR26] plus [MOR35] ) ) exceeds 0</sch:assert>
        <sch:assert test="not(
                 MTR:Income/MTR:TaxTakenOffSalaryStipend
              or MTR:Income/MTR:TaxTakenOffRoundSumExpenses
              or MTR:Income/MTR:TaxTakenOffOtherIncome
              or MTR:OtherIncome/MTR:TaxTakenOfOtherIncome
            )
            or MTR:TaxableIncome/MTR:TotalTaxTakenOff" id="a_SA102M.6" diagnostics="errorCode.SA102M.6 transactional.SA102M.6 transactional.en.SA102M.6 ">total tax taken off should be present if [MOR3] or [MOR9] or [MOR11] or [MOR37]</sch:assert>
        <sch:assert test="not(MTR:Income/MTR:SalaryOrStipend) or MTR:Income/MTR:TotalIncomeAsMinisterOfReligion" id="a_SA102M.0" diagnostics="errorCode.SA102M.0 transactional.SA102M.0 transactional.en.SA102M.0 ">[MOR12] should be present if [MOR2] is present</sch:assert>
        <sch:assert test="not(MTR:Income/MTR:FeesAndOfferings) or MTR:Income/MTR:TotalIncomeAsMinisterOfReligion" id="a_SA102M.4" diagnostics="errorCode.SA102M.4 transactional.SA102M.4 transactional.en.SA102M.4 ">[MOR12] should be present if [MOR4] is present</sch:assert>
        <sch:assert test="not(MTR:Income/MTR:VicarageManseExpenses) or MTR:Income/MTR:TotalIncomeAsMinisterOfReligion" id="a_SA102M.8" diagnostics="errorCode.SA102M.8 transactional.SA102M.8 transactional.en.SA102M.8 ">[MOR12] should be present if [MOR5] is present</sch:assert>
        <sch:assert test="not(MTR:Income/MTR:PersonalExpensesEtcPaid) or MTR:Income/MTR:TotalIncomeAsMinisterOfReligion" id="a_SA102M.9" diagnostics="errorCode.SA102M.9 transactional.SA102M.9 transactional.en.SA102M.9 ">[MOR12] should be present if [MOR6] is present</sch:assert>
        <sch:assert test="not(MTR:Income/MTR:ExcessMileageAllowanceEtc) or MTR:Income/MTR:TotalIncomeAsMinisterOfReligion" id="a_SA102M.10" diagnostics="errorCode.SA102M.10 transactional.SA102M.10 transactional.en.SA102M.10 ">[MOR12] should be present if [MOR7] is present</sch:assert>
        <sch:assert test="not(MTR:Income/MTR:RoundSumExpensesAndRentAllowances) or MTR:Income/MTR:TotalIncomeAsMinisterOfReligion" id="a_SA102M.11" diagnostics="errorCode.SA102M.11 transactional.SA102M.11 transactional.en.SA102M.11 ">[MOR12] should be present if [MOR8] is present</sch:assert>
        <sch:assert test="not(MTR:Income/MTR:OtherIncomeFromPost) or MTR:Income/MTR:TotalIncomeAsMinisterOfReligion" id="a_SA102M.12" diagnostics="errorCode.SA102M.12 transactional.SA102M.12 transactional.en.SA102M.12 ">[MOR12] should be present if [MOR10] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p97">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessDetails/MTR:DidYourBusinessStart">
        <sch:assert test="not((.) = &apos;yes&apos;) or ../MTR:DateBusinessStarted" id="a_SLF-BUSINESS-COMM-QUES.0" diagnostics="errorCode.SLF-BUSINESS-COMM-QUES.0 transactional.SLF-BUSINESS-COMM-QUES.0 transactional.en.SLF-BUSINESS-COMM-QUES.0 ">[FSE6] should be present if [FSE6Q] equals 'yes'</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p98">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessDetails/MTR:DateBusinessStarted">
        <sch:assert test="(round(date:seconds(normalize-space(concat(2025, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))
                  and
                (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2026, &quot;-04-05&quot;))) div 86400))" id="a_SLF1-COMMENCEMENT-DATE.1" diagnostics="errorCode.SLF1-COMMENCEMENT-DATE.1 transactional.SLF1-COMMENCEMENT-DATE.1 transactional.en.SLF1-COMMENCEMENT-DATE.1 ">[FSE6] should be within the current return year</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p99">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessDetails/MTR:DidYourBusinessCease">
        <sch:assert test="not((.) = &apos;yes&apos;) or ../MTR:DateBusinessCeased" id="a_SLF-BUSINESS-CESS-QUES.0" diagnostics="errorCode.SLF-BUSINESS-CESS-QUES.0 transactional.SLF-BUSINESS-CESS-QUES.0 transactional.en.SLF-BUSINESS-CESS-QUES.0 ">[FSE7] should be present if [FSE7Q] equals 'yes'</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p100">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessDetails/MTR:DateBusinessCeased">
        <sch:assert test="(round(date:seconds(normalize-space(concat(2025, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))
                  and
                (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2026, &quot;-04-05&quot;))) div 86400))" id="a_SLF-CESSATION-DATE.1" diagnostics="errorCode.SLF-CESSATION-DATE.1 transactional.SLF-CESSATION-DATE.1 transactional.en.SLF-CESSATION-DATE.1 ">[FSE7] should be within the current return year</sch:assert>
        <sch:assert test="not(../MTR:DateBusinessStarted) or starts-with(date:difference(normalize-space(../MTR:DateBusinessStarted), normalize-space((.))), &apos;P&apos;)" id="a_SLF-CESSATION-DATE.2" diagnostics="errorCode.SLF-CESSATION-DATE.2 transactional.SLF-CESSATION-DATE.2 transactional.en.SLF-CESSATION-DATE.2 ">Must be the same as or later than [FSE6]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p101">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessDetails/MTR:DateAccountingPeriodEnds">
        <sch:assert test="(number(translate(.,&apos;-&apos;,&apos;&apos;)) &gt;= number(translate(../MTR:DateAccountingPeriodStarts,&apos;-&apos;,&apos;&apos;))) or not (../MTR:DateAccountingPeriodStarts)" id="a_SLF-ACCOUNT-END-DATE.1" diagnostics="errorCode.SLF-ACCOUNT-END-DATE.1 transactional.SLF-ACCOUNT-END-DATE.1 transactional.en.SLF-ACCOUNT-END-DATE.1 ">If [FSE8] is present, Must be the same as or later than [FSE8]</sch:assert>
        <sch:assert test="../MTR:DateAccountingPeriodStarts" id="a_SLF-ACCOUNT-END-DATE.2" diagnostics="errorCode.SLF-ACCOUNT-END-DATE.2 transactional.SLF-ACCOUNT-END-DATE.2 transactional.en.SLF-ACCOUNT-END-DATE.2 ">If date accounting period ends is present the following should be true: [FSE8]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p102">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessIncome/MTR:Turnover">
        <sch:assert test="../../MTR:BusinessDetails/MTR:DateAccountingPeriodStarts" id="a_SLF-BUSINESS-SALES-TURNOVER.1" diagnostics="errorCode.SLF-BUSINESS-SALES-TURNOVER.1 transactional.SLF-BUSINESS-SALES-TURNOVER.1 transactional.en.SLF-BUSINESS-SALES-TURNOVER.1 ">If turnover is present the following should be true: [FSE8]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p103">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessIncome/MTR:OtherBusinessIncome">
        <sch:assert test="../../MTR:BusinessDetails/MTR:DateAccountingPeriodStarts" id="a_SLF-OTHER-INCOME-PROFITS.1" diagnostics="errorCode.SLF-OTHER-INCOME-PROFITS.1 transactional.SLF-OTHER-INCOME-PROFITS.1 transactional.en.SLF-OTHER-INCOME-PROFITS.1 ">If other business income is present the following should be true: [FSE8]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p104">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance">
        <sch:assert test="((.) - (sum(../../MTR:TaxableProfitOrLoss/MTR:NetBusinessProfitLossForTax) + sum(../../MTR:TaxableProfitOrLoss/MTR:TaxYearAdjustment)) &lt; 0.001)" id="a_SLF-TRADING-INCOME-ALLOWANCE.0" diagnostics="errorCode.SLF-TRADING-INCOME-ALLOWANCE.0 transactional.SLF-TRADING-INCOME-ALLOWANCE.0 transactional.en.SLF-TRADING-INCOME-ALLOWANCE.0 ">[FSE16.1] must be less than or equal to ( [FSE64 / FSE65] + [FSE68] ).</sch:assert>
        <sch:assert test="not(../../../MTR:SA103S/MTR:NetProfitOrLoss &lt; 0)" id="a_SLF-TRADING-INCOME-ALLOWANCE.2" diagnostics="errorCode.SLF-TRADING-INCOME-ALLOWANCE.2 transactional.SLF-TRADING-INCOME-ALLOWANCE.2 transactional.en.SLF-TRADING-INCOME-ALLOWANCE.2 ">If [FSE16.1] is present then all instances of [SSE21/SSE22] can not be negative</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p105">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:TotalExpenses/MTR:CostOfGoods">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF2-COST-OF-SALES.0" diagnostics="errorCode.SLF2-COST-OF-SALES.0 transactional.SLF2-COST-OF-SALES.0 transactional.en.SLF2-COST-OF-SALES.0 ">[FSE17] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p106">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:TotalExpenses/MTR:SubcontractorCosts">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-SUB-CONTRACTOR-COSTS.0" diagnostics="errorCode.SLF-SUB-CONTRACTOR-COSTS.0 transactional.SLF-SUB-CONTRACTOR-COSTS.0 transactional.en.SLF-SUB-CONTRACTOR-COSTS.0 ">[FSE18] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p107">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:TotalExpenses/MTR:WagesSalariesAndStaffCosts">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-EMPLOYEE-COSTS.0" diagnostics="errorCode.SLF-EMPLOYEE-COSTS.0 transactional.SLF-EMPLOYEE-COSTS.0 transactional.en.SLF-EMPLOYEE-COSTS.0 ">[FSE19] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p108">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:TotalExpenses/MTR:CarVanAndTravelExpenses">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-MOTOR-EXPENSES.0" diagnostics="errorCode.SLF-MOTOR-EXPENSES.0 transactional.SLF-MOTOR-EXPENSES.0 transactional.en.SLF-MOTOR-EXPENSES.0 ">[FSE20] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p109">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:TotalExpenses/MTR:RentAndOtherPropertyCosts">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF2-PREMISES-COSTS.0" diagnostics="errorCode.SLF2-PREMISES-COSTS.0 transactional.SLF2-PREMISES-COSTS.0 transactional.en.SLF2-PREMISES-COSTS.0 ">[FSE21] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p110">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:TotalExpenses/MTR:RepairsAndMaintenanceCosts">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF2-REPAIRS.0" diagnostics="errorCode.SLF2-REPAIRS.0 transactional.SLF2-REPAIRS.0 transactional.en.SLF2-REPAIRS.0 ">[FSE22] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p111">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:TotalExpenses/MTR:PhoneAndOtherOfficeCosts">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-GENERAL-ADMIN-EXPENSES.0" diagnostics="errorCode.SLF-GENERAL-ADMIN-EXPENSES.0 transactional.SLF-GENERAL-ADMIN-EXPENSES.0 transactional.en.SLF-GENERAL-ADMIN-EXPENSES.0 ">[FSE23] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p112">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:TotalExpenses/MTR:AdvertisingAndEntertainmentCosts">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-ADVERTISING.0" diagnostics="errorCode.SLF-ADVERTISING.0 transactional.SLF-ADVERTISING.0 transactional.en.SLF-ADVERTISING.0 ">[FSE24] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p113">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:TotalExpenses/MTR:BankAndLoanInterest">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF2-LOAN-INTEREST.0" diagnostics="errorCode.SLF2-LOAN-INTEREST.0 transactional.SLF2-LOAN-INTEREST.0 transactional.en.SLF2-LOAN-INTEREST.0 ">[FSE25] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p114">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:TotalExpenses/MTR:OtherFinanceCharges">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF2-FINANCE-CHARGES.0" diagnostics="errorCode.SLF2-FINANCE-CHARGES.0 transactional.SLF2-FINANCE-CHARGES.0 transactional.en.SLF2-FINANCE-CHARGES.0 ">[FSE26] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p115">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:TotalExpenses/MTR:DebtsWrittenOff">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-BAD-DEBTS.0" diagnostics="errorCode.SLF-BAD-DEBTS.0 transactional.SLF-BAD-DEBTS.0 transactional.en.SLF-BAD-DEBTS.0 ">[FSE27] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p116">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:TotalExpenses/MTR:AccountancyAndLegalFees">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-LEGAL-COSTS.0" diagnostics="errorCode.SLF-LEGAL-COSTS.0 transactional.SLF-LEGAL-COSTS.0 transactional.en.SLF-LEGAL-COSTS.0 ">[FSE28] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p117">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:TotalExpenses/MTR:DepreciationAndLossProfitOnSale">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-DEPRECIATION.0" diagnostics="errorCode.SLF-DEPRECIATION.0 transactional.SLF-DEPRECIATION.0 transactional.en.SLF-DEPRECIATION.0 ">[FSE29] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p118">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:TotalExpenses/MTR:OtherBusinessExpenses">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-OTHER-EXPENDITURE.0" diagnostics="errorCode.SLF-OTHER-EXPENDITURE.0 transactional.SLF-OTHER-EXPENDITURE.0 transactional.en.SLF-OTHER-EXPENDITURE.0 ">[FSE30] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p119">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:TotalExpenses/MTR:TotalExpenses">
        <sch:assert test="not(../MTR:CostOfGoods or ../MTR:SubcontractorCosts or ../MTR:WagesSalariesAndStaffCosts or ../MTR:CarVanAndTravelExpenses or ../MTR:RentAndOtherPropertyCosts or ../MTR:RepairsAndMaintenanceCosts or ../MTR:PhoneAndOtherOfficeCosts or ../MTR:AdvertisingAndEntertainmentCosts or ../MTR:BankAndLoanInterest or ../MTR:OtherFinanceCharges or ../MTR:DebtsWrittenOff or ../MTR:AccountancyAndLegalFees or ../MTR:DepreciationAndLossProfitOnSale or ../MTR:OtherBusinessExpenses)

or

((math:abs(((.)) - ((sum(../MTR:CostOfGoods) + sum(../MTR:SubcontractorCosts) + sum(../MTR:WagesSalariesAndStaffCosts) + sum(../MTR:CarVanAndTravelExpenses) + sum(../MTR:RentAndOtherPropertyCosts) + sum(../MTR:RepairsAndMaintenanceCosts) + sum(../MTR:PhoneAndOtherOfficeCosts) + sum(../MTR:AdvertisingAndEntertainmentCosts) + sum(../MTR:BankAndLoanInterest) + sum(../MTR:OtherFinanceCharges) + sum(../MTR:DebtsWrittenOff) + sum(../MTR:AccountancyAndLegalFees) + sum(../MTR:DepreciationAndLossProfitOnSale) + sum(../MTR:OtherBusinessExpenses)))) &lt; 0.001))" id="a_SLF-TOTAL-EXPENDITURE.1" diagnostics="errorCode.SLF-TOTAL-EXPENDITURE.1 transactional.SLF-TOTAL-EXPENDITURE.1 transactional.en.SLF-TOTAL-EXPENDITURE.1 ">If entry in any of [FSE17],[FSE18],[FSE19],[FSE20],[FSE21],[FSE22],[FSE23],[FSE24],[FSE25],[FSE26],[FSE27],[FSE28],[FSE29] or [FSE30] total of all boxes must = [FSE31]</sch:assert>
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-TOTAL-EXPENDITURE.0" diagnostics="errorCode.SLF-TOTAL-EXPENDITURE.0 transactional.SLF-TOTAL-EXPENDITURE.0 transactional.en.SLF-TOTAL-EXPENDITURE.0 ">[FSE31] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p120">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableCostOfGoods">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF2-DISALLOW-COST-OF-SALES.0" diagnostics="errorCode.SLF2-DISALLOW-COST-OF-SALES.0 transactional.SLF2-DISALLOW-COST-OF-SALES.0 transactional.en.SLF2-DISALLOW-COST-OF-SALES.0 ">[FSE32] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p121">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableSubcontractorCosts">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-DISALLOW-SUB-CON-COSTS.0" diagnostics="errorCode.SLF-DISALLOW-SUB-CON-COSTS.0 transactional.SLF-DISALLOW-SUB-CON-COSTS.0 transactional.en.SLF-DISALLOW-SUB-CON-COSTS.0 ">[FSE33] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p122">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableStaffCosts">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-DISALLOW-EMPLOYEE-COSTS.0" diagnostics="errorCode.SLF-DISALLOW-EMPLOYEE-COSTS.0 transactional.SLF-DISALLOW-EMPLOYEE-COSTS.0 transactional.en.SLF-DISALLOW-EMPLOYEE-COSTS.0 ">[FSE34] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p123">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableCarAndTravelExpenses">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-DISALLOW-MOTOR-EXPENSES.0" diagnostics="errorCode.SLF-DISALLOW-MOTOR-EXPENSES.0 transactional.SLF-DISALLOW-MOTOR-EXPENSES.0 transactional.en.SLF-DISALLOW-MOTOR-EXPENSES.0 ">[FSE35] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p124">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableRentAndOtherPropertyCosts">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF2-DISALLOW-PREMISES-COSTS.0" diagnostics="errorCode.SLF2-DISALLOW-PREMISES-COSTS.0 transactional.SLF2-DISALLOW-PREMISES-COSTS.0 transactional.en.SLF2-DISALLOW-PREMISES-COSTS.0 ">[FSE36] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p125">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableRepairsAndMaintenanceCosts">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF2-DISALLOW-REPAIRS.0" diagnostics="errorCode.SLF2-DISALLOW-REPAIRS.0 transactional.SLF2-DISALLOW-REPAIRS.0 transactional.en.SLF2-DISALLOW-REPAIRS.0 ">[FSE37] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p126">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowablePhoneAndOtherOfficeCosts">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-DISALLOW-GENERAL-ADMIN-EXP.0" diagnostics="errorCode.SLF-DISALLOW-GENERAL-ADMIN-EXP.0 transactional.SLF-DISALLOW-GENERAL-ADMIN-EXP.0 transactional.en.SLF-DISALLOW-GENERAL-ADMIN-EXP.0 ">[FSE38] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p127">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableAdvertisingAndEntertainmentCosts">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-DISALLOW-ADVERTISING.0" diagnostics="errorCode.SLF-DISALLOW-ADVERTISING.0 transactional.SLF-DISALLOW-ADVERTISING.0 transactional.en.SLF-DISALLOW-ADVERTISING.0 ">[FSE39] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p128">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableBankAndLoanInterest">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF2-DISALLOW-LOAN-INTEREST.0" diagnostics="errorCode.SLF2-DISALLOW-LOAN-INTEREST.0 transactional.SLF2-DISALLOW-LOAN-INTEREST.0 transactional.en.SLF2-DISALLOW-LOAN-INTEREST.0 ">[FSE40] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p129">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableOtherFinanceCharges">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF2-DISALLOW-FINANCE-CHARGES.0" diagnostics="errorCode.SLF2-DISALLOW-FINANCE-CHARGES.0 transactional.SLF2-DISALLOW-FINANCE-CHARGES.0 transactional.en.SLF2-DISALLOW-FINANCE-CHARGES.0 ">[FSE41] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p130">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableDebtsWrittenOff">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-DISALLOW-BAD-DEBTS.0" diagnostics="errorCode.SLF-DISALLOW-BAD-DEBTS.0 transactional.SLF-DISALLOW-BAD-DEBTS.0 transactional.en.SLF-DISALLOW-BAD-DEBTS.0 ">[FSE42] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p131">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableAccountancyAndLegalFees">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-DISALLOW-LEGAL-COSTS.0" diagnostics="errorCode.SLF-DISALLOW-LEGAL-COSTS.0 transactional.SLF-DISALLOW-LEGAL-COSTS.0 transactional.en.SLF-DISALLOW-LEGAL-COSTS.0 ">[FSE43] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p132">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableDepreciationAndLossProfitOnSale">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-DISALLOW-DEPRECIATION.0" diagnostics="errorCode.SLF-DISALLOW-DEPRECIATION.0 transactional.SLF-DISALLOW-DEPRECIATION.0 transactional.en.SLF-DISALLOW-DEPRECIATION.0 ">[FSE44] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p133">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableOtherBusinessExpenses">
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-DISALLOW-OTHER.0" diagnostics="errorCode.SLF-DISALLOW-OTHER.0 transactional.SLF-DISALLOW-OTHER.0 transactional.en.SLF-DISALLOW-OTHER.0 ">[FSE45] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p134">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:TotalDisallowableExpenses">
        <sch:assert test="not(
                       ../MTR:DisallowableCostOfGoods
                    or ../MTR:DisallowableSubcontractorCosts
                    or ../MTR:DisallowableStaffCosts
                    or ../MTR:DisallowableCarAndTravelExpenses
                    or ../MTR:DisallowableRentAndOtherPropertyCosts
                    or ../MTR:DisallowableRepairsAndMaintenanceCosts
                    or ../MTR:DisallowablePhoneAndOtherOfficeCosts
                    or ../MTR:DisallowableAdvertisingAndEntertainmentCosts
                    or ../MTR:DisallowableBankAndLoanInterest
                    or ../MTR:DisallowableOtherFinanceCharges
                    or ../MTR:DisallowableDebtsWrittenOff
                    or ../MTR:DisallowableAccountancyAndLegalFees
                    or ../MTR:DisallowableDepreciationAndLossProfitOnSale
                    or ../MTR:DisallowableOtherBusinessExpenses
                  )
                  or
                  (math:abs((.) - (sum(../MTR:DisallowableCostOfGoods)
                     + sum(../MTR:DisallowableSubcontractorCosts)
                     + sum(../MTR:DisallowableStaffCosts)
                     + sum(../MTR:DisallowableCarAndTravelExpenses)
                     + sum(../MTR:DisallowableRentAndOtherPropertyCosts)
                     + sum(../MTR:DisallowableRepairsAndMaintenanceCosts)
                     + sum(../MTR:DisallowablePhoneAndOtherOfficeCosts)
                     + sum(../MTR:DisallowableAdvertisingAndEntertainmentCosts)
                     + sum(../MTR:DisallowableBankAndLoanInterest)
                     + sum(../MTR:DisallowableOtherFinanceCharges)
                     + sum(../MTR:DisallowableDebtsWrittenOff)
                     + sum(../MTR:DisallowableAccountancyAndLegalFees)
                     + sum(../MTR:DisallowableDepreciationAndLossProfitOnSale)
                     + sum(../MTR:DisallowableOtherBusinessExpenses))) &lt; 0.001)" id="a_SLF-DISALLOW-EXPENDITURE.1" diagnostics="errorCode.SLF-DISALLOW-EXPENDITURE.1 transactional.SLF-DISALLOW-EXPENDITURE.1 transactional.en.SLF-DISALLOW-EXPENDITURE.1 ">If entry in any of [FSE32], [FSE33], [FSE34], [FSE35], [FSE36], [FSE37], [FSE38], [FSE39], [FSE40], [FSE41], [FSE42], [FSE43], [FSE44], [FSE45] then total of those boxes must equal [FSE46]</sch:assert>
        <sch:assert test="not(../../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-DISALLOW-EXPENDITURE.0" diagnostics="errorCode.SLF-DISALLOW-EXPENDITURE.0 transactional.SLF-DISALLOW-EXPENDITURE.0 transactional.en.SLF-DISALLOW-EXPENDITURE.0 ">[FSE46] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p135">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:NetProfitLoss">
        <sch:assert test="( (math:abs(((sum(../MTR:BusinessIncome/MTR:Turnover) + sum(../MTR:BusinessIncome/MTR:OtherBusinessIncome) - sum(../MTR:BusinessExpenses/MTR:TotalExpenses/MTR:TotalExpenses))) - ((.))) &lt; 0.001))" id="a_SLF-NET-PROFIT-LOSS-AMT-merged.1" diagnostics="errorCode.SLF-NET-PROFIT-LOSS-AMT-merged.1 transactional.SLF-NET-PROFIT-LOSS-AMT-merged.1 transactional.en.SLF-NET-PROFIT-LOSS-AMT-merged.1 ">The sum of [FSE15] + [FSE16] minus [FSE31] must equal [FSE47/FSE48]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p137">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:CapitalAllowances/MTR:AnnualInvestmentAllowance">
        <sch:assert test=". &lt;= 1500000" id="a_SLF-ANNUAL-INV-ALLCE-AMT.0" diagnostics="errorCode.SLF-ANNUAL-INV-ALLCE-AMT.0 transactional.SLF-ANNUAL-INV-ALLCE-AMT.0 transactional.en.SLF-ANNUAL-INV-ALLCE-AMT.0 ">[FSE49] should not exceed [£1,500,000]</sch:assert>
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-ANNUAL-INV-ALLCE-AMT.2" diagnostics="errorCode.SLF-ANNUAL-INV-ALLCE-AMT.2 transactional.SLF-ANNUAL-INV-ALLCE-AMT.2 transactional.en.SLF-ANNUAL-INV-ALLCE-AMT.2 ">[FSE49] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p138">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:CapitalAllowances/MTR:AnnualAllowancesAtHigherRate">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-PLANT-MACHINERY-ALLCE.1" diagnostics="errorCode.SLF-PLANT-MACHINERY-ALLCE.1 transactional.SLF-PLANT-MACHINERY-ALLCE.1 transactional.en.SLF-PLANT-MACHINERY-ALLCE.1 ">[FSE50] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p139">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:CapitalAllowances/MTR:AnnualAllowancesAtLowerRate">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-YEAR1-ALLCE-AMT.1" diagnostics="errorCode.SLF-YEAR1-ALLCE-AMT.1 transactional.SLF-YEAR1-ALLCE-AMT.1 transactional.en.SLF-YEAR1-ALLCE-AMT.1 ">[FSE51] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p140">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:CapitalAllowances/MTR:ZeroEmissionGoodsVehicleAllowance">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-ZERO-EMISSIONS-GV-ALLCE.1" diagnostics="errorCode.SLF-ZERO-EMISSIONS-GV-ALLCE.1 transactional.SLF-ZERO-EMISSIONS-GV-ALLCE.1 transactional.en.SLF-ZERO-EMISSIONS-GV-ALLCE.1 ">[FSE52] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p141">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:CapitalAllowances/MTR:ZeroEmissionCarAllowance">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-ZERO-EMISSION-CAR-ALLCE.0" diagnostics="errorCode.SLF-ZERO-EMISSION-CAR-ALLCE.0 transactional.SLF-ZERO-EMISSION-CAR-ALLCE.0 transactional.en.SLF-ZERO-EMISSION-CAR-ALLCE.0 ">[FSE52.1] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p142">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:CapitalAllowances/MTR:TheStructuresAndBuildingsAllowance">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-SB-ALLCE.0" diagnostics="errorCode.SLF-SB-ALLCE.0 transactional.SLF-SB-ALLCE.0 transactional.en.SLF-SB-ALLCE.0 ">[FSE53] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p143">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:CapitalAllowances/MTR:FreeportAndInvestmentZonesStructuresAndBuildingsAllowance">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-FREEPORT-SB-ALLCE.0" diagnostics="errorCode.SLF-FREEPORT-SB-ALLCE.0 transactional.SLF-FREEPORT-SB-ALLCE.0 transactional.en.SLF-FREEPORT-SB-ALLCE.0 ">[FSE53.1] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p144">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:CapitalAllowances/MTR:ElectricChargePointAllowance">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-ECP-ALLCE.0" diagnostics="errorCode.SLF-ECP-ALLCE.0 transactional.SLF-ECP-ALLCE.0 transactional.en.SLF-ECP-ALLCE.0 ">[FSE54] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p145">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:CapitalAllowances/MTR:OtherCapitalAllowances">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF3-OTHER-CAPITAL-ALLOWANCES.1" diagnostics="errorCode.SLF3-OTHER-CAPITAL-ALLOWANCES.1 transactional.SLF3-OTHER-CAPITAL-ALLOWANCES.1 transactional.en.SLF3-OTHER-CAPITAL-ALLOWANCES.1 ">[FSE55] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p146">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:CapitalAllowances/MTR:BalancingAllowancesOnSaleOrCessation">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF-DISPOSAL-LOWVAL-ALLCE-AMT.1" diagnostics="errorCode.SLF-DISPOSAL-LOWVAL-ALLCE-AMT.1 transactional.SLF-DISPOSAL-LOWVAL-ALLCE-AMT.1 transactional.en.SLF-DISPOSAL-LOWVAL-ALLCE-AMT.1 ">[FSE56] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p147">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:CapitalAllowances/MTR:TotalCapitalAllowances">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SLF4-TOTAL-CAPITAL-ALLOWANCES.1" diagnostics="errorCode.SLF4-TOTAL-CAPITAL-ALLOWANCES.1 transactional.SLF4-TOTAL-CAPITAL-ALLOWANCES.1 transactional.en.SLF4-TOTAL-CAPITAL-ALLOWANCES.1 ">[FSE57] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
        <sch:assert test="(math:abs((.) - ((sum(../MTR:AnnualInvestmentAllowance) + sum(../MTR:AnnualAllowancesAtHigherRate) + sum(../MTR:AnnualAllowancesAtLowerRate) + sum(../MTR:ZeroEmissionGoodsVehicleAllowance) + sum(../MTR:ZeroEmissionCarAllowance) + sum(../MTR:TheStructuresAndBuildingsAllowance) + sum(../MTR:FreeportAndInvestmentZonesStructuresAndBuildingsAllowance) + sum(../MTR:ElectricChargePointAllowance) + sum(../MTR:OtherCapitalAllowances) + sum(../MTR:BalancingAllowancesOnSaleOrCessation)))) &lt; 0.001)" id="a_SLF4-TOTAL-CAPITAL-ALLOWANCES.0" diagnostics="errorCode.SLF4-TOTAL-CAPITAL-ALLOWANCES.0 transactional.SLF4-TOTAL-CAPITAL-ALLOWANCES.0 transactional.en.SLF4-TOTAL-CAPITAL-ALLOWANCES.0 ">[FSE57] is valid only if this equals ( The sum of [FSE49], [FSE50], [FSE51], [FSE52], [FSE52.1], [FSE53], [FSE53.1], [FSE54], [FSE55], and [FSE56] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p136">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:CapitalAllowances">
        <sch:assert test="not(MTR:AnnualInvestmentAllowance) or MTR:TotalCapitalAllowances" id="a_SLF-ANNUAL-INV-ALLCE-AMT.1" diagnostics="errorCode.SLF-ANNUAL-INV-ALLCE-AMT.1 transactional.SLF-ANNUAL-INV-ALLCE-AMT.1 transactional.en.SLF-ANNUAL-INV-ALLCE-AMT.1 ">[FSE57] should be present if [FSE49] is present</sch:assert>
        <sch:assert test="not(MTR:AnnualAllowancesAtHigherRate) or MTR:TotalCapitalAllowances" id="a_SLF-PLANT-MACHINERY-ALLCE.0" diagnostics="errorCode.SLF-PLANT-MACHINERY-ALLCE.0 transactional.SLF-PLANT-MACHINERY-ALLCE.0 transactional.en.SLF-PLANT-MACHINERY-ALLCE.0 ">[FSE57] should be present if [FSE50] is present</sch:assert>
        <sch:assert test="not(MTR:AnnualAllowancesAtLowerRate) or MTR:TotalCapitalAllowances" id="a_SLF-YEAR1-ALLCE-AMT.0" diagnostics="errorCode.SLF-YEAR1-ALLCE-AMT.0 transactional.SLF-YEAR1-ALLCE-AMT.0 transactional.en.SLF-YEAR1-ALLCE-AMT.0 ">[FSE57] should be present if [FSE51] is present</sch:assert>
        <sch:assert test="not(MTR:ZeroEmissionGoodsVehicleAllowance) or MTR:TotalCapitalAllowances" id="a_SLF-ZERO-EMISSIONS-GV-ALLCE.0" diagnostics="errorCode.SLF-ZERO-EMISSIONS-GV-ALLCE.0 transactional.SLF-ZERO-EMISSIONS-GV-ALLCE.0 transactional.en.SLF-ZERO-EMISSIONS-GV-ALLCE.0 ">[FSE57] should be present if [FSE52] is present</sch:assert>
        <sch:assert test="not(MTR:ZeroEmissionCarAllowance) or MTR:TotalCapitalAllowances" id="a_SLF-ZERO-EMISSION-CAR-ALLCE.1" diagnostics="errorCode.SLF-ZERO-EMISSION-CAR-ALLCE.1 transactional.SLF-ZERO-EMISSION-CAR-ALLCE.1 transactional.en.SLF-ZERO-EMISSION-CAR-ALLCE.1 ">[FSE57] should be present if [FSE52.1] is present</sch:assert>
        <sch:assert test="not(MTR:TheStructuresAndBuildingsAllowance) or MTR:TotalCapitalAllowances" id="a_SLF-SB-ALLCE.1" diagnostics="errorCode.SLF-SB-ALLCE.1 transactional.SLF-SB-ALLCE.1 transactional.en.SLF-SB-ALLCE.1 ">[FSE57] should be present if [FSE53] is present</sch:assert>
        <sch:assert test="not(MTR:FreeportAndInvestmentZonesStructuresAndBuildingsAllowance) or MTR:TotalCapitalAllowances" id="a_SLF-FREEPORT-SB-ALLCE.1" diagnostics="errorCode.SLF-FREEPORT-SB-ALLCE.1 transactional.SLF-FREEPORT-SB-ALLCE.1 transactional.en.SLF-FREEPORT-SB-ALLCE.1 ">[FSE57] should be present if [FSE53.1] is present</sch:assert>
        <sch:assert test="not(MTR:ElectricChargePointAllowance) or MTR:TotalCapitalAllowances" id="a_SLF-ECP-ALLCE.1" diagnostics="errorCode.SLF-ECP-ALLCE.1 transactional.SLF-ECP-ALLCE.1 transactional.en.SLF-ECP-ALLCE.1 ">[FSE57] should be present if [FSE54] is present</sch:assert>
        <sch:assert test="not(MTR:OtherCapitalAllowances) or MTR:TotalCapitalAllowances" id="a_SLF3-OTHER-CAPITAL-ALLOWANCES.0" diagnostics="errorCode.SLF3-OTHER-CAPITAL-ALLOWANCES.0 transactional.SLF3-OTHER-CAPITAL-ALLOWANCES.0 transactional.en.SLF3-OTHER-CAPITAL-ALLOWANCES.0 ">[FSE57] should be present if [FSE55] is present</sch:assert>
        <sch:assert test="not(MTR:BalancingAllowancesOnSaleOrCessation) or MTR:TotalCapitalAllowances" id="a_SLF-DISPOSAL-LOWVAL-ALLCE-AMT.0" diagnostics="errorCode.SLF-DISPOSAL-LOWVAL-ALLCE-AMT.0 transactional.SLF-DISPOSAL-LOWVAL-ALLCE-AMT.0 transactional.en.SLF-DISPOSAL-LOWVAL-ALLCE-AMT.0 ">[FSE57] should be present if [FSE56] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p148">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:AdditionsToNetProfitDeductionsFromNetLoss">
        <sch:assert test="(math:abs((.) - ((sum(../../MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:TotalDisallowableExpenses) + sum(../../MTR:CapitalAllowances/MTR:TotalBalancingCharges) + sum(../MTR:OwnGoodsAndServices)))) &lt; 0.001)" id="a_SLF1-ADDITIONS-TO-NET-PROFIT.0" diagnostics="errorCode.SLF1-ADDITIONS-TO-NET-PROFIT.0 transactional.SLF1-ADDITIONS-TO-NET-PROFIT.0 transactional.en.SLF1-ADDITIONS-TO-NET-PROFIT.0 ">[FSE61] is valid only if this equals ( The sum of [FSE46], [FSE59], and [FSE60] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p149">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:DeductionsFromNetProfitAdditionsToNetLoss">
        <sch:assert test="(math:abs((.) - ((sum(../../MTR:CapitalAllowances/MTR:TotalCapitalAllowances) + sum(../MTR:NonTaxableBusinessIncome)))) &lt; 0.001)" id="a_SLF-TOTAL-DEDUCTIONS.1" diagnostics="errorCode.SLF-TOTAL-DEDUCTIONS.1 transactional.SLF-TOTAL-DEDUCTIONS.1 transactional.en.SLF-TOTAL-DEDUCTIONS.1 ">[FSE63] should equal ( [FSE57] plus [FSE62] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p150">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:NetBusinessProfitLossForTax">
        <sch:assert test="(math:abs(((sum(../../MTR:NetProfitLoss) + sum(../MTR:AdditionsToNetProfitDeductionsFromNetLoss) - sum(../MTR:DeductionsFromNetProfitAdditionsToNetLoss))) - (number(.))) &lt; 0.001)" id="a_SLF-NET-BUSINESS-PROFIT-LOSS-AMT-merged.1" diagnostics="errorCode.SLF-NET-BUSINESS-PROFIT-LOSS-AMT-merged.1 transactional.SLF-NET-BUSINESS-PROFIT-LOSS-AMT-merged.1 transactional.en.SLF-NET-BUSINESS-PROFIT-LOSS-AMT-merged.1 ">The sum of [FSE47/FSE48] + [FSE61] - [FSE63] must equal [FSE64 / FSE65].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p151">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:LossBroughtForwardUsedAgainstSpreadTransitionProfit">
        <sch:assert test=". &lt;= sum(../MTR:SpreadTransitionProfitTreatedAsArising)" id="a_SLF-TRPO-LOSSES-USED-THIS-YEAR.0" diagnostics="errorCode.SLF-TRPO-LOSSES-USED-THIS-YEAR.0 transactional.SLF-TRPO-LOSSES-USED-THIS-YEAR.0 transactional.en.SLF-TRPO-LOSSES-USED-THIS-YEAR.0 ">[FSE73.4] is valid only if this does not exceed [FSE73.3].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p152">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:LossBroughtForward">
        <sch:assert test="(. &lt;= sum(../MTR:NetBusinessProfitLossForTax)) or (. &lt;= sum(../MTR:AdjustedProfitForTheYear))" id="a_SLF-LOSSES-USED-THIS-YEAR.1" diagnostics="errorCode.SLF-LOSSES-USED-THIS-YEAR.1 transactional.SLF-LOSSES-USED-THIS-YEAR.1 transactional.en.SLF-LOSSES-USED-THIS-YEAR.1 ">[FSE74] must not exceed the greater of [FSE64 / FSE65] and [FSE73].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p153">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:TotalTaxableBusinessProfits">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:AdjustedProfitForTheYear) - sum(../MTR:LossBroughtForward)) + sum(../MTR:AnyOtherBusinessIncome))) &lt; 0.001)" id="a_SLF1-TOTAL-TAXABLE-PROFITS.1" diagnostics="errorCode.SLF1-TOTAL-TAXABLE-PROFITS.1 transactional.SLF1-TOTAL-TAXABLE-PROFITS.1 transactional.en.SLF1-TOTAL-TAXABLE-PROFITS.1 ">[FSE76] should equal ([FSE73] minus [FSE74]) plus [FSE75]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p154">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:TotalTaxableBusinessProfitsFIGclaim">
        <sch:assert test=". &lt;= sum(../MTR:TotalTaxableBusinessProfits)" id="a_SLF1-TOTAL-TAX-PROF-FIG-CLM.0" diagnostics="errorCode.SLF1-TOTAL-TAX-PROF-FIG-CLM.0 transactional.SLF1-TOTAL-TAX-PROF-FIG-CLM.0 transactional.en.SLF1-TOTAL-TAX-PROF-FIG-CLM.0 ">[FSE76.1] is valid only if this does not exceed [FSE76]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_SLF1-TOTAL-TAX-PROF-FIG-CLM.1" diagnostics="errorCode.SLF1-TOTAL-TAX-PROF-FIG-CLM.1 transactional.SLF1-TOTAL-TAX-PROF-FIG-CLM.1 transactional.en.SLF1-TOTAL-TAX-PROF-FIG-CLM.1 ">If [FSE76.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p155">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:Losses/MTR:AdjustedLossForTheYear">
        <sch:assert test="(((sum(../../MTR:TaxableProfitOrLoss/MTR:NetBusinessProfitLossForTax) + sum(../../MTR:TaxableProfitOrLoss/MTR:TaxYearAdjustment) - sum(../../MTR:BusinessIncome/MTR:TradingIncomeAllowance))) - (0) &lt;= -0.001)
            or
          (math:abs((0) - ((.))) &lt; 0.001)" id="a_RIM-FSE-TAXABLE-PL.3" diagnostics="errorCode.RIM-FSE-TAXABLE-PL.3 transactional.RIM-FSE-TAXABLE-PL.3 transactional.en.RIM-FSE-TAXABLE-PL.3 ">If ([FSE64 / FSE65] + [FSE68] - [FSE16.1]) is greater than or equal to zero, then [FSE77] = 0 or is absent.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p156">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:Losses/MTR:AdjustedLossForTheYearFIGclaim">
        <sch:assert test=". = sum(../MTR:AdjustedLossForTheYear)" id="a_SLF3-ALLOW-LOSS-FIG-CLM.0" diagnostics="errorCode.SLF3-ALLOW-LOSS-FIG-CLM.0 transactional.SLF3-ALLOW-LOSS-FIG-CLM.0 transactional.en.SLF3-ALLOW-LOSS-FIG-CLM.0 ">[FSE77.1] is valid only if this equals [FSE77]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_SLF3-ALLOW-LOSS-FIG-CLM.1" diagnostics="errorCode.SLF3-ALLOW-LOSS-FIG-CLM.1 transactional.SLF3-ALLOW-LOSS-FIG-CLM.1 transactional.en.SLF3-ALLOW-LOSS-FIG-CLM.1 ">If [FSE77.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p157">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:Losses/MTR:LossOfYearSetAgainstOtherIncome">
        <sch:assert test=". &lt;= sum(../MTR:AdjustedLossForTheYear)" id="a_SLF1-LOSS-SET-OFF-OTHER-INC.1" diagnostics="errorCode.SLF1-LOSS-SET-OFF-OTHER-INC.1 transactional.SLF1-LOSS-SET-OFF-OTHER-INC.1 transactional.en.SLF1-LOSS-SET-OFF-OTHER-INC.1 ">[FSE78] should not exceed [FSE77]</sch:assert>
        <sch:assert test="not(../MTR:AdjustedLossForTheYearFIGclaim)" id="a_SLF1-LOSS-SET-OFF-OTHER-INC.0" diagnostics="errorCode.SLF1-LOSS-SET-OFF-OTHER-INC.0 transactional.SLF1-LOSS-SET-OFF-OTHER-INC.0 transactional.en.SLF1-LOSS-SET-OFF-OTHER-INC.0 ">[FSE78] should not be present if [FSE77.1] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p158">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:Losses/MTR:LossToCarryBack">
        <sch:assert test="(((.)) - (sum(../MTR:AdjustedLossForTheYear) - sum(../MTR:LossOfYearSetAgainstOtherIncome)) &lt; 0.001)" id="a_SLF-LOSS-TO-CARRY-BACK.1" diagnostics="errorCode.SLF-LOSS-TO-CARRY-BACK.1 transactional.SLF-LOSS-TO-CARRY-BACK.1 transactional.en.SLF-LOSS-TO-CARRY-BACK.1 ">Must not exceed [FSE77] minus [FSE78]</sch:assert>
        <sch:assert test="not(../MTR:AdjustedLossForTheYearFIGclaim)" id="a_SLF-LOSS-TO-CARRY-BACK.0" diagnostics="errorCode.SLF-LOSS-TO-CARRY-BACK.0 transactional.SLF-LOSS-TO-CARRY-BACK.0 transactional.en.SLF-LOSS-TO-CARRY-BACK.0 ">[FSE79] should not be present if [FSE77.1] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p159">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BalanceSheet/MTR:Assets/MTR:TotalBusinessAssets">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:EquipmentMachineryVehicles) + sum(../MTR:OtherFixedAssets) + sum(../MTR:StockAndWorkInProgress) + sum(../MTR:TradeDebtors) + sum(../MTR:BankEtcBalances) + sum(../MTR:CashInHand) + sum(../MTR:OtherCurrentAssets)))) &lt; 0.001)" id="a_SLF3-TOTAL-ASSETS.1" diagnostics="errorCode.SLF3-TOTAL-ASSETS.1 transactional.SLF3-TOTAL-ASSETS.1 transactional.en.SLF3-TOTAL-ASSETS.1 ">
total business assets is valid if and only if this equals ( The sum of [FSE83], [FSE84], [FSE85], [FSE86], [FSE87], [FSE88], and [FSE89] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p160">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BalanceSheet/MTR:NetBusinessAssets">
        <sch:assert test="(math:abs((.) - (sum(../MTR:Assets/MTR:TotalBusinessAssets) - (sum(../MTR:Liabilities/MTR:TradeCreditors) + sum(../MTR:Liabilities/MTR:LoansAndOverdrafts) + sum(../MTR:Liabilities/MTR:OtherLiabilities)))) &lt; 0.001)" id="a_SLF3-NET-BUSINESS-ASSETS.1" diagnostics="errorCode.SLF3-NET-BUSINESS-ASSETS.1 transactional.SLF3-NET-BUSINESS-ASSETS.1 transactional.en.SLF3-NET-BUSINESS-ASSETS.1 ">[FSE94] should equal ( [FSE90] minus ( The sum of [FSE91], [FSE92], and [FSE93] ) )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p161">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BalanceSheet/MTR:CapitalAccount/MTR:NetProfitOrLoss">
        <sch:assert test="number(.) = sum(../../../MTR:NetProfitLoss)" id="a_SLF3-ACCOUNT-NET-PROFIT-LOSS.0" diagnostics="errorCode.SLF3-ACCOUNT-NET-PROFIT-LOSS.0 transactional.SLF3-ACCOUNT-NET-PROFIT-LOSS.0 transactional.en.SLF3-ACCOUNT-NET-PROFIT-LOSS.0 ">Must = [FSE47/FSE48]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p162">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:BalanceSheet/MTR:CapitalAccount/MTR:CapitalAccountBalanceAtEnd">
        <sch:assert test="(math:abs((.) - (((sum(../MTR:CapitalAccountBalanceAtStart) + sum(../MTR:NetProfitOrLoss) + sum(../MTR:CapitalIntroduced)) - sum(../MTR:Drawings)))) &lt; 0.001)" id="a_SLF3-TOTAL-BALANCE.1" diagnostics="errorCode.SLF3-TOTAL-BALANCE.1 transactional.SLF3-TOTAL-BALANCE.1 transactional.en.SLF3-TOTAL-BALANCE.1 ">[FSE99] should equal ( ( The sum of [FSE95], [FSE96], and [FSE97] ) minus [FSE98] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p164">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:NICs/MTR:Class2NICamount">
        <sch:assert test=". &lt;= 219.95" id="a_SLF-CLASS-2-NIC-AMOUNT.0" diagnostics="errorCode.SLF-CLASS-2-NIC-AMOUNT.0 transactional.SLF-CLASS-2-NIC-AMOUNT.0 transactional.en.SLF-CLASS-2-NIC-AMOUNT.0 ">[FSECL2] is valid only if this does not exceed [£219.95]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p163">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F/MTR:NICs">
        <sch:assert test="MTR:PayClass2NICvoluntarily or MTR:Class2NICamount or MTR:Class4NICexempt or MTR:AdjustmentToClass4NICProfits" id="a_RIM-FSE-NIC.0" diagnostics="errorCode.RIM-FSE-NIC.0 transactional.RIM-FSE-NIC.0 transactional.en.RIM-FSE-NIC.0 ">If [FSE100-102] is present then at least one of the following should be present: [FSE100], [FSECL2], [FSE101] or [FSE102]</sch:assert>
        <sch:assert test="not(MTR:PayClass2NICvoluntarily) or MTR:Class2NICamount" id="a_RIM-FSE-NIC.1" diagnostics="errorCode.RIM-FSE-NIC.1 transactional.RIM-FSE-NIC.1 transactional.en.RIM-FSE-NIC.1 ">[FSECL2] should be present if [FSE100] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p96">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103F">
        <sch:assert test="not(MTR:BusinessDetails/MTR:DateAccountingPeriodStarts) or MTR:BusinessDetails/MTR:DateAccountingPeriodEnds" id="a_SA103F.0" diagnostics="errorCode.SA103F.0 transactional.SA103F.0 transactional.en.SA103F.0 ">date accounting period ends should be present if [FSE8]</sch:assert>
        <sch:assert test="not(MTR:BusinessExpenses/MTR:TotalExpenses/MTR:CostOfGoods or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:SubcontractorCosts or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:WagesSalariesAndStaffCosts or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:CarVanAndTravelExpenses or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:RentAndOtherPropertyCosts or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:RepairsAndMaintenanceCosts or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:PhoneAndOtherOfficeCosts or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:AdvertisingAndEntertainmentCosts or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:BankAndLoanInterest or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:OtherFinanceCharges or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:DebtsWrittenOff or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:AccountancyAndLegalFees or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:DepreciationAndLossProfitOnSale or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:OtherBusinessExpenses) or MTR:BusinessExpenses/MTR:TotalExpenses/MTR:TotalExpenses" id="a_SA103F.1" diagnostics="errorCode.SA103F.1 transactional.SA103F.1 transactional.en.SA103F.1 ">total expenses should be present if [FSE17] or [FSE18] or [FSE19] or [FSE20] or [FSE21] or [FSE22] or [FSE23] or [FSE24] or [FSE25] or [FSE26] or [FSE27] or [FSE28] or [FSE29] or [FSE30]</sch:assert>
        <sch:assert test="not(MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableCostOfGoods or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableSubcontractorCosts or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableStaffCosts or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableCarAndTravelExpenses or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableRentAndOtherPropertyCosts or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableRepairsAndMaintenanceCosts or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowablePhoneAndOtherOfficeCosts or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableAdvertisingAndEntertainmentCosts or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableBankAndLoanInterest or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableOtherFinanceCharges or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableDebtsWrittenOff or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableAccountancyAndLegalFees or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableDepreciationAndLossProfitOnSale or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:DisallowableOtherBusinessExpenses) or MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:TotalDisallowableExpenses" id="a_SA103F.2" diagnostics="errorCode.SA103F.2 transactional.SA103F.2 transactional.en.SA103F.2 ">total disallowable expenses should be present if [FSE32] or [FSE33] or [FSE34] or [FSE35] or [FSE36] or [FSE37] or [FSE38] or [FSE39] or [FSE40] or [FSE41] or [FSE42] or [FSE43] or [FSE44] or [FSE45]</sch:assert>
        <sch:assert test="(math:abs(((sum(MTR:BusinessIncome/MTR:Turnover) + sum(MTR:BusinessIncome/MTR:OtherBusinessIncome)) - sum(MTR:BusinessExpenses/MTR:TotalExpenses/MTR:TotalExpenses)) - (0)) &lt; 0.001) or MTR:NetProfitLoss" id="a_SA103F.3" diagnostics="errorCode.SA103F.3 transactional.SA103F.3 transactional.en.SA103F.3 ">net profit should be present if ( ( [FSE15] plus [FSE16] ) minus [FSE31] ) is non-zero</sch:assert>
        <sch:assert test="not(MTR:CapitalAllowances/MTR:TotalCapitalAllowances or MTR:TaxableProfitOrLoss/MTR:NonTaxableBusinessIncome) or MTR:TaxableProfitOrLoss/MTR:DeductionsFromNetProfitAdditionsToNetLoss" id="a_SA103F.6" diagnostics="errorCode.SA103F.6 transactional.SA103F.6 transactional.en.SA103F.6 ">deductions from net profit/additions to net loss should be present if [FSE57] or [FSE62]</sch:assert>
        <sch:assert test="(math:abs(((sum(MTR:NetProfitLoss) + sum(MTR:TaxableProfitOrLoss/MTR:AdditionsToNetProfitDeductionsFromNetLoss)) - sum(MTR:TaxableProfitOrLoss/MTR:DeductionsFromNetProfitAdditionsToNetLoss)) - (0)) &lt; 0.001) or MTR:TaxableProfitOrLoss/MTR:NetBusinessProfitLossForTax" id="a_SA103F.7" diagnostics="errorCode.SA103F.7 transactional.SA103F.7 transactional.en.SA103F.7 ">Net business profit for tax should be present if ( ( [FSE47/FSE48] plus [FSE61] ) minus ( [FSE63] ) ) is non-zero</sch:assert>
        <sch:assert test="not(( sum(MTR:TaxableProfitOrLoss/MTR:AdjustedProfitForTheYear) &gt; 0 ) or ( sum(MTR:TaxableProfitOrLoss/MTR:LossBroughtForward) &gt; 0 ) or ( sum(MTR:TaxableProfitOrLoss/MTR:AnyOtherBusinessIncome) &gt; 0 )) or MTR:TaxableProfitOrLoss/MTR:TotalTaxableBusinessProfits" id="a_SA103F.8" diagnostics="errorCode.SA103F.8 transactional.SA103F.8 transactional.en.SA103F.8 ">Total taxable business profits should be present if any of [FSE73] or [FSE74] or [FSE75] exceeds 0</sch:assert>
        <sch:assert test="not(MTR:BalanceSheet/MTR:Assets/MTR:EquipmentMachineryVehicles or MTR:BalanceSheet/MTR:Assets/MTR:OtherFixedAssets or MTR:BalanceSheet/MTR:Assets/MTR:StockAndWorkInProgress or MTR:BalanceSheet/MTR:Assets/MTR:TradeDebtors or MTR:BalanceSheet/MTR:Assets/MTR:BankEtcBalances or MTR:BalanceSheet/MTR:Assets/MTR:CashInHand or MTR:BalanceSheet/MTR:Assets/MTR:OtherCurrentAssets) or MTR:BalanceSheet/MTR:Assets/MTR:TotalBusinessAssets" id="a_SA103F.10" diagnostics="errorCode.SA103F.10 transactional.SA103F.10 transactional.en.SA103F.10 ">
total business assets should be present if [FSE83] or [FSE84] or [FSE85] or [FSE86] or [FSE87] or [FSE88] or [FSE89]</sch:assert>
        <sch:assert test="not(MTR:BalanceSheet/MTR:Assets/MTR:TotalBusinessAssets or MTR:BalanceSheet/MTR:Liabilities/MTR:TradeCreditors or MTR:BalanceSheet/MTR:Liabilities/MTR:LoansAndOverdrafts or MTR:BalanceSheet/MTR:Liabilities/MTR:OtherLiabilities) or MTR:BalanceSheet/MTR:NetBusinessAssets" id="a_SA103F.11" diagnostics="errorCode.SA103F.11 transactional.SA103F.11 transactional.en.SA103F.11 ">

net business assets should be present if [FSE90] or [FSE91] or [FSE92] or [FSE93]</sch:assert>
        <sch:assert test="not(MTR:BalanceSheet/MTR:CapitalAccount/MTR:CapitalAccountBalanceAtStart or MTR:BalanceSheet/MTR:CapitalAccount/MTR:NetProfitOrLoss or MTR:BalanceSheet/MTR:CapitalAccount/MTR:CapitalIntroduced or MTR:BalanceSheet/MTR:CapitalAccount/MTR:Drawings) or MTR:BalanceSheet/MTR:CapitalAccount/MTR:CapitalAccountBalanceAtEnd" id="a_SA103F.12" diagnostics="errorCode.SA103F.12 transactional.SA103F.12 transactional.en.SA103F.12 ">

capital account balance at end should be present if [FSE95] or [FSE96] or [FSE97] or [FSE98]</sch:assert>
        <sch:assert test="not(MTR:BusinessExpenses/MTR:DisallowableExpenses/MTR:TotalDisallowableExpenses) or MTR:TaxableProfitOrLoss/MTR:AdditionsToNetProfitDeductionsFromNetLoss" id="a_SA103F.4" diagnostics="errorCode.SA103F.4 transactional.SA103F.4 transactional.en.SA103F.4 ">[FSE61] should be present if [FSE46] is present</sch:assert>
        <sch:assert test="not(MTR:CapitalAllowances/MTR:TotalBalancingCharges) or MTR:TaxableProfitOrLoss/MTR:AdditionsToNetProfitDeductionsFromNetLoss" id="a_SA103F.5" diagnostics="errorCode.SA103F.5 transactional.SA103F.5 transactional.en.SA103F.5 ">[FSE61] should be present if [FSE59] is present</sch:assert>
        <sch:assert test="not(MTR:TaxableProfitOrLoss/MTR:OwnGoodsAndServices) or MTR:TaxableProfitOrLoss/MTR:AdditionsToNetProfitDeductionsFromNetLoss" id="a_SA103F.9" diagnostics="errorCode.SA103F.9 transactional.SA103F.9 transactional.en.SA103F.9 ">[FSE61] should be present if [FSE60] is present</sch:assert>
        <sch:assert test="(((sum(MTR:TaxableProfitOrLoss/MTR:NetBusinessProfitLossForTax) + sum(MTR:TaxableProfitOrLoss/MTR:TaxYearAdjustment) - sum(MTR:BusinessIncome/MTR:TradingIncomeAllowance))) - (0) &lt; 0.001)
              or
            (MTR:TaxableProfitOrLoss/MTR:AdjustedProfitForTheYear and (math:abs(((sum(MTR:TaxableProfitOrLoss/MTR:NetBusinessProfitLossForTax) + sum(MTR:TaxableProfitOrLoss/MTR:TaxYearAdjustment) - sum(MTR:BusinessIncome/MTR:TradingIncomeAllowance)) + sum(MTR:TaxableProfitOrLoss/MTR:AveragingAdjustment) + sum(MTR:TaxableProfitOrLoss/MTR:ChangeOfAccountingPracticeAdjustment)) - (sum(MTR:TaxableProfitOrLoss/MTR:AdjustedProfitForTheYear))) &lt; 0.001))" id="a_SA103F.13" diagnostics="errorCode.SA103F.13 transactional.SA103F.13 transactional.en.SA103F.13 ">If ([FSE64 / FSE65] + [FSE68] - [FSE16.1]) is positive, then [FSE73] is mandatory and  = ([FSE64 / FSE65] + [FSE68] - [FSE16.1] + [FSE72] +  [FSE71])</sch:assert>
        <sch:assert test="(((sum(MTR:TaxableProfitOrLoss/MTR:NetBusinessProfitLossForTax) + sum(MTR:TaxableProfitOrLoss/MTR:TaxYearAdjustment) - sum(MTR:BusinessIncome/MTR:TradingIncomeAllowance))) - (0) &gt;= 0.001)
              or
            ( (sum(MTR:TaxableProfitOrLoss/MTR:AveragingAdjustment) + sum(MTR:TaxableProfitOrLoss/MTR:ChangeOfAccountingPracticeAdjustment)) &gt; 0 and (MTR:TaxableProfitOrLoss/MTR:AdjustedProfitForTheYear and (math:abs((sum(MTR:TaxableProfitOrLoss/MTR:AdjustedProfitForTheYear)) - ((sum(MTR:TaxableProfitOrLoss/MTR:AveragingAdjustment) + sum(MTR:TaxableProfitOrLoss/MTR:ChangeOfAccountingPracticeAdjustment)))) &lt; 0.001)))
              or
            ( (sum(MTR:TaxableProfitOrLoss/MTR:AveragingAdjustment) + sum(MTR:TaxableProfitOrLoss/MTR:ChangeOfAccountingPracticeAdjustment)) &lt;= 0 and (sum(MTR:TaxableProfitOrLoss/MTR:AdjustedProfitForTheYear) = 0))" id="a_SA103F.14" diagnostics="errorCode.SA103F.14 transactional.SA103F.14 transactional.en.SA103F.14 ">If ( [FSE64 / FSE65] + [FSE68] - [FSE16.1] ) is negative or zero, then if ([FSE71] + [FSE72]) is greater than zero, then [FSE73] is mandatory and = ([FSE71] + [FSE72]); else [FSE73] must be zero or absent</sch:assert>
        <sch:assert test="not((((sum(MTR:TaxableProfitOrLoss/MTR:NetBusinessProfitLossForTax) + sum(MTR:TaxableProfitOrLoss/MTR:TaxYearAdjustment) - sum(MTR:BusinessIncome/MTR:TradingIncomeAllowance))) - (0) &lt;= -0.001))
          or
        (math:abs((math:abs((sum(MTR:TaxableProfitOrLoss/MTR:NetBusinessProfitLossForTax) + sum(MTR:TaxableProfitOrLoss/MTR:TaxYearAdjustment) - sum(MTR:BusinessIncome/MTR:TradingIncomeAllowance)))) - (sum(MTR:Losses/MTR:AdjustedLossForTheYear))) &lt; 0.001)" id="a_SA103F.15" diagnostics="errorCode.SA103F.15 transactional.SA103F.15 transactional.en.SA103F.15 ">If ([FSE64 / FSE65] + [FSE68] - [FSE16.1]) is negative, then [FSE77] is mandatory and  = positive equivalent of ([FSE64 / FSE65] + [FSE68] - [FSE16.1])</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p166">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:BusinessDetails/MTR:DidYourBusinessStart">
        <sch:assert test="not((.) = &apos;yes&apos;) or ../MTR:DateBusinessStarted" id="a_SSE-BUSINESS-COMM-QUES.0" diagnostics="errorCode.SSE-BUSINESS-COMM-QUES.0 transactional.SSE-BUSINESS-COMM-QUES.0 transactional.en.SSE-BUSINESS-COMM-QUES.0 ">[SSE5] should be present if [SSE5Q] equals 'yes'</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p167">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:BusinessDetails/MTR:DateBusinessStarted">
        <sch:assert test="(round(date:seconds(normalize-space(concat(2025, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))
                  and
                (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2026, &quot;-04-05&quot;))) div 86400))" id="a_SSE-COMMENCEMENT-DATE.1" diagnostics="errorCode.SSE-COMMENCEMENT-DATE.1 transactional.SSE-COMMENCEMENT-DATE.1 transactional.en.SSE-COMMENCEMENT-DATE.1 ">[SSE5] should be within the current return year</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p168">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:BusinessDetails/MTR:DidYourBusinessCease">
        <sch:assert test="not((.) = &apos;yes&apos;) or ../MTR:DateBusinessCeased" id="a_SSE-BUSINESS-CESS-QUES.0" diagnostics="errorCode.SSE-BUSINESS-CESS-QUES.0 transactional.SSE-BUSINESS-CESS-QUES.0 transactional.en.SSE-BUSINESS-CESS-QUES.0 ">[SSE6] should be present if [SSE6Q] equals 'yes'</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p169">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:BusinessDetails/MTR:DateBusinessCeased">
        <sch:assert test="(round(date:seconds(normalize-space(concat(2025, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))
                  and
                (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2026, &quot;-04-05&quot;))) div 86400))" id="a_SSE-CESSATION-DATE.1" diagnostics="errorCode.SSE-CESSATION-DATE.1 transactional.SSE-CESSATION-DATE.1 transactional.en.SSE-CESSATION-DATE.1 ">[SSE6] should be within the current return year</sch:assert>
        <sch:assert test="(number(translate(.,&apos;-&apos;,&apos;&apos;)) &gt;= number(translate(../MTR:DateBusinessStarted,&apos;-&apos;,&apos;&apos;))) or not (../MTR:DateBusinessStarted)" id="a_SSE-CESSATION-DATE.2" diagnostics="errorCode.SSE-CESSATION-DATE.2 transactional.SSE-CESSATION-DATE.2 transactional.en.SSE-CESSATION-DATE.2 ">If present must be the same as or later than [SSE5]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p170">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:BusinessIncome/MTR:Turnover">
        <sch:assert test="../../MTR:BusinessDetails/MTR:DateBusinessStarted or ../../MTR:BusinessDetails/MTR:DateBusinessCeased
                or
              ((.) - (90000) &lt;= -0.001)" id="a_SSE-BUSINESS-SALES-TURNOVER.0" diagnostics="errorCode.SSE-BUSINESS-SALES-TURNOVER.0 transactional.SSE-BUSINESS-SALES-TURNOVER.0 transactional.en.SSE-BUSINESS-SALES-TURNOVER.0 ">If [SSE5] and [SSE6] are both absent, amount must be below [£90,000].</sch:assert>
        <sch:assert test="not(../../MTR:BusinessDetails/MTR:DateBusinessStarted) or ../../MTR:BusinessDetails/MTR:DateBusinessCeased
                or
              ((.) - 90000 * ((round((date:seconds(normalize-space(&apos;2026-04-05&apos;)) - date:seconds(normalize-space(../../MTR:BusinessDetails/MTR:DateBusinessStarted))) div 86400 ) + 1) div (round( date:seconds(date:difference(&apos;2025-04-06&apos;, &apos;2026-04-05&apos;)) div 86400 ) + 1))) &lt; -0.00000001" id="a_SSE-BUSINESS-SALES-TURNOVER.1" diagnostics="errorCode.SSE-BUSINESS-SALES-TURNOVER.1 transactional.SSE-BUSINESS-SALES-TURNOVER.1 transactional.en.SSE-BUSINESS-SALES-TURNOVER.1 ">If [SSE5] present but [SSE6] is absent, amount must be below ([£90,000] x no of days / (365 or 366) ) where no of days = no of days from ( [SSE5]  to [5 April 2026] inclusive )</sch:assert>
        <sch:assert test="../../MTR:BusinessDetails/MTR:DateBusinessStarted or not(../../MTR:BusinessDetails/MTR:DateBusinessCeased)
                or
              ((.) - 90000 * ((round((date:seconds(normalize-space(../../MTR:BusinessDetails/MTR:DateBusinessCeased)) - date:seconds(normalize-space(&apos;2025-04-06&apos;))) div 86400 ) + 1) div (round( date:seconds(date:difference(&apos;2025-04-06&apos;, &apos;2026-04-05&apos;)) div 86400 ) + 1))) &lt; -0.00000001" id="a_SSE-BUSINESS-SALES-TURNOVER.2" diagnostics="errorCode.SSE-BUSINESS-SALES-TURNOVER.2 transactional.SSE-BUSINESS-SALES-TURNOVER.2 transactional.en.SSE-BUSINESS-SALES-TURNOVER.2 ">If [SSE6] is present but [SSE5] is absent, amount must be below ( [£90,000] x no of days / (365 or 366) ) where no of days = no of days from ( [6 April 2025] to [SSE6] inclusive )</sch:assert>
        <sch:assert test="not(../../MTR:BusinessDetails/MTR:DateBusinessStarted) or not(../../MTR:BusinessDetails/MTR:DateBusinessCeased)
                or
              (((.) -  (90000 * ((round((date:seconds(normalize-space(../../MTR:BusinessDetails/MTR:DateBusinessCeased)) - date:seconds(normalize-space(../../MTR:BusinessDetails/MTR:DateBusinessStarted))) div 86400 ) + 1) div (round( date:seconds(date:difference(&apos;2025-04-06&apos;, &apos;2026-04-05&apos;)) div 86400 ) + 1)))) &lt; -0.00000001)" id="a_SSE-BUSINESS-SALES-TURNOVER.3" diagnostics="errorCode.SSE-BUSINESS-SALES-TURNOVER.3 transactional.SSE-BUSINESS-SALES-TURNOVER.3 transactional.en.SSE-BUSINESS-SALES-TURNOVER.3 ">If [SSE5] and [SSE6] are both present, amount must be below ( [£90,000] x no of days / (365 or 366) ) where the no of days = no of days from [SSE5] to [SSE6] inclusive</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p171">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance">
        <sch:assert test="not(../../../MTR:SA103S/MTR:NetProfitOrLoss &lt; 0)" id="a_SSE-TRADING-INCOME-ALLOWANCE.1" diagnostics="errorCode.SSE-TRADING-INCOME-ALLOWANCE.1 transactional.SSE-TRADING-INCOME-ALLOWANCE.1 transactional.en.SSE-TRADING-INCOME-ALLOWANCE.1 ">If [SSE10.1] is present then all instances of [SSE21/SSE22] can not be negative</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p172">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:AllowableBusinessExpenses/MTR:CostOfGoods">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SSE-COST-OF-SALES.0" diagnostics="errorCode.SSE-COST-OF-SALES.0 transactional.SSE-COST-OF-SALES.0 transactional.en.SSE-COST-OF-SALES.0 ">[SSE11] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p173">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:AllowableBusinessExpenses/MTR:CarVanAndTravelExpenses">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SSE-MOTOR-EXPENSES.0" diagnostics="errorCode.SSE-MOTOR-EXPENSES.0 transactional.SSE-MOTOR-EXPENSES.0 transactional.en.SSE-MOTOR-EXPENSES.0 ">[SSE12] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p174">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:AllowableBusinessExpenses/MTR:WagesSalariesAndStaffCosts">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SSE-EMPLOYEE-COSTS.0" diagnostics="errorCode.SSE-EMPLOYEE-COSTS.0 transactional.SSE-EMPLOYEE-COSTS.0 transactional.en.SSE-EMPLOYEE-COSTS.0 ">[SSE13] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p175">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:AllowableBusinessExpenses/MTR:RentAndOtherPropertyCosts">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SSE-PREMISES-COSTS.0" diagnostics="errorCode.SSE-PREMISES-COSTS.0 transactional.SSE-PREMISES-COSTS.0 transactional.en.SSE-PREMISES-COSTS.0 ">[SSE14] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p176">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:AllowableBusinessExpenses/MTR:RepairsAndMaintenanceCosts">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SSE-REPAIRS.0" diagnostics="errorCode.SSE-REPAIRS.0 transactional.SSE-REPAIRS.0 transactional.en.SSE-REPAIRS.0 ">[SSE15] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p177">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:AllowableBusinessExpenses/MTR:AccountancyAndLegalFees">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SSE-LEGAL-COSTS.0" diagnostics="errorCode.SSE-LEGAL-COSTS.0 transactional.SSE-LEGAL-COSTS.0 transactional.en.SSE-LEGAL-COSTS.0 ">[SSE16] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p178">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:AllowableBusinessExpenses/MTR:InterestAndFinanceCharges">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SSE-LOAN-INTEREST.0" diagnostics="errorCode.SSE-LOAN-INTEREST.0 transactional.SSE-LOAN-INTEREST.0 transactional.en.SSE-LOAN-INTEREST.0 ">[SSE17] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p179">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:AllowableBusinessExpenses/MTR:PhoneAndOtherOfficeCosts">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SSE-GENERAL-ADMIN-EXPENSES.0" diagnostics="errorCode.SSE-GENERAL-ADMIN-EXPENSES.0 transactional.SSE-GENERAL-ADMIN-EXPENSES.0 transactional.en.SSE-GENERAL-ADMIN-EXPENSES.0 ">[SSE18] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p180">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:AllowableBusinessExpenses/MTR:OtherAllowableBusinessExpenses">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SSE-OTHER-EXPENDITURE.0" diagnostics="errorCode.SSE-OTHER-EXPENDITURE.0 transactional.SSE-OTHER-EXPENDITURE.0 transactional.en.SSE-OTHER-EXPENDITURE.0 ">[SSE19] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p181">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:AllowableBusinessExpenses/MTR:TotalAllowableExpenses">
        <sch:assert test="(
  . &lt;= 0
)
or
(
  sum(../../MTR:BusinessIncome/MTR:Turnover) &lt; 90000
)
or
(
    (math:abs((number(.)) - ((sum(../MTR:CostOfGoods) +
                           sum(../MTR:CarVanAndTravelExpenses) +
                           sum(../MTR:WagesSalariesAndStaffCosts) +
                           sum(../MTR:RentAndOtherPropertyCosts) +
                           sum(../MTR:RepairsAndMaintenanceCosts) +
                           sum(../MTR:AccountancyAndLegalFees) +
                           sum(../MTR:InterestAndFinanceCharges) +
                           sum(../MTR:PhoneAndOtherOfficeCosts) +
                           sum(../MTR:OtherAllowableBusinessExpenses)))) &lt; 0.001)
)" id="a_SSE-TOTAL-EXPENDITURE.1" diagnostics="errorCode.SSE-TOTAL-EXPENDITURE.1 transactional.SSE-TOTAL-EXPENDITURE.1 transactional.en.SSE-TOTAL-EXPENDITURE.1 ">If [SSE20] is present and greater than zero and [SSE9] is &gt;= [£90,000] there must be an entry in at least one of [SSE11] to [SSE19] and [SSE20] must equal the total of those boxes.</sch:assert>
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SSE-TOTAL-EXPENDITURE.0" diagnostics="errorCode.SSE-TOTAL-EXPENDITURE.0 transactional.SSE-TOTAL-EXPENDITURE.0 transactional.en.SSE-TOTAL-EXPENDITURE.0 ">[SSE20] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p182">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:NetProfitOrLoss">
        <sch:assert test="(math:abs((number(.)) - ((sum(../MTR:BusinessIncome/MTR:Turnover) + sum(../MTR:BusinessIncome/MTR:OtherBusinessIncome) - sum(../MTR:AllowableBusinessExpenses/MTR:TotalAllowableExpenses)))) &lt; 0.001)" id="a_SSE-NET-PROFIT-LOSS-AMT-merged.1" diagnostics="errorCode.SSE-NET-PROFIT-LOSS-AMT-merged.1 transactional.SSE-NET-PROFIT-LOSS-AMT-merged.1 transactional.en.SSE-NET-PROFIT-LOSS-AMT-merged.1 ">The sum of [SSE9] + [SSE10] - [SSE20] must equal [SSE21/SSE22]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p183">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:CapitalAllowances/MTR:AnnualInvestmentAllowance">
        <sch:assert test=". &lt;= 1500000" id="a_SSE-ANNUAL-INV-ALLCE-AMT.0" diagnostics="errorCode.SSE-ANNUAL-INV-ALLCE-AMT.0 transactional.SSE-ANNUAL-INV-ALLCE-AMT.0 transactional.en.SSE-ANNUAL-INV-ALLCE-AMT.0 ">[SSE23] must not exceed [£1,500,000]</sch:assert>
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SSE-ANNUAL-INV-ALLCE-AMT.1" diagnostics="errorCode.SSE-ANNUAL-INV-ALLCE-AMT.1 transactional.SSE-ANNUAL-INV-ALLCE-AMT.1 transactional.en.SSE-ANNUAL-INV-ALLCE-AMT.1 ">[SSE23] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p184">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:CapitalAllowances/MTR:AllowanceForSmallBalanceOfUnrelievedExpenditure">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SSE-SMALL-BAL-EXP-ALLCE-AMT.0" diagnostics="errorCode.SSE-SMALL-BAL-EXP-ALLCE-AMT.0 transactional.SSE-SMALL-BAL-EXP-ALLCE-AMT.0 transactional.en.SSE-SMALL-BAL-EXP-ALLCE-AMT.0 ">[SSE24] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
        <sch:assert test=". &lt;= 2000" id="a_SSE-SMALL-BAL-EXP-ALLCE-AMT.1" diagnostics="errorCode.SSE-SMALL-BAL-EXP-ALLCE-AMT.1 transactional.SSE-SMALL-BAL-EXP-ALLCE-AMT.1 transactional.en.SSE-SMALL-BAL-EXP-ALLCE-AMT.1 ">[SSE24] is valid only if this does not exceed [£2,000]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p185">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:CapitalAllowances/MTR:ZeroEmissionCarAllowance">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SSE-ZERO-EMISSION-CAR-ALLCE.0" diagnostics="errorCode.SSE-ZERO-EMISSION-CAR-ALLCE.0 transactional.SSE-ZERO-EMISSION-CAR-ALLCE.0 transactional.en.SSE-ZERO-EMISSION-CAR-ALLCE.0 ">[SSE24.1] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p186">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:CapitalAllowances/MTR:OtherCapitalAllowances">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SSE-TOTAL-CAPITAL-ALLOWANCES.0" diagnostics="errorCode.SSE-TOTAL-CAPITAL-ALLOWANCES.0 transactional.SSE-TOTAL-CAPITAL-ALLOWANCES.0 transactional.en.SSE-TOTAL-CAPITAL-ALLOWANCES.0 ">[SSE25] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p187">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:CapitalAllowances/MTR:TheStructuresAndBuildingsAllowance">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SSE-SB-ALLCE.0" diagnostics="errorCode.SSE-SB-ALLCE.0 transactional.SSE-SB-ALLCE.0 transactional.en.SSE-SB-ALLCE.0 ">[SSE25.1] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p188">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:CapitalAllowances/MTR:FreeportAndInvestmentZonesStructuresAndBuildingsAllowance">
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SSE-FREEPORT-SB-ALLCE.0" diagnostics="errorCode.SSE-FREEPORT-SB-ALLCE.0 transactional.SSE-FREEPORT-SB-ALLCE.0 transactional.en.SSE-FREEPORT-SB-ALLCE.0 ">[SSE25.2] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p189">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:TaxableProfits/MTR:NetBusinessProfitForTax">
        <sch:assert test="(((
                ( sum(../../MTR:NetProfitOrLoss) + sum(../../MTR:CapitalAllowances/MTR:TotalBalancingCharges) + sum(../MTR:OwnGoodsAndServices) )
                -
		( sum(../../MTR:BusinessIncome/MTR:TradingIncomeAllowance) + sum(../../MTR:CapitalAllowances/MTR:AnnualInvestmentAllowance) + sum(../../MTR:CapitalAllowances/MTR:AllowanceForSmallBalanceOfUnrelievedExpenditure) + sum(../../MTR:CapitalAllowances/MTR:ZeroEmissionCarAllowance) + 
	       	sum(../../MTR:CapitalAllowances/MTR:OtherCapitalAllowances)	+ sum(../../MTR:CapitalAllowances/MTR:TheStructuresAndBuildingsAllowance) +  sum(../../MTR:CapitalAllowances/MTR:FreeportAndInvestmentZonesStructuresAndBuildingsAllowance))
                )) - (0) &lt; 0.001) or (math:abs((number(.)) - ((
                ( sum(../../MTR:NetProfitOrLoss) + sum(../../MTR:CapitalAllowances/MTR:TotalBalancingCharges) + sum(../MTR:OwnGoodsAndServices) )
                -
		( sum(../../MTR:BusinessIncome/MTR:TradingIncomeAllowance) + sum(../../MTR:CapitalAllowances/MTR:AnnualInvestmentAllowance) + sum(../../MTR:CapitalAllowances/MTR:AllowanceForSmallBalanceOfUnrelievedExpenditure) + sum(../../MTR:CapitalAllowances/MTR:ZeroEmissionCarAllowance) + 
	       	sum(../../MTR:CapitalAllowances/MTR:OtherCapitalAllowances)	+ sum(../../MTR:CapitalAllowances/MTR:TheStructuresAndBuildingsAllowance) +  sum(../../MTR:CapitalAllowances/MTR:FreeportAndInvestmentZonesStructuresAndBuildingsAllowance))
                ))) &lt; 0.001)" id="a_SSE-NET-BUSINESS-PROFIT-LOSS.0" diagnostics="errorCode.SSE-NET-BUSINESS-PROFIT-LOSS.0 transactional.SSE-NET-BUSINESS-PROFIT-LOSS.0 transactional.en.SSE-NET-BUSINESS-PROFIT-LOSS.0 ">Where sum of ( [SSE21/SSE22] + [SSE26] + [SSE27] ) minus ( [SSE10.1] + [SSE23] + [SSE24] + [SSE24.1] +  [SSE25] + [SSE25.1] + [SSE25.2]  ) is positive, [SSE28] must equal that positive amount</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p190">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:TaxableProfits/MTR:LossBroughtForward">
        <sch:assert test=". &lt;= sum(../MTR:NetBusinessProfitForTax)" id="a_SSE-LOSSES-USED-THIS-YEAR.1" diagnostics="errorCode.SSE-LOSSES-USED-THIS-YEAR.1 transactional.SSE-LOSSES-USED-THIS-YEAR.1 transactional.en.SSE-LOSSES-USED-THIS-YEAR.1 ">[SSE29] should not exceed [SSE28]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p191">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:TotalTaxableBusinessProfits">
        <sch:assert test="(math:abs(((.)) - (((sum(../../MTR:TaxableProfits/MTR:NetBusinessProfitForTax) + sum(../../MTR:TaxableProfits/MTR:AnyOtherBusinessIncome)) - sum(../../MTR:TaxableProfits/MTR:LossBroughtForward)))) &lt; 0.001)" id="a_SSE-TOTAL-TAXABLE-PROFITS.0" diagnostics="errorCode.SSE-TOTAL-TAXABLE-PROFITS.0 transactional.SSE-TOTAL-TAXABLE-PROFITS.0 transactional.en.SSE-TOTAL-TAXABLE-PROFITS.0 ">If [SSE31] is present, it should equal ( ( [SSE28] plus [SSE30] ) minus [SSE29] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p192">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:NetBusinessLossForTax">
        <sch:assert test="(((
		( sum(../../MTR:CapitalAllowances/MTR:AnnualInvestmentAllowance) + sum(../../MTR:CapitalAllowances/MTR:AllowanceForSmallBalanceOfUnrelievedExpenditure) + sum(../../MTR:CapitalAllowances/MTR:ZeroEmissionCarAllowance) +  sum(../../MTR:CapitalAllowances/MTR:OtherCapitalAllowances) +
	       	sum(../../MTR:CapitalAllowances/MTR:TheStructuresAndBuildingsAllowance) + sum(../../MTR:CapitalAllowances/MTR:FreeportAndInvestmentZonesStructuresAndBuildingsAllowance) )
                -
                ( sum(../../MTR:NetProfitOrLoss) + sum(../../MTR:CapitalAllowances/MTR:TotalBalancingCharges) + sum(../../MTR:TaxableProfits/MTR:OwnGoodsAndServices) )
                )) - (0) &lt;= -0.001) or (math:abs((number(.)) - ((
		( sum(../../MTR:CapitalAllowances/MTR:AnnualInvestmentAllowance) + sum(../../MTR:CapitalAllowances/MTR:AllowanceForSmallBalanceOfUnrelievedExpenditure) + sum(../../MTR:CapitalAllowances/MTR:ZeroEmissionCarAllowance) +  sum(../../MTR:CapitalAllowances/MTR:OtherCapitalAllowances) +
	       	sum(../../MTR:CapitalAllowances/MTR:TheStructuresAndBuildingsAllowance) + sum(../../MTR:CapitalAllowances/MTR:FreeportAndInvestmentZonesStructuresAndBuildingsAllowance) )
                -
                ( sum(../../MTR:NetProfitOrLoss) + sum(../../MTR:CapitalAllowances/MTR:TotalBalancingCharges) + sum(../../MTR:TaxableProfits/MTR:OwnGoodsAndServices) )
                ))) &lt; 0.001)" id="a_SSE-ALLOWABLE-LOSS-FOR-YEAR.0" diagnostics="errorCode.SSE-ALLOWABLE-LOSS-FOR-YEAR.0 transactional.SSE-ALLOWABLE-LOSS-FOR-YEAR.0 transactional.en.SSE-ALLOWABLE-LOSS-FOR-YEAR.0 ">Where the sum of [SSE23] + [SSE24] + [SSE24.1] + [SSE25] + [SSE25.1] + [SSE25.2] - ([SSE21/SSE22] + [SSE26] + [SSE27]) is positive or zero [SSE32] must equal that sum</sch:assert>
        <sch:assert test="not(../../../MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance) and not(../../../MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)" id="a_SSE-ALLOWABLE-LOSS-FOR-YEAR.1" diagnostics="errorCode.SSE-ALLOWABLE-LOSS-FOR-YEAR.1 transactional.SSE-ALLOWABLE-LOSS-FOR-YEAR.1 transactional.en.SSE-ALLOWABLE-LOSS-FOR-YEAR.1 ">[SSE32] should not be present if any instance of [FSE16.1] or [SSE10.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p193">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:LossOfYearSetAgainstOtherIncome">
        <sch:assert test=". &lt;= sum(../MTR:NetBusinessLossForTax)" id="a_SSE-LOSS-SET-OFF-OTHER-INC.1" diagnostics="errorCode.SSE-LOSS-SET-OFF-OTHER-INC.1 transactional.SSE-LOSS-SET-OFF-OTHER-INC.1 transactional.en.SSE-LOSS-SET-OFF-OTHER-INC.1 ">[SSE33] must not exceed [SSE32]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p194">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:LossToCarryBack">
        <sch:assert test="((.) - (sum(../MTR:NetBusinessLossForTax) - sum(../MTR:LossOfYearSetAgainstOtherIncome)) &lt; 0.001)" id="a_SSE-LOSS-TO-CARRY-BACK.1" diagnostics="errorCode.SSE-LOSS-TO-CARRY-BACK.1 transactional.SSE-LOSS-TO-CARRY-BACK.1 transactional.en.SSE-LOSS-TO-CARRY-BACK.1 ">[SSE34] must not be greater than [SSE32] - [SSE33]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p195">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:PayClass2NICvoluntarily">
        <sch:assert test="../MTR:Class2NICamount" id="a_SSE-CLASS-2-NIC-VOLUNTARY-SIG.0" diagnostics="errorCode.SSE-CLASS-2-NIC-VOLUNTARY-SIG.0 transactional.SSE-CLASS-2-NIC-VOLUNTARY-SIG.0 transactional.en.SSE-CLASS-2-NIC-VOLUNTARY-SIG.0 ">[SSECL2] should be present if [SSE36] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p196">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:Class2NICamount">
        <sch:assert test=". &lt;= 219.95" id="a_SSE-CLASS-2-NIC-AMOUNT.0" diagnostics="errorCode.SSE-CLASS-2-NIC-AMOUNT.0 transactional.SSE-CLASS-2-NIC-AMOUNT.0 transactional.en.SSE-CLASS-2-NIC-AMOUNT.0 ">[SSECL2] is valid only if this does not exceed [£219.95]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p165">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103S">
        <sch:assert test="not(MTR:AllowableBusinessExpenses/MTR:CostOfGoods or MTR:AllowableBusinessExpenses/MTR:CarVanAndTravelExpenses or MTR:AllowableBusinessExpenses/MTR:WagesSalariesAndStaffCosts or MTR:AllowableBusinessExpenses/MTR:RentAndOtherPropertyCosts or MTR:AllowableBusinessExpenses/MTR:RepairsAndMaintenanceCosts or MTR:AllowableBusinessExpenses/MTR:AccountancyAndLegalFees or MTR:AllowableBusinessExpenses/MTR:InterestAndFinanceCharges or MTR:AllowableBusinessExpenses/MTR:PhoneAndOtherOfficeCosts or MTR:AllowableBusinessExpenses/MTR:OtherAllowableBusinessExpenses) or MTR:AllowableBusinessExpenses/MTR:TotalAllowableExpenses" id="a_SA103S.0" diagnostics="errorCode.SA103S.0 transactional.SA103S.0 transactional.en.SA103S.0 ">total allowable expenses should be present if [SSE11] or [SSE12] or [SSE13] or [SSE14] or [SSE15] or [SSE16] or [SSE17] or [SSE18] or [SSE19]</sch:assert>
        <sch:assert test="(math:abs((((sum(MTR:BusinessIncome/MTR:Turnover) + sum(MTR:BusinessIncome/MTR:OtherBusinessIncome)) - sum(MTR:AllowableBusinessExpenses/MTR:TotalAllowableExpenses))) - (0)) &lt; 0.001) or MTR:NetProfitOrLoss" id="a_SA103S.1" diagnostics="errorCode.SA103S.1 transactional.SA103S.1 transactional.en.SA103S.1 ">Net profit should be present if ( ( [SSE9] plus [SSE10] ) minus [SSE20] ) is non-zero</sch:assert>
        <sch:assert test="not(
              (((
                  (sum(MTR:NetProfitOrLoss) + sum(MTR:CapitalAllowances/MTR:TotalBalancingCharges) + sum(MTR:TaxableProfits/MTR:OwnGoodsAndServices))
                -
                  (sum(MTR:BusinessIncome/MTR:TradingIncomeAllowance) + sum(MTR:CapitalAllowances/MTR:AnnualInvestmentAllowance) + sum(MTR:CapitalAllowances/MTR:AllowanceForSmallBalanceOfUnrelievedExpenditure) + sum(MTR:CapitalAllowances/MTR:ZeroEmissionCarAllowance) + sum(MTR:CapitalAllowances/MTR:OtherCapitalAllowances) + sum(MTR:CapitalAllowances/MTR:TheStructuresAndBuildingsAllowance) + sum(MTR:CapitalAllowances/MTR:FreeportAndInvestmentZonesStructuresAndBuildingsAllowance))
                )) - (0) &gt;= 0.001)
            )
            or
            MTR:TaxableProfits/MTR:NetBusinessProfitForTax" id="a_SA103S.2" diagnostics="errorCode.SA103S.2 transactional.SA103S.2 transactional.en.SA103S.2 ">[SSE28] should be present if ( the sum of [SSE21/SSE22], [SSE26] and [SSE27] ) minus ( the sum of [SSE10.1], [SSE23], [SSE24], [SSE24.1], [SSE25], [SSE25.1] and [SSE25.2])  exceeds 0</sch:assert>
        <sch:assert test="not(((((sum(MTR:TaxableProfits/MTR:NetBusinessProfitForTax) + sum(MTR:TaxableProfits/MTR:AnyOtherBusinessIncome)) - sum(MTR:TaxableProfits/MTR:LossBroughtForward))) - (0) &gt;= 0.001)) or MTR:ProfitsLossesNICsAndCIS/MTR:TotalTaxableBusinessProfits" id="a_SA103S.3" diagnostics="errorCode.SA103S.3 transactional.SA103S.3 transactional.en.SA103S.3 ">total taxable business profits should be present if ( ( [SSE28] plus [SSE30] ) minus [SSE29] ) exceeds 0</sch:assert>
        <sch:assert test="not(
              (((
                  ( sum(MTR:CapitalAllowances/MTR:AnnualInvestmentAllowance) + sum(MTR:CapitalAllowances/MTR:AllowanceForSmallBalanceOfUnrelievedExpenditure) + sum(MTR:CapitalAllowances/MTR:ZeroEmissionCarAllowance) +  sum(MTR:CapitalAllowances/MTR:OtherCapitalAllowances) +
	       	sum(MTR:CapitalAllowances/MTR:TheStructuresAndBuildingsAllowance) + sum(MTR:CapitalAllowances/MTR:FreeportAndInvestmentZonesStructuresAndBuildingsAllowance) )
                -
                  (sum(MTR:NetProfitOrLoss) + sum(MTR:CapitalAllowances/MTR:TotalBalancingCharges) + sum(MTR:TaxableProfits/MTR:OwnGoodsAndServices))
                )) - (0) &gt;= 0.001)
            )
            or
            MTR:ProfitsLossesNICsAndCIS/MTR:NetBusinessLossForTax" id="a_SA103S.4" diagnostics="errorCode.SA103S.4 transactional.SA103S.4 transactional.en.SA103S.4 ">Loss for the year should be present if ( the sum of [SSE23], [SSE24], [SSE24.1], [SSE25], [SSE25.1] and [SSE25.2] ) minus ( the sum of [SSE21/SSE22], [SSE26], and [SSE27] ) exceeds 0</sch:assert>
        <sch:assert test="((sum(MTR:NetProfitOrLoss)) - (0) &lt;= -0.001)
            or
              ((sum(MTR:BusinessIncome/MTR:TradingIncomeAllowance)) - (sum(MTR:NetProfitOrLoss) + sum(MTR:CapitalAllowances/MTR:TotalBalancingCharges) + sum(MTR:TaxableProfits/MTR:OwnGoodsAndServices)) &lt; 0.001)" id="a_SA103S.5" diagnostics="errorCode.SA103S.5 transactional.SA103S.5 transactional.en.SA103S.5 ">[SSE10.1] must be less than or equal to the sum of ( [SSE21/SSE22] + [SSE26] + [SSE27] ) if [SSE21/SSE22] is not negative.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p198">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:UKIncome/MTR:UKInterest/MTR:TaxTakenOff">
        <sch:assert test=". &lt; sum(../MTR:TaxedUnitTrustEtcInterest)" id="a_LUW-UK-INT-TAX-DEDUCTED-AMT.1" diagnostics="errorCode.LUW-UK-INT-TAX-DEDUCTED-AMT.1 transactional.LUW-UK-INT-TAX-DEDUCTED-AMT.1 transactional.en.LUW-UK-INT-TAX-DEDUCTED-AMT.1 ">[LUN4] should be less than [LUN3]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p199">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:UKIncome/MTR:UKInterest/MTR:TotalUKInterestAndTaxTakenOff">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:BankEtcAndGiltUntaxedInterest) + sum(../MTR:AccruedIncomeSchemeAggregateAmount) + sum(../MTR:TaxedUnitTrustEtcInterest) + sum(../MTR:TaxTakenOff)))) &lt; 0.001)" id="a_LUW4-UK-INTEREST-INCOME-AMO.1" diagnostics="errorCode.LUW4-UK-INTEREST-INCOME-AMO.1 transactional.LUW4-UK-INTEREST-INCOME-AMO.1 transactional.en.LUW4-UK-INTEREST-INCOME-AMO.1 ">[LUN5] should equal ( The sum of [LUN1], [LUN2], [LUN3], and [LUN4] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p200">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:UKIncome/MTR:UKDividends/MTR:TotalUKDividendsAndDistributions">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:StockDividendsAmountReceived) + sum(../MTR:BonusIssuesOfSecuritiesAndRedeemableShares) + sum(../MTR:OtherDistributionsAmountReceived)))) &lt; 0.001)" id="a_LUW4-LUWU-TOTAL-DIV-GROSS-AMO.0" diagnostics="errorCode.LUW4-LUWU-TOTAL-DIV-GROSS-AMO.0 transactional.LUW4-LUWU-TOTAL-DIV-GROSS-AMO.0 transactional.en.LUW4-LUWU-TOTAL-DIV-GROSS-AMO.0 ">[LUN11] should equal ( The sum of [LUN6], [LUN8], and [LUN9] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p201">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:ForeignIncome/MTR:Dividends/MTR:TotalNonUKIncome">
        <sch:assert test="(math:abs((.) - ((sum(../../MTR:Interest/MTR:ForeignInterestEtcAmount) + sum(../../MTR:Interest/MTR:ForeignTaxDeducted) + sum(../../MTR:Interest/MTR:UKTaxDeducted) + sum(../MTR:NonUKDividendsAmount) + sum(../MTR:ForeignTaxDeducted) + sum(../MTR:UKTaxDeducted)))) &lt; 0.001)" id="a_LUW4-FOREIGN-DIV-GROSS-AMO.1" diagnostics="errorCode.LUW4-FOREIGN-DIV-GROSS-AMO.1 transactional.LUW4-FOREIGN-DIV-GROSS-AMO.1 transactional.en.LUW4-FOREIGN-DIV-GROSS-AMO.1 ">[LUN18] should equal ( The sum of [LUN12], [LUN13], [LUN14], [LUN15], [LUN16], and [LUN17] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p202">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:OtherReceipts/MTR:AggregateSyndicateProfits">
        <sch:assert test="../MTR:TotalOtherLloydsReceipts" id="a_LUW4-AGGREGATE-SYND-PROFIT-AMO.0" diagnostics="errorCode.LUW4-AGGREGATE-SYND-PROFIT-AMO.0 transactional.LUW4-AGGREGATE-SYND-PROFIT-AMO.0 transactional.en.LUW4-AGGREGATE-SYND-PROFIT-AMO.0 ">[LUN26] is mandatory if [LUN20]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p203">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:OtherReceipts/MTR:SpecialReserveFundNetWithdrawalRelease">
        <sch:assert test="../MTR:TotalOtherLloydsReceipts" id="a_LUW4-SPECIAL-RESERVE-FUND-AMO.0" diagnostics="errorCode.LUW4-SPECIAL-RESERVE-FUND-AMO.0 transactional.LUW4-SPECIAL-RESERVE-FUND-AMO.0 transactional.en.LUW4-SPECIAL-RESERVE-FUND-AMO.0 ">[LUN26] is mandatory if [LUN21]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p204">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:OtherReceipts/MTR:StopLossRecoveries">
        <sch:assert test="../MTR:TotalOtherLloydsReceipts" id="a_LUW4-STOP-LOSS-RECOVERY-AMO.0" diagnostics="errorCode.LUW4-STOP-LOSS-RECOVERY-AMO.0 transactional.LUW4-STOP-LOSS-RECOVERY-AMO.0 transactional.en.LUW4-STOP-LOSS-RECOVERY-AMO.0 ">[LUN26] is mandatory if [LUN22]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p205">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:OtherReceipts/MTR:CompensationReceipts">
        <sch:assert test="../MTR:TotalOtherLloydsReceipts" id="a_LUW4-COMPENSATION-RECEIPT-AMO.0" diagnostics="errorCode.LUW4-COMPENSATION-RECEIPT-AMO.0 transactional.LUW4-COMPENSATION-RECEIPT-AMO.0 transactional.en.LUW4-COMPENSATION-RECEIPT-AMO.0 ">[LUN26] is mandatory if [LUN23]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p206">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:OtherReceipts/MTR:RepaymentOfForeignTaxDeduction">
        <sch:assert test="../MTR:TotalOtherLloydsReceipts" id="a_LUW4-REPAYT-FOREIGN-TAX-AMO.0" diagnostics="errorCode.LUW4-REPAYT-FOREIGN-TAX-AMO.0 transactional.LUW4-REPAYT-FOREIGN-TAX-AMO.0 transactional.en.LUW4-REPAYT-FOREIGN-TAX-AMO.0 ">[LUN26] is mandatory if [LUN24]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p207">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:OtherReceipts/MTR:OtherNonsyndicateIncome">
        <sch:assert test="../MTR:TotalOtherLloydsReceipts" id="a_LUW4-OTHER-NON-SYND-INCOME-AMO.0" diagnostics="errorCode.LUW4-OTHER-NON-SYND-INCOME-AMO.0 transactional.LUW4-OTHER-NON-SYND-INCOME-AMO.0 transactional.en.LUW4-OTHER-NON-SYND-INCOME-AMO.0 ">[LUN26] is mandatory if [LUN25]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p208">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:OtherReceipts/MTR:TotalOtherLloydsReceipts">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:AggregateSyndicateProfits) + sum(../MTR:SpecialReserveFundNetWithdrawalRelease) + sum(../MTR:StopLossRecoveries) + sum(../MTR:CompensationReceipts) + sum(../MTR:RepaymentOfForeignTaxDeduction) + sum(../MTR:OtherNonsyndicateIncome)))) &lt; 0.001)" id="a_LUW4-OTHER-LLOYDS-RCPT-TOTAL.0" diagnostics="errorCode.LUW4-OTHER-LLOYDS-RCPT-TOTAL.0 transactional.LUW4-OTHER-LLOYDS-RCPT-TOTAL.0 transactional.en.LUW4-OTHER-LLOYDS-RCPT-TOTAL.0 ">[LUN26] should equal ( The sum of [LUN20], [LUN21], [LUN22], [LUN23], [LUN24], and [LUN25] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p209">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:TotalLloydsIncome">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:UKIncome/MTR:UKInterest/MTR:TotalUKInterestAndTaxTakenOff) + sum(../MTR:UKIncome/MTR:UKDividends/MTR:TotalUKDividendsAndDistributions) + sum(../MTR:ForeignIncome/MTR:Dividends/MTR:TotalNonUKIncome) + sum(../MTR:OtherReceipts/MTR:TotalOtherLloydsReceipts)))) &lt; 0.001)" id="a_LUW4-LLOYDS-INCOME-TOTAL.1" diagnostics="errorCode.LUW4-LLOYDS-INCOME-TOTAL.1 transactional.LUW4-LLOYDS-INCOME-TOTAL.1 transactional.en.LUW4-LLOYDS-INCOME-TOTAL.1 ">[LUN27] should equal ( The sum of [LUN5], [LUN11], [LUN18], and [LUN26] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p210">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:LossesAndExpenses/MTR:AggregateSyndicateLosses">
        <sch:assert test="not(../../MTR:OtherReceipts/MTR:AggregateSyndicateProfits)" id="a_LUW4-AGGREGATE-SYND-LOSSES-AMO.3" diagnostics="errorCode.LUW4-AGGREGATE-SYND-LOSSES-AMO.3 transactional.LUW4-AGGREGATE-SYND-LOSSES-AMO.3 transactional.en.LUW4-AGGREGATE-SYND-LOSSES-AMO.3 ">If aggregate syndicate losses is present the following should be true: not ( [LUN20] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p211">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:AggregateSyndicateLosses) + sum(../MTR:SpecialReserveFundNetTransfer) + sum(../MTR:StopLossPremiumsPaid) + sum(../MTR:PersonalQuotaShareAndExeatPremiums) + sum(../MTR:EstateProtectionPlanPremiums) + sum(../MTR:UnderwritingLoanInterest) + sum(../MTR:LloydsMembersAssociationExpenses) + sum(../MTR:MembersAgentProfitCommissionAndSalaries) + sum(../MTR:BankGuaranteelettersOfCreditFees) + sum(../MTR:AccountancyFees) + sum(../MTR:OtherLloydsExpenses)))) &lt; 0.001)" id="a_LUW4-LLOYDS-OUTGOINGS-TOTAL.1" diagnostics="errorCode.LUW4-LLOYDS-OUTGOINGS-TOTAL.1 transactional.LUW4-LLOYDS-OUTGOINGS-TOTAL.1 transactional.en.LUW4-LLOYDS-OUTGOINGS-TOTAL.1 ">[LUN40] should equal ( The sum of [LUN29], [LUN30], [LUN31], [LUN32], [LUN33], [LUN34], [LUN35], [LUN36], [LUN37], [LUN38], and [LUN39] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p212">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:ProfitAmount">
        <sch:assert test="../MTR:TaxableProfits/MTR:TotalTaxableProfits or not((.) &gt; 0)" id="a_LUW4-LUWU-NET-PROFIT-AMO.2" diagnostics="errorCode.LUW4-LUWU-NET-PROFIT-AMO.2 transactional.LUW4-LUWU-NET-PROFIT-AMO.2 transactional.en.LUW4-LUWU-NET-PROFIT-AMO.2 ">[LUN52] mandatory if [LUN41] &gt; 0</sch:assert>
        <sch:assert test="(math:abs(((.)) - ((sum(../MTR:TotalLloydsIncome) - sum(../MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses)))) &lt; 0.001) or ((sum(../MTR:TotalLloydsIncome) - sum(../MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses)) - (0) &lt;= -0.001)" id="a_LUW4-LUWU-NET-PROFIT-AMO.1" diagnostics="errorCode.LUW4-LUWU-NET-PROFIT-AMO.1 transactional.LUW4-LUWU-NET-PROFIT-AMO.1 transactional.en.LUW4-LUWU-NET-PROFIT-AMO.1 ">If [LUN27] minus [LUN40] is zero or positive then[LUN41] must equal the result.</sch:assert>
        <sch:assert test=". = sum(../MTR:TaxableProfits/MTR:ProfitAmount)" id="a_LUW4-LUWU-NET-PROFIT-AMO.0" diagnostics="errorCode.LUW4-LUWU-NET-PROFIT-AMO.0 transactional.LUW4-LUWU-NET-PROFIT-AMO.0 transactional.en.LUW4-LUWU-NET-PROFIT-AMO.0 ">[LUN41] should equal [LUN49]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p213">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:LossAmount">
        <sch:assert test="not(((((sum(../MTR:TotalLloydsIncome) - sum(../MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses))) - (0) &gt;= 0.001)) and (.))" id="a_LUW4-NET-LOSS-PRE-FRGN-TAX-AMO.1" diagnostics="errorCode.LUW4-NET-LOSS-PRE-FRGN-TAX-AMO.1 transactional.LUW4-NET-LOSS-PRE-FRGN-TAX-AMO.1 transactional.en.LUW4-NET-LOSS-PRE-FRGN-TAX-AMO.1 ">loss amount should not be present if ( [LUN27] minus [LUN40] ) exceeds 0</sch:assert>
        <sch:assert test="((sum(../MTR:TotalLloydsIncome) - sum(../MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses)) - (0) &gt; -0.001)
              or
              (math:abs((sum(../MTR:TotalLloydsIncome) - sum(../MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses) + (.)) - (0)) &lt; 0.001)" id="a_LUW4-NET-LOSS-PRE-FRGN-TAX-AMO.2" diagnostics="errorCode.LUW4-NET-LOSS-PRE-FRGN-TAX-AMO.2 transactional.LUW4-NET-LOSS-PRE-FRGN-TAX-AMO.2 transactional.en.LUW4-NET-LOSS-PRE-FRGN-TAX-AMO.2 ">If [LUN27] minus [LUN40] is negative then [LUN42] must equal the positive equivalent</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p214">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:ForeignTax/MTR:ForeignTaxOnPersonalFundIncome">
        <sch:assert test="../MTR:TotalForeignTax" id="a_LUW4-FRGN-TAX-PERSNL-FUND-AMO.0" diagnostics="errorCode.LUW4-FRGN-TAX-PERSNL-FUND-AMO.0 transactional.LUW4-FRGN-TAX-PERSNL-FUND-AMO.0 transactional.en.LUW4-FRGN-TAX-PERSNL-FUND-AMO.0 ">[LUN48] is mandatory if [LUN43] is present</sch:assert>
        <sch:assert test="(math:abs((.) - ((sum(../../MTR:ForeignIncome/MTR:Interest/MTR:ForeignTaxDeducted) + sum(../../MTR:ForeignIncome/MTR:Dividends/MTR:ForeignTaxDeducted)))) &lt; 0.001)" id="a_LUW4-FRGN-TAX-PERSNL-FUND-AMO.1" diagnostics="errorCode.LUW4-FRGN-TAX-PERSNL-FUND-AMO.1 transactional.LUW4-FRGN-TAX-PERSNL-FUND-AMO.1 transactional.en.LUW4-FRGN-TAX-PERSNL-FUND-AMO.1 ">[LUN43] should equal ( [LUN13] plus [LUN16] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p215">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:ForeignTax/MTR:USIncomeTaxPaid">
        <sch:assert test="../MTR:TotalForeignTax" id="a_LUW4-US-FEDERAL-TAX-AMO.0" diagnostics="errorCode.LUW4-US-FEDERAL-TAX-AMO.0 transactional.LUW4-US-FEDERAL-TAX-AMO.0 transactional.en.LUW4-US-FEDERAL-TAX-AMO.0 ">[LUN48] is mandatory if [LUN44] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p216">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:ForeignTax/MTR:CanadianTaxPaid">
        <sch:assert test="../MTR:TotalForeignTax" id="a_LUW4-CANADIAN-FEDERAL-TAX-AMO.0" diagnostics="errorCode.LUW4-CANADIAN-FEDERAL-TAX-AMO.0 transactional.LUW4-CANADIAN-FEDERAL-TAX-AMO.0 transactional.en.LUW4-CANADIAN-FEDERAL-TAX-AMO.0 ">[LUN48] is mandatory if [LUN45] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p217">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:ForeignTax/MTR:SyndicateForeignTax">
        <sch:assert test="../MTR:TotalForeignTax" id="a_LUW4-SYNDICATE-FOREIGN-TAX-AMO.0" diagnostics="errorCode.LUW4-SYNDICATE-FOREIGN-TAX-AMO.0 transactional.LUW4-SYNDICATE-FOREIGN-TAX-AMO.0 transactional.en.LUW4-SYNDICATE-FOREIGN-TAX-AMO.0 ">[LUN48] is mandatory if [LUN46] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p218">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:ForeignTax/MTR:AdditionalPaymentsOfForeignTax">
        <sch:assert test="../MTR:TotalForeignTax" id="a_LUW4-ADDNL-FOREIGN-TAX-AMO.0" diagnostics="errorCode.LUW4-ADDNL-FOREIGN-TAX-AMO.0 transactional.LUW4-ADDNL-FOREIGN-TAX-AMO.0 transactional.en.LUW4-ADDNL-FOREIGN-TAX-AMO.0 ">[LUN48] is mandatory if [LUN47] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p219">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:ForeignTax/MTR:TotalForeignTax">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:ForeignTaxOnPersonalFundIncome) + sum(../MTR:USIncomeTaxPaid) + sum(../MTR:CanadianTaxPaid) + sum(../MTR:SyndicateForeignTax) + sum(../MTR:AdditionalPaymentsOfForeignTax)))) &lt; 0.001)" id="a_LUW4-FOREIGN-TAX-POOL-AMO.0" diagnostics="errorCode.LUW4-FOREIGN-TAX-POOL-AMO.0 transactional.LUW4-FOREIGN-TAX-POOL-AMO.0 transactional.en.LUW4-FOREIGN-TAX-POOL-AMO.0 ">[LUN48] should equal ( The sum of [LUN43], [LUN44], [LUN45], [LUN46], and [LUN47] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p220">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:TaxableProfits/MTR:ProfitAmount">
        <sch:assert test=". = sum(../../MTR:ProfitAmount)" id="a_LUW-NET-PROF-PRE-FRGN-TAX-AMT.1" diagnostics="errorCode.LUW-NET-PROF-PRE-FRGN-TAX-AMT.1 transactional.LUW-NET-PROF-PRE-FRGN-TAX-AMT.1 transactional.en.LUW-NET-PROF-PRE-FRGN-TAX-AMT.1 ">[LUN49] should equal [LUN41]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p221">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:TaxableProfits/MTR:ForeignTaxClaimedAsDeduction">
        <sch:assert test="../MTR:TotalTaxableProfits or not((.) &gt; 0)" id="a_LUW4-PROFIT-FRGN-TAX-DEDN-AMO.0" diagnostics="errorCode.LUW4-PROFIT-FRGN-TAX-DEDN-AMO.0 transactional.LUW4-PROFIT-FRGN-TAX-DEDN-AMO.0 transactional.en.LUW4-PROFIT-FRGN-TAX-DEDN-AMO.0 ">[LUN52] mandatory if [LUN50] &gt; 0</sch:assert>
        <sch:assert test="(. &lt;= 0) or (sum(../../MTR:ProfitAmount) &gt; 0)" id="a_LUW4-PROFIT-FRGN-TAX-DEDN-AMO.1" diagnostics="errorCode.LUW4-PROFIT-FRGN-TAX-DEDN-AMO.1 transactional.LUW4-PROFIT-FRGN-TAX-DEDN-AMO.1 transactional.en.LUW4-PROFIT-FRGN-TAX-DEDN-AMO.1 ">If [LUN50] is present and greater than zero, [LUN41] must be present and greater than zero</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p222">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:TaxableProfits/MTR:UnusedLossesBroughtForward">
        <sch:assert test="../MTR:TotalTaxableProfits or not((.) &gt; 0)" id="a_LUW4-LOSSES-BROUGHT-FWD-AMO.2" diagnostics="errorCode.LUW4-LOSSES-BROUGHT-FWD-AMO.2 transactional.LUW4-LOSSES-BROUGHT-FWD-AMO.2 transactional.en.LUW4-LOSSES-BROUGHT-FWD-AMO.2 ">[LUN52] mandatory if [LUN51] &gt; 0</sch:assert>
        <sch:assert test="(. &lt; 0) or (sum(../../MTR:ProfitAmount) &gt; 0)" id="a_LUW4-LOSSES-BROUGHT-FWD-AMO.1" diagnostics="errorCode.LUW4-LOSSES-BROUGHT-FWD-AMO.1 transactional.LUW4-LOSSES-BROUGHT-FWD-AMO.1 transactional.en.LUW4-LOSSES-BROUGHT-FWD-AMO.1 ">If [LUN51] is present and greater than zero, [LUN41] must be present and greater than zero</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p223">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:TaxableProfits/MTR:TotalTaxableProfits">
        <sch:assert test="((sum(../../MTR:ProfitAmount) - ( sum(../MTR:ForeignTaxClaimedAsDeduction) + sum(../MTR:UnusedLossesBroughtForward) )) - (0) &lt;= -0.001)
or
(math:abs((.) - (sum(../../MTR:ProfitAmount) - ( sum(../MTR:ForeignTaxClaimedAsDeduction) + sum(../MTR:UnusedLossesBroughtForward) ))) &lt; 0.001)" id="a_LUW3-TOT-LLOYDS-TAXABLE-PROFIT.0" diagnostics="errorCode.LUW3-TOT-LLOYDS-TAXABLE-PROFIT.0 transactional.LUW3-TOT-LLOYDS-TAXABLE-PROFIT.0 transactional.en.LUW3-TOT-LLOYDS-TAXABLE-PROFIT.0 ">If the sum of [LUN41] - ( [LUN50] + [LUN51] ) is positive or zero then [LUN52] must equal that sum</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p224">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:AllowableLosses/MTR:LossAmount">
        <sch:assert test="not(((((sum(../../MTR:TotalLloydsIncome) - sum(../../MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses))) - (0) &gt;= 0.001)) and (.))" id="a_LUW-NET-LOSS-PRE-FRGN-TAX-AMT.2" diagnostics="errorCode.LUW-NET-LOSS-PRE-FRGN-TAX-AMT.2 transactional.LUW-NET-LOSS-PRE-FRGN-TAX-AMT.2 transactional.en.LUW-NET-LOSS-PRE-FRGN-TAX-AMT.2 ">loss amount should not be present if ( [LUN27] minus [LUN40] ) exceeds 0</sch:assert>
        <sch:assert test=". = sum(../../MTR:LossAmount)" id="a_LUW-NET-LOSS-PRE-FRGN-TAX-AMT.3" diagnostics="errorCode.LUW-NET-LOSS-PRE-FRGN-TAX-AMT.3 transactional.LUW-NET-LOSS-PRE-FRGN-TAX-AMT.3 transactional.en.LUW-NET-LOSS-PRE-FRGN-TAX-AMT.3 ">[LUN53] should equal [LUN42]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p225">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:AllowableLosses/MTR:ForeignTaxClaimedAsDeduction">
        <sch:assert test="not(sum(../../MTR:LossAmount) &gt; 0) or (.) &lt;= sum(../../MTR:ForeignTax/MTR:TotalForeignTax)" id="a_LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.0" diagnostics="errorCode.LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.0 transactional.LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.0 transactional.en.LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.0 ">If [LUN42] is present and greater than zero, [LUN54] must be less than or equal to [LUN48].</sch:assert>
        <sch:assert test="((.) &lt;= 0) or (sum(../../MTR:LossAmount) &gt; 0)" id="a_LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.1" diagnostics="errorCode.LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.1 transactional.LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.1 transactional.en.LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.1 ">If [LUN54] is present and greater than zero, [LUN42] must be present and greater than zero.</sch:assert>
        <sch:assert test="not(((((sum(../../MTR:TotalLloydsIncome) - sum(../../MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses))) - (0) &gt;= 0.001)) and (.))" id="a_LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.2" diagnostics="errorCode.LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.2 transactional.LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.2 transactional.en.LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.2 ">foreign tax claimed as deduction should not be present if ( [LUN27] minus [LUN40] ) exceeds 0</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p226">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:AllowableLosses/MTR:LossForTheYear">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:LossAmount) + sum(../MTR:ForeignTaxClaimedAsDeduction)))) &lt; 0.001)" id="a_LUW4-LUWU-LOSS-AMO.1" diagnostics="errorCode.LUW4-LUWU-LOSS-AMO.1 transactional.LUW4-LUWU-LOSS-AMO.1 transactional.en.LUW4-LUWU-LOSS-AMO.1 ">[LUN55] should equal ( [LUN53] plus [LUN54] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p227">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:AllowableLosses/MTR:LossOffsetAgainstOtherIncome">
        <sch:assert test=". &lt;= sum(../MTR:LossForTheYear)" id="a_LUW-LOSS-SET-OFF-OTHER-INC.1" diagnostics="errorCode.LUW-LOSS-SET-OFF-OTHER-INC.1 transactional.LUW-LOSS-SET-OFF-OTHER-INC.1 transactional.en.LUW-LOSS-SET-OFF-OTHER-INC.1 ">[LUN56] should not exceed [LUN55]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p228">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:AllowableLosses/MTR:LossCarriedBack">
        <sch:assert test="((.) - ((sum(../MTR:LossForTheYear) - sum(../MTR:LossOffsetAgainstOtherIncome))) &lt; 0.001)" id="a_LUW-LOSS-CARRIED-BACK.0" diagnostics="errorCode.LUW-LOSS-CARRIED-BACK.0 transactional.LUW-LOSS-CARRIED-BACK.0 transactional.en.LUW-LOSS-CARRIED-BACK.0 ">[LUN57] should not exceed ( [LUN55] minus [LUN56] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p229">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:LossesReconciliation/MTR:LossesUsedAgainstProfitsOfYear">
        <sch:assert test=". = sum(../../MTR:TaxableProfits/MTR:UnusedLossesBroughtForward)" id="a_LUW-LOSSES-BF-USED-IN-CY-AMT.1" diagnostics="errorCode.LUW-LOSSES-BF-USED-IN-CY-AMT.1 transactional.LUW-LOSSES-BF-USED-IN-CY-AMT.1 transactional.en.LUW-LOSSES-BF-USED-IN-CY-AMT.1 ">[LUN60] should equal [LUN51]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p230">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:LossesReconciliation/MTR:UnusedLossFromTheYear">
        <sch:assert test=". = sum(../../MTR:AllowableLosses/MTR:UnusedLossesToCarryForward)" id="a_LUW-LOSSES-UNUSED-IN-CY-AMT.1" diagnostics="errorCode.LUW-LOSSES-UNUSED-IN-CY-AMT.1 transactional.LUW-LOSSES-UNUSED-IN-CY-AMT.1 transactional.en.LUW-LOSSES-UNUSED-IN-CY-AMT.1 ">[LUN61] should equal [LUN58]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p231">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:LossesReconciliation/MTR:TotalLossToCarryForward">
        <sch:assert test="(math:abs((.) - (((sum(../MTR:LossesBroughtForward) + sum(../MTR:UnusedLossFromTheYear)) - sum(../MTR:LossesUsedAgainstProfitsOfYear)))) &lt; 0.001)" id="a_LUW-LOSSES-AVAILABLE-TO-CF-AMT.1" diagnostics="errorCode.LUW-LOSSES-AVAILABLE-TO-CF-AMT.1 transactional.LUW-LOSSES-AVAILABLE-TO-CF-AMT.1 transactional.en.LUW-LOSSES-AVAILABLE-TO-CF-AMT.1 ">[LUN62] should equal ( ( [LUN59] plus [LUN61] ) minus [LUN60] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p233">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:NICs/MTR:PayClass2NICvoluntarily">
        <sch:assert test="../MTR:Class2NICamount" id="a_LUW-CLASS-2-NIC-VOLUNTARY-SIG.0" diagnostics="errorCode.LUW-CLASS-2-NIC-VOLUNTARY-SIG.0 transactional.LUW-CLASS-2-NIC-VOLUNTARY-SIG.0 transactional.en.LUW-CLASS-2-NIC-VOLUNTARY-SIG.0 ">[LUNCL2] should be present if [LUN63] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p234">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:NICs/MTR:Class2NICamount">
        <sch:assert test=". &lt;= 219.95" id="a_LUW-CLASS-2-NIC-AMOUNT.0" diagnostics="errorCode.LUW-CLASS-2-NIC-AMOUNT.0 transactional.LUW-CLASS-2-NIC-AMOUNT.0 transactional.en.LUW-CLASS-2-NIC-AMOUNT.0 ">[LUNCL2] is valid only if this does not exceed [£219.95]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p232">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L/MTR:NICs">
        <sch:assert test="MTR:PayClass2NICvoluntarily or MTR:Class2NICamount or MTR:Class4NICexempt or MTR:AdjustmentToClass4NICProfits" id="a_RIM-LUW-NIC.0" diagnostics="errorCode.RIM-LUW-NIC.0 transactional.RIM-LUW-NIC.0 transactional.en.RIM-LUW-NIC.0 ">If [LUN63-65] is present then at least one of the following should be present: [LUN63], [LUNCL2], [LUN64] or [LUN65]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p197">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA103L">
        <sch:assert test="not(MTR:UKIncome/MTR:UKInterest/MTR:BankEtcAndGiltUntaxedInterest or MTR:UKIncome/MTR:UKInterest/MTR:AccruedIncomeSchemeAggregateAmount or MTR:UKIncome/MTR:UKInterest/MTR:TaxedUnitTrustEtcInterest or MTR:UKIncome/MTR:UKInterest/MTR:TaxTakenOff) or MTR:UKIncome/MTR:UKInterest/MTR:TotalUKInterestAndTaxTakenOff" id="a_SA103L.0" diagnostics="errorCode.SA103L.0 transactional.SA103L.0 transactional.en.SA103L.0 ">total UK interest and tax teken off should be present if [LUN1] or [LUN2] or [LUN3] or [LUN4]</sch:assert>
        <sch:assert test="not(MTR:ForeignIncome/MTR:Interest/MTR:ForeignInterestEtcAmount or MTR:ForeignIncome/MTR:Interest/MTR:ForeignTaxDeducted or MTR:ForeignIncome/MTR:Interest/MTR:UKTaxDeducted or MTR:ForeignIncome/MTR:Dividends/MTR:NonUKDividendsAmount or MTR:ForeignIncome/MTR:Dividends/MTR:ForeignTaxDeducted or MTR:ForeignIncome/MTR:Dividends/MTR:UKTaxDeducted) or MTR:ForeignIncome/MTR:Dividends/MTR:TotalNonUKIncome" id="a_SA103L.3" diagnostics="errorCode.SA103L.3 transactional.SA103L.3 transactional.en.SA103L.3 ">total non-UK income should be present if [LUN12] or [LUN13] or [LUN14] or [LUN15] or [LUN16] or [LUN17]</sch:assert>
        <sch:assert test="not(MTR:UKIncome/MTR:UKInterest/MTR:TotalUKInterestAndTaxTakenOff or MTR:UKIncome/MTR:UKDividends/MTR:TotalUKDividendsAndDistributions or MTR:ForeignIncome/MTR:Dividends/MTR:TotalNonUKIncome or MTR:OtherReceipts/MTR:TotalOtherLloydsReceipts) or MTR:TotalLloydsIncome" id="a_SA103L.5" diagnostics="errorCode.SA103L.5 transactional.SA103L.5 transactional.en.SA103L.5 ">total Lloyd's income should be present if [LUN5] or [LUN11] or [LUN18] or [LUN26]</sch:assert>
        <sch:assert test="not((((sum(MTR:LossesAndExpenses/MTR:AggregateSyndicateLosses) + sum(MTR:LossesAndExpenses/MTR:SpecialReserveFundNetTransfer) + sum(MTR:LossesAndExpenses/MTR:StopLossPremiumsPaid) + sum(MTR:LossesAndExpenses/MTR:PersonalQuotaShareAndExeatPremiums) + sum(MTR:LossesAndExpenses/MTR:EstateProtectionPlanPremiums) + sum(MTR:LossesAndExpenses/MTR:UnderwritingLoanInterest) + sum(MTR:LossesAndExpenses/MTR:LloydsMembersAssociationExpenses) + sum(MTR:LossesAndExpenses/MTR:MembersAgentProfitCommissionAndSalaries) + sum(MTR:LossesAndExpenses/MTR:BankGuaranteelettersOfCreditFees) + sum(MTR:LossesAndExpenses/MTR:AccountancyFees) + sum(MTR:LossesAndExpenses/MTR:OtherLloydsExpenses))) - (0) &gt;= 0.001)) or MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses" id="a_SA103L.6" diagnostics="errorCode.SA103L.6 transactional.SA103L.6 transactional.en.SA103L.6 ">total losses and expenses should be present if ( The sum of [LUN29], [LUN30], [LUN31], [LUN32], [LUN33], [LUN34], [LUN35], [LUN36], [LUN37], [LUN38], and [LUN39] ) exceeds 0</sch:assert>
        <sch:assert test="not((((sum(MTR:TotalLloydsIncome) - sum(MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses))) - (0) &gt;= 0.001)) or MTR:ProfitAmount" id="a_SA103L.7" diagnostics="errorCode.SA103L.7 transactional.SA103L.7 transactional.en.SA103L.7 ">profit amount should be present if ( [LUN27] minus [LUN40] ) exceeds 0</sch:assert>
        <sch:assert test="not((((sum(MTR:LossesAndExpenses/MTR:TotalLossesAndExpenses) - sum(MTR:TotalLloydsIncome))) - (0) &gt;= 0.001)) or MTR:LossAmount" id="a_SA103L.8" diagnostics="errorCode.SA103L.8 transactional.SA103L.8 transactional.en.SA103L.8 ">loss amount should be present if ( [LUN40] minus [LUN27] ) exceeds 0</sch:assert>
        <sch:assert test="not(MTR:ForeignIncome/MTR:Interest/MTR:ForeignTaxDeducted or MTR:ForeignIncome/MTR:Dividends/MTR:ForeignTaxDeducted) or MTR:ForeignTax/MTR:ForeignTaxOnPersonalFundIncome" id="a_SA103L.9" diagnostics="errorCode.SA103L.9 transactional.SA103L.9 transactional.en.SA103L.9 ">foreign tax on personal fund income should be present if [LUN13] or [LUN16]</sch:assert>
        <sch:assert test="not(MTR:LossAmount) or MTR:AllowableLosses/MTR:LossAmount" id="a_SA103L.12" diagnostics="errorCode.SA103L.12 transactional.SA103L.12 transactional.en.SA103L.12 ">loss amount should be present if [LUN42]</sch:assert>
        <sch:assert test="not(MTR:AllowableLosses/MTR:LossAmount or MTR:AllowableLosses/MTR:ForeignTaxClaimedAsDeduction) or MTR:AllowableLosses/MTR:LossForTheYear" id="a_SA103L.14" diagnostics="errorCode.SA103L.14 transactional.SA103L.14 transactional.en.SA103L.14 ">loss for the year should be present if [LUN53] or [LUN54]</sch:assert>
        <sch:assert test="not(MTR:TaxableProfits/MTR:UnusedLossesBroughtForward) or MTR:LossesReconciliation/MTR:LossesUsedAgainstProfitsOfYear" id="a_SA103L.15" diagnostics="errorCode.SA103L.15 transactional.SA103L.15 transactional.en.SA103L.15 ">losses used against profits of year should be present if [LUN51]</sch:assert>
        <sch:assert test="not(MTR:AllowableLosses/MTR:UnusedLossesToCarryForward) or MTR:LossesReconciliation/MTR:UnusedLossFromTheYear" id="a_SA103L.16" diagnostics="errorCode.SA103L.16 transactional.SA103L.16 transactional.en.SA103L.16 ">unused loss from the year should be present if [LUN58]</sch:assert>
        <sch:assert test="not(sum(MTR:ProfitAmount) &gt; 0) or MTR:TaxableProfits/MTR:ProfitAmount" id="a_SA103L.17" diagnostics="errorCode.SA103L.17 transactional.SA103L.17 transactional.en.SA103L.17 ">profit amount should be present if [LUN41] exceeds 0</sch:assert>
        <sch:assert test="not(((((sum(MTR:LossesReconciliation/MTR:LossesBroughtForward) + sum(MTR:LossesReconciliation/MTR:UnusedLossFromTheYear)) - sum(MTR:LossesReconciliation/MTR:LossesUsedAgainstProfitsOfYear))) - (0) &gt;= 0.001)) or MTR:LossesReconciliation/MTR:TotalLossToCarryForward" id="a_SA103L.20" diagnostics="errorCode.SA103L.20 transactional.SA103L.20 transactional.en.SA103L.20 ">[LUN62] should be present if ( ( [LUN59] plus [LUN61] ) minus [LUN60] ) exceeds 0</sch:assert>
        <sch:assert test="not(MTR:UKIncome/MTR:UKDividends/MTR:StockDividendsAmountReceived) or MTR:UKIncome/MTR:UKDividends/MTR:TotalUKDividendsAndDistributions" id="a_SA103L.1" diagnostics="errorCode.SA103L.1 transactional.SA103L.1 transactional.en.SA103L.1 ">[LUN11] should be present if [LUN6] is present</sch:assert>
        <sch:assert test="not(MTR:UKIncome/MTR:UKDividends/MTR:BonusIssuesOfSecuritiesAndRedeemableShares) or MTR:UKIncome/MTR:UKDividends/MTR:TotalUKDividendsAndDistributions" id="a_SA103L.2" diagnostics="errorCode.SA103L.2 transactional.SA103L.2 transactional.en.SA103L.2 ">[LUN11] should be present if [LUN8] is present</sch:assert>
        <sch:assert test="not(MTR:UKIncome/MTR:UKDividends/MTR:OtherDistributionsAmountReceived) or MTR:UKIncome/MTR:UKDividends/MTR:TotalUKDividendsAndDistributions" id="a_SA103L.4" diagnostics="errorCode.SA103L.4 transactional.SA103L.4 transactional.en.SA103L.4 ">[LUN11] should be present if [LUN9] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p236">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:PartnershipDetails/MTR:PartnershipReferenceNumber">
        <sch:assert test="(((11 - (((6 * substring((.), 2, 1)) + (7 * substring((.), 3, 1)) + (8 * substring((.), 4, 1)) + (9 * substring((.), 5, 1)) + (10 * substring((.), 6, 1)) + (5 * substring((.), 7, 1)) + (4 * substring((.), 8, 1)) + (3 * substring((.), 9, 1)) + (2 * substring((.), 10, 1))) mod 11)) &gt; 9) and (substring((.), 1, 1) = (11 - (((6 * substring((.), 2, 1)) + (7 * substring((.), 3, 1)) + (8 * substring((.), 4, 1)) + (9 * substring((.), 5, 1)) + (10 * substring((.), 6, 1)) + (5 * substring((.), 7, 1)) + (4 * substring((.), 8, 1)) + (3 * substring((.), 9, 1)) + (2 * substring((.), 10, 1))) mod 11)) - 9))
                or
                (substring((.), 1, 1) = (11 - (((6 * substring((.), 2, 1)) + (7 * substring((.), 3, 1)) + (8 * substring((.), 4, 1)) + (9 * substring((.), 5, 1)) + (10 * substring((.), 6, 1)) + (5 * substring((.), 7, 1)) + (4 * substring((.), 8, 1)) + (3 * substring((.), 9, 1)) + (2 * substring((.), 10, 1))) mod 11)))" id="a_PTR2-PARTNERSHIP-REF-NUMBER.0" diagnostics="errorCode.PTR2-PARTNERSHIP-REF-NUMBER.0 transactional.PTR2-PARTNERSHIP-REF-NUMBER.0 transactional.en.PTR2-PARTNERSHIP-REF-NUMBER.0 ">Must be valid against the UTR algorithm</sch:assert>
        <sch:assert test="(&apos;1111111111&apos; != (.)) 
                and
              (&apos;2222222222&apos; != (.)) 
                and
              (&apos;3333333333&apos; != (.)) 
                and
              (&apos;4444444444&apos; != (.)) 
                and
              (&apos;5555555555&apos; != (.)) 
                and
              (&apos;6666666666&apos; != (.)) 
                and
              (&apos;7777777777&apos; != (.)) 
                and
              (&apos;8888888888&apos; != (.)) 
                and
              (&apos;9999999999&apos; != (.))" id="a_PTR2-PARTNERSHIP-REF-NUMBER.1" diagnostics="errorCode.PTR2-PARTNERSHIP-REF-NUMBER.1 transactional.PTR2-PARTNERSHIP-REF-NUMBER.1 transactional.en.PTR2-PARTNERSHIP-REF-NUMBER.1 ">Must not be 1111111111, 2222222222, 3333333333, 4444444444, 5555555555, 6666666666, 7777777777, 8888888888, or 9999999999.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p237">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:PartnershipDetails/MTR:DidYouJoinThePartnership">
        <sch:assert test="not((.) = &apos;yes&apos;) or ../MTR:DateJoinedPartnership" id="a_PTR-BUSINESS-JOIN-QUES.0" diagnostics="errorCode.PTR-BUSINESS-JOIN-QUES.0 transactional.PTR-BUSINESS-JOIN-QUES.0 transactional.en.PTR-BUSINESS-JOIN-QUES.0 ">[FPS3] should be present if [FPS3Q] equals 'yes'</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p238">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:PartnershipDetails/MTR:DateJoinedPartnership">
        <sch:assert test="(round(date:seconds(normalize-space(concat(2025, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))
                  and
                (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2026, &quot;-04-05&quot;))) div 86400))" id="a_PTR3-STARTED-AS-PARTNER-DATE.1" diagnostics="errorCode.PTR3-STARTED-AS-PARTNER-DATE.1 transactional.PTR3-STARTED-AS-PARTNER-DATE.1 transactional.en.PTR3-STARTED-AS-PARTNER-DATE.1 ">[FPS3] should be within the current return year</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p239">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:PartnershipDetails/MTR:DidYouLeaveThePartnership">
        <sch:assert test="not((.) = &apos;yes&apos;) or ../MTR:DateLeftPartnership" id="a_PTR-BUSINESS-LEAVE-QUES.0" diagnostics="errorCode.PTR-BUSINESS-LEAVE-QUES.0 transactional.PTR-BUSINESS-LEAVE-QUES.0 transactional.en.PTR-BUSINESS-LEAVE-QUES.0 ">[FPS4] should be present if [FPS4Q] equals 'yes'</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p240">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:PartnershipDetails/MTR:DateLeftPartnership">
        <sch:assert test="(round(date:seconds(normalize-space(concat(2025, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))
                  and
                (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2026, &quot;-04-05&quot;))) div 86400))" id="a_PTR-DATE-CEASED-AS-PARTNER.1" diagnostics="errorCode.PTR-DATE-CEASED-AS-PARTNER.1 transactional.PTR-DATE-CEASED-AS-PARTNER.1 transactional.en.PTR-DATE-CEASED-AS-PARTNER.1 ">[FPS4] should be within the current return year</sch:assert>
        <sch:assert test="not(../MTR:DateJoinedPartnership) or translate((.),&apos;-&apos;,&apos;&apos;) &gt;= translate(../MTR:DateJoinedPartnership,&apos;-&apos;,&apos;&apos;)" id="a_PTR-DATE-CEASED-AS-PARTNER.2" diagnostics="errorCode.PTR-DATE-CEASED-AS-PARTNER.2 transactional.PTR-DATE-CEASED-AS-PARTNER.2 transactional.en.PTR-DATE-CEASED-AS-PARTNER.2 ">If both [FPS3] and [FPS4] present then [FPS4] must be &gt;= [FPS3]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p242">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfProfits/MTR:LossBroughtForwardUsedAgainstSpreadTransitionProfit">
        <sch:assert test=". &lt;= sum(../MTR:SpreadTransitionProfitTreatedAsArising)" id="a_PTR-TRPO-LOSSES-USED-THIS-YEAR.0" diagnostics="errorCode.PTR-TRPO-LOSSES-USED-THIS-YEAR.0 transactional.PTR-TRPO-LOSSES-USED-THIS-YEAR.0 transactional.en.PTR-TRPO-LOSSES-USED-THIS-YEAR.0 ">[FPS16.4] is valid only if this does not exceed [FPS16.3]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p243">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfProfits/MTR:LossesBroughtForward">
        <sch:assert test=". &lt;= sum(../MTR:AdjustedProfitForYear)" id="a_PTR-LOSSES-USED-THIS-YR.1" diagnostics="errorCode.PTR-LOSSES-USED-THIS-YR.1 transactional.PTR-LOSSES-USED-THIS-YR.1 transactional.en.PTR-LOSSES-USED-THIS-YR.1 ">[FPS17] is valid only if this does not exceed [FPS16]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p244">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfProfits/MTR:TaxableProfitsAfterLosses">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:AdjustedProfitForYear) - sum(../MTR:LossesBroughtForward)))) &lt; 0.001)" id="a_PTR-PROFIT-AFTER-LOSSES.1" diagnostics="errorCode.PTR-PROFIT-AFTER-LOSSES.1 transactional.PTR-PROFIT-AFTER-LOSSES.1 transactional.en.PTR-PROFIT-AFTER-LOSSES.1 ">[FPS18] should equal ( [FPS16] minus [FPS17] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p245">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfProfits/MTR:TotalTaxableBusinessProfits">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:TaxableProfitsAfterLosses) + sum(../MTR:OtherBusinessIncome)))) &lt; 0.001)" id="a_PTR-TOTAL-TAXABLE-PROFITS.1" diagnostics="errorCode.PTR-TOTAL-TAXABLE-PROFITS.1 transactional.PTR-TOTAL-TAXABLE-PROFITS.1 transactional.en.PTR-TOTAL-TAXABLE-PROFITS.1 ">[FPS20] should equal ( [FPS18] plus [FPS19] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p246">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfProfits/MTR:TotalTaxableBusinessProfitsFIGclaim">
        <sch:assert test=". &lt;= sum(../MTR:TotalTaxableBusinessProfits)" id="a_PTR-TOTAL-TAX-PROF-FIG-CLM.0" diagnostics="errorCode.PTR-TOTAL-TAX-PROF-FIG-CLM.0 transactional.PTR-TOTAL-TAX-PROF-FIG-CLM.0 transactional.en.PTR-TOTAL-TAX-PROF-FIG-CLM.0 ">[FPS20.1] is valid only if this does not exceed [FPS20]</sch:assert>
        <sch:assert test="../../MTR:ShareOfPartnershipIncome/MTR:TotalTaxedAndUntaxedIncomeFIGclaim" id="a_PTR-TOTAL-TAX-PROF-FIG-CLM.1" diagnostics="errorCode.PTR-TOTAL-TAX-PROF-FIG-CLM.1 transactional.PTR-TOTAL-TAX-PROF-FIG-CLM.1 transactional.en.PTR-TOTAL-TAX-PROF-FIG-CLM.1 ">[FPS76.1] mandatory if [FPS20.1]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_PTR-TOTAL-TAX-PROF-FIG-CLM.2" diagnostics="errorCode.PTR-TOTAL-TAX-PROF-FIG-CLM.2 transactional.PTR-TOTAL-TAX-PROF-FIG-CLM.2 transactional.en.PTR-TOTAL-TAX-PROF-FIG-CLM.2 ">If [FPS20.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p241">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfProfits">
        <sch:assert test="(((sum(MTR:ShareOfPartnershipProfitOrLoss) + sum(MTR:TaxYearAdjustment) - sum(MTR:ForeignTaxClaimedAsDeduction))) - (0) &lt; 0.001)
                or
              (MTR:AdjustedProfitForYear and (math:abs(((sum(MTR:ShareOfPartnershipProfitOrLoss) + sum(MTR:TaxYearAdjustment) - sum(MTR:ForeignTaxClaimedAsDeduction)) + sum(MTR:ChangeOfAccountingPracticeAdjustment) + sum(MTR:AveragingAdjustment)) - (sum(MTR:AdjustedProfitForYear))) &lt; 0.001))" id="a_RIM-FPS-SHARE-PROFIT.0" diagnostics="errorCode.RIM-FPS-SHARE-PROFIT.0 transactional.RIM-FPS-SHARE-PROFIT.0 transactional.en.RIM-FPS-SHARE-PROFIT.0 ">If ([FPS8] + [FPS9] - [FPS12]) is positive, then [FPS16] is mandatory and equals ([FPS8] + [FPS9] - [FPS12] + [FPS10] + [FPS11])</sch:assert>
        <sch:assert test="(((sum(MTR:ShareOfPartnershipProfitOrLoss) + sum(MTR:TaxYearAdjustment) - sum(MTR:ForeignTaxClaimedAsDeduction))) - (0) &gt;= 0.001)
                or
              ( (((sum(MTR:AveragingAdjustment) + sum(MTR:ChangeOfAccountingPracticeAdjustment))) - (0) &lt; 0.001) and sum(MTR:AdjustedProfitForYear) = 0)
                or
              ( (((sum(MTR:AveragingAdjustment) + sum(MTR:ChangeOfAccountingPracticeAdjustment))) - (0) &gt;= 0.001) and MTR:AdjustedProfitForYear and (math:abs(((sum(MTR:AveragingAdjustment) + sum(MTR:ChangeOfAccountingPracticeAdjustment))) - (MTR:AdjustedProfitForYear)) &lt; 0.001))" id="a_RIM-FPS-SHARE-PROFIT.5" diagnostics="errorCode.RIM-FPS-SHARE-PROFIT.5 transactional.RIM-FPS-SHARE-PROFIT.5 transactional.en.RIM-FPS-SHARE-PROFIT.5 ">If ([FPS8] + [FPS9] - [FPS12]) is negative or zero, then if ([FPS10] + [FPS11]) is greater than zero, then [FPS16]  is mandatory and equals ([FPS10] + [FPS11]); else [FPS16] must be zero or absent.</sch:assert>
        <sch:assert test="not((((sum(MTR:ShareOfPartnershipProfitOrLoss) + sum(MTR:TaxYearAdjustment) - sum(MTR:ForeignTaxClaimedAsDeduction))) - (0) &lt;= -0.001))
            or
          (math:abs((math:abs((sum(MTR:ShareOfPartnershipProfitOrLoss) + sum(MTR:TaxYearAdjustment) - sum(MTR:ForeignTaxClaimedAsDeduction)))) - (sum(../MTR:ShareOfLosses/MTR:AdjustedLossForYear))) &lt; 0.001)" id="a_RIM-FPS-SHARE-PROFIT.2" diagnostics="errorCode.RIM-FPS-SHARE-PROFIT.2 transactional.RIM-FPS-SHARE-PROFIT.2 transactional.en.RIM-FPS-SHARE-PROFIT.2 ">If ([FPS8] + [FPS9] - [FPS12]) is less than zero, then [FPS21] is mandatory and  = positive equivalent of ([FPS8] + [FPS9] - [FPS12])</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p247">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfLosses/MTR:AdjustedLossForYear">
        <sch:assert test="(((sum(../../MTR:ShareOfProfits/MTR:ShareOfPartnershipProfitOrLoss) + sum(../../MTR:ShareOfProfits/MTR:TaxYearAdjustment) - sum(../../MTR:ShareOfProfits/MTR:ForeignTaxClaimedAsDeduction))) - (0) &lt;= -0.001)
            or
          (math:abs((0) - ((.))) &lt; 0.001)" id="a_RIM-FPS-SHARE-PROFIT.3" diagnostics="errorCode.RIM-FPS-SHARE-PROFIT.3 transactional.RIM-FPS-SHARE-PROFIT.3 transactional.en.RIM-FPS-SHARE-PROFIT.3 ">If ([FPS8] + [FPS9] - [FPS12]) is greater than or equal to zero, then [FPS21] must be equal to zero or is absent</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p248">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfLosses/MTR:AdjustedLossForYearFIGclaim">
        <sch:assert test=". = sum(../MTR:AdjustedLossForYear)" id="a_PTR3-ALLOW-LOSS-FIG-CLM.0" diagnostics="errorCode.PTR3-ALLOW-LOSS-FIG-CLM.0 transactional.PTR3-ALLOW-LOSS-FIG-CLM.0 transactional.en.PTR3-ALLOW-LOSS-FIG-CLM.0 ">[FPS21.1] is valid only if this equals [FPS21]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_PTR3-ALLOW-LOSS-FIG-CLM.1" diagnostics="errorCode.PTR3-ALLOW-LOSS-FIG-CLM.1 transactional.PTR3-ALLOW-LOSS-FIG-CLM.1 transactional.en.PTR3-ALLOW-LOSS-FIG-CLM.1 ">If [FPS21.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p249">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfLosses/MTR:LossSetOffAgainstOtherIncome">
        <sch:assert test=". &lt;= sum(../MTR:AdjustedLossForYear)" id="a_PTR1-LOSS-TO-SET-OFF-OTHER-INC.0" diagnostics="errorCode.PTR1-LOSS-TO-SET-OFF-OTHER-INC.0 transactional.PTR1-LOSS-TO-SET-OFF-OTHER-INC.0 transactional.en.PTR1-LOSS-TO-SET-OFF-OTHER-INC.0 ">[FPS22] should not exceed [FPS21]</sch:assert>
        <sch:assert test="not(../MTR:AdjustedLossForYearFIGclaim)" id="a_PTR1-LOSS-TO-SET-OFF-OTHER-INC.1" diagnostics="errorCode.PTR1-LOSS-TO-SET-OFF-OTHER-INC.1 transactional.PTR1-LOSS-TO-SET-OFF-OTHER-INC.1 transactional.en.PTR1-LOSS-TO-SET-OFF-OTHER-INC.1 ">[FPS22] should not be present if [FPS21.1] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p250">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfLosses/MTR:LossToBeCarriedBack">
        <sch:assert test="((.) - ((sum(../MTR:AdjustedLossForYear) - sum(../MTR:LossSetOffAgainstOtherIncome))) &lt; 0.001)" id="a_PTR-LOSS-TO-CARRY-BACK.0" diagnostics="errorCode.PTR-LOSS-TO-CARRY-BACK.0 transactional.PTR-LOSS-TO-CARRY-BACK.0 transactional.en.PTR-LOSS-TO-CARRY-BACK.0 ">[FPS23] should not exceed ( [FPS21] minus [FPS22] )</sch:assert>
        <sch:assert test="not(../MTR:AdjustedLossForYearFIGclaim)" id="a_PTR-LOSS-TO-CARRY-BACK.1" diagnostics="errorCode.PTR-LOSS-TO-CARRY-BACK.1 transactional.PTR-LOSS-TO-CARRY-BACK.1 transactional.en.PTR-LOSS-TO-CARRY-BACK.1 ">[FPS23] should not be present if [FPS21.1] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p252">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:NICs/MTR:PayClass2NICvoluntarily">
        <sch:assert test="../MTR:Class2NICamount" id="a_PTR-CLASS-2-NIC-VOLUNTARY-SIG.0" diagnostics="errorCode.PTR-CLASS-2-NIC-VOLUNTARY-SIG.0 transactional.PTR-CLASS-2-NIC-VOLUNTARY-SIG.0 transactional.en.PTR-CLASS-2-NIC-VOLUNTARY-SIG.0 ">[FPSCL2] should be present if [FPS25] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p253">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:NICs/MTR:Class2NICamount">
        <sch:assert test=". &lt;= 219.95" id="a_PTR-CLASS-2-NIC-AMOUNT.0" diagnostics="errorCode.PTR-CLASS-2-NIC-AMOUNT.0 transactional.PTR-CLASS-2-NIC-AMOUNT.0 transactional.en.PTR-CLASS-2-NIC-AMOUNT.0 ">[FPSCL2] is valid only if this does not exceed [£219.95]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p251">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:NICs">
        <sch:assert test="MTR:PayClass2NICvoluntarily or MTR:Class2NICamount or MTR:Class4NICexempt or MTR:AdjustmentToClass4NICProfits" id="a_RIM-FPS-NIC.0" diagnostics="errorCode.RIM-FPS-NIC.0 transactional.RIM-FPS-NIC.0 transactional.en.RIM-FPS-NIC.0 ">If [FPS25-27] is present then at least one of the following should be present: [FPS25], [FPSCL2], [FPS26] or [FPS27]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p254">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:AdjustedUKSavingsIncome">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:UKUntaxedSavingsIncomeShare) + sum(../MTR:UKUntaxedSavingsAdjustment)))) &lt; 0.001)" id="a_PTR-ADJ-UK-SAVING-BASIS-PERIOD.1" diagnostics="errorCode.PTR-ADJ-UK-SAVING-BASIS-PERIOD.1 transactional.PTR-ADJ-UK-SAVING-BASIS-PERIOD.1 transactional.en.PTR-ADJ-UK-SAVING-BASIS-PERIOD.1 ">[FPS30] should equal ( [FPS28] plus [FPS29] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p255">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:ForeignIncome/MTR:AdjustedForeignSavingsIncome">
        <sch:assert test="(math:abs((.) - (((sum(../MTR:ForeignUntaxedSavingsIncomeShare) + sum(../MTR:ForeignUntaxedSavingsAdjustment)) - sum(../MTR:TotalForeignTaxTakenOff)))) &lt; 0.001)" id="a_PTR-TAXABLE-FOREIGN-INCOME.1" diagnostics="errorCode.PTR-TAXABLE-FOREIGN-INCOME.1 transactional.PTR-TAXABLE-FOREIGN-INCOME.1 transactional.en.PTR-TAXABLE-FOREIGN-INCOME.1 ">[FPS34] should equal ( ( [FPS31] plus [FPS32] ) minus [FPS33] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p256">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:TotalUntaxedSavingsIncome">
        <sch:assert test="(((sum(../MTR:AdjustedUKSavingsIncome) + sum(../MTR:ForeignIncome/MTR:AdjustedForeignSavingsIncome))) - (0) &lt;= -0.001) or (math:abs((.) - ((sum(../MTR:AdjustedUKSavingsIncome) + sum(../MTR:ForeignIncome/MTR:AdjustedForeignSavingsIncome)))) &lt; 0.001)" id="a_PTR-UNTAXED-INC-LIABLE-AT-LR.1" diagnostics="errorCode.PTR-UNTAXED-INC-LIABLE-AT-LR.1 transactional.PTR-UNTAXED-INC-LIABLE-AT-LR.1 transactional.en.PTR-UNTAXED-INC-LIABLE-AT-LR.1 ">If ([FPS30] plus [FPS34]) is positive or zero, then [FPS35] must equal [FPS30] plus [FPS34]</sch:assert>
        <sch:assert test="((0) - ((sum(../MTR:AdjustedUKSavingsIncome) + sum(../MTR:ForeignIncome/MTR:AdjustedForeignSavingsIncome))) &lt; 0.001) or (math:abs((0) - (.)) &lt; 0.001)" id="a_PTR-UNTAXED-INC-LIABLE-AT-LR.2" diagnostics="errorCode.PTR-UNTAXED-INC-LIABLE-AT-LR.2 transactional.PTR-UNTAXED-INC-LIABLE-AT-LR.2 transactional.en.PTR-UNTAXED-INC-LIABLE-AT-LR.2 ">If ([FPS30] plus [FPS34]) is negative, [FPS35] must equal zero</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p257">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:TotalUntaxedSavingsIncomeFIGclaim">
        <sch:assert test=". &lt;= sum(../MTR:TotalUntaxedSavingsIncome)" id="a_PTR-UNTAXED-INC-LATLR-FIG-CLM.0" diagnostics="errorCode.PTR-UNTAXED-INC-LATLR-FIG-CLM.0 transactional.PTR-UNTAXED-INC-LATLR-FIG-CLM.0 transactional.en.PTR-UNTAXED-INC-LATLR-FIG-CLM.0 ">[FPS35.1] is valid only if this does not exceed [FPS35]</sch:assert>
        <sch:assert test="not(../../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_PTR-UNTAXED-INC-LATLR-FIG-CLM.1" diagnostics="errorCode.PTR-UNTAXED-INC-LATLR-FIG-CLM.1 transactional.PTR-UNTAXED-INC-LATLR-FIG-CLM.1 transactional.en.PTR-UNTAXED-INC-LATLR-FIG-CLM.1 ">If [FPS35.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p258">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:UKPropertyIncome/MTR:LossBroughtForward">
        <sch:assert test="((sum(../MTR:UKPropertyProfitLossShare) + sum(../MTR:UKPropertyIncomeAdjustment)) - (0) &lt; 0.001) or ((.) - (sum(../MTR:UKPropertyProfitLossShare) + sum(../MTR:UKPropertyIncomeAdjustment)) &lt; 0.001)" id="a_PTR4-UK-LAND-LOSS-BF-AMO.1" diagnostics="errorCode.PTR4-UK-LAND-LOSS-BF-AMO.1 transactional.PTR4-UK-LAND-LOSS-BF-AMO.1 transactional.en.PTR4-UK-LAND-LOSS-BF-AMO.1 ">[FPS38] cannot exceed the sum of [FPS36]+[FPS37] where the sum is positive</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p259">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:UKPropertyIncome/MTR:TaxableProfitsAfterAdjustmentAndLosses">
        <sch:assert test="(((sum(../MTR:UKPropertyProfitLossShare) + sum(../MTR:UKPropertyIncomeAdjustment) - sum(../MTR:LossBroughtForward))) - (0) &lt;= -0.001)
            or
          (math:abs(((sum(../MTR:UKPropertyProfitLossShare) + sum(../MTR:UKPropertyIncomeAdjustment) - sum(../MTR:LossBroughtForward))) - ((.))) &lt; 0.001)" id="a_PTR-TAXABLE-PROFIT-FROM-IFP.0" diagnostics="errorCode.PTR-TAXABLE-PROFIT-FROM-IFP.0 transactional.PTR-TAXABLE-PROFIT-FROM-IFP.0 transactional.en.PTR-TAXABLE-PROFIT-FROM-IFP.0 ">if ([FPS36] + [FPS37] - [FPS38]) is positive or zero, then [FPS41] = [FPS36] + [FPS37] - [FPS38]</sch:assert>
        <sch:assert test="((0) - ((sum(../MTR:UKPropertyProfitLossShare) + sum(../MTR:UKPropertyIncomeAdjustment) - sum(../MTR:LossBroughtForward))) &lt; 0.001)
            or
          (math:abs((0) - ((.))) &lt; 0.001)" id="a_PTR-TAXABLE-PROFIT-FROM-IFP.1" diagnostics="errorCode.PTR-TAXABLE-PROFIT-FROM-IFP.1 transactional.PTR-TAXABLE-PROFIT-FROM-IFP.1 transactional.en.PTR-TAXABLE-PROFIT-FROM-IFP.1 ">if ([FPS36] + [FPS37] - [FPS38]) is negative, [FPS41] = 0 </sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p261">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedUKIncome/MTR:LossBroughtForward">
        <sch:assert test="((.) - ((sum(../MTR:OtherUntaxedUKIncomeShare) + sum(../MTR:OtherUntaxedUKIncomeAdjustment))) &lt; 0.001)" id="a_PTR4-OTHER-UK-LOSS-BF-AMO.1" diagnostics="errorCode.PTR4-OTHER-UK-LOSS-BF-AMO.1 transactional.PTR4-OTHER-UK-LOSS-BF-AMO.1 transactional.en.PTR4-OTHER-UK-LOSS-BF-AMO.1 ">[FPS47] should not exceed ( [FPS45] plus [FPS46] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p262">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedUKIncome/MTR:TaxableProfit">
        <sch:assert test="((.) - (((sum(../MTR:OtherUntaxedUKIncomeShare) + sum(../MTR:OtherUntaxedUKIncomeAdjustment)) - sum(../MTR:LossBroughtForward))) &lt; 0.001)" id="a_PTR-TXBLE-PROFIT-OTH-UNT-INC.0" diagnostics="errorCode.PTR-TXBLE-PROFIT-OTH-UNT-INC.0 transactional.PTR-TXBLE-PROFIT-OTH-UNT-INC.0 transactional.en.PTR-TXBLE-PROFIT-OTH-UNT-INC.0 ">[FPS48] should not exceed ( ( [FPS45] plus [FPS46] ) minus [FPS47] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p260">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedUKIncome">
        <sch:assert test="not(MTR:OtherUntaxedUKIncomeShare or MTR:OtherUntaxedUKIncomeAdjustment or MTR:LossBroughtForward)
              or
            not(((((sum(MTR:OtherUntaxedUKIncomeShare) + sum(MTR:OtherUntaxedUKIncomeAdjustment)) - sum(MTR:LossBroughtForward))) - (0) &gt; -0.001))
              or
            MTR:TaxableProfit" id="a_RIM-FPS-OTHER-UK-INC.0" diagnostics="errorCode.RIM-FPS-OTHER-UK-INC.0 transactional.RIM-FPS-OTHER-UK-INC.0 transactional.en.RIM-FPS-OTHER-UK-INC.0 ">If any of [FPS45], [FPS46] or [FPS47] are present, then [FPS48] is mandatory if ([FPS45] + [FPS46] - [FPS47] ) &gt;= 0</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p263">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OffshoreFundsIncome/MTR:TaxableIncomeAfterAdjustmentAndForeignTax">
        <sch:assert test="(math:abs((.) - (((sum(../MTR:OffshoreFundsIncomeShare) + sum(../MTR:OffshoreFundsIncomeAdjustment)) - sum(../MTR:ForeignTaxTakenOff)))) &lt; 0.001)" id="a_PTR-TXBLE-PROFIT-OFFSHORE-FUND.1" diagnostics="errorCode.PTR-TXBLE-PROFIT-OFFSHORE-FUND.1 transactional.PTR-TXBLE-PROFIT-OFFSHORE-FUND.1 transactional.en.PTR-TXBLE-PROFIT-OFFSHORE-FUND.1 ">[FPS55] should equal ( ( [FPS52] plus [FPS53] ) minus [FPS54] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p264">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OffshoreFundsIncome/MTR:OffshoreFundTaxableIncomeFIGclaim">
        <sch:assert test=". &lt;= sum(../MTR:TaxableIncomeAfterAdjustmentAndForeignTax)" id="a_PTR-TXBLE-PROF-OSF-FIG-CLM.0" diagnostics="errorCode.PTR-TXBLE-PROF-OSF-FIG-CLM.0 transactional.PTR-TXBLE-PROF-OSF-FIG-CLM.0 transactional.en.PTR-TXBLE-PROF-OSF-FIG-CLM.0 ">[FPS55.1] is valid only if this does not exceed [FPS55]</sch:assert>
        <sch:assert test="../../../MTR:ShareOfPartnershipIncome/MTR:TotalTaxedAndUntaxedIncomeFIGclaim" id="a_PTR-TXBLE-PROF-OSF-FIG-CLM.1" diagnostics="errorCode.PTR-TXBLE-PROF-OSF-FIG-CLM.1 transactional.PTR-TXBLE-PROF-OSF-FIG-CLM.1 transactional.en.PTR-TXBLE-PROF-OSF-FIG-CLM.1 ">[FPS76.1] mandatory if [FPS55.1]</sch:assert>
        <sch:assert test="not(../../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_PTR-TXBLE-PROF-OSF-FIG-CLM.2" diagnostics="errorCode.PTR-TXBLE-PROF-OSF-FIG-CLM.2 transactional.PTR-TXBLE-PROF-OSF-FIG-CLM.2 transactional.en.PTR-TXBLE-PROF-OSF-FIG-CLM.2 ">If [FPS55.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p265">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedForeignIncome/MTR:OtherUntaxedForeignIncomeShare">
        <sch:assert test="../MTR:TaxableProfit or not((.))" id="a_PTR2-OTHER-UNTAXED-FOREIGN-INC.0" diagnostics="errorCode.PTR2-OTHER-UNTAXED-FOREIGN-INC.0 transactional.PTR2-OTHER-UNTAXED-FOREIGN-INC.0 transactional.en.PTR2-OTHER-UNTAXED-FOREIGN-INC.0 ">[FPS60] mandatory if [FPS56]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p266">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedForeignIncome/MTR:OtherUntaxedForeignIncomeAdjustment">
        <sch:assert test="../MTR:TaxableProfit or not((.))" id="a_PTR4-OTHR-FRGN-PROFIT-ADJ-AMO.0" diagnostics="errorCode.PTR4-OTHR-FRGN-PROFIT-ADJ-AMO.0 transactional.PTR4-OTHR-FRGN-PROFIT-ADJ-AMO.0 transactional.en.PTR4-OTHR-FRGN-PROFIT-ADJ-AMO.0 ">[FPS60] mandatory if [FPS57]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p267">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedForeignIncome/MTR:LossBroughtForward">
        <sch:assert test="../MTR:TaxableProfit or not((.))" id="a_PTR4-OTHER-FRGN-LOSS-BF-AMO.0" diagnostics="errorCode.PTR4-OTHER-FRGN-LOSS-BF-AMO.0 transactional.PTR4-OTHER-FRGN-LOSS-BF-AMO.0 transactional.en.PTR4-OTHER-FRGN-LOSS-BF-AMO.0 ">[FPS60] mandatory if [FPS58]</sch:assert>
        <sch:assert test="((.) - ((sum(../MTR:OtherUntaxedForeignIncomeShare) + sum(../MTR:OtherUntaxedForeignIncomeAdjustment))) &lt; 0.001)" id="a_PTR4-OTHER-FRGN-LOSS-BF-AMO.1" diagnostics="errorCode.PTR4-OTHER-FRGN-LOSS-BF-AMO.1 transactional.PTR4-OTHER-FRGN-LOSS-BF-AMO.1 transactional.en.PTR4-OTHER-FRGN-LOSS-BF-AMO.1 ">[FPS58] should not exceed ( [FPS56] plus [FPS57] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p268">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedForeignIncome/MTR:TotalForeignTaxTakenOff">
        <sch:assert test="../MTR:TaxableProfit or not((.))" id="a_PTR-TXBLE-PROFIT-UNTAXED-FI.0" diagnostics="errorCode.PTR-TXBLE-PROFIT-UNTAXED-FI.0 transactional.PTR-TXBLE-PROFIT-UNTAXED-FI.0 transactional.en.PTR-TXBLE-PROFIT-UNTAXED-FI.0 ">[FPS60] mandatory if [FPS59]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p269">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedForeignIncome/MTR:TaxableProfit">
        <sch:assert test="not((((sum(../MTR:OtherUntaxedForeignIncomeShare) + sum(../MTR:OtherUntaxedForeignIncomeAdjustment)) - (sum(../MTR:LossBroughtForward) + sum(../MTR:TotalForeignTaxTakenOff))) - (0) &gt; -0.001)) or (math:abs((.) - ((sum(../MTR:OtherUntaxedForeignIncomeShare) + sum(../MTR:OtherUntaxedForeignIncomeAdjustment)) - (sum(../MTR:LossBroughtForward) + sum(../MTR:TotalForeignTaxTakenOff)))) &lt; 0.001)" id="a_PTR2-FOREIGN-LET-PROPERTY-LOSS.0" diagnostics="errorCode.PTR2-FOREIGN-LET-PROPERTY-LOSS.0 transactional.PTR2-FOREIGN-LET-PROPERTY-LOSS.0 transactional.en.PTR2-FOREIGN-LET-PROPERTY-LOSS.0 ">If ([FPS56] + [FPS57]) minus ([FPS58] + [FPS59]) is greater than or equal to zero then [FPS60] equals that sum.</sch:assert>
        <sch:assert test="not((((sum(../MTR:OtherUntaxedForeignIncomeShare) + sum(../MTR:OtherUntaxedForeignIncomeAdjustment)) - (sum(../MTR:LossBroughtForward) + sum(../MTR:TotalForeignTaxTakenOff))) - (0) &lt;= -0.001)) or . = 0.00" id="a_PTR2-FOREIGN-LET-PROPERTY-LOSS.1" diagnostics="errorCode.PTR2-FOREIGN-LET-PROPERTY-LOSS.1 transactional.PTR2-FOREIGN-LET-PROPERTY-LOSS.1 transactional.en.PTR2-FOREIGN-LET-PROPERTY-LOSS.1 ">If ([FPS56] + [FPS57]) minus ([FPS58] + [FPS59]) is negative then [FPS60] equals zero.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p270">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedForeignIncome/MTR:TaxableProfitFIGclaim">
        <sch:assert test=". &lt;= sum(../MTR:TaxableProfit)" id="a_PTR2-FOREIGN-LET-PROP-FIG-CLM.0" diagnostics="errorCode.PTR2-FOREIGN-LET-PROP-FIG-CLM.0 transactional.PTR2-FOREIGN-LET-PROP-FIG-CLM.0 transactional.en.PTR2-FOREIGN-LET-PROP-FIG-CLM.0 ">[FPS60.1] is valid only if this does not exceed [FPS60]</sch:assert>
        <sch:assert test="../../../MTR:ShareOfPartnershipIncome/MTR:TotalTaxedAndUntaxedIncomeFIGclaim" id="a_PTR2-FOREIGN-LET-PROP-FIG-CLM.1" diagnostics="errorCode.PTR2-FOREIGN-LET-PROP-FIG-CLM.1 transactional.PTR2-FOREIGN-LET-PROP-FIG-CLM.1 transactional.en.PTR2-FOREIGN-LET-PROP-FIG-CLM.1 ">[FPS76.1] mandatory if [FPS60.1]</sch:assert>
        <sch:assert test="not(../../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_PTR2-FOREIGN-LET-PROP-FIG-CLM.2" diagnostics="errorCode.PTR2-FOREIGN-LET-PROP-FIG-CLM.2 transactional.PTR2-FOREIGN-LET-PROP-FIG-CLM.2 transactional.en.PTR2-FOREIGN-LET-PROP-FIG-CLM.2 ">If [FPS60.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p271">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:TotalUntaxedIncomeShare">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:UKPropertyIncome/MTR:TaxableProfitsAfterAdjustmentAndLosses) + sum(../MTR:OtherUntaxedUKIncome/MTR:TaxableProfit) + sum(../MTR:OffshoreFundsIncome/MTR:TaxableIncomeAfterAdjustmentAndForeignTax) + sum(../MTR:OtherUntaxedForeignIncome/MTR:TaxableProfit)))) &lt; 0.001)" id="a_PTR-TOTAL-UNTAXED-INCOME.0" diagnostics="errorCode.PTR-TOTAL-UNTAXED-INCOME.0 transactional.PTR-TOTAL-UNTAXED-INCOME.0 transactional.en.PTR-TOTAL-UNTAXED-INCOME.0 ">[FPS67] is valid only if this equals ( The sum of [FPS41], [FPS48], [FPS55], and [FPS60] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p272">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfPartnershipIncome/MTR:ShareOfDividendIncome/MTR:TotalDividendIncome">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:DividendIncome) - sum(../MTR:TotalForeignTaxTakenOff)))) &lt; 0.001)" id="a_PTR3-TOTAL-TAXED-INC-SCHF-RATE.1" diagnostics="errorCode.PTR3-TOTAL-TAXED-INC-SCHF-RATE.1 transactional.PTR3-TOTAL-TAXED-INC-SCHF-RATE.1 transactional.en.PTR3-TOTAL-TAXED-INC-SCHF-RATE.1 ">[FPS70] should equal ( [FPS68] minus [FPS69] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p273">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfPartnershipIncome/MTR:ShareOfDividendIncome/MTR:TotalDividendIncomeFIGclaim">
        <sch:assert test=". &lt;= sum(../MTR:TotalDividendIncome)" id="a_PTR3-TOT-TAXD-INC-SCHF-FIG-CLM.0" diagnostics="errorCode.PTR3-TOT-TAXD-INC-SCHF-FIG-CLM.0 transactional.PTR3-TOT-TAXD-INC-SCHF-FIG-CLM.0 transactional.en.PTR3-TOT-TAXD-INC-SCHF-FIG-CLM.0 ">[FPS70.1] is valid only if this does not exceed [FPS70]</sch:assert>
        <sch:assert test="not(../../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_PTR3-TOT-TAXD-INC-SCHF-FIG-CLM.1" diagnostics="errorCode.PTR3-TOT-TAXD-INC-SCHF-FIG-CLM.1 transactional.PTR3-TOT-TAXD-INC-SCHF-FIG-CLM.1 transactional.en.PTR3-TOT-TAXD-INC-SCHF-FIG-CLM.1 ">If [FPS70.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p274">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfPartnershipIncome/MTR:ShareOfTaxedIncomeTaxableAt20Percent/MTR:TaxedIncomeTaxableAt20Percent">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:ShareOfTaxedIncome) - sum(../MTR:TotalForeignTaxTakenOff)))) &lt; 0.001)" id="a_PTR-TOTAL-DIV-INC-WITH-TAX-CRD.1" diagnostics="errorCode.PTR-TOTAL-DIV-INC-WITH-TAX-CRD.1 transactional.PTR-TOTAL-DIV-INC-WITH-TAX-CRD.1 transactional.en.PTR-TOTAL-DIV-INC-WITH-TAX-CRD.1 ">[FPS73] should equal ( [FPS71] minus [FPS72] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p275">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfPartnershipIncome/MTR:ShareOfOtherTaxedIncome/MTR:ShareOfOtherTaxedIncomeFIGclaim">
        <sch:assert test="not((math:abs((.) - (sum(../MTR:ShareOfTaxedIncome))) &lt; 0.001)) or not(../MTR:TotalForeignTaxTakenOff)" id="a_PTR-ADJ-SHARE-OTHER-FIG-CLM.0" diagnostics="errorCode.PTR-ADJ-SHARE-OTHER-FIG-CLM.0 transactional.PTR-ADJ-SHARE-OTHER-FIG-CLM.0 transactional.en.PTR-ADJ-SHARE-OTHER-FIG-CLM.0 ">If [FPS75.1] is present and equal to [FPS74], then [FPS75] must be absent.</sch:assert>
        <sch:assert test="(math:abs((.) - (sum(../MTR:ShareOfTaxedIncome))) &lt; 0.001) or ((.) - ((sum(../MTR:ShareOfTaxedIncome) - sum(../MTR:TotalForeignTaxTakenOff))) &lt; 0.001)" id="a_PTR-ADJ-SHARE-OTHER-FIG-CLM.1" diagnostics="errorCode.PTR-ADJ-SHARE-OTHER-FIG-CLM.1 transactional.PTR-ADJ-SHARE-OTHER-FIG-CLM.1 transactional.en.PTR-ADJ-SHARE-OTHER-FIG-CLM.1 ">If [FPS75.1] is present and not equal to [FPS74], then [FPS75.1] must be less than or equal to [FPS74] minus [FPS75].</sch:assert>
        <sch:assert test="../../MTR:TotalTaxedAndUntaxedIncomeFIGclaim" id="a_PTR-ADJ-SHARE-OTHER-FIG-CLM.2" diagnostics="errorCode.PTR-ADJ-SHARE-OTHER-FIG-CLM.2 transactional.PTR-ADJ-SHARE-OTHER-FIG-CLM.2 transactional.en.PTR-ADJ-SHARE-OTHER-FIG-CLM.2 ">[FPS76.1] mandatory if [FPS75.1]</sch:assert>
        <sch:assert test="not(../../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_PTR-ADJ-SHARE-OTHER-FIG-CLM.3" diagnostics="errorCode.PTR-ADJ-SHARE-OTHER-FIG-CLM.3 transactional.PTR-ADJ-SHARE-OTHER-FIG-CLM.3 transactional.en.PTR-ADJ-SHARE-OTHER-FIG-CLM.3 ">If [FPS75.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p276">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfPartnershipIncome/MTR:ShareOfTotalTaxedAndUntaxedIncome">
        <sch:assert test="(math:abs((.) - (((sum(../../MTR:ShareOfProfits/MTR:TotalTaxableBusinessProfits) + sum(../../MTR:ShareOfUntaxedIncome/MTR:TotalUntaxedIncomeShare) + sum(../MTR:ShareOfOtherTaxedIncome/MTR:ShareOfTaxedIncome)) - sum(../MTR:ShareOfOtherTaxedIncome/MTR:TotalForeignTaxTakenOff)))) &lt; 0.001)" id="a_PTR-TOT-TAX-SHARE-OF-PSHIP-INC.1" diagnostics="errorCode.PTR-TOT-TAX-SHARE-OF-PSHIP-INC.1 transactional.PTR-TOT-TAX-SHARE-OF-PSHIP-INC.1 transactional.en.PTR-TOT-TAX-SHARE-OF-PSHIP-INC.1 ">
share of total taxed and untaxed income is valid if and only if this equals ( ( The sum of [FPS20], [FPS67], and [FPS74] ) minus [FPS75] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p277">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfPartnershipIncome/MTR:TotalTaxedAndUntaxedIncomeFIGclaim">
        <sch:assert test="(math:abs((.) - ((sum(../../MTR:ShareOfProfits/MTR:TotalTaxableBusinessProfitsFIGclaim) + sum(../../MTR:ShareOfUntaxedIncome/MTR:OffshoreFundsIncome/MTR:OffshoreFundTaxableIncomeFIGclaim) + sum(../../MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedForeignIncome/MTR:TaxableProfitFIGclaim) + sum(../MTR:ShareOfOtherTaxedIncome/MTR:ShareOfOtherTaxedIncomeFIGclaim)))) &lt; 0.001)" id="a_PTR-TOT-TAX-SHRE-PSHIP-FIG-CLM.0" diagnostics="errorCode.PTR-TOT-TAX-SHRE-PSHIP-FIG-CLM.0 transactional.PTR-TOT-TAX-SHRE-PSHIP-FIG-CLM.0 transactional.en.PTR-TOT-TAX-SHRE-PSHIP-FIG-CLM.0 ">[FPS76.1] should be equal to the sum of [FPS20.1], [FPS55.1], [FPS60.1] and [FPS75.1]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_PTR-TOT-TAX-SHRE-PSHIP-FIG-CLM.1" diagnostics="errorCode.PTR-TOT-TAX-SHRE-PSHIP-FIG-CLM.1 transactional.PTR-TOT-TAX-SHRE-PSHIP-FIG-CLM.1 transactional.en.PTR-TOT-TAX-SHRE-PSHIP-FIG-CLM.1 ">If [FPS76.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p279">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfPartnershipTaxPayed/MTR:ShareOfTotalTaxTakenOff">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:ShareOfIncomeTaxTakenOffPartnershipIncome) + sum(../MTR:ShareOfTaxTakenOffByContractors) + sum(../MTR:ShareOfTaxTakenOffTradingIncome)))) &lt; 0.001)" id="a_PTR-TOTAL-ADJ-TAX-EX-NOTIONAL.1" diagnostics="errorCode.PTR-TOTAL-ADJ-TAX-EX-NOTIONAL.1 transactional.PTR-TOTAL-ADJ-TAX-EX-NOTIONAL.1 transactional.en.PTR-TOTAL-ADJ-TAX-EX-NOTIONAL.1 ">[FPS80] should equal the sum of [FPS77], [FPS78], and [FPS79].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p278">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F/MTR:ShareOfPartnershipTaxPayed">
        <sch:assert test="not(MTR:ShareOfIncomeTaxTakenOffPartnershipIncome) or MTR:ShareOfTotalTaxTakenOff" id="a_RIM-PARTNERSHIP-SHARE-TAX-PAYED.0" diagnostics="errorCode.RIM-PARTNERSHIP-SHARE-TAX-PAYED.0 transactional.RIM-PARTNERSHIP-SHARE-TAX-PAYED.0 transactional.en.RIM-PARTNERSHIP-SHARE-TAX-PAYED.0 ">[FPS80] should be present if [FPS77] is present</sch:assert>
        <sch:assert test="not(MTR:ShareOfTaxTakenOffByContractors) or MTR:ShareOfTotalTaxTakenOff" id="a_RIM-PARTNERSHIP-SHARE-TAX-PAYED.1" diagnostics="errorCode.RIM-PARTNERSHIP-SHARE-TAX-PAYED.1 transactional.RIM-PARTNERSHIP-SHARE-TAX-PAYED.1 transactional.en.RIM-PARTNERSHIP-SHARE-TAX-PAYED.1 ">[FPS80] should be present if [FPS78] is present</sch:assert>
        <sch:assert test="not(MTR:ShareOfTaxTakenOffTradingIncome) or MTR:ShareOfTotalTaxTakenOff" id="a_RIM-PARTNERSHIP-SHARE-TAX-PAYED.2" diagnostics="errorCode.RIM-PARTNERSHIP-SHARE-TAX-PAYED.2 transactional.RIM-PARTNERSHIP-SHARE-TAX-PAYED.2 transactional.en.RIM-PARTNERSHIP-SHARE-TAX-PAYED.2 ">[FPS80] should be present if [FPS79] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p235">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104F">
        <sch:assert test="not(MTR:ShareOfProfits/MTR:AdjustedProfitForYear or MTR:ShareOfProfits/MTR:LossesBroughtForward) or MTR:ShareOfProfits/MTR:TaxableProfitsAfterLosses" id="a_SA104F.2" diagnostics="errorCode.SA104F.2 transactional.SA104F.2 transactional.en.SA104F.2 ">taxable profits after losses should be present if [FPS16] or [FPS17]</sch:assert>
        <sch:assert test="not(MTR:ShareOfProfits/MTR:TaxableProfitsAfterLosses or MTR:ShareOfProfits/MTR:OtherBusinessIncome) or MTR:ShareOfProfits/MTR:TotalTaxableBusinessProfits" id="a_SA104F.3" diagnostics="errorCode.SA104F.3 transactional.SA104F.3 transactional.en.SA104F.3 ">total taxable business profits should be present if [FPS18] or [FPS19]</sch:assert>
        <sch:assert test="not(MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:UKUntaxedSavingsIncomeShare or MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:UKUntaxedSavingsAdjustment) or MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:AdjustedUKSavingsIncome" id="a_SA104F.4" diagnostics="errorCode.SA104F.4 transactional.SA104F.4 transactional.en.SA104F.4 ">adjusted UK savings income should be present if [FPS28] or [FPS29]</sch:assert>
        <sch:assert test="not(MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:ForeignIncome/MTR:ForeignUntaxedSavingsIncomeShare or MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:ForeignIncome/MTR:ForeignUntaxedSavingsAdjustment or MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:ForeignIncome/MTR:TotalForeignTaxTakenOff) or MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:ForeignIncome/MTR:AdjustedForeignSavingsIncome" id="a_SA104F.5" diagnostics="errorCode.SA104F.5 transactional.SA104F.5 transactional.en.SA104F.5 ">adjusted foreign savings income should be present if [FPS31] or [FPS32] or [FPS33]</sch:assert>
        <sch:assert test="not(MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:AdjustedUKSavingsIncome or MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:ForeignIncome/MTR:AdjustedForeignSavingsIncome) or MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:TotalUntaxedSavingsIncome" id="a_SA104F.6" diagnostics="errorCode.SA104F.6 transactional.SA104F.6 transactional.en.SA104F.6 ">total untaxed savings income  should be present if [FPS30] or [FPS34]</sch:assert>
        <sch:assert test="not(((((sum(MTR:ShareOfUntaxedIncome/MTR:OffshoreFundsIncome/MTR:OffshoreFundsIncomeShare) + sum(MTR:ShareOfUntaxedIncome/MTR:OffshoreFundsIncome/MTR:OffshoreFundsIncomeAdjustment)) - sum(MTR:ShareOfUntaxedIncome/MTR:OffshoreFundsIncome/MTR:ForeignTaxTakenOff))) - (0) &gt;= 0.001)) or MTR:ShareOfUntaxedIncome/MTR:OffshoreFundsIncome/MTR:TaxableIncomeAfterAdjustmentAndForeignTax" id="a_SA104F.9" diagnostics="errorCode.SA104F.9 transactional.SA104F.9 transactional.en.SA104F.9 ">taxable income after adjustment and foreign tax should be present if ( ( [FPS52] plus [FPS53] ) minus [FPS54] ) exceeds 0</sch:assert>
        <sch:assert test="not((((sum(MTR:ShareOfPartnershipIncome/MTR:ShareOfDividendIncome/MTR:DividendIncome) - sum(MTR:ShareOfPartnershipIncome/MTR:ShareOfDividendIncome/MTR:TotalForeignTaxTakenOff))) - (0) &gt;= 0.001)) or MTR:ShareOfPartnershipIncome/MTR:ShareOfDividendIncome/MTR:TotalDividendIncome" id="a_SA104F.13" diagnostics="errorCode.SA104F.13 transactional.SA104F.13 transactional.en.SA104F.13 ">taxed income taxable at 10% should be present if ( [FPS68] minus [FPS69] ) exceeds 0</sch:assert>
        <sch:assert test="not((((sum(MTR:ShareOfPartnershipIncome/MTR:ShareOfTaxedIncomeTaxableAt20Percent/MTR:ShareOfTaxedIncome) - sum(MTR:ShareOfPartnershipIncome/MTR:ShareOfTaxedIncomeTaxableAt20Percent/MTR:TotalForeignTaxTakenOff))) - (0) &gt;= 0.001)) or MTR:ShareOfPartnershipIncome/MTR:ShareOfTaxedIncomeTaxableAt20Percent/MTR:TaxedIncomeTaxableAt20Percent" id="a_SA104F.14" diagnostics="errorCode.SA104F.14 transactional.SA104F.14 transactional.en.SA104F.14 ">taxed income taxable at 20% should be present if ( [FPS71] minus [FPS72] ) exceeds 0</sch:assert>
        <sch:assert test="not(((((sum(MTR:ShareOfProfits/MTR:TotalTaxableBusinessProfits) + sum(MTR:ShareOfUntaxedIncome/MTR:TotalUntaxedIncomeShare) + sum(MTR:ShareOfPartnershipIncome/MTR:ShareOfOtherTaxedIncome/MTR:ShareOfTaxedIncome)) - sum(MTR:ShareOfPartnershipIncome/MTR:ShareOfOtherTaxedIncome/MTR:TotalForeignTaxTakenOff))) - (0) &gt;= 0.001)) or MTR:ShareOfPartnershipIncome/MTR:ShareOfTotalTaxedAndUntaxedIncome" id="a_SA104F.15" diagnostics="errorCode.SA104F.15 transactional.SA104F.15 transactional.en.SA104F.15 ">
share of total taxed and untaxed income should be present if ( ( The sum of [FPS20], [FPS67], and [FPS74] ) minus [FPS75] ) exceeds 0</sch:assert>
        <sch:assert test="not(MTR:ShareOfUntaxedIncome/MTR:UKPropertyIncome/MTR:UKPropertyProfitLossShare or MTR:ShareOfUntaxedIncome/MTR:UKPropertyIncome/MTR:UKPropertyIncomeAdjustment or MTR:ShareOfUntaxedIncome/MTR:UKPropertyIncome/MTR:LossBroughtForward) or MTR:ShareOfUntaxedIncome/MTR:UKPropertyIncome/MTR:TaxableProfitsAfterAdjustmentAndLosses" id="a_SA104F.18" diagnostics="errorCode.SA104F.18 transactional.SA104F.18 transactional.en.SA104F.18 ">taxable profits after adjustment and losses should be present if [FPS36] or [FPS37] or [FPS38]</sch:assert>
        <sch:assert test="not((((sum(MTR:ShareOfUntaxedIncome/MTR:UKPropertyIncome/MTR:TaxableProfitsAfterAdjustmentAndLosses) + sum(MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedUKIncome/MTR:TaxableProfit) + sum(MTR:ShareOfUntaxedIncome/MTR:OffshoreFundsIncome/MTR:TaxableIncomeAfterAdjustmentAndForeignTax) + sum(MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedForeignIncome/MTR:TaxableProfit))) - (0) &gt;= 0.001)) or MTR:ShareOfUntaxedIncome/MTR:TotalUntaxedIncomeShare" id="a_SA104F.0" diagnostics="errorCode.SA104F.0 transactional.SA104F.0 transactional.en.SA104F.0 ">[FPS67] should be present if ( The sum of [FPS41], [FPS48], [FPS55], and [FPS60] ) exceeds 0</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p281">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:PartnershipDetails/MTR:PartnershipReferenceNumber">
        <sch:assert test="(((11 - (((6 * substring((.), 2, 1)) + (7 * substring((.), 3, 1)) + (8 * substring((.), 4, 1)) + (9 * substring((.), 5, 1)) + (10 * substring((.), 6, 1)) + (5 * substring((.), 7, 1)) + (4 * substring((.), 8, 1)) + (3 * substring((.), 9, 1)) + (2 * substring((.), 10, 1))) mod 11)) &gt; 9) and (substring((.), 1, 1) = (11 - (((6 * substring((.), 2, 1)) + (7 * substring((.), 3, 1)) + (8 * substring((.), 4, 1)) + (9 * substring((.), 5, 1)) + (10 * substring((.), 6, 1)) + (5 * substring((.), 7, 1)) + (4 * substring((.), 8, 1)) + (3 * substring((.), 9, 1)) + (2 * substring((.), 10, 1))) mod 11)) - 9))
                or
                (substring((.), 1, 1) = (11 - (((6 * substring((.), 2, 1)) + (7 * substring((.), 3, 1)) + (8 * substring((.), 4, 1)) + (9 * substring((.), 5, 1)) + (10 * substring((.), 6, 1)) + (5 * substring((.), 7, 1)) + (4 * substring((.), 8, 1)) + (3 * substring((.), 9, 1)) + (2 * substring((.), 10, 1))) mod 11)))" id="a_SPS-PARTNERSHIP-REF-NUMBER.0" diagnostics="errorCode.SPS-PARTNERSHIP-REF-NUMBER.0 transactional.SPS-PARTNERSHIP-REF-NUMBER.0 transactional.en.SPS-PARTNERSHIP-REF-NUMBER.0 ">Must be valid against the UTR algorithm</sch:assert>
        <sch:assert test="(&apos;1111111111&apos; != (.)) 
                and
              (&apos;2222222222&apos; != (.)) 
                and
              (&apos;3333333333&apos; != (.)) 
                and
              (&apos;4444444444&apos; != (.)) 
                and
              (&apos;5555555555&apos; != (.)) 
                and
              (&apos;6666666666&apos; != (.)) 
                and
              (&apos;7777777777&apos; != (.)) 
                and
              (&apos;8888888888&apos; != (.)) 
                and
              (&apos;9999999999&apos; != (.))" id="a_SPS-PARTNERSHIP-REF-NUMBER.1" diagnostics="errorCode.SPS-PARTNERSHIP-REF-NUMBER.1 transactional.SPS-PARTNERSHIP-REF-NUMBER.1 transactional.en.SPS-PARTNERSHIP-REF-NUMBER.1 ">Must not be 1111111111, 2222222222, 3333333333, 4444444444, 5555555555, 6666666666, 7777777777, 8888888888, or 9999999999.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p282">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:PartnershipDetails/MTR:DidYouJoinThePartnership">
        <sch:assert test="not((.) = &apos;yes&apos;) or ../MTR:DateJoinedPartnership" id="a_SPS-BUSINESS-JOIN-QUES.0" diagnostics="errorCode.SPS-BUSINESS-JOIN-QUES.0 transactional.SPS-BUSINESS-JOIN-QUES.0 transactional.en.SPS-BUSINESS-JOIN-QUES.0 ">[SPS3] should be present if [SPS3Q] equals 'yes'</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p283">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:PartnershipDetails/MTR:DateJoinedPartnership">
        <sch:assert test="(round(date:seconds(normalize-space(concat(2025, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))
                  and
                (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2026, &quot;-04-05&quot;))) div 86400))" id="a_SPS-STARTED-AS-PARTNER-DATE.1" diagnostics="errorCode.SPS-STARTED-AS-PARTNER-DATE.1 transactional.SPS-STARTED-AS-PARTNER-DATE.1 transactional.en.SPS-STARTED-AS-PARTNER-DATE.1 ">[SPS3] should be within the current return year</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p284">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:PartnershipDetails/MTR:DidYouLeaveThePartnership">
        <sch:assert test="not((.) = &apos;yes&apos;) or ../MTR:DateLeftPartnership" id="a_SPS-BUSINESS-LEAVE-QUES.0" diagnostics="errorCode.SPS-BUSINESS-LEAVE-QUES.0 transactional.SPS-BUSINESS-LEAVE-QUES.0 transactional.en.SPS-BUSINESS-LEAVE-QUES.0 ">[SPS4] should be present if [SPS4Q] equals 'yes'</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p285">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:PartnershipDetails/MTR:DateLeftPartnership">
        <sch:assert test="(round(date:seconds(normalize-space(concat(2025, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))
                  and
                (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2026, &quot;-04-05&quot;))) div 86400))" id="a_SPS-DATE-CEASED-AS-PARTNER.1" diagnostics="errorCode.SPS-DATE-CEASED-AS-PARTNER.1 transactional.SPS-DATE-CEASED-AS-PARTNER.1 transactional.en.SPS-DATE-CEASED-AS-PARTNER.1 ">[SPS4] should be within the current return year</sch:assert>
        <sch:assert test="not(../MTR:DateJoinedPartnership) or translate((.),&apos;-&apos;,&apos;&apos;) &gt;= translate(../MTR:DateJoinedPartnership,&apos;-&apos;,&apos;&apos;)" id="a_SPS-DATE-CEASED-AS-PARTNER.2" diagnostics="errorCode.SPS-DATE-CEASED-AS-PARTNER.2 transactional.SPS-DATE-CEASED-AS-PARTNER.2 transactional.en.SPS-DATE-CEASED-AS-PARTNER.2 ">If both [SPS3] and [SPS4] present then [SPS4] must be same as or later than [SPS3]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p287">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:LossesBroughtForward">
        <sch:assert test=". &lt;= sum(../MTR:AdjustedProfitForYear)" id="a_SPS-LOSSES-USED-THIS-YR.1" diagnostics="errorCode.SPS-LOSSES-USED-THIS-YR.1 transactional.SPS-LOSSES-USED-THIS-YR.1 transactional.en.SPS-LOSSES-USED-THIS-YR.1 ">[SPS17] should not exceed [SPS16]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p288">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:TaxableProfitsAfterLosses">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:AdjustedProfitForYear) - sum(../MTR:LossesBroughtForward)))) &lt; 0.001)" id="a_SPS-PROFIT-AFTER-LOSSES.1" diagnostics="errorCode.SPS-PROFIT-AFTER-LOSSES.1 transactional.SPS-PROFIT-AFTER-LOSSES.1 transactional.en.SPS-PROFIT-AFTER-LOSSES.1 ">[SPS18] should equal ( [SPS16] minus [SPS17] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p289">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:TotalTaxableBusinessProfits">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:TaxableProfitsAfterLosses) + sum(../MTR:OtherBusinessIncome)))) &lt; 0.001)" id="a_SPS-TOTAL-TAXABLE-PROFITS.1" diagnostics="errorCode.SPS-TOTAL-TAXABLE-PROFITS.1 transactional.SPS-TOTAL-TAXABLE-PROFITS.1 transactional.en.SPS-TOTAL-TAXABLE-PROFITS.1 ">[SPS20] should equal ( [SPS18] plus [SPS19] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p286">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalProfits">
        <sch:assert test="(((sum(MTR:ShareOfPartnershipProfitOrLoss) + sum(MTR:TaxYearAdjustment) - sum(MTR:ForeignTaxClaimedAsDeduction))) - (0) &lt; 0.001)
                or
              (MTR:AdjustedProfitForYear and (math:abs(((sum(MTR:ShareOfPartnershipProfitOrLoss) + sum(MTR:TaxYearAdjustment) - sum(MTR:ForeignTaxClaimedAsDeduction)) + sum(MTR:ChangeOfAccountingPracticeAdjustment) + sum(MTR:AveragingAdjustment)) - (sum(MTR:AdjustedProfitForYear))) &lt; 0.001))" id="a_RIM-PARTNERSHIP-PROFITS.0" diagnostics="errorCode.RIM-PARTNERSHIP-PROFITS.0 transactional.RIM-PARTNERSHIP-PROFITS.0 transactional.en.RIM-PARTNERSHIP-PROFITS.0 ">If (([SPS8] + [SPS9]) - [SPS12]) is greater than zero, then [SPS16] is mandatory and = (([SPS8] + [SPS9]) - [SPS12] + [SPS10] +  [SPS11])</sch:assert>
        <sch:assert test="(((sum(MTR:ShareOfPartnershipProfitOrLoss) + sum(MTR:TaxYearAdjustment) - sum(MTR:ForeignTaxClaimedAsDeduction))) - (0) &gt;= 0.001)
              or
            ( (((sum(MTR:ChangeOfAccountingPracticeAdjustment) + sum(MTR:AveragingAdjustment))) - (0) &gt;= 0.001) and (MTR:AdjustedProfitForYear and (math:abs(((sum(MTR:ChangeOfAccountingPracticeAdjustment) + sum(MTR:AveragingAdjustment))) - (sum(MTR:AdjustedProfitForYear))) &lt; 0.001)) )
              or
            ( (((sum(MTR:ChangeOfAccountingPracticeAdjustment) + sum(MTR:AveragingAdjustment))) - (0) &lt; 0.001) and ((math:abs((0) - (sum(MTR:AdjustedProfitForYear))) &lt; 0.001)) )" id="a_RIM-PARTNERSHIP-PROFITS.1" diagnostics="errorCode.RIM-PARTNERSHIP-PROFITS.1 transactional.RIM-PARTNERSHIP-PROFITS.1 transactional.en.RIM-PARTNERSHIP-PROFITS.1 ">If (([SPS8] + [SPS9]) minus [SPS12]) is less than or equal to zero, then if ([SPS10] + [SPS11]) is greater than zero, then [SPS16] is mandatory and equals ([SPS10] + [SPS11]); else [SPS16] must be zero or absent.</sch:assert>
        <sch:assert test="not((((sum(MTR:ShareOfPartnershipProfitOrLoss) + sum(MTR:TaxYearAdjustment) - sum(MTR:ForeignTaxClaimedAsDeduction))) - (0) &lt;= -0.001))
            or
          (math:abs((math:abs((sum(MTR:ShareOfPartnershipProfitOrLoss) + sum(MTR:TaxYearAdjustment) - sum(MTR:ForeignTaxClaimedAsDeduction)))) - (sum(../MTR:ShareOfPartnershipTradingOrProfessionalLosses/MTR:AdjustedLossForYear))) &lt; 0.001)" id="a_RIM-PARTNERSHIP-PROFITS.2" diagnostics="errorCode.RIM-PARTNERSHIP-PROFITS.2 transactional.RIM-PARTNERSHIP-PROFITS.2 transactional.en.RIM-PARTNERSHIP-PROFITS.2 ">If (([SPS8] + [SPS9]) - [SPS12]) is less than zero, then [SPS21] is mandatory and = positive equivalent of (([SPS8] + [SPS9]) - [SPS12])</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p290">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalLosses/MTR:AdjustedLossForYear">
        <sch:assert test="(((sum(../../MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:ShareOfPartnershipProfitOrLoss) + sum(../../MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:TaxYearAdjustment) - sum(../../MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:ForeignTaxClaimedAsDeduction))) - (0) &lt;= -0.001)
            or
          (math:abs((0) - ((.))) &lt; 0.001)" id="a_RIM-PARTNERSHIP-PROFITS.3" diagnostics="errorCode.RIM-PARTNERSHIP-PROFITS.3 transactional.RIM-PARTNERSHIP-PROFITS.3 transactional.en.RIM-PARTNERSHIP-PROFITS.3 ">If (([SPS8] + [SPS9]) - [SPS12]) is greater than or equal to zero, then [SPS21] must be equal to zero or is absent</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p291">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalLosses/MTR:LossSetOffAgainstOtherIncome">
        <sch:assert test=". &lt;= sum(../MTR:AdjustedLossForYear)" id="a_SPS-LOSS-TO-SET-OFF-OTHER-INC.0" diagnostics="errorCode.SPS-LOSS-TO-SET-OFF-OTHER-INC.0 transactional.SPS-LOSS-TO-SET-OFF-OTHER-INC.0 transactional.en.SPS-LOSS-TO-SET-OFF-OTHER-INC.0 ">[SPS22] should not exceed [SPS21]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p292">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalLosses/MTR:LossToBeCarriedBack">
        <sch:assert test="((.) - ((sum(../MTR:AdjustedLossForYear) - sum(../MTR:LossSetOffAgainstOtherIncome))) &lt; 0.001)" id="a_SPS-LOSS-TO-CARRY-BACK.0" diagnostics="errorCode.SPS-LOSS-TO-CARRY-BACK.0 transactional.SPS-LOSS-TO-CARRY-BACK.0 transactional.en.SPS-LOSS-TO-CARRY-BACK.0 ">[SPS23] should not exceed ( [SPS21] minus [SPS22] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p294">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:NICs/MTR:PayClass2NICvoluntarily">
        <sch:assert test="../MTR:Class2NICamount" id="a_SPS-CLASS-2-NIC-VOLUNTARY-SIG.0" diagnostics="errorCode.SPS-CLASS-2-NIC-VOLUNTARY-SIG.0 transactional.SPS-CLASS-2-NIC-VOLUNTARY-SIG.0 transactional.en.SPS-CLASS-2-NIC-VOLUNTARY-SIG.0 ">[SPSCL2] should be present if [SPS25] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p295">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:NICs/MTR:Class2NICamount">
        <sch:assert test=". &lt;= 219.95" id="a_SPS-CLASS-2-NIC-AMOUNT.0" diagnostics="errorCode.SPS-CLASS-2-NIC-AMOUNT.0 transactional.SPS-CLASS-2-NIC-AMOUNT.0 transactional.en.SPS-CLASS-2-NIC-AMOUNT.0 ">[SPSCL2] is valid only if this does not exceed [£219.95]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p293">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S/MTR:NICs">
        <sch:assert test="MTR:PayClass2NICvoluntarily or MTR:Class2NICamount or MTR:Class4NICexempt or MTR:AdjustmentToClass4NICProfits" id="a_RIM-CLASS-4-NICS-CONTRIBUTIONS.0" diagnostics="errorCode.RIM-CLASS-4-NICS-CONTRIBUTIONS.0 transactional.RIM-CLASS-4-NICS-CONTRIBUTIONS.0 transactional.en.RIM-CLASS-4-NICS-CONTRIBUTIONS.0 ">If [SPS25-27] is present then at least one of the following should be present: [SPS25], [SPSCL2], [SPS26] or [SPS27]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p280">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA104S">
        <sch:assert test="not((((sum(MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:AdjustedProfitForYear) - sum(MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:LossesBroughtForward))) - (0) &gt;= 0.001)) or MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:TaxableProfitsAfterLosses" id="a_SA104S.0" diagnostics="errorCode.SA104S.0 transactional.SA104S.0 transactional.en.SA104S.0 ">taxable profits after losses should be present if ( [SPS16] minus [SPS17] ) exceeds 0</sch:assert>
        <sch:assert test="not(MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:TaxableProfitsAfterLosses or MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:OtherBusinessIncome) or MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:TotalTaxableBusinessProfits" id="a_SA104S.1" diagnostics="errorCode.SA104S.1 transactional.SA104S.1 transactional.en.SA104S.1 ">total taxable business profits should be present if [SPS18] or [SPS19]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p297">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance">
        <sch:assert test="((.) - (sum(../MTR:TotalRentsAndOtherIncomeFromProperty) + sum(../MTR:PremiumsForGrantOfALease) + sum(../MTR:ReversePremiumsAndInducements) + sum(../../MTR:TaxableProfitOrLoss/MTR:BalancingCharges)) &lt; 0.001)" id="a_UKL-PPTY-INCOME-ALLCE.1" diagnostics="errorCode.UKL-PPTY-INCOME-ALLCE.1 transactional.UKL-PPTY-INCOME-ALLCE.1 transactional.en.UKL-PPTY-INCOME-ALLCE.1 ">[PRO20.1] must not exceed the sum of [PRO20], [PRO22], [PRO23] and [PRO31].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p298">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:RentRatesInsuranceAndGroundRents">
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_UKL-PPTY-RENT-RATES.0" diagnostics="errorCode.UKL-PPTY-RENT-RATES.0 transactional.UKL-PPTY-RENT-RATES.0 transactional.en.UKL-PPTY-RENT-RATES.0 ">[PRO24] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p299">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:RepairsAndMaintenance">
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_UKL-PPTY-REPAIRS-RENEWALS.0" diagnostics="errorCode.UKL-PPTY-REPAIRS-RENEWALS.0 transactional.UKL-PPTY-REPAIRS-RENEWALS.0 transactional.en.UKL-PPTY-REPAIRS-RENEWALS.0 ">[PRO25] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p300">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:AllowableInterestAndOtherFinancialCharges">
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_UKL-PPTY-FINANCE-CHARGES.0" diagnostics="errorCode.UKL-PPTY-FINANCE-CHARGES.0 transactional.UKL-PPTY-FINANCE-CHARGES.0 transactional.en.UKL-PPTY-FINANCE-CHARGES.0 ">[PRO26] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p301">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:LegalManagementAndProfessionalFees">
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_UKL-PPTY-LEGAL-CHARGES.0" diagnostics="errorCode.UKL-PPTY-LEGAL-CHARGES.0 transactional.UKL-PPTY-LEGAL-CHARGES.0 transactional.en.UKL-PPTY-LEGAL-CHARGES.0 ">[PRO27] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p302">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:CostsOfServicesProvided">
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_UKL-PPTY-SERVICE-COSTS.0" diagnostics="errorCode.UKL-PPTY-SERVICE-COSTS.0 transactional.UKL-PPTY-SERVICE-COSTS.0 transactional.en.UKL-PPTY-SERVICE-COSTS.0 ">[PRO28] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p303">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:OtherPropertyExpenses">
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_UKL-PPTY-OTHER-DEDUCTIONS.0" diagnostics="errorCode.UKL-PPTY-OTHER-DEDUCTIONS.0 transactional.UKL-PPTY-OTHER-DEDUCTIONS.0 transactional.en.UKL-PPTY-OTHER-DEDUCTIONS.0 ">[PRO29] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p304">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:PrivateUseAdjustment">
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_UKL-PPTY-PRIVATE-USE-ADJUST.0" diagnostics="errorCode.UKL-PPTY-PRIVATE-USE-ADJUST.0 transactional.UKL-PPTY-PRIVATE-USE-ADJUST.0 transactional.en.UKL-PPTY-PRIVATE-USE-ADJUST.0 ">[PRO30] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p305">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:AnnualInvestmentAllowance">
        <sch:assert test=". &lt;= 1000000" id="a_UKL-PPTY-CAPITAL-ALLOWANCES.0" diagnostics="errorCode.UKL-PPTY-CAPITAL-ALLOWANCES.0 transactional.UKL-PPTY-CAPITAL-ALLOWANCES.0 transactional.en.UKL-PPTY-CAPITAL-ALLOWANCES.0 ">[PRO32] should not exceed [£1,000,000]</sch:assert>
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_UKL-PPTY-CAPITAL-ALLOWANCES.1" diagnostics="errorCode.UKL-PPTY-CAPITAL-ALLOWANCES.1 transactional.UKL-PPTY-CAPITAL-ALLOWANCES.1 transactional.en.UKL-PPTY-CAPITAL-ALLOWANCES.1 ">[PRO32] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
        <sch:assert test="../../MTR:PropertyIncomeAndExpenses/MTR:TraditionalAccounting" id="a_UKL-PPTY-CAPITAL-ALLOWANCES.2" diagnostics="errorCode.UKL-PPTY-CAPITAL-ALLOWANCES.2 transactional.UKL-PPTY-CAPITAL-ALLOWANCES.2 transactional.en.UKL-PPTY-CAPITAL-ALLOWANCES.2 ">[PRO32] should not be present if [PRO20.2] is absent</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p306">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:TheStructuresAndBuildingsAllowance">
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_UKL-PPTY-SB-ALLCE.0" diagnostics="errorCode.UKL-PPTY-SB-ALLCE.0 transactional.UKL-PPTY-SB-ALLCE.0 transactional.en.UKL-PPTY-SB-ALLCE.0 ">[PRO33] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p307">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:ElectricChargePointAllowance">
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_UKL-PPTY-ECP-ALLCE.0" diagnostics="errorCode.UKL-PPTY-ECP-ALLCE.0 transactional.UKL-PPTY-ECP-ALLCE.0 transactional.en.UKL-PPTY-ECP-ALLCE.0 ">[PRO33.1] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p308">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:FreeportAndInvestmentZonesStructuresAndBuildingsAllowance">
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_UKL-PPTY-FREEPORT-SB-ALLCE.0" diagnostics="errorCode.UKL-PPTY-FREEPORT-SB-ALLCE.0 transactional.UKL-PPTY-FREEPORT-SB-ALLCE.0 transactional.en.UKL-PPTY-FREEPORT-SB-ALLCE.0 ">[PRO33.2] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p309">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:ZeroEmissionCarAllowance">
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_UKL-P-ZERO-EMISSION-CAR-ALLCE.0" diagnostics="errorCode.UKL-P-ZERO-EMISSION-CAR-ALLCE.0 transactional.UKL-P-ZERO-EMISSION-CAR-ALLCE.0 transactional.en.UKL-P-ZERO-EMISSION-CAR-ALLCE.0 ">[PRO34.1] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p310">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:EnhancedCapitalAllowances">
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_UKL-ENH-CAPITAL-ALLCES-AMT.0" diagnostics="errorCode.UKL-ENH-CAPITAL-ALLCES-AMT.0 transactional.UKL-ENH-CAPITAL-ALLCES-AMT.0 transactional.en.UKL-ENH-CAPITAL-ALLCES-AMT.0 ">[PRO35] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p311">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:CostsOfReplacingDomesticItems">
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_UKL-PPTY-WEAR-AND-TEAR.0" diagnostics="errorCode.UKL-PPTY-WEAR-AND-TEAR.0 transactional.UKL-PPTY-WEAR-AND-TEAR.0 transactional.en.UKL-PPTY-WEAR-AND-TEAR.0 ">[PRO36] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p312">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:RentARoomExemptAmount">
        <sch:assert test="not(../../MTR:UKPropertyDetails/MTR:RentARoomReliefClaim)" id="a_UKL-RENT-ROOM-EXEMPT-AMOUNT.1" diagnostics="errorCode.UKL-RENT-ROOM-EXEMPT-AMOUNT.1 transactional.UKL-RENT-ROOM-EXEMPT-AMOUNT.1 transactional.en.UKL-RENT-ROOM-EXEMPT-AMOUNT.1 ">If present [PRO4] must be absent</sch:assert>
        <sch:assert test=". &lt;= 7500" id="a_UKL-RENT-ROOM-EXEMPT-AMOUNT.2" diagnostics="errorCode.UKL-RENT-ROOM-EXEMPT-AMOUNT.2 transactional.UKL-RENT-ROOM-EXEMPT-AMOUNT.2 transactional.en.UKL-RENT-ROOM-EXEMPT-AMOUNT.2 ">[PRO37] is valid if and only if this does not exceed [£7,500]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p313">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:AdjustedProfitForTheYear">
        <sch:assert test="(math:abs(((.)) - (((sum(../../MTR:PropertyIncomeAndExpenses/MTR:TotalRentsAndOtherIncomeFromProperty) 
		      + sum(../../MTR:PropertyIncomeAndExpenses/MTR:PremiumsForGrantOfALease) 
		      + sum(../../MTR:PropertyIncomeAndExpenses/MTR:ReversePremiumsAndInducements) 
		      + sum(../MTR:PrivateUseAdjustment) 
		      + sum(../MTR:BalancingCharges)) 
		      - 
		      (sum(../../MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) 
		      + sum(../../MTR:PropertyIncomeAndExpenses/MTR:RentRatesInsuranceAndGroundRents) 
		      + sum(../../MTR:PropertyIncomeAndExpenses/MTR:RepairsAndMaintenance) 
		      + sum(../../MTR:PropertyIncomeAndExpenses/MTR:AllowableInterestAndOtherFinancialCharges) 
		      + sum(../../MTR:PropertyIncomeAndExpenses/MTR:LegalManagementAndProfessionalFees) 
		      + sum(../../MTR:PropertyIncomeAndExpenses/MTR:CostsOfServicesProvided) 
		      + sum(../../MTR:PropertyIncomeAndExpenses/MTR:OtherPropertyExpenses) 
		      + sum(../MTR:AnnualInvestmentAllowance) 
		      + sum(../MTR:TheStructuresAndBuildingsAllowance) 
		      + sum(../MTR:ElectricChargePointAllowance) 
		      + sum(../MTR:FreeportAndInvestmentZonesStructuresAndBuildingsAllowance) 
		      + sum(../MTR:ZeroEmissionCarAllowance) 
		      + sum(../MTR:EnhancedCapitalAllowances) 
		      + sum(../MTR:CostsOfReplacingDomesticItems) 
		      + sum(../MTR:RentARoomExemptAmount))))) &lt; 0.001)" id="a_UKL-ADJUSTED-PROFIT-4-YEAR-AMT.0" diagnostics="errorCode.UKL-ADJUSTED-PROFIT-4-YEAR-AMT.0 transactional.UKL-ADJUSTED-PROFIT-4-YEAR-AMT.0 transactional.en.UKL-ADJUSTED-PROFIT-4-YEAR-AMT.0 ">If [PRO38] is present the following should be true: [PRO38] equals ( ( The sum of [PRO20], [PRO22], [PRO23], [PRO30], and [PRO31] ) minus ( The sum of [PRO20.1], [PRO24], [PRO25], [PRO26], [PRO27], [PRO28], [PRO29], [PRO32], [PRO33], [PRO33.1], [PRO33.2], [PRO34.1], [PRO35], [PRO36], and [PRO37] ) )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p314">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:LossBroughtForward">
        <sch:assert test=". &lt;= sum(../MTR:AdjustedProfitForTheYear)" id="a_UKL-PPTY-LOSS-BROUGHT-FWD.0" diagnostics="errorCode.UKL-PPTY-LOSS-BROUGHT-FWD.0 transactional.UKL-PPTY-LOSS-BROUGHT-FWD.0 transactional.en.UKL-PPTY-LOSS-BROUGHT-FWD.0 ">[PRO39] should not exceed [PRO38]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p315">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:TaxableProfitForTheYear">
        <sch:assert test="(math:abs((.) - ((sum(../MTR:AdjustedProfitForTheYear) - sum(../MTR:LossBroughtForward)))) &lt; 0.001)" id="a_UKL-TAXABLE-PROFIT-FOR-YR-AMT.1" diagnostics="errorCode.UKL-TAXABLE-PROFIT-FOR-YR-AMT.1 transactional.UKL-TAXABLE-PROFIT-FOR-YR-AMT.1 transactional.en.UKL-TAXABLE-PROFIT-FOR-YR-AMT.1 ">[PRO40] should equal ( [PRO38] minus [PRO39] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p316">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:AdjustedLossForTheYear">
        <sch:assert test="not(../../MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance)" id="a_UKL-ADJUSTED-LOSS-AMT.0" diagnostics="errorCode.UKL-ADJUSTED-LOSS-AMT.0 transactional.UKL-ADJUSTED-LOSS-AMT.0 transactional.en.UKL-ADJUSTED-LOSS-AMT.0 ">[PRO41] should not be present if [PRO20.1] is present.</sch:assert>
        <sch:assert test="(math:abs(((.)) - (((sum(../../MTR:PropertyIncomeAndExpenses/MTR:RentRatesInsuranceAndGroundRents) 
		      + sum(../../MTR:PropertyIncomeAndExpenses/MTR:RepairsAndMaintenance) 
		      + sum(../../MTR:PropertyIncomeAndExpenses/MTR:AllowableInterestAndOtherFinancialCharges) 
		      + sum(../../MTR:PropertyIncomeAndExpenses/MTR:LegalManagementAndProfessionalFees) 
		      + sum(../../MTR:PropertyIncomeAndExpenses/MTR:CostsOfServicesProvided) 
		      + sum(../../MTR:PropertyIncomeAndExpenses/MTR:OtherPropertyExpenses) 
		      + sum(../MTR:AnnualInvestmentAllowance) 
		      + sum(../MTR:TheStructuresAndBuildingsAllowance) 
		      + sum(../MTR:ElectricChargePointAllowance) 
		      + sum(../MTR:FreeportAndInvestmentZonesStructuresAndBuildingsAllowance) 
		      + sum(../MTR:ZeroEmissionCarAllowance) 
		      + sum(../MTR:EnhancedCapitalAllowances) 
		      + sum(../MTR:CostsOfReplacingDomesticItems) 
		      + sum(../MTR:RentARoomExemptAmount)) 
		      - 
		      (sum(../../MTR:PropertyIncomeAndExpenses/MTR:TotalRentsAndOtherIncomeFromProperty) 
		      + sum(../../MTR:PropertyIncomeAndExpenses/MTR:PremiumsForGrantOfALease) 
		      + sum(../../MTR:PropertyIncomeAndExpenses/MTR:ReversePremiumsAndInducements) 
		      + sum(../MTR:PrivateUseAdjustment) 
		      + sum(../MTR:BalancingCharges))))) &lt; 0.001)" id="a_UKL-ADJUSTED-LOSS-AMT.1" diagnostics="errorCode.UKL-ADJUSTED-LOSS-AMT.1 transactional.UKL-ADJUSTED-LOSS-AMT.1 transactional.en.UKL-ADJUSTED-LOSS-AMT.1 ">If [PRO41] is present the following should be true: [PRO41] equals ( ( The sum of [PRO24], [PRO25], [PRO26], [PRO27], [PRO28], [PRO29], [PRO32], [PRO33], [PRO33.1], [PRO33.2], [PRO34.1], [PRO35], [PRO36], and [PRO37] ) minus ( The sum of [PRO20], [PRO22], [PRO23], [PRO30], and [PRO31] ) )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p317">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:LossSetOffAgainstTotalIncomeOfTheYear">
        <sch:assert test="not(../../MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance)" id="a_UKL-PPTY-LOSS-OFFSET-INCOME.0" diagnostics="errorCode.UKL-PPTY-LOSS-OFFSET-INCOME.0 transactional.UKL-PPTY-LOSS-OFFSET-INCOME.0 transactional.en.UKL-PPTY-LOSS-OFFSET-INCOME.0 ">[PRO42] should not be present if [PRO20.1] is present.</sch:assert>
        <sch:assert test="../../MTR:PropertyIncomeAndExpenses/MTR:TraditionalAccounting" id="a_UKL-PPTY-LOSS-OFFSET-INCOME.1" diagnostics="errorCode.UKL-PPTY-LOSS-OFFSET-INCOME.1 transactional.UKL-PPTY-LOSS-OFFSET-INCOME.1 transactional.en.UKL-PPTY-LOSS-OFFSET-INCOME.1 ">[PRO42] should not be present if [PRO20.2] is absent</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p318">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:ResidentialFinanceCosts">
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_UKL-PPTY-RES-FIN-COSTS.2" diagnostics="errorCode.UKL-PPTY-RES-FIN-COSTS.2 transactional.UKL-PPTY-RES-FIN-COSTS.2 transactional.en.UKL-PPTY-RES-FIN-COSTS.2 ">[PRO44] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p319">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105/MTR:TaxableProfitOrLoss/MTR:UnusedResidentialFinanceCostsBroughtForward">
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_UKL-PPTY-RES-FIN-COSTS-BF.0" diagnostics="errorCode.UKL-PPTY-RES-FIN-COSTS-BF.0 transactional.UKL-PPTY-RES-FIN-COSTS-BF.0 transactional.en.UKL-PPTY-RES-FIN-COSTS-BF.0 ">[PRO45] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p296">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA105">
        <sch:assert test="not((((sum(MTR:TaxableProfitOrLoss/MTR:AdjustedProfitForTheYear) - sum(MTR:TaxableProfitOrLoss/MTR:LossBroughtForward))) - (0) &gt;= 0.001)) or MTR:TaxableProfitOrLoss/MTR:TaxableProfitForTheYear" id="a_SA105.2" diagnostics="errorCode.SA105.2 transactional.SA105.2 transactional.en.SA105.2 ">taxable profit for the year should be present if ( [PRO38] minus [PRO39] ) exceeds 0</sch:assert>
        <sch:assert test="MTR:PropertyIncomeAndExpenses/MTR:TraditionalAccounting
	    or ((sum(MTR:PropertyIncomeAndExpenses/MTR:TotalRentsAndOtherIncomeFromProperty) + sum(MTR:PropertyIncomeAndExpenses/MTR:PremiumsForGrantOfALease) + sum(MTR:PropertyIncomeAndExpenses/MTR:ReversePremiumsAndInducements) + sum(MTR:TaxableProfitOrLoss/MTR:BalancingCharges)) - (150000) &lt; 0.001)" id="a_SA105.6" diagnostics="errorCode.SA105.6 transactional.SA105.6 transactional.en.SA105.6 ">Total of ( [PRO20], [PRO22], [PRO23] and [PRO31] ) must not exceed [£150,000] if [PRO20.2] is absent.</sch:assert>
        <sch:assert test="not(((((sum(MTR:PropertyIncomeAndExpenses/MTR:TotalRentsAndOtherIncomeFromProperty) 
		  + sum(MTR:PropertyIncomeAndExpenses/MTR:PremiumsForGrantOfALease) 
		  + sum(MTR:PropertyIncomeAndExpenses/MTR:ReversePremiumsAndInducements) 
		  + sum(MTR:TaxableProfitOrLoss/MTR:PrivateUseAdjustment) 
		  + sum(MTR:TaxableProfitOrLoss/MTR:BalancingCharges)) 
		  - 
		  (sum(MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) 
		  + sum(MTR:PropertyIncomeAndExpenses/MTR:RentRatesInsuranceAndGroundRents) 
		  + sum(MTR:PropertyIncomeAndExpenses/MTR:RepairsAndMaintenance) 
		  + sum(MTR:PropertyIncomeAndExpenses/MTR:AllowableInterestAndOtherFinancialCharges) 
		  + sum(MTR:PropertyIncomeAndExpenses/MTR:LegalManagementAndProfessionalFees) 
		  + sum(MTR:PropertyIncomeAndExpenses/MTR:CostsOfServicesProvided) 
		  + sum(MTR:PropertyIncomeAndExpenses/MTR:OtherPropertyExpenses) 
		  + sum(MTR:TaxableProfitOrLoss/MTR:AnnualInvestmentAllowance) 
		  + sum(MTR:TaxableProfitOrLoss/MTR:TheStructuresAndBuildingsAllowance) 
		  + sum(MTR:TaxableProfitOrLoss/MTR:ElectricChargePointAllowance) 
		  + sum(MTR:TaxableProfitOrLoss/MTR:FreeportAndInvestmentZonesStructuresAndBuildingsAllowance) 
		  + sum(MTR:TaxableProfitOrLoss/MTR:ZeroEmissionCarAllowance) 
		  + sum(MTR:TaxableProfitOrLoss/MTR:EnhancedCapitalAllowances) 
		  + sum(MTR:TaxableProfitOrLoss/MTR:CostsOfReplacingDomesticItems) 
		  + sum(MTR:TaxableProfitOrLoss/MTR:RentARoomExemptAmount)))) - (0) &gt;= 0.001)) 
		  or 
		  MTR:TaxableProfitOrLoss/MTR:AdjustedProfitForTheYear" id="a_SA105.0" diagnostics="errorCode.SA105.0 transactional.SA105.0 transactional.en.SA105.0 ">[PRO38] should be present if ( ( The sum of [PRO20], [PRO22], [PRO23], [PRO30], and [PRO31] ) minus ( The sum of [PRO20.1], [PRO24], [PRO25], [PRO26], [PRO27], [PRO28], [PRO29], [PRO32], [PRO33], [PRO33.1], [PRO33.2], [PRO34.1], [PRO35], [PRO36], and [PRO37] ) ) exceeds 0</sch:assert>
        <sch:assert test="not(((((sum(MTR:PropertyIncomeAndExpenses/MTR:RentRatesInsuranceAndGroundRents) 
		  + sum(MTR:PropertyIncomeAndExpenses/MTR:RepairsAndMaintenance) 
		  + sum(MTR:PropertyIncomeAndExpenses/MTR:AllowableInterestAndOtherFinancialCharges) 
		  + sum(MTR:PropertyIncomeAndExpenses/MTR:LegalManagementAndProfessionalFees) 
		  + sum(MTR:PropertyIncomeAndExpenses/MTR:CostsOfServicesProvided) 
		  + sum(MTR:PropertyIncomeAndExpenses/MTR:OtherPropertyExpenses) 
		  + sum(MTR:TaxableProfitOrLoss/MTR:AnnualInvestmentAllowance) 
		  + sum(MTR:TaxableProfitOrLoss/MTR:TheStructuresAndBuildingsAllowance) 
		  + sum(MTR:TaxableProfitOrLoss/MTR:ElectricChargePointAllowance) 
		  + sum(MTR:TaxableProfitOrLoss/MTR:FreeportAndInvestmentZonesStructuresAndBuildingsAllowance) 
		  + sum(MTR:TaxableProfitOrLoss/MTR:ZeroEmissionCarAllowance) 
		  + sum(MTR:TaxableProfitOrLoss/MTR:EnhancedCapitalAllowances) 
		  + sum(MTR:TaxableProfitOrLoss/MTR:CostsOfReplacingDomesticItems) 
		  + sum(MTR:TaxableProfitOrLoss/MTR:RentARoomExemptAmount)) 
		  - 
		  (sum(MTR:PropertyIncomeAndExpenses/MTR:TotalRentsAndOtherIncomeFromProperty) 
		  + sum(MTR:PropertyIncomeAndExpenses/MTR:PremiumsForGrantOfALease) 
		  + sum(MTR:PropertyIncomeAndExpenses/MTR:ReversePremiumsAndInducements) 
		  + sum(MTR:TaxableProfitOrLoss/MTR:PrivateUseAdjustment) 
		  + sum(MTR:TaxableProfitOrLoss/MTR:BalancingCharges)))) - (0) &gt;= 0.001)) 
		  or 
		  MTR:TaxableProfitOrLoss/MTR:AdjustedLossForTheYear" id="a_SA105.1" diagnostics="errorCode.SA105.1 transactional.SA105.1 transactional.en.SA105.1 ">[PRO41] should be present if ( ( The sum of [PRO24], [PRO25], [PRO26], [PRO27], [PRO28], [PRO29], [PRO32], [PRO33], [PRO33.1], [PRO33.2], [PRO34.1], [PRO35], [PRO36], and [PRO37] ) minus ( The sum of [PRO20], [PRO22], [PRO23], [PRO30], and [PRO31] ) ) exceeds 0</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p322">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasSavings/MTR:IncomeSource/MTR:IncomeBeforeTax">
        <sch:assert test="../MTR:TaxableAmountOnInterestAndOtherSavings" id="a_FIG4-OTHR-FI-SAV-GROSS-INC-AMO.1" diagnostics="errorCode.FIG4-OTHR-FI-SAV-GROSS-INC-AMO.1 transactional.FIG4-OTHR-FI-SAV-GROSS-INC-AMO.1 transactional.en.FIG4-OTHR-FI-SAV-GROSS-INC-AMO.1 ">[FOR4F] must be present if [FOR4B] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p323">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasSavings/MTR:IncomeSource/MTR:ForeignTax">
        <sch:assert test=". &lt;= sum(../MTR:IncomeBeforeTax)" id="a_FIG4-OTHER-FI-SAV-FOR-TAX-AMO.1" diagnostics="errorCode.FIG4-OTHER-FI-SAV-FOR-TAX-AMO.1 transactional.FIG4-OTHER-FI-SAV-FOR-TAX-AMO.1 transactional.en.FIG4-OTHER-FI-SAV-FOR-TAX-AMO.1 ">[FOR4C] should not exceed [FOR4B]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p324">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasSavings/MTR:IncomeSource/MTR:SpecialWithholdingTax">
        <sch:assert test="../../../MTR:UnremittableIncome or . &lt;= sum(../MTR:IncomeBeforeTax)" id="a_FIG4-OTHER-FI-SAV-UK-TAX-AMO.1" diagnostics="errorCode.FIG4-OTHER-FI-SAV-UK-TAX-AMO.1 transactional.FIG4-OTHER-FI-SAV-UK-TAX-AMO.1 transactional.en.FIG4-OTHER-FI-SAV-UK-TAX-AMO.1 ">If [FOR1] is not 'yes', then [FOR4D] should not exceed [FOR4B]</sch:assert>
        <sch:assert test="../../MTR:Totals/MTR:SWTOrUKTax" id="a_FIG4-OTHER-FI-SAV-UK-TAX-AMO.2" diagnostics="errorCode.FIG4-OTHER-FI-SAV-UK-TAX-AMO.2 transactional.FIG4-OTHER-FI-SAV-UK-TAX-AMO.2 transactional.en.FIG4-OTHER-FI-SAV-UK-TAX-AMO.2 ">[FOR3] must be present if [FOR4D] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p325">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasSavings/MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings">
        <sch:assert test="../../MTR:Totals/MTR:TaxableAmount" id="a_FIG4-OTHER-FI-SAV-UK-CHRG-AMO.1" diagnostics="errorCode.FIG4-OTHER-FI-SAV-UK-CHRG-AMO.1 transactional.FIG4-OTHER-FI-SAV-UK-CHRG-AMO.1 transactional.en.FIG4-OTHER-FI-SAV-UK-CHRG-AMO.1 ">[FOR4] must be present if [FOR4F] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p321">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasSavings/MTR:IncomeSource">
        <sch:assert test="(
  not(MTR:ClaimToFTCR) 
  and 
  (math:abs((sum(MTR:TaxableAmountOnInterestAndOtherSavings)) - (sum(MTR:IncomeBeforeTax) - sum(MTR:ForeignTax))) &lt; 0.001)
)
or 
( 
  MTR:ClaimToFTCR 
  and 
  (math:abs((sum(MTR:TaxableAmountOnInterestAndOtherSavings)) - (sum(MTR:IncomeBeforeTax))) &lt; 0.001) 
)" id="a_FIG-OTHER-DIVIDENDS-ETC.1" diagnostics="errorCode.FIG-OTHER-DIVIDENDS-ETC.1 transactional.FIG-OTHER-DIVIDENDS-ETC.1 transactional.en.FIG-OTHER-DIVIDENDS-ETC.1 ">If [FOR4E] is Y, [FOR4F] must = [FOR4B] otherwise [FOR4F] must = [FOR4B] minus [FOR4C]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p326">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasSavings/MTR:Totals/MTR:SWTOrUKTax">
        <sch:assert test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:SpecialWithholdingTax )) &lt;= 1.001" id="a_SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1" diagnostics="errorCode.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1 transactional.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1 transactional.en.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1 ">Total of all iterations of box SpecialWithholdingTax</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p327">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasSavings/MTR:Totals/MTR:TaxableAmount">
        <sch:assert test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings )) &lt;= 1.001" id="a_TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1" diagnostics="errorCode.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1 transactional.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1 transactional.en.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1 ">Total of all iterations of box TaxableAmountOnInterestAndOtherSavings</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p328">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasSavings/MTR:InterestTotalClaimedFIGregime">
        <sch:assert test=". &lt;= ../MTR:Totals/MTR:TaxableAmount" id="a_FIG3-TOT-AMO-FIG-CLM-INT.0" diagnostics="errorCode.FIG3-TOT-AMO-FIG-CLM-INT.0 transactional.FIG3-TOT-AMO-FIG-CLM-INT.0 transactional.en.FIG3-TOT-AMO-FIG-CLM-INT.0 ">[FOR4.1] is valid only if this does not exceed [FOR4]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_FIG3-TOT-AMO-FIG-CLM-INT.1" diagnostics="errorCode.FIG3-TOT-AMO-FIG-CLM-INT.1 transactional.FIG3-TOT-AMO-FIG-CLM-INT.1 transactional.en.FIG3-TOT-AMO-FIG-CLM-INT.1 ">If [FOR4.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
        <sch:assert test="not((math:abs((.) - (../MTR:Totals/MTR:TaxableAmount)) &lt; 0.001)) or not(../MTR:IncomeSource/MTR:ClaimToFTCR)" id="a_FIG3-TOT-AMO-FIG-CLM-INT.2" diagnostics="errorCode.FIG3-TOT-AMO-FIG-CLM-INT.2 transactional.FIG3-TOT-AMO-FIG-CLM-INT.2 transactional.en.FIG3-TOT-AMO-FIG-CLM-INT.2 ">If [FOR4.1] present and equals [FOR4] then all iterations of [FOR4E] must not be 'Y'</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p330">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:ForeignCompanies/MTR:IncomeSource/MTR:IncomeBeforeTax">
        <sch:assert test="../MTR:TaxableAmountOnInterestAndOtherSavings" id="a_FIG4-FRGN-DIV-GROSS-INC-AMO.1" diagnostics="errorCode.FIG4-FRGN-DIV-GROSS-INC-AMO.1 transactional.FIG4-FRGN-DIV-GROSS-INC-AMO.1 transactional.en.FIG4-FRGN-DIV-GROSS-INC-AMO.1 ">[FOR6F] must be present if [FOR6B] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p331">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:ForeignCompanies/MTR:IncomeSource/MTR:ForeignTax">
        <sch:assert test=". &lt;= sum(../MTR:IncomeBeforeTax)" id="a_FIG4-DIVIDENDS-FRGN-TAX-AMO.1" diagnostics="errorCode.FIG4-DIVIDENDS-FRGN-TAX-AMO.1 transactional.FIG4-DIVIDENDS-FRGN-TAX-AMO.1 transactional.en.FIG4-DIVIDENDS-FRGN-TAX-AMO.1 ">[FOR6C] should not exceed [FOR6B]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p332">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:ForeignCompanies/MTR:IncomeSource/MTR:SpecialWithholdingTax">
        <sch:assert test="../../../MTR:UnremittableIncome or . &lt;= sum(../MTR:IncomeBeforeTax)" id="a_FIG-DIVIDENDS-UK-TAX-AMT.1" diagnostics="errorCode.FIG-DIVIDENDS-UK-TAX-AMT.1 transactional.FIG-DIVIDENDS-UK-TAX-AMT.1 transactional.en.FIG-DIVIDENDS-UK-TAX-AMT.1 ">If [FOR1] is not 'yes', then [FOR6D] should not exceed [FOR6B]</sch:assert>
        <sch:assert test="../../MTR:Totals/MTR:SWTOrUKTax" id="a_FIG-DIVIDENDS-UK-TAX-AMT.2" diagnostics="errorCode.FIG-DIVIDENDS-UK-TAX-AMT.2 transactional.FIG-DIVIDENDS-UK-TAX-AMT.2 transactional.en.FIG-DIVIDENDS-UK-TAX-AMT.2 ">[FOR5] must be present if [FOR6D] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p333">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:ForeignCompanies/MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings">
        <sch:assert test="../../MTR:Totals/MTR:TaxableAmount" id="a_FIG4-DIV-UK-CHARGEABLE-AMO.1" diagnostics="errorCode.FIG4-DIV-UK-CHARGEABLE-AMO.1 transactional.FIG4-DIV-UK-CHARGEABLE-AMO.1 transactional.en.FIG4-DIV-UK-CHARGEABLE-AMO.1 ">[FOR6] must be present if [FOR6F] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p329">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:ForeignCompanies/MTR:IncomeSource">
        <sch:assert test="(
  not(MTR:ClaimToFTCR) 
  and 
  (math:abs((sum(MTR:TaxableAmountOnInterestAndOtherSavings)) - (sum(MTR:IncomeBeforeTax) - sum(MTR:ForeignTax))) &lt; 0.001)
)
or 
( 
  MTR:ClaimToFTCR 
  and 
  (math:abs((sum(MTR:TaxableAmountOnInterestAndOtherSavings)) - (sum(MTR:IncomeBeforeTax))) &lt; 0.001) 
)" id="a_FIG-FOREIGN-DIVIDENDS.1" diagnostics="errorCode.FIG-FOREIGN-DIVIDENDS.1 transactional.FIG-FOREIGN-DIVIDENDS.1 transactional.en.FIG-FOREIGN-DIVIDENDS.1 ">If [FOR6E] is Y, [FOR6F] must = [FOR6B] otherwise [FOR6F] must = [FOR6B] minus [FOR6C]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p334">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:ForeignCompanies/MTR:Totals/MTR:SWTOrUKTax">
        <sch:assert test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:SpecialWithholdingTax )) &lt;= 1.001" id="a_SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.0" diagnostics="errorCode.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.0 transactional.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.0 transactional.en.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.0 ">Total of all iterations of box SpecialWithholdingTax</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p335">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:ForeignCompanies/MTR:Totals/MTR:TaxableAmount">
        <sch:assert test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings )) &lt;= 1.001" id="a_TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.0" diagnostics="errorCode.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.0 transactional.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.0 transactional.en.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.0 ">Total of all iterations of box TaxableAmountOnInterestAndOtherSavings</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p336">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:ForeignCompanies/MTR:DividendsTotalClaimedFIGregime">
        <sch:assert test=". &lt;= ../MTR:Totals/MTR:TaxableAmount" id="a_FIG3-TOT-AMO-FIG-CLM-DIVS.0" diagnostics="errorCode.FIG3-TOT-AMO-FIG-CLM-DIVS.0 transactional.FIG3-TOT-AMO-FIG-CLM-DIVS.0 transactional.en.FIG3-TOT-AMO-FIG-CLM-DIVS.0 ">[FOR6.1] must be less than or equal to [FOR6]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_FIG3-TOT-AMO-FIG-CLM-DIVS.1" diagnostics="errorCode.FIG3-TOT-AMO-FIG-CLM-DIVS.1 transactional.FIG3-TOT-AMO-FIG-CLM-DIVS.1 transactional.en.FIG3-TOT-AMO-FIG-CLM-DIVS.1 ">If [FOR6.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
        <sch:assert test="not((math:abs((.) - (../MTR:Totals/MTR:TaxableAmount)) &lt; 0.001)) or not(../MTR:IncomeSource/MTR:ClaimToFTCR)" id="a_FIG3-TOT-AMO-FIG-CLM-DIVS.2" diagnostics="errorCode.FIG3-TOT-AMO-FIG-CLM-DIVS.2 transactional.FIG3-TOT-AMO-FIG-CLM-DIVS.2 transactional.en.FIG3-TOT-AMO-FIG-CLM-DIVS.2 ">If [FOR6.1] present and equals [FOR6] then all iterations of [FOR6E] must not be 'Y'</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p337">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:RemittedForeignIncome/MTR:IncomeSource/MTR:IncomeBeforeTax">
        <sch:assert test="not((.)) or ../MTR:TaxableAmount" id="a_FIG-REM-FOR-INC-GROSS-AMT.0" diagnostics="errorCode.FIG-REM-FOR-INC-GROSS-AMT.0 transactional.FIG-REM-FOR-INC-GROSS-AMT.0 transactional.en.FIG-REM-FOR-INC-GROSS-AMT.0 ">[FOR7.2F (pseudo)] must be present if [FOR7.2B] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p338">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:RemittedForeignIncome/MTR:IncomeSource/MTR:ForeignTax">
        <sch:assert test=". &lt;= sum(../MTR:IncomeBeforeTax)" id="a_FIG-REM-FOR-INC-FORGN-TAX-AMT.0" diagnostics="errorCode.FIG-REM-FOR-INC-FORGN-TAX-AMT.0 transactional.FIG-REM-FOR-INC-FORGN-TAX-AMT.0 transactional.en.FIG-REM-FOR-INC-FORGN-TAX-AMT.0 ">[FOR7.2C] is valid only if this does not exceed [FOR7.2B]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p339">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:RemittedForeignIncome/MTR:IncomeSource/MTR:SpecialWithholdingTax">
        <sch:assert test=". &lt;= sum(../MTR:IncomeBeforeTax)" id="a_FIG-REM-FOR-INC-TAX-ITEM-AMT.0" diagnostics="errorCode.FIG-REM-FOR-INC-TAX-ITEM-AMT.0 transactional.FIG-REM-FOR-INC-TAX-ITEM-AMT.0 transactional.en.FIG-REM-FOR-INC-TAX-ITEM-AMT.0 ">[FOR7.2D (pseudo)] is valid only if this does not exceed [FOR7.2B]</sch:assert>
        <sch:assert test="../../MTR:Totals/MTR:SWTOrUKTax" id="a_FIG-REM-FOR-INC-TAX-ITEM-AMT.1" diagnostics="errorCode.FIG-REM-FOR-INC-TAX-ITEM-AMT.1 transactional.FIG-REM-FOR-INC-TAX-ITEM-AMT.1 transactional.en.FIG-REM-FOR-INC-TAX-ITEM-AMT.1 ">[FOR7.1] must be present if [FOR7.2D (pseudo)] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p340">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:RemittedForeignIncome/MTR:IncomeSource/MTR:TaxableAmount">
        <sch:assert test="../../MTR:Totals/MTR:TaxableAmount" id="a_FIG-REM-FOR-INC-UK-CHRG-AMT.3" diagnostics="errorCode.FIG-REM-FOR-INC-UK-CHRG-AMT.3 transactional.FIG-REM-FOR-INC-UK-CHRG-AMT.3 transactional.en.FIG-REM-FOR-INC-UK-CHRG-AMT.3 ">[FOR7.2] must be present if [FOR7.2F (pseudo)] is present</sch:assert>
        <sch:assert test="not(../MTR:ClaimToFTCR) or (.) = sum(../MTR:IncomeBeforeTax)" id="a_FIG-REM-FOR-INC-UK-CHRG-AMT.0" diagnostics="errorCode.FIG-REM-FOR-INC-UK-CHRG-AMT.0 transactional.FIG-REM-FOR-INC-UK-CHRG-AMT.0 transactional.en.FIG-REM-FOR-INC-UK-CHRG-AMT.0 ">[FOR7.2F (pseudo)] must be equal to [FOR7.2B] if [FOR7.2E] is present</sch:assert>
        <sch:assert test="../MTR:ClaimToFTCR or (math:abs(((.)) - (sum(../MTR:IncomeBeforeTax) - sum(../MTR:ForeignTax))) &lt; 0.001)" id="a_FIG-REM-FOR-INC-UK-CHRG-AMT.2" diagnostics="errorCode.FIG-REM-FOR-INC-UK-CHRG-AMT.2 transactional.FIG-REM-FOR-INC-UK-CHRG-AMT.2 transactional.en.FIG-REM-FOR-INC-UK-CHRG-AMT.2 ">[FOR7.2F (pseudo)] must be equal to [FOR7.2B] - [FOR7.2C] if [FOR7.2E] is absent</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p341">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:RemittedForeignIncome/MTR:Totals/MTR:SWTOrUKTax">
        <sch:assert test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:SpecialWithholdingTax )) &lt;= 1.001" id="a_SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC2.1" diagnostics="errorCode.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC2.1 transactional.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC2.1 transactional.en.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC2.1 ">Total of all iterations of box SpecialWithholdingTax</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p342">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:RemittedForeignIncome/MTR:Totals/MTR:TaxableAmount">
        <sch:assert test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:TaxableAmount )) &lt;= 1.001" id="a_TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC2.1" diagnostics="errorCode.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC2.1 transactional.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC2.1 transactional.en.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC2.1 ">Total of all iterations of box TaxableAmount</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p344">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:RemittedForeignDividends/MTR:IncomeSource/MTR:IncomeBeforeTax">
        <sch:assert test="../MTR:TaxableAmount" id="a_FIG-REM-DIV-GROSS-AMT.1" diagnostics="errorCode.FIG-REM-DIV-GROSS-AMT.1 transactional.FIG-REM-DIV-GROSS-AMT.1 transactional.en.FIG-REM-DIV-GROSS-AMT.1 ">[FOR7.4F (pseudo)] must be present if [FOR7.4B] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p345">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:RemittedForeignDividends/MTR:IncomeSource/MTR:ForeignTax">
        <sch:assert test=". &lt;= sum(../MTR:IncomeBeforeTax)" id="a_FIG-REM-DIV-FOREIGN-TAX-AMT.1" diagnostics="errorCode.FIG-REM-DIV-FOREIGN-TAX-AMT.1 transactional.FIG-REM-DIV-FOREIGN-TAX-AMT.1 transactional.en.FIG-REM-DIV-FOREIGN-TAX-AMT.1 ">[FOR7.4C] should not exceed [FOR7.4B]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p346">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:RemittedForeignDividends/MTR:IncomeSource/MTR:SpecialWithholdingTax">
        <sch:assert test=". &lt;= sum(../MTR:IncomeBeforeTax)" id="a_FIG-REM-DIV-TAX-ITEM-AMT.1" diagnostics="errorCode.FIG-REM-DIV-TAX-ITEM-AMT.1 transactional.FIG-REM-DIV-TAX-ITEM-AMT.1 transactional.en.FIG-REM-DIV-TAX-ITEM-AMT.1 ">[FOR7.4D (pseudo)] should not exceed [FOR7.4B]</sch:assert>
        <sch:assert test="../../MTR:Totals/MTR:SWTOrUKTax" id="a_FIG-REM-DIV-TAX-ITEM-AMT.2" diagnostics="errorCode.FIG-REM-DIV-TAX-ITEM-AMT.2 transactional.FIG-REM-DIV-TAX-ITEM-AMT.2 transactional.en.FIG-REM-DIV-TAX-ITEM-AMT.2 ">[FOR7.3] must be present if [FOR7.4D (pseudo)] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p347">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:RemittedForeignDividends/MTR:IncomeSource/MTR:TaxableAmount">
        <sch:assert test="../../MTR:Totals/MTR:TaxableAmount" id="a_FIG-REM-DIV-UK-CHARGEABLE-AMO.1" diagnostics="errorCode.FIG-REM-DIV-UK-CHARGEABLE-AMO.1 transactional.FIG-REM-DIV-UK-CHARGEABLE-AMO.1 transactional.en.FIG-REM-DIV-UK-CHARGEABLE-AMO.1 ">[FOR7.4] must be present if [FOR7.4F (pseudo)] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p343">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:RemittedForeignDividends/MTR:IncomeSource">
        <sch:assert test="not(MTR:ClaimToFTCR) or sum(MTR:TaxableAmount) = sum(MTR:IncomeBeforeTax)" id="a_FIG-REMITTED-FORG-DIVIDENDS.0" diagnostics="errorCode.FIG-REMITTED-FORG-DIVIDENDS.0 transactional.FIG-REMITTED-FORG-DIVIDENDS.0 transactional.en.FIG-REMITTED-FORG-DIVIDENDS.0 ">[FOR7.4F (pseudo)] must be equal to [FOR7.4B] if [FOR7.4E] is present</sch:assert>
        <sch:assert test="MTR:ClaimToFTCR or (math:abs((sum(MTR:TaxableAmount)) - (sum(MTR:IncomeBeforeTax) - sum(MTR:ForeignTax))) &lt; 0.001)" id="a_FIG-REMITTED-FORG-DIVIDENDS.1" diagnostics="errorCode.FIG-REMITTED-FORG-DIVIDENDS.1 transactional.FIG-REMITTED-FORG-DIVIDENDS.1 transactional.en.FIG-REMITTED-FORG-DIVIDENDS.1 ">[FOR7.4F (pseudo)] must be equal to [FOR7.4B] - [FOR7.4C] if [FOR7.4E] is absent</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p348">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:RemittedForeignDividends/MTR:Totals/MTR:SWTOrUKTax">
        <sch:assert test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:SpecialWithholdingTax )) &lt;= 1.001" id="a_SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC2.1.0" diagnostics="errorCode.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC2.1.0 transactional.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC2.1.0 transactional.en.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC2.1.0 ">Total of all iterations of box SpecialWithholdingTax</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p349">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:RemittedForeignDividends/MTR:Totals/MTR:TaxableAmount">
        <sch:assert test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:TaxableAmount )) &lt;= 1.001" id="a_TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC2.1.0" diagnostics="errorCode.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC2.1.0 transactional.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC2.1.0 transactional.en.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC2.1.0 ">Total of all iterations of box TaxableAmount</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p350">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:RemittedForeignDividends/MTR:AmountSubjectToDividendTaxCredit">
        <sch:assert test=". &lt;= sum(../MTR:Totals/MTR:TaxableAmount)" id="a_FIG-REM-DIV-CHRG-AMO-SUB-DTC.1" diagnostics="errorCode.FIG-REM-DIV-CHRG-AMO-SUB-DTC.1 transactional.FIG-REM-DIV-CHRG-AMO-SUB-DTC.1 transactional.en.FIG-REM-DIV-CHRG-AMO-SUB-DTC.1 ">[FOR7.5] should not exceed [FOR7.4]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p351">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasPensions/MTR:IncomeSource/MTR:IncomeBeforeTax">
        <sch:assert test="../MTR:TaxableAmountOnInterestAndOtherSavings" id="a_FIG-PENSIONS-GROSS-AMT.1" diagnostics="errorCode.FIG-PENSIONS-GROSS-AMT.1 transactional.FIG-PENSIONS-GROSS-AMT.1 transactional.en.FIG-PENSIONS-GROSS-AMT.1 ">[FOR9F (pseudo)] must be present if [FOR9B] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p352">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasPensions/MTR:IncomeSource/MTR:ForeignTax">
        <sch:assert test=". &lt;= sum(../MTR:IncomeBeforeTax)" id="a_FIG-PENSIONS-FOREIGN-TAX-AMT.1" diagnostics="errorCode.FIG-PENSIONS-FOREIGN-TAX-AMT.1 transactional.FIG-PENSIONS-FOREIGN-TAX-AMT.1 transactional.en.FIG-PENSIONS-FOREIGN-TAX-AMT.1 ">[FOR9C] should not exceed [FOR9B]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p353">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasPensions/MTR:IncomeSource/MTR:SpecialWithholdingTax">
        <sch:assert test="../../../MTR:UnremittableIncome or . &lt;= sum(../MTR:IncomeBeforeTax)" id="a_FIG-PENSIONS-UK-TAX-ITEM-AMT.1" diagnostics="errorCode.FIG-PENSIONS-UK-TAX-ITEM-AMT.1 transactional.FIG-PENSIONS-UK-TAX-ITEM-AMT.1 transactional.en.FIG-PENSIONS-UK-TAX-ITEM-AMT.1 ">If [FOR1] is not 'yes', then [FOR9D (pseudo)] should not exceed [FOR9B]</sch:assert>
        <sch:assert test="../../MTR:Totals/MTR:SWTOrUKTax" id="a_FIG-PENSIONS-UK-TAX-ITEM-AMT.2" diagnostics="errorCode.FIG-PENSIONS-UK-TAX-ITEM-AMT.2 transactional.FIG-PENSIONS-UK-TAX-ITEM-AMT.2 transactional.en.FIG-PENSIONS-UK-TAX-ITEM-AMT.2 ">[FOR8] must be present if [FOR9D (pseudo)] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p354">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasPensions/MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings">
        <sch:assert test="../../MTR:Totals/MTR:TaxableAmount" id="a_FIG-PENSIONS-CHARGEABLE-AMT.1" diagnostics="errorCode.FIG-PENSIONS-CHARGEABLE-AMT.1 transactional.FIG-PENSIONS-CHARGEABLE-AMT.1 transactional.en.FIG-PENSIONS-CHARGEABLE-AMT.1 ">[FOR9] must be present if [FOR9F (pseudo)] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p355">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasPensions/MTR:Totals/MTR:SWTOrUKTax">
        <sch:assert test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:SpecialWithholdingTax )) &lt;= 1.001" id="a_SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.1" diagnostics="errorCode.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.1 transactional.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.1 transactional.en.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.1 ">Total of all iterations of box SpecialWithholdingTax</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p356">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasPensions/MTR:Totals/MTR:TaxableAmount">
        <sch:assert test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings )) &lt;= 1.001" id="a_TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.1" diagnostics="errorCode.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.1 transactional.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.1 transactional.en.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.1 ">Total of all iterations of box TaxableAmountOnInterestAndOtherSavings</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p357">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasPensions/MTR:PensionsTotalClaimedFIGregime">
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK)
                 and
                 (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_FIG3-TOT-AMO-FIG-CLM-PENS.1" diagnostics="errorCode.FIG3-TOT-AMO-FIG-CLM-PENS.1 transactional.FIG3-TOT-AMO-FIG-CLM-PENS.1 transactional.en.FIG3-TOT-AMO-FIG-CLM-PENS.1 ">If [FOR9.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
        <sch:assert test=". &lt;= ../MTR:Totals/MTR:TaxableAmount" id="a_FIG3-TOT-AMO-FIG-CLM-PENS.0" diagnostics="errorCode.FIG3-TOT-AMO-FIG-CLM-PENS.0 transactional.FIG3-TOT-AMO-FIG-CLM-PENS.0 transactional.en.FIG3-TOT-AMO-FIG-CLM-PENS.0 ">[FOR9.1] is valid only if this does not exceed [FOR9]</sch:assert>
        <sch:assert test="not((math:abs((.) - (../MTR:Totals/MTR:TaxableAmount)) &lt; 0.001)) or not(../MTR:IncomeSource/MTR:ClaimToFTCR)" id="a_FIG3-TOT-AMO-FIG-CLM-PENS.2" diagnostics="errorCode.FIG3-TOT-AMO-FIG-CLM-PENS.2 transactional.FIG3-TOT-AMO-FIG-CLM-PENS.2 transactional.en.FIG3-TOT-AMO-FIG-CLM-PENS.2 ">If [FOR9.1] is present and equal to [FOR9] then all iterations of [FOR9E] must not be 'Y'</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p359">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasDividendIncome/MTR:IncomeSource/MTR:IncomeBeforeTax">
        <sch:assert test="../MTR:TaxableAmountOnInterestAndOtherSavings" id="a_FIG4-INTEREST-GROSS-INCOME-AMO.1" diagnostics="errorCode.FIG4-INTEREST-GROSS-INCOME-AMO.1 transactional.FIG4-INTEREST-GROSS-INCOME-AMO.1 transactional.en.FIG4-INTEREST-GROSS-INCOME-AMO.1 ">[FOR11F (psuedo)] must be present if [FOR11B] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p360">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasDividendIncome/MTR:IncomeSource/MTR:ForeignTax">
        <sch:assert test=". &lt;= sum(../MTR:IncomeBeforeTax)" id="a_FIG4-INTEREST-FOREIGN-TAX-AMO.1" diagnostics="errorCode.FIG4-INTEREST-FOREIGN-TAX-AMO.1 transactional.FIG4-INTEREST-FOREIGN-TAX-AMO.1 transactional.en.FIG4-INTEREST-FOREIGN-TAX-AMO.1 ">[FOR11C] should not exceed [FOR11B]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p361">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasDividendIncome/MTR:IncomeSource/MTR:SpecialWithholdingTax">
        <sch:assert test="../../../MTR:UnremittableIncome or . &lt;= sum(../MTR:IncomeBeforeTax)" id="a_FIG-INTEREST-UK-TAX-ITEM-AMT.1" diagnostics="errorCode.FIG-INTEREST-UK-TAX-ITEM-AMT.1 transactional.FIG-INTEREST-UK-TAX-ITEM-AMT.1 transactional.en.FIG-INTEREST-UK-TAX-ITEM-AMT.1 ">If [FOR1] is not 'yes', then [FOR11D (pseudo)] should not exceed [FOR11B]</sch:assert>
        <sch:assert test="../../MTR:Totals/MTR:SWTOrUKTax" id="a_FIG-INTEREST-UK-TAX-ITEM-AMT.2" diagnostics="errorCode.FIG-INTEREST-UK-TAX-ITEM-AMT.2 transactional.FIG-INTEREST-UK-TAX-ITEM-AMT.2 transactional.en.FIG-INTEREST-UK-TAX-ITEM-AMT.2 ">[FOR10] must be present if [FOR11D (pseudo)] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p362">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasDividendIncome/MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings">
        <sch:assert test="../../MTR:Totals/MTR:TaxableAmount" id="a_FIG4-FRGN-INT-UK-CHRGBLE-AMO.1" diagnostics="errorCode.FIG4-FRGN-INT-UK-CHRGBLE-AMO.1 transactional.FIG4-FRGN-INT-UK-CHRGBLE-AMO.1 transactional.en.FIG4-FRGN-INT-UK-CHRGBLE-AMO.1 ">[FOR11] must be present if [FOR11F (psuedo)] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p358">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasDividendIncome/MTR:IncomeSource">
        <sch:assert test="(
  not(MTR:ClaimToFTCR) 
  and 
  (math:abs((sum(MTR:TaxableAmountOnInterestAndOtherSavings)) - (sum(MTR:IncomeBeforeTax) - sum(MTR:ForeignTax))) &lt; 0.001)
)
or 
( 
  MTR:ClaimToFTCR 
  and 
  (math:abs((sum(MTR:TaxableAmountOnInterestAndOtherSavings)) - (sum(MTR:IncomeBeforeTax))) &lt; 0.001) 
)" id="a_FIG-FOREIGN-SAVINGS.1" diagnostics="errorCode.FIG-FOREIGN-SAVINGS.1 transactional.FIG-FOREIGN-SAVINGS.1 transactional.en.FIG-FOREIGN-SAVINGS.1 ">If [FOR11E] is Y, [FOR11F (psuedo)] must = [FOR11B] otherwise [FOR11F (psuedo)] must = [FOR11B] minus [FOR11C]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p363">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasDividendIncome/MTR:Totals/MTR:SWTOrUKTax">
        <sch:assert test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:SpecialWithholdingTax )) &lt;= 1.001" id="a_SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.2" diagnostics="errorCode.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.2 transactional.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.2 transactional.en.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.2 ">Total of all iterations of box SpecialWithholdingTax</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p364">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasDividendIncome/MTR:Totals/MTR:TaxableAmount">
        <sch:assert test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings )) &lt;= 1.001" id="a_TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.2" diagnostics="errorCode.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.2 transactional.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.2 transactional.en.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.2 ">Total of all iterations of box TaxableAmountOnInterestAndOtherSavings</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p365">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasDividendIncome/MTR:DividendFromOverseasTrustEtcTotalClaimedFIGregime">
        <sch:assert test=". &lt;= ../MTR:Totals/MTR:TaxableAmount" id="a_FIG2-TOT-AMO-FIG-CLM-OT.0" diagnostics="errorCode.FIG2-TOT-AMO-FIG-CLM-OT.0 transactional.FIG2-TOT-AMO-FIG-CLM-OT.0 transactional.en.FIG2-TOT-AMO-FIG-CLM-OT.0 ">[FOR11.1] is valid only if this does not exceed [FOR11]</sch:assert>
        <sch:assert test="not((math:abs((.) - (../MTR:Totals/MTR:TaxableAmount)) &lt; 0.001)) or not(../MTR:IncomeSource/MTR:ClaimToFTCR)" id="a_FIG2-TOT-AMO-FIG-CLM-OT.2" diagnostics="errorCode.FIG2-TOT-AMO-FIG-CLM-OT.2 transactional.FIG2-TOT-AMO-FIG-CLM-OT.2 transactional.en.FIG2-TOT-AMO-FIG-CLM-OT.2 ">If [FOR11.1] is present and equal to [FOR11] then all iterations of [FOR11E] must not be 'Y'</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_FIG2-TOT-AMO-FIG-CLM-OT.1" diagnostics="errorCode.FIG2-TOT-AMO-FIG-CLM-OT.1 transactional.FIG2-TOT-AMO-FIG-CLM-OT.1 transactional.en.FIG2-TOT-AMO-FIG-CLM-OT.1 ">If [FOR11.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p367">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasTrustIncome/MTR:IncomeSource/MTR:IncomeBeforeTax">
        <sch:assert test="../MTR:TaxableAmountOnInterestAndOtherSavings" id="a_FIG4-DIV-OTCOE-SAV-GROSS-AMO.1" diagnostics="errorCode.FIG4-DIV-OTCOE-SAV-GROSS-AMO.1 transactional.FIG4-DIV-OTCOE-SAV-GROSS-AMO.1 transactional.en.FIG4-DIV-OTCOE-SAV-GROSS-AMO.1 ">[FOR13F (psuedo)] must be present if [FOR13B] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p368">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasTrustIncome/MTR:IncomeSource/MTR:ForeignTax">
        <sch:assert test=". &lt;= sum(../MTR:IncomeBeforeTax)" id="a_FIG4-DIV-OTCOE-SAV-FOR-TAX-AMO.1" diagnostics="errorCode.FIG4-DIV-OTCOE-SAV-FOR-TAX-AMO.1 transactional.FIG4-DIV-OTCOE-SAV-FOR-TAX-AMO.1 transactional.en.FIG4-DIV-OTCOE-SAV-FOR-TAX-AMO.1 ">[FOR13C] should not exceed [FOR13B]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p369">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasTrustIncome/MTR:IncomeSource/MTR:SpecialWithholdingTax">
        <sch:assert test="../../../MTR:UnremittableIncome or . &lt;= sum(../MTR:IncomeBeforeTax)" id="a_FIG-DIV-OTCOE-SAV-UK-TAX-AMO.1" diagnostics="errorCode.FIG-DIV-OTCOE-SAV-UK-TAX-AMO.1 transactional.FIG-DIV-OTCOE-SAV-UK-TAX-AMO.1 transactional.en.FIG-DIV-OTCOE-SAV-UK-TAX-AMO.1 ">If [FOR1] is not 'yes', then [FOR13D (psuedo)] should not exceed [FOR13B]</sch:assert>
        <sch:assert test="../../MTR:Totals/MTR:SWTOrUKTax" id="a_FIG-DIV-OTCOE-SAV-UK-TAX-AMO.2" diagnostics="errorCode.FIG-DIV-OTCOE-SAV-UK-TAX-AMO.2 transactional.FIG-DIV-OTCOE-SAV-UK-TAX-AMO.2 transactional.en.FIG-DIV-OTCOE-SAV-UK-TAX-AMO.2 ">[FOR12] must be present if [FOR13D (psuedo)] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p370">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasTrustIncome/MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings">
        <sch:assert test="../../MTR:Totals/MTR:TaxableAmount" id="a_FIG4-DIV-OTCOE-SAV-UK-CHRG-AMO.1" diagnostics="errorCode.FIG4-DIV-OTCOE-SAV-UK-CHRG-AMO.1 transactional.FIG4-DIV-OTCOE-SAV-UK-CHRG-AMO.1 transactional.en.FIG4-DIV-OTCOE-SAV-UK-CHRG-AMO.1 ">[FOR13] must be present if [FOR13F (psuedo)] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p366">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasTrustIncome/MTR:IncomeSource">
        <sch:assert test="(
  not(MTR:ClaimToFTCR) 
  and 
  (math:abs((sum(MTR:TaxableAmountOnInterestAndOtherSavings)) - (sum(MTR:IncomeBeforeTax) - sum(MTR:ForeignTax))) &lt; 0.001)
)
or 
( 
  MTR:ClaimToFTCR 
  and 
  (math:abs((sum(MTR:TaxableAmountOnInterestAndOtherSavings)) - (sum(MTR:IncomeBeforeTax))) &lt; 0.001) 
)" id="a_FIG-OTCOE-INCOME.1" diagnostics="errorCode.FIG-OTCOE-INCOME.1 transactional.FIG-OTCOE-INCOME.1 transactional.en.FIG-OTCOE-INCOME.1 ">If [FOR13E] is Y, [FOR13F (psuedo)] must = [FOR13B] otherwise [FOR13F (psuedo)] must = [FOR13B] minus [FOR13C]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p371">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasTrustIncome/MTR:Totals/MTR:SWTOrUKTax">
        <sch:assert test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:SpecialWithholdingTax )) &lt;= 1.001" id="a_SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.3" diagnostics="errorCode.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.3 transactional.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.3 transactional.en.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.3 ">Total of all iterations of box SpecialWithholdingTax</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p372">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasTrustIncome/MTR:Totals/MTR:TaxableAmount">
        <sch:assert test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings )) &lt;= 1.001" id="a_TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.3" diagnostics="errorCode.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.3 transactional.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.3 transactional.en.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.3 ">Total of all iterations of box TaxableAmountOnInterestAndOtherSavings</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p373">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasTrustIncome/MTR:OverseasTrustsEtcOtherIncomeTotalClaimedFIGregime">
        <sch:assert test=". &lt;= ../MTR:Totals/MTR:TaxableAmount" id="a_FIG3-TOT-AMO-FIG-CLM-OTCOE.0" diagnostics="errorCode.FIG3-TOT-AMO-FIG-CLM-OTCOE.0 transactional.FIG3-TOT-AMO-FIG-CLM-OTCOE.0 transactional.en.FIG3-TOT-AMO-FIG-CLM-OTCOE.0 ">[FOR13.0] is valid only if this does not exceed [FOR13]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_FIG3-TOT-AMO-FIG-CLM-OTCOE.1" diagnostics="errorCode.FIG3-TOT-AMO-FIG-CLM-OTCOE.1 transactional.FIG3-TOT-AMO-FIG-CLM-OTCOE.1 transactional.en.FIG3-TOT-AMO-FIG-CLM-OTCOE.1 ">If [FOR13.0] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
        <sch:assert test="not((math:abs((.) - (../MTR:Totals/MTR:TaxableAmount)) &lt; 0.001)) or not(../MTR:IncomeSource/MTR:ClaimToFTCR)" id="a_FIG3-TOT-AMO-FIG-CLM-OTCOE.2" diagnostics="errorCode.FIG3-TOT-AMO-FIG-CLM-OTCOE.2 transactional.FIG3-TOT-AMO-FIG-CLM-OTCOE.2 transactional.en.FIG3-TOT-AMO-FIG-CLM-OTCOE.2 ">If [FOR13.0] is present and equal to [FOR13] then all iterations of [FOR13E] must not be 'Y'</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p374">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:ResidentialPropertyIncomeOrRestrictedFinanceCosts">
        <sch:assert test="../MTR:OverseasTrustIncome/MTR:Totals/MTR:TaxableAmount" id="a_RES-PPTY-INC-OR-REST-FIN.1" diagnostics="errorCode.RES-PPTY-INC-OR-REST-FIN.1 transactional.RES-PPTY-INC-OR-REST-FIN.1 transactional.en.RES-PPTY-INC-OR-REST-FIN.1 ">If [FOR13.1] is present, [FOR13] should also be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p376">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:TotalRentsAndOtherPropertyReceipts">
        <sch:assert test="../MTR:NumberOfProperties" id="a_FIG4-PROPERTY-INCOME-AMO.1" diagnostics="errorCode.FIG4-PROPERTY-INCOME-AMO.1 transactional.FIG4-PROPERTY-INCOME-AMO.1 transactional.en.FIG4-PROPERTY-INCOME-AMO.1 ">number of properties should be present if [FOR14]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p377">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance">
        <sch:assert test="../MTR:AdjustedProfitOrLossForTheYear" id="a_FIG-PROPERTY-INCOME-ALLOWANCE.0" diagnostics="errorCode.FIG-PROPERTY-INCOME-ALLOWANCE.0 transactional.FIG-PROPERTY-INCOME-ALLOWANCE.0 transactional.en.FIG-PROPERTY-INCOME-ALLOWANCE.0 ">[FOR24] should be present if [FOR14.1] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p378">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:AllowablePropertyExpenses">
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_FIG4-PROPERTY-TOTAL-EXP-AMO.0" diagnostics="errorCode.FIG4-PROPERTY-TOTAL-EXP-AMO.0 transactional.FIG4-PROPERTY-TOTAL-EXP-AMO.0 transactional.en.FIG4-PROPERTY-TOTAL-EXP-AMO.0 ">[FOR17] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p379">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:NetProfitOrLoss">
        <sch:assert test="(math:abs((.) - (((sum(../MTR:TotalRentsAndOtherPropertyReceipts) + sum(../MTR:PremiumsPaidForLease)) - sum(../MTR:AllowablePropertyExpenses)))) &lt; 0.001)" id="a_FIG4-PROPERTY-NET-PROFIT-AMO.1" diagnostics="errorCode.FIG4-PROPERTY-NET-PROFIT-AMO.1 transactional.FIG4-PROPERTY-NET-PROFIT-AMO.1 transactional.en.FIG4-PROPERTY-NET-PROFIT-AMO.1 ">[FOR18] should equal ( ( [FOR14] plus [FOR16] ) minus [FOR17] )</sch:assert>
        <sch:assert test="../MTR:AdjustedProfitOrLossForTheYear" id="a_FIG4-PROPERTY-NET-PROFIT-AMO.2" diagnostics="errorCode.FIG4-PROPERTY-NET-PROFIT-AMO.2 transactional.FIG4-PROPERTY-NET-PROFIT-AMO.2 transactional.en.FIG4-PROPERTY-NET-PROFIT-AMO.2 ">[FOR24] should be present if [FOR18] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p380">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PrivateUseAdjustment">
        <sch:assert test=". &lt;= sum(../MTR:AllowablePropertyExpenses)" id="a_FIG4-PPTY-ADJUST-PERSNL-AMO.1" diagnostics="errorCode.FIG4-PPTY-ADJUST-PERSNL-AMO.1 transactional.FIG4-PPTY-ADJUST-PERSNL-AMO.1 transactional.en.FIG4-PPTY-ADJUST-PERSNL-AMO.1 ">[FOR19] should not exceed [FOR17]</sch:assert>
        <sch:assert test="../MTR:AdjustedProfitOrLossForTheYear" id="a_FIG4-PPTY-ADJUST-PERSNL-AMO.2" diagnostics="errorCode.FIG4-PPTY-ADJUST-PERSNL-AMO.2 transactional.FIG4-PPTY-ADJUST-PERSNL-AMO.2 transactional.en.FIG4-PPTY-ADJUST-PERSNL-AMO.2 ">[FOR24] should be present if [FOR19] is present</sch:assert>
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_FIG4-PPTY-ADJUST-PERSNL-AMO.0" diagnostics="errorCode.FIG4-PPTY-ADJUST-PERSNL-AMO.0 transactional.FIG4-PPTY-ADJUST-PERSNL-AMO.0 transactional.en.FIG4-PPTY-ADJUST-PERSNL-AMO.0 ">[FOR19] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p381">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:BalancingCharges">
        <sch:assert test="../MTR:AdjustedProfitOrLossForTheYear" id="a_FIG4-PROPERTY-BC-AMO.1" diagnostics="errorCode.FIG4-PROPERTY-BC-AMO.1 transactional.FIG4-PROPERTY-BC-AMO.1 transactional.en.FIG4-PROPERTY-BC-AMO.1 ">[FOR24] should be present if [FOR20] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p382">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:CapitalAllowances">
        <sch:assert test="../MTR:AdjustedProfitOrLossForTheYear" id="a_FIG4-PROPERTY-CAP-AMO.1" diagnostics="errorCode.FIG4-PROPERTY-CAP-AMO.1 transactional.FIG4-PROPERTY-CAP-AMO.1 transactional.en.FIG4-PROPERTY-CAP-AMO.1 ">[FOR24] should be present if [FOR21] is present</sch:assert>
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_FIG4-PROPERTY-CAP-AMO.0" diagnostics="errorCode.FIG4-PROPERTY-CAP-AMO.0 transactional.FIG4-PROPERTY-CAP-AMO.0 transactional.en.FIG4-PROPERTY-CAP-AMO.0 ">[FOR21] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p383">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:ZeroEmissionCarAllowance">
        <sch:assert test="../MTR:AdjustedProfitOrLossForTheYear" id="a_FIG-ZERO-EMISSION-CAR-ALLCE.1" diagnostics="errorCode.FIG-ZERO-EMISSION-CAR-ALLCE.1 transactional.FIG-ZERO-EMISSION-CAR-ALLCE.1 transactional.en.FIG-ZERO-EMISSION-CAR-ALLCE.1 ">[FOR24] should be present if [FOR21.1] is present</sch:assert>
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_FIG-ZERO-EMISSION-CAR-ALLCE.0" diagnostics="errorCode.FIG-ZERO-EMISSION-CAR-ALLCE.0 transactional.FIG-ZERO-EMISSION-CAR-ALLCE.0 transactional.en.FIG-ZERO-EMISSION-CAR-ALLCE.0 ">[FOR21.1] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p384">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:TheStructuresAndBuildingsAllowance">
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_FIG-SB-ALLCE.0" diagnostics="errorCode.FIG-SB-ALLCE.0 transactional.FIG-SB-ALLCE.0 transactional.en.FIG-SB-ALLCE.0 ">[FOR22.1] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
        <sch:assert test="../MTR:AdjustedProfitOrLossForTheYear" id="a_FIG-SB-ALLCE.1" diagnostics="errorCode.FIG-SB-ALLCE.1 transactional.FIG-SB-ALLCE.1 transactional.en.FIG-SB-ALLCE.1 ">[FOR24] should be present if [FOR22.1] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p385">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:ElectricChargePointAllowance">
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_FIG-ECP-ALLCE.0" diagnostics="errorCode.FIG-ECP-ALLCE.0 transactional.FIG-ECP-ALLCE.0 transactional.en.FIG-ECP-ALLCE.0 ">[FOR22.2] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
        <sch:assert test="../MTR:AdjustedProfitOrLossForTheYear" id="a_FIG-ECP-ALLCE.1" diagnostics="errorCode.FIG-ECP-ALLCE.1 transactional.FIG-ECP-ALLCE.1 transactional.en.FIG-ECP-ALLCE.1 ">[FOR24] should be present if [FOR22.2] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p386">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:CostsOfReplacingDomesticItems">
        <sch:assert test="../MTR:AdjustedProfitOrLossForTheYear" id="a_FIG4-PROPERTY-WEAR-TEAR-AMO.1" diagnostics="errorCode.FIG4-PROPERTY-WEAR-TEAR-AMO.1 transactional.FIG4-PROPERTY-WEAR-TEAR-AMO.1 transactional.en.FIG4-PROPERTY-WEAR-TEAR-AMO.1 ">[FOR24] should be present if [FOR23] is present</sch:assert>
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_FIG4-PROPERTY-WEAR-TEAR-AMO.0" diagnostics="errorCode.FIG4-PROPERTY-WEAR-TEAR-AMO.0 transactional.FIG4-PROPERTY-WEAR-TEAR-AMO.0 transactional.en.FIG4-PROPERTY-WEAR-TEAR-AMO.0 ">[FOR23] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p387">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:AdjustedProfitOrLossForTheYear">
        <sch:assert test="not(../MTR:PropertyIncomeAllowance)
                or
                (.) &gt;= 0" id="a_FIG-PPTY-ADJUSTD-PROF-LOSS-AMT.1" diagnostics="errorCode.FIG-PPTY-ADJUSTD-PROF-LOSS-AMT.1 transactional.FIG-PPTY-ADJUSTD-PROF-LOSS-AMT.1 transactional.en.FIG-PPTY-ADJUSTD-PROF-LOSS-AMT.1 ">If [FOR14.1] is present then [FOR24] must not be negative</sch:assert>
        <sch:assert test="(math:abs((.) - (((sum(../MTR:NetProfitOrLoss)
                      + sum(../MTR:PrivateUseAdjustment)
                      + sum(../MTR:BalancingCharges))
                      -
                      (sum(../MTR:PropertyIncomeAllowance)
                      + sum(../MTR:CapitalAllowances)
                      + sum(../MTR:ZeroEmissionCarAllowance)
                      + sum(../MTR:TheStructuresAndBuildingsAllowance)
                      + sum(../MTR:ElectricChargePointAllowance)
                      + sum(../MTR:CostsOfReplacingDomesticItems))))) &lt; 0.001)" id="a_FIG-PPTY-ADJUSTD-PROF-LOSS-AMT.0" diagnostics="errorCode.FIG-PPTY-ADJUSTD-PROF-LOSS-AMT.0 transactional.FIG-PPTY-ADJUSTD-PROF-LOSS-AMT.0 transactional.en.FIG-PPTY-ADJUSTD-PROF-LOSS-AMT.0 ">[FOR24] is valid only if this equals ( ( The sum of [FOR18], [FOR19], and [FOR20] ) minus ( The sum of [FOR14.1], [FOR21], [FOR21.1], [FOR22.1], [FOR22.2], and [FOR23] ) )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p388">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:ResidentialFinanceCosts">
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_FIG-PPTY-RES-FIN-COSTS.2" diagnostics="errorCode.FIG-PPTY-RES-FIN-COSTS.2 transactional.FIG-PPTY-RES-FIN-COSTS.2 transactional.en.FIG-PPTY-RES-FIN-COSTS.2 ">[FOR24.1] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p389">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:UnusedResidentialFinanceCostsBroughtForward">
        <sch:assert test="not(../../../MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) and
		      not(../../../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_FIG-LET-PPTY-RES-FIN-COSTS-BF.0" diagnostics="errorCode.FIG-LET-PPTY-RES-FIN-COSTS-BF.0 transactional.FIG-LET-PPTY-RES-FIN-COSTS-BF.0 transactional.en.FIG-LET-PPTY-RES-FIN-COSTS-BF.0 ">[FOR24.2] should not be present if any instance of [PRO20.1] or [FOR14.1] is present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p390">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyAbroadProfitOrLoss">
        <sch:assert test="not((.) &gt; 0) or ../../MTR:TotalAdjustedProfitOrLoss" id="a_FIG4-LET-PPTY-PROFIT-AMO.0" diagnostics="errorCode.FIG4-LET-PPTY-PROFIT-AMO.0 transactional.FIG4-LET-PPTY-PROFIT-AMO.0 transactional.en.FIG4-LET-PPTY-PROFIT-AMO.0 ">[FOR25] should be present if [FOR30B] exceeds 0</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p375">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails">
        <sch:assert test="MTR:TraditionalAccounting
            or
              ((sum(MTR:TotalRentsAndOtherPropertyReceipts) + sum(MTR:PremiumsPaidForLease) + sum(MTR:BalancingCharges)) - (150000) &lt; 0.001)" id="a_FIG-INCOME-LET-PROPERTY.0" diagnostics="errorCode.FIG-INCOME-LET-PROPERTY.0 transactional.FIG-INCOME-LET-PROPERTY.0 transactional.en.FIG-INCOME-LET-PROPERTY.0 ">Within each [FOR14-FOR24.2 / FOR30A-FOR30F], the total of [FOR14], [FOR16] and [FOR20] must not exceed [£150,000] if [FOR14.2] is absent</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p391">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:TotalAdjustedProfitOrLoss">
        <sch:assert test="not(../MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)
              or
              (.) &gt;= 0" id="a_FIG4-LET-PPTY-PROFIT-TOT.0" diagnostics="errorCode.FIG4-LET-PPTY-PROFIT-TOT.0 transactional.FIG4-LET-PPTY-PROFIT-TOT.0 transactional.en.FIG4-LET-PPTY-PROFIT-TOT.0 ">If a [FOR14.1] is present then [FOR25] must not be negative</sch:assert>
        <sch:assert test="math:abs(number(.) - sum( ../MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyAbroadProfitOrLoss )) &lt;= 1.001" id="a_FIG4-LET-PPTY-PROFIT-TOT.1" diagnostics="errorCode.FIG4-LET-PPTY-PROFIT-TOT.1 transactional.FIG4-LET-PPTY-PROFIT-TOT.1 transactional.en.FIG4-LET-PPTY-PROFIT-TOT.1 ">Total of all iterations of box [FOR30B]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p392">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:TotalTaxableProfit">
        <sch:assert test="( ((sum(../MTR:TotalAdjustedProfitOrLoss) - sum(../MTR:LossBroughtForward)) - (0) &gt; -0.001) and (math:abs((.) - (sum(../MTR:TotalAdjustedProfitOrLoss) - sum(../MTR:LossBroughtForward))) &lt; 0.001) )
or
( ((sum(../MTR:TotalAdjustedProfitOrLoss) - sum(../MTR:LossBroughtForward)) - (0) &lt;= -0.001) and (math:abs((.) - (0)) &lt; 0.001) )" id="a_FIG4-LET-PPTY-TAXABLE-TOT.1" diagnostics="errorCode.FIG4-LET-PPTY-TAXABLE-TOT.1 transactional.FIG4-LET-PPTY-TAXABLE-TOT.1 transactional.en.FIG4-LET-PPTY-TAXABLE-TOT.1 ">If [FOR25] minus [FOR26] is positive or zero then [FOR27] = [FOR25] minus [FOR26] else [FOR27] must be absent or zero</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p393">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:TotalForeignTaxTakenOff">
        <sch:assert test="(math:abs((number(.)) - (sum( ../MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyAbroadForeignTax ))) &lt; 0.001)" id="a_FIG4-LET-PPTY-FOREIGN-TAX-TOT.1" diagnostics="errorCode.FIG4-LET-PPTY-FOREIGN-TAX-TOT.1 transactional.FIG4-LET-PPTY-FOREIGN-TAX-TOT.1 transactional.en.FIG4-LET-PPTY-FOREIGN-TAX-TOT.1 ">Total of all iterations of box [FOR30C]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p394">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:TotalSpecialWithholdingTax">
        <sch:assert test="(math:abs((number(.)) - (sum( ../MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyAbroadUKtaxTakenOff ))) &lt; 0.001)" id="a_FIG-LET-PPTY-TOT-WHOLD-TAX-AMT.1" diagnostics="errorCode.FIG-LET-PPTY-TOT-WHOLD-TAX-AMT.1 transactional.FIG-LET-PPTY-TOT-WHOLD-TAX-AMT.1 transactional.en.FIG-LET-PPTY-TOT-WHOLD-TAX-AMT.1 ">Total of all iterations of box [FOR30D]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p395">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:PropertyAbroadTotalClaimedFIGregime">
        <sch:assert test=". &lt;= sum(../MTR:TotalTaxableAmount)" id="a_FIG4-LET-PPTY-TOT-AMO-FIG-CLM.0" diagnostics="errorCode.FIG4-LET-PPTY-TOT-AMO-FIG-CLM.0 transactional.FIG4-LET-PPTY-TOT-AMO-FIG-CLM.0 transactional.en.FIG4-LET-PPTY-TOT-AMO-FIG-CLM.0 ">[FOR30.1] is valid only if this does not exceed [FOR30]</sch:assert>
        <sch:assert test="not(../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_FIG4-LET-PPTY-TOT-AMO-FIG-CLM.1" diagnostics="errorCode.FIG4-LET-PPTY-TOT-AMO-FIG-CLM.1 transactional.FIG4-LET-PPTY-TOT-AMO-FIG-CLM.1 transactional.en.FIG4-LET-PPTY-TOT-AMO-FIG-CLM.1 ">If [FOR30.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
        <sch:assert test="not((math:abs((.) - (../MTR:TotalTaxableAmount)) &lt; 0.001)) or not(../MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyAbroadClaimToFTCR)" id="a_FIG4-LET-PPTY-TOT-AMO-FIG-CLM.2" diagnostics="errorCode.FIG4-LET-PPTY-TOT-AMO-FIG-CLM.2 transactional.FIG4-LET-PPTY-TOT-AMO-FIG-CLM.2 transactional.en.FIG4-LET-PPTY-TOT-AMO-FIG-CLM.2 ">If [FOR30.1] is present and equal to [FOR30] then all iterations of [FOR30E] must not be 'Y'</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p396">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:LossSetOffAgainstTotalIncome">
        <sch:assert test="not(../MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)" id="a_FIG-MLOFFSET-ON-INC-AMT.0" diagnostics="errorCode.FIG-MLOFFSET-ON-INC-AMT.0 transactional.FIG-MLOFFSET-ON-INC-AMT.0 transactional.en.FIG-MLOFFSET-ON-INC-AMT.0 ">[FOR31] should not be present if [FOR14.1] is present.</sch:assert>
        <sch:assert test="../MTR:OverseasLandAndPropertyIncomeDetails/MTR:TraditionalAccounting" id="a_FIG-MLOFFSET-ON-INC-AMT.1" diagnostics="errorCode.FIG-MLOFFSET-ON-INC-AMT.1 transactional.FIG-MLOFFSET-ON-INC-AMT.1 transactional.en.FIG-MLOFFSET-ON-INC-AMT.1 ">[FOR31] should not be present if [FOR14.2] is not present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p397">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:LossToCarryForward">
        <sch:assert test="not(../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG or ../../MTR:SA109/MTR:OverseasWorkdayReliefOWR/MTR:OWRclaim)
		      or not(((sum(../MTR:TotalAdjustedProfitOrLoss)) - (0) &lt;= -0.001))
		      or not(((sum(../MTR:LossBroughtForward)) - (0) &gt;= 0.001))
		      or not((((.)) - (0) &gt;= 0.001))
          or (math:abs((.) - (sum(../MTR:LossBroughtForward))) &lt; 0.001)" id="a_FIG4-LET-PPTY-LOSS-CF-AMO.0" diagnostics="errorCode.FIG4-LET-PPTY-LOSS-CF-AMO.0 transactional.FIG4-LET-PPTY-LOSS-CF-AMO.0 transactional.en.FIG4-LET-PPTY-LOSS-CF-AMO.0 ">If [NRD28] or [NRD29] or [NRD41] are 'Y' and [FOR25] is less than zero and [FOR26] is present (greater than zero) then, if [FOR32] is present (greater than zero) it must equal [FOR26]</sch:assert>
        <sch:assert test="not(../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG or ../../MTR:SA109/MTR:OverseasWorkdayReliefOWR/MTR:OWRclaim)
		      or not(((sum(../MTR:TotalAdjustedProfitOrLoss)) - (0) &gt; -0.001))
		      or not(((sum(../MTR:LossBroughtForward)) - (0) &gt;= 0.001))
		      or not(((sum(../MTR:TotalTaxableProfit)) - (0) &gt;= 0.001))
          or (math:abs((.) - (0.00)) &lt; 0.001)" id="a_FIG4-LET-PPTY-LOSS-CF-AMO.1" diagnostics="errorCode.FIG4-LET-PPTY-LOSS-CF-AMO.1 transactional.FIG4-LET-PPTY-LOSS-CF-AMO.1 transactional.en.FIG4-LET-PPTY-LOSS-CF-AMO.1 ">If [NRD28] or [NRD29] or [NRD41] are 'Y' and [FOR25] is equal to or greater than zero and [FOR26] and [FOR27] are present (greater than zero) then [FOR32] must be zero or absent</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p398">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:ForeignTaxPaid/MTR:ClaimToFTCRForeignTax">
        <sch:assert test="not((.)) or ../MTR:ClaimToFTCRAmountChargable" id="a_FIG4-CRED-RLF-SAV-FRGN-TAX-AMO.0" diagnostics="errorCode.FIG4-CRED-RLF-SAV-FRGN-TAX-AMO.0 transactional.FIG4-CRED-RLF-SAV-FRGN-TAX-AMO.0 transactional.en.FIG4-CRED-RLF-SAV-FRGN-TAX-AMO.0 ">[FORF] should be present if [FORC]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p399">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:ForeignTaxPaid/MTR:ClaimToFTCRAmountChargable">
        <sch:assert test=". &gt; sum(../MTR:ClaimToFTCRForeignTax)" id="a_FIG4-CRED-RLF-SAV-UK-CHRG-AMO.1" diagnostics="errorCode.FIG4-CRED-RLF-SAV-UK-CHRG-AMO.1 transactional.FIG4-CRED-RLF-SAV-UK-CHRG-AMO.1 transactional.en.FIG4-CRED-RLF-SAV-UK-CHRG-AMO.1 ">[FORF] should exceed [FORC]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p400">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:NumberOfYearsSincePolicyMade">
        <sch:assert test="../MTR:ForeignLifeInsuranceGains" id="a_FIG-YEARS-ON-FOREIGN-CE-GAINS.1" diagnostics="errorCode.FIG-YEARS-ON-FOREIGN-CE-GAINS.1 transactional.FIG-YEARS-ON-FOREIGN-CE-GAINS.1 transactional.en.FIG-YEARS-ON-FOREIGN-CE-GAINS.1 ">If number of years since policy made is present the following should be true: [FOR43]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p401">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:TaxTreatedAsPaid">
        <sch:assert test=". &lt; sum(../MTR:ForeignLifeInsuranceGains)" id="a_FIG-NOTNAL-IT-FOREIGN-CE-GAINS.1" diagnostics="errorCode.FIG-NOTNAL-IT-FOREIGN-CE-GAINS.1 transactional.FIG-NOTNAL-IT-FOREIGN-CE-GAINS.1 transactional.en.FIG-NOTNAL-IT-FOREIGN-CE-GAINS.1 ">[FOR45] should be less than [FOR43]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p402">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:NonSavingsIncomeNRSItrusts/MTR:IncomeSource/MTR:IncomeBeforeTax">
        <sch:assert test="../MTR:TaxableAmountOnInterestAndOtherSavings" id="a_FIG-NS-NRSIT-GROSS-AMO.1" diagnostics="errorCode.FIG-NS-NRSIT-GROSS-AMO.1 transactional.FIG-NS-NRSIT-GROSS-AMO.1 transactional.en.FIG-NS-NRSIT-GROSS-AMO.1 ">[FOR48F (pseudo)] must be present if [FOR48B] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p403">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:NonSavingsIncomeNRSItrusts/MTR:IncomeSource/MTR:ForeignTax">
        <sch:assert test=". &lt;= sum(../MTR:IncomeBeforeTax)" id="a_FIG-NS-NRSIT-FOR-TAX-AMO.0" diagnostics="errorCode.FIG-NS-NRSIT-FOR-TAX-AMO.0 transactional.FIG-NS-NRSIT-FOR-TAX-AMO.0 transactional.en.FIG-NS-NRSIT-FOR-TAX-AMO.0 ">[FOR48C] is valid only if this does not exceed [FOR48B]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p404">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:NonSavingsIncomeNRSItrusts/MTR:IncomeSource/MTR:SpecialWithholdingTax">
        <sch:assert test="../../../../MTR:UnremittableIncome = &apos;yes&apos; or . &lt;= ../MTR:IncomeBeforeTax" id="a_FIG-NS-NRSIT-UK-TAX-AMO.0" diagnostics="errorCode.FIG-NS-NRSIT-UK-TAX-AMO.0 transactional.FIG-NS-NRSIT-UK-TAX-AMO.0 transactional.en.FIG-NS-NRSIT-UK-TAX-AMO.0 ">If [FOR1] is not 'Y' then [FOR48D (pseudo)] must be less than or equal to [FOR48B]</sch:assert>
        <sch:assert test="../../MTR:Totals/MTR:SWTOrUKTax" id="a_FIG-NS-NRSIT-UK-TAX-AMO.1" diagnostics="errorCode.FIG-NS-NRSIT-UK-TAX-AMO.1 transactional.FIG-NS-NRSIT-UK-TAX-AMO.1 transactional.en.FIG-NS-NRSIT-UK-TAX-AMO.1 ">[FOR47] should be present if [FOR48D (pseudo)] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p405">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:NonSavingsIncomeNRSItrusts/MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings">
        <sch:assert test="not(../MTR:ClaimToFTCR = &apos;yes&apos;) or (math:abs((.) - (../MTR:IncomeBeforeTax)) &lt; 0.001)" id="a_FIG-NS-NRSIT-UK-CHRG-AMO.0" diagnostics="errorCode.FIG-NS-NRSIT-UK-CHRG-AMO.0 transactional.FIG-NS-NRSIT-UK-CHRG-AMO.0 transactional.en.FIG-NS-NRSIT-UK-CHRG-AMO.0 ">If [FOR48E] is 'Y' then [FOR48F (pseudo)] must eq [FOR48B]</sch:assert>
        <sch:assert test="../MTR:ClaimToFTCR or (math:abs(((.)) - ((sum(../MTR:IncomeBeforeTax) - ../MTR:ForeignTax))) &lt; 0.001)" id="a_FIG-NS-NRSIT-UK-CHRG-AMO.1" diagnostics="errorCode.FIG-NS-NRSIT-UK-CHRG-AMO.1 transactional.FIG-NS-NRSIT-UK-CHRG-AMO.1 transactional.en.FIG-NS-NRSIT-UK-CHRG-AMO.1 ">If [FOR48E] is not 'Y' then [FOR48F (pseudo)] must eq [FOR48B] minus [FOR48C]</sch:assert>
        <sch:assert test="../../MTR:Totals/MTR:TaxableAmount" id="a_FIG-NS-NRSIT-UK-CHRG-AMO.2" diagnostics="errorCode.FIG-NS-NRSIT-UK-CHRG-AMO.2 transactional.FIG-NS-NRSIT-UK-CHRG-AMO.2 transactional.en.FIG-NS-NRSIT-UK-CHRG-AMO.2 ">[FOR48] should be present if [FOR48F (pseudo)] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p406">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:NonSavingsIncomeNRSItrusts/MTR:Totals/MTR:SWTOrUKTax">
        <sch:assert test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:SpecialWithholdingTax )) &lt;= 1.001" id="a_SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.4" diagnostics="errorCode.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.4 transactional.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.4 transactional.en.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.4 ">Total of all iterations of box SpecialWithholdingTax</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p407">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:NonSavingsIncomeNRSItrusts/MTR:Totals/MTR:TaxableAmount">
        <sch:assert test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings )) &lt;= 1.001" id="a_TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.4" diagnostics="errorCode.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.4 transactional.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.4 transactional.en.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.4 ">Total of all iterations of box TaxableAmountOnInterestAndOtherSavings</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p408">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:NonSavingsIncomeNRSItrusts/MTR:NonSavingsIncomeNRSItrustsTotalClaimedFIGregime">
        <sch:assert test=". &lt;= sum(../MTR:Totals/MTR:TaxableAmount)" id="a_FIG-NS-NRSIT-TOT-AMO-FIG-CLM.0" diagnostics="errorCode.FIG-NS-NRSIT-TOT-AMO-FIG-CLM.0 transactional.FIG-NS-NRSIT-TOT-AMO-FIG-CLM.0 transactional.en.FIG-NS-NRSIT-TOT-AMO-FIG-CLM.0 ">[FOR48.1] is valid only if this does not exceed [FOR48]</sch:assert>
        <sch:assert test="not(../../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_FIG-NS-NRSIT-TOT-AMO-FIG-CLM.1" diagnostics="errorCode.FIG-NS-NRSIT-TOT-AMO-FIG-CLM.1 transactional.FIG-NS-NRSIT-TOT-AMO-FIG-CLM.1 transactional.en.FIG-NS-NRSIT-TOT-AMO-FIG-CLM.1 ">If [FOR48.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
        <sch:assert test="not((math:abs((.) - (../MTR:Totals/MTR:TaxableAmount)) &lt; 0.001)) or not(../MTR:IncomeSource/MTR:ClaimToFTCR)" id="a_FIG-NS-NRSIT-TOT-AMO-FIG-CLM.2" diagnostics="errorCode.FIG-NS-NRSIT-TOT-AMO-FIG-CLM.2 transactional.FIG-NS-NRSIT-TOT-AMO-FIG-CLM.2 transactional.en.FIG-NS-NRSIT-TOT-AMO-FIG-CLM.2 ">If [FOR48.1] is present and equal to [FOR48] then all iterations of [FOR48E] must not be 'Y'</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p409">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:OverseasResidentialPropertyOrRestrictedFinanceCostsForNonResidentTrust">
        <sch:assert test="../MTR:NonSavingsIncomeNRSItrusts/MTR:Totals/MTR:TaxableAmount" id="a_FIG-ORPROP-FIN-COST-NRT.0" diagnostics="errorCode.FIG-ORPROP-FIN-COST-NRT.0 transactional.FIG-ORPROP-FIN-COST-NRT.0 transactional.en.FIG-ORPROP-FIN-COST-NRT.0 ">If [FOR49] is present the following should be true: [FOR48] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p410">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:SavingsIncomeNRSItrusts/MTR:IncomeSource/MTR:IncomeBeforeTax">
        <sch:assert test="../MTR:TaxableAmountOnInterestAndOtherSavings" id="a_FIG-SAV-NRSIT-GROSS-AMO.0" diagnostics="errorCode.FIG-SAV-NRSIT-GROSS-AMO.0 transactional.FIG-SAV-NRSIT-GROSS-AMO.0 transactional.en.FIG-SAV-NRSIT-GROSS-AMO.0 ">[FOR51F (pseudo)] should be present if [FOR51B] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p411">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:SavingsIncomeNRSItrusts/MTR:IncomeSource/MTR:ForeignTax">
        <sch:assert test=". &lt;= sum(../MTR:IncomeBeforeTax)" id="a_FIG-SAV-NRSIT-FOR-TAX-AMO.0" diagnostics="errorCode.FIG-SAV-NRSIT-FOR-TAX-AMO.0 transactional.FIG-SAV-NRSIT-FOR-TAX-AMO.0 transactional.en.FIG-SAV-NRSIT-FOR-TAX-AMO.0 ">[FOR51C] is valid only if this does not exceed [FOR51B]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p412">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:SavingsIncomeNRSItrusts/MTR:IncomeSource/MTR:SpecialWithholdingTax">
        <sch:assert test="../../MTR:Totals/MTR:SWTOrUKTax" id="a_FIG-SAV-NRSIT-UK-TAX-AMO.0" diagnostics="errorCode.FIG-SAV-NRSIT-UK-TAX-AMO.0 transactional.FIG-SAV-NRSIT-UK-TAX-AMO.0 transactional.en.FIG-SAV-NRSIT-UK-TAX-AMO.0 ">[FOR50] should be present if [FOR51D (pseudo)] is present</sch:assert>
        <sch:assert test="../../../../MTR:UnremittableIncome or (((.)) - (sum(../MTR:IncomeBeforeTax)) &lt; 0.001)" id="a_FIG-SAV-NRSIT-UK-TAX-AMO.1" diagnostics="errorCode.FIG-SAV-NRSIT-UK-TAX-AMO.1 transactional.FIG-SAV-NRSIT-UK-TAX-AMO.1 transactional.en.FIG-SAV-NRSIT-UK-TAX-AMO.1 ">If [FOR1] is not 'Y' then, if present, [FOR51D (pseudo)] must be less than or equal to [FOR51B]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p413">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:SavingsIncomeNRSItrusts/MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings">
        <sch:assert test="../../MTR:Totals/MTR:TaxableAmount" id="a_FIG-SAV-NRSIT-UK-CHRG-AMO.0" diagnostics="errorCode.FIG-SAV-NRSIT-UK-CHRG-AMO.0 transactional.FIG-SAV-NRSIT-UK-CHRG-AMO.0 transactional.en.FIG-SAV-NRSIT-UK-CHRG-AMO.0 ">[FOR51] should be present if [FOR51F (pseudo)] is present</sch:assert>
        <sch:assert test="not(../MTR:ClaimToFTCR) or (math:abs(((.)) - (sum(../MTR:IncomeBeforeTax))) &lt; 0.001)" id="a_FIG-SAV-NRSIT-UK-CHRG-AMO.1" diagnostics="errorCode.FIG-SAV-NRSIT-UK-CHRG-AMO.1 transactional.FIG-SAV-NRSIT-UK-CHRG-AMO.1 transactional.en.FIG-SAV-NRSIT-UK-CHRG-AMO.1 ">If [FOR51E] is 'Y' then [FOR51F (pseudo)] must eq [FOR51B]</sch:assert>
        <sch:assert test="../MTR:ClaimToFTCR or (math:abs(((.)) - ((sum(../MTR:IncomeBeforeTax) - sum(../MTR:ForeignTax)))) &lt; 0.001)" id="a_FIG-SAV-NRSIT-UK-CHRG-AMO.2" diagnostics="errorCode.FIG-SAV-NRSIT-UK-CHRG-AMO.2 transactional.FIG-SAV-NRSIT-UK-CHRG-AMO.2 transactional.en.FIG-SAV-NRSIT-UK-CHRG-AMO.2 ">If [FOR51E] is not 'Y' then [FOR51F (pseudo)] must eq [FOR51B] minus [FOR51C]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p414">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:SavingsIncomeNRSItrusts/MTR:Totals/MTR:SWTOrUKTax">
        <sch:assert test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:SpecialWithholdingTax )) &lt;= 1.001" id="a_SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.5" diagnostics="errorCode.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.5 transactional.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.5 transactional.en.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.5 ">Total of all iterations of box SpecialWithholdingTax</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p415">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:SavingsIncomeNRSItrusts/MTR:Totals/MTR:TaxableAmount">
        <sch:assert test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings )) &lt;= 1.001" id="a_TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.5" diagnostics="errorCode.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.5 transactional.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.5 transactional.en.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.5 ">Total of all iterations of box TaxableAmountOnInterestAndOtherSavings</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p416">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:SavingsIncomeNRSItrusts/MTR:SavingsIncomeNRSItrustsTotalClaimedFIGregime">
        <sch:assert test=". &lt;= sum(../MTR:Totals/MTR:TaxableAmount)" id="a_FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.0" diagnostics="errorCode.FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.0 transactional.FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.0 transactional.en.FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.0 ">[FOR51.1] is valid only if this does not exceed [FOR51]</sch:assert>
        <sch:assert test="not(../../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.1" diagnostics="errorCode.FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.1 transactional.FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.1 transactional.en.FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.1 ">If [FOR51.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
        <sch:assert test="not((math:abs((.) - (../MTR:Totals/MTR:TaxableAmount)) &lt; 0.001)) or not(../MTR:IncomeSource/MTR:ClaimToFTCR)" id="a_FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.2" diagnostics="errorCode.FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.2 transactional.FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.2 transactional.en.FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.2 ">If [FOR51.1] is present and equal to [FOR51] then all iterations of [FOR51E] must not be 'Y'</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p417">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:DividendIncomeNRSItrusts/MTR:IncomeSource/MTR:IncomeBeforeTax">
        <sch:assert test="../MTR:TaxableAmountOnInterestAndOtherSavings" id="a_FIG-DIV-NRSIT-GROSS-AMO.0" diagnostics="errorCode.FIG-DIV-NRSIT-GROSS-AMO.0 transactional.FIG-DIV-NRSIT-GROSS-AMO.0 transactional.en.FIG-DIV-NRSIT-GROSS-AMO.0 ">[FOR53F (pseudo)] should be present if [FOR53B] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p418">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:DividendIncomeNRSItrusts/MTR:IncomeSource/MTR:ForeignTax">
        <sch:assert test=". &lt;= sum(../MTR:IncomeBeforeTax)" id="a_FIG-DIV-NRSIT-FOR-TAX-AMO.0" diagnostics="errorCode.FIG-DIV-NRSIT-FOR-TAX-AMO.0 transactional.FIG-DIV-NRSIT-FOR-TAX-AMO.0 transactional.en.FIG-DIV-NRSIT-FOR-TAX-AMO.0 ">[FOR53C] is valid only if this does not exceed [FOR53B]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p419">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:DividendIncomeNRSItrusts/MTR:IncomeSource/MTR:SpecialWithholdingTax">
        <sch:assert test="../../MTR:Totals/MTR:SWTOrUKTax" id="a_FIG-DIV-NRSIT-UK-TAX-AMO.0" diagnostics="errorCode.FIG-DIV-NRSIT-UK-TAX-AMO.0 transactional.FIG-DIV-NRSIT-UK-TAX-AMO.0 transactional.en.FIG-DIV-NRSIT-UK-TAX-AMO.0 ">[FOR52] should be present if [FOR53D (pseudo)] is present</sch:assert>
        <sch:assert test="../../../../MTR:UnremittableIncome or (((.)) - ((sum(../MTR:IncomeBeforeTax))) &lt; 0.001)" id="a_FIG-DIV-NRSIT-UK-TAX-AMO.1" diagnostics="errorCode.FIG-DIV-NRSIT-UK-TAX-AMO.1 transactional.FIG-DIV-NRSIT-UK-TAX-AMO.1 transactional.en.FIG-DIV-NRSIT-UK-TAX-AMO.1 ">If [FOR1] is not 'Y' then, if present, [FOR53D (pseudo)] must be less than or equal to [FOR53B]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p420">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:DividendIncomeNRSItrusts/MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings">
        <sch:assert test="../../MTR:Totals/MTR:TaxableAmount" id="a_FIG-DIV-NRSIT-UK-CHRG-AMO.0" diagnostics="errorCode.FIG-DIV-NRSIT-UK-CHRG-AMO.0 transactional.FIG-DIV-NRSIT-UK-CHRG-AMO.0 transactional.en.FIG-DIV-NRSIT-UK-CHRG-AMO.0 ">[FOR53] should be present if [FOR53F (pseudo)] is present</sch:assert>
        <sch:assert test="not(../MTR:ClaimToFTCR) or (math:abs(((.)) - (sum(../MTR:IncomeBeforeTax))) &lt; 0.001)" id="a_FIG-DIV-NRSIT-UK-CHRG-AMO.1" diagnostics="errorCode.FIG-DIV-NRSIT-UK-CHRG-AMO.1 transactional.FIG-DIV-NRSIT-UK-CHRG-AMO.1 transactional.en.FIG-DIV-NRSIT-UK-CHRG-AMO.1 ">If [FOR53E] is 'Y' then [FOR53F (pseudo)] must eq [FOR53B]</sch:assert>
        <sch:assert test="../MTR:ClaimToFTCR or (math:abs((.) - ((sum(../MTR:IncomeBeforeTax) - sum(../MTR:ForeignTax)))) &lt; 0.001)" id="a_FIG-DIV-NRSIT-UK-CHRG-AMO.2" diagnostics="errorCode.FIG-DIV-NRSIT-UK-CHRG-AMO.2 transactional.FIG-DIV-NRSIT-UK-CHRG-AMO.2 transactional.en.FIG-DIV-NRSIT-UK-CHRG-AMO.2 ">If [FOR53E] is not 'Y' then [FOR53F (pseudo)] must eq [FOR53B] minus [FOR53C]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p421">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:DividendIncomeNRSItrusts/MTR:Totals/MTR:SWTOrUKTax">
        <sch:assert test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:SpecialWithholdingTax )) &lt;= 1.001" id="a_SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.6" diagnostics="errorCode.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.6 transactional.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.6 transactional.en.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.6 ">Total of all iterations of box SpecialWithholdingTax</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p422">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:DividendIncomeNRSItrusts/MTR:Totals/MTR:TaxableAmount">
        <sch:assert test="math:abs(number(.) - sum( ../../MTR:IncomeSource/MTR:TaxableAmountOnInterestAndOtherSavings )) &lt;= 1.001" id="a_TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.6" diagnostics="errorCode.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.6 transactional.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.6 transactional.en.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.6 ">Total of all iterations of box TaxableAmountOnInterestAndOtherSavings</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p423">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:DividendIncomeNRSItrusts/MTR:DividendIncomeNRSItrustsTotalClaimedFIGregime">
        <sch:assert test=". &lt;= sum(../MTR:Totals/MTR:TaxableAmount)" id="a_FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.0" diagnostics="errorCode.FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.0 transactional.FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.0 transactional.en.FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.0 ">[FOR53.1] is valid only if this does not exceed [FOR53]</sch:assert>
        <sch:assert test="not(../../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.1" diagnostics="errorCode.FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.1 transactional.FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.1 transactional.en.FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.1 ">If [FOR53.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
        <sch:assert test="not((math:abs((.) - (../MTR:Totals/MTR:TaxableAmount)) &lt; 0.001)) or not(../MTR:IncomeSource/MTR:ClaimToFTCR)" id="a_FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.2" diagnostics="errorCode.FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.2 transactional.FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.2 transactional.en.FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.2 ">If [FOR53.1] is present and equal to [FOR53] then all iterations of [FOR53E] must not be 'Y'</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p424">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:DiscretionaryIncomeArisingFromNSINRtrustsFIGregimeClaimAmount">
        <sch:assert test=". &lt;= sum(../MTR:DiscretionaryIncomeArisingFromNSINRtrusts)" id="a_FIG-DI-NSINRT-FIG-CLM.0" diagnostics="errorCode.FIG-DI-NSINRT-FIG-CLM.0 transactional.FIG-DI-NSINRT-FIG-CLM.0 transactional.en.FIG-DI-NSINRT-FIG-CLM.0 ">[FOR54.1] is valid only if this does not exceed [FOR54]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_FIG-DI-NSINRT-FIG-CLM.1" diagnostics="errorCode.FIG-DI-NSINRT-FIG-CLM.1 transactional.FIG-DI-NSINRT-FIG-CLM.1 transactional.en.FIG-DI-NSINRT-FIG-CLM.1 ">If [FOR54.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p425">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:CapitalSumsPaidToSettlorByTrusteesFIGregimeClaimAmount">
        <sch:assert test=". &lt;= sum(../MTR:CapitalSumsPaidToSettlorByTrustees)" id="a_FIG-CS-TRSTS-NR-SETT-FIG-CLM.0" diagnostics="errorCode.FIG-CS-TRSTS-NR-SETT-FIG-CLM.0 transactional.FIG-CS-TRSTS-NR-SETT-FIG-CLM.0 transactional.en.FIG-CS-TRSTS-NR-SETT-FIG-CLM.0 ">[FOR55.1] is valid only if this does not exceed [FOR55]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_FIG-CS-TRSTS-NR-SETT-FIG-CLM.1" diagnostics="errorCode.FIG-CS-TRSTS-NR-SETT-FIG-CLM.1 transactional.FIG-CS-TRSTS-NR-SETT-FIG-CLM.1 transactional.en.FIG-CS-TRSTS-NR-SETT-FIG-CLM.1 ">If [FOR55.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p426">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:GainsOnDisposalOfHoldingsInOffshoreFundFIGregimeClaimAmount">
        <sch:assert test=". &lt;= sum(../MTR:GainsOnDisposalOfHoldingsInOffshoreFund)" id="a_FIG-GOD-HOLD-OFF-FIG-CLM.0" diagnostics="errorCode.FIG-GOD-HOLD-OFF-FIG-CLM.0 transactional.FIG-GOD-HOLD-OFF-FIG-CLM.0 transactional.en.FIG-GOD-HOLD-OFF-FIG-CLM.0 ">[FOR56.1] is valid only if this does not exceed [FOR56]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_FIG-GOD-HOLD-OFF-FIG-CLM.1" diagnostics="errorCode.FIG-GOD-HOLD-OFF-FIG-CLM.1 transactional.FIG-GOD-HOLD-OFF-FIG-CLM.1 transactional.en.FIG-GOD-HOLD-OFF-FIG-CLM.1 ">If [FOR56.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p427">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:NonTradeIncomeFIGregimeClaimAmount">
        <sch:assert test=". &lt;= sum(../MTR:NonTradeIncome)" id="a_FIG-NON-TRADE-INC-FIG-CLM.0" diagnostics="errorCode.FIG-NON-TRADE-INC-FIG-CLM.0 transactional.FIG-NON-TRADE-INC-FIG-CLM.0 transactional.en.FIG-NON-TRADE-INC-FIG-CLM.0 ">[FOR57.1] is valid only if this does not exceed [FOR57]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_FIG-NON-TRADE-INC-FIG-CLM.1" diagnostics="errorCode.FIG-NON-TRADE-INC-FIG-CLM.1 transactional.FIG-NON-TRADE-INC-FIG-CLM.1 transactional.en.FIG-NON-TRADE-INC-FIG-CLM.1 ">If [FOR57.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p428">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:BenefitsReceivedByNonTransferorsUnderToAAFIGregimeClaimAmount">
        <sch:assert test=". &lt;= sum(../MTR:BenefitsReceivedByNonTransferorsUnderToAA)" id="a_FIG-BEN-NT-TOAA-FIG-CLM.0" diagnostics="errorCode.FIG-BEN-NT-TOAA-FIG-CLM.0 transactional.FIG-BEN-NT-TOAA-FIG-CLM.0 transactional.en.FIG-BEN-NT-TOAA-FIG-CLM.0 ">[FOR58.1] is valid only if this does not exceed [FOR58]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_FIG-BEN-NT-TOAA-FIG-CLM.1" diagnostics="errorCode.FIG-BEN-NT-TOAA-FIG-CLM.1 transactional.FIG-BEN-NT-TOAA-FIG-CLM.1 transactional.en.FIG-BEN-NT-TOAA-FIG-CLM.1 ">If [FOR58.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p429">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:BenefitsReceivedByTransferorMatchedToTPIorPFSItaxableUnderToAAFIGregimeClaimAmount">
        <sch:assert test=". &lt;= sum(../MTR:BenefitsReceivedByTransferorMatchedToTPIorPFSItaxableUnderToAA)" id="a_FIG-BEN-T-TPI-TOAA-FIG-CLM.0" diagnostics="errorCode.FIG-BEN-T-TPI-TOAA-FIG-CLM.0 transactional.FIG-BEN-T-TPI-TOAA-FIG-CLM.0 transactional.en.FIG-BEN-T-TPI-TOAA-FIG-CLM.0 ">[FOR59.1] is valid only if this does not exceed [FOR59]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_FIG-BEN-T-TPI-TOAA-FIG-CLM.1" diagnostics="errorCode.FIG-BEN-T-TPI-TOAA-FIG-CLM.1 transactional.FIG-BEN-T-TPI-TOAA-FIG-CLM.1 transactional.en.FIG-BEN-T-TPI-TOAA-FIG-CLM.1 ">If [FOR59.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p430">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:BenefitsChargeableUnderCloseFamilyMemberRulesFIGregimeClaimAmount">
        <sch:assert test=". &lt;= sum(../MTR:BenefitsChargeableUnderCloseFamilyMemberRules)" id="a_FIG-BEN-FMR-TOAA-FIG-CLM.0" diagnostics="errorCode.FIG-BEN-FMR-TOAA-FIG-CLM.0 transactional.FIG-BEN-FMR-TOAA-FIG-CLM.0 transactional.en.FIG-BEN-FMR-TOAA-FIG-CLM.0 ">[FOR60.1] is valid only if this does not exceed [FOR60]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_FIG-BEN-FMR-TOAA-FIG-CLM.1" diagnostics="errorCode.FIG-BEN-FMR-TOAA-FIG-CLM.1 transactional.FIG-BEN-FMR-TOAA-FIG-CLM.1 transactional.en.FIG-BEN-FMR-TOAA-FIG-CLM.1 ">If [FOR60.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p431">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:BenefitsChargeableUnderOnwardGiftsRulesUnderToAAFIGregimeClaimAmount">
        <sch:assert test=". &lt;= sum(../MTR:BenefitsChargeableUnderOnwardGiftsRulesUnderToAA)" id="a_FIG-BEN-OGR-TOAA-FIG-CLM.0" diagnostics="errorCode.FIG-BEN-OGR-TOAA-FIG-CLM.0 transactional.FIG-BEN-OGR-TOAA-FIG-CLM.0 transactional.en.FIG-BEN-OGR-TOAA-FIG-CLM.0 ">[FOR61.1] is valid only if this does not exceed [FOR61]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_FIG-BEN-OGR-TOAA-FIG-CLM.1" diagnostics="errorCode.FIG-BEN-OGR-TOAA-FIG-CLM.1 transactional.FIG-BEN-OGR-TOAA-FIG-CLM.1 transactional.en.FIG-BEN-OGR-TOAA-FIG-CLM.1 ">If [FOR61.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p432">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:BenefitsReceivedBySettlorMatchedToTTIorPFSIFIGregimeClaimAmount">
        <sch:assert test=". &lt;= sum(../MTR:BenefitsReceivedBySettlorMatchedToTTIorPFSI)" id="a_FIG-BEN-S-TTI-PFSI-FIG-CLM.0" diagnostics="errorCode.FIG-BEN-S-TTI-PFSI-FIG-CLM.0 transactional.FIG-BEN-S-TTI-PFSI-FIG-CLM.0 transactional.en.FIG-BEN-S-TTI-PFSI-FIG-CLM.0 ">[FOR62.1] is valid only if this does not exceed [FOR62]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_FIG-BEN-S-TTI-PFSI-FIG-CLM.1" diagnostics="errorCode.FIG-BEN-S-TTI-PFSI-FIG-CLM.1 transactional.FIG-BEN-S-TTI-PFSI-FIG-CLM.1 transactional.en.FIG-BEN-S-TTI-PFSI-FIG-CLM.1 ">If [FOR62.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p433">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:BenefitsReceivedByCloseFamilyMemberMatchedToTTIorPFSIFIGregimeClaimAmount">
        <sch:assert test=". &lt;= sum(../MTR:BenefitsReceivedByCloseFamilyMemberMatchedToTTIorPFSI)" id="a_FIG-BEN-CFM-TTI-PFSI-FIG-CLM.0" diagnostics="errorCode.FIG-BEN-CFM-TTI-PFSI-FIG-CLM.0 transactional.FIG-BEN-CFM-TTI-PFSI-FIG-CLM.0 transactional.en.FIG-BEN-CFM-TTI-PFSI-FIG-CLM.0 ">[FOR63.1] is valid only if this does not exceed [FOR63]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_FIG-BEN-CFM-TTI-PFSI-FIG-CLM.1" diagnostics="errorCode.FIG-BEN-CFM-TTI-PFSI-FIG-CLM.1 transactional.FIG-BEN-CFM-TTI-PFSI-FIG-CLM.1 transactional.en.FIG-BEN-CFM-TTI-PFSI-FIG-CLM.1 ">If [FOR63.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p434">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:BenefitsChargeableUnderOnwardGiftsRulesUnderSettlementsFIGregimeClaimAmount">
        <sch:assert test=". &lt;= sum(../MTR:BenefitsChargeableUnderOnwardGiftsRulesUnderSettlements)" id="a_FIG-BEN-OGR-SETTLE-FIG-CLM.0" diagnostics="errorCode.FIG-BEN-OGR-SETTLE-FIG-CLM.0 transactional.FIG-BEN-OGR-SETTLE-FIG-CLM.0 transactional.en.FIG-BEN-OGR-SETTLE-FIG-CLM.0 ">[FOR64.1] is valid only if this does not exceed [FOR64]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_FIG-BEN-OGR-SETTLE-FIG-CLM.1" diagnostics="errorCode.FIG-BEN-OGR-SETTLE-FIG-CLM.1 transactional.FIG-BEN-OGR-SETTLE-FIG-CLM.1 transactional.en.FIG-BEN-OGR-SETTLE-FIG-CLM.1 ">If [FOR64.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p320">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA106">
        <sch:assert test="not(MTR:OverseasLandAndPropertyIncomeDetails/MTR:TotalRentsAndOtherPropertyReceipts or MTR:OverseasLandAndPropertyIncomeDetails/MTR:PremiumsPaidForLease or MTR:OverseasLandAndPropertyIncomeDetails/MTR:AllowablePropertyExpenses) or MTR:OverseasLandAndPropertyIncomeDetails/MTR:NetProfitOrLoss" id="a_SA106.3" diagnostics="errorCode.SA106.3 transactional.SA106.3 transactional.en.SA106.3 ">net profit or loss should be present if [FOR14] or [FOR16] or [FOR17]</sch:assert>
        <sch:assert test="not((((sum(MTR:TotalAdjustedProfitOrLoss) - sum(MTR:LossBroughtForward))) - (0) &gt;= 0.001)) or MTR:TotalTaxableProfit" id="a_SA106.6" diagnostics="errorCode.SA106.6 transactional.SA106.6 transactional.en.SA106.6 ">total taxable profit should be present if ( [FOR25] minus [FOR26] ) exceeds 0</sch:assert>
        <sch:assert test="not(MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyAbroadForeignTax) or MTR:TotalForeignTaxTakenOff" id="a_SA106.7" diagnostics="errorCode.SA106.7 transactional.SA106.7 transactional.en.SA106.7 ">total foreign tax taken off should be present if [FOR30C]</sch:assert>
        <sch:assert test="not(MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyAbroadUKtaxTakenOff) or MTR:TotalSpecialWithholdingTax" id="a_SA106.8" diagnostics="errorCode.SA106.8 transactional.SA106.8 transactional.en.SA106.8 ">total Special Withholding Tax should be present if [FOR30D]</sch:assert>
        <sch:assert test="((sum(MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)) - (1000) &lt; 0.001)" id="a_SA106.9" diagnostics="errorCode.SA106.9 transactional.SA106.9 transactional.en.SA106.9 ">Total of all instances of [FOR14.1] must not exceed [£1,000]</sch:assert>
        <sch:assert test="count(MTR:OverseasLandAndPropertyIncomeDetails/MTR:TraditionalAccounting) = 0
          or
            count(MTR:OverseasLandAndPropertyIncomeDetails/MTR:TraditionalAccounting) = count(MTR:OverseasLandAndPropertyIncomeDetails)" id="a_PRE-CALC.n" diagnostics="errorCode.PRE-CALC.n transactional.PRE-CALC.n transactional.en.PRE-CALC.n ">All occurrences of [FOR14-FOR24.2 / FOR30A-FOR30F] must have the same value of [FOR14.2].</sch:assert>
        <sch:assert test="count(MTR:OverseasLandAndPropertyIncomeDetails/MTR:TraditionalAccounting) &gt; 0
            or
              ((sum(MTR:OverseasLandAndPropertyIncomeDetails/MTR:TotalRentsAndOtherPropertyReceipts) + sum(MTR:OverseasLandAndPropertyIncomeDetails/MTR:PremiumsPaidForLease) + sum(MTR:OverseasLandAndPropertyIncomeDetails/MTR:BalancingCharges)) - (150000) &lt; 0.001)" id="a_SA106.10" diagnostics="errorCode.SA106.10 transactional.SA106.10 transactional.en.SA106.10 ">Total across all instances of [FOR14], [FOR16] &amp; [FOR20] must not exceed [£150,000] if no [FOR14.2] is present</sch:assert>
        <sch:assert test="not(MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyAbroadTotalAmount) or MTR:TotalTaxableAmount" id="a_SA106.0" diagnostics="errorCode.SA106.0 transactional.SA106.0 transactional.en.SA106.0 ">[FOR30] should be present if [FOR30F] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p435">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA107/MTR:IncomeFromEstates/MTR:ForeignEstates/MTR:ForeignEstateIncomeFIGclaim">
        <sch:assert test=". &lt;= sum(../MTR:ForeignEstateIncome)" id="a_TRU-FRGN-ESTATE-INC-FIG-CLM.0" diagnostics="errorCode.TRU-FRGN-ESTATE-INC-FIG-CLM.0 transactional.TRU-FRGN-ESTATE-INC-FIG-CLM.0 transactional.en.TRU-FRGN-ESTATE-INC-FIG-CLM.0 ">[TRU22.1] is valid only if this does not exceed [TRU22]</sch:assert>
        <sch:assert test="not(../../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_TRU-FRGN-ESTATE-INC-FIG-CLM.1" diagnostics="errorCode.TRU-FRGN-ESTATE-INC-FIG-CLM.1 transactional.TRU-FRGN-ESTATE-INC-FIG-CLM.1 transactional.en.TRU-FRGN-ESTATE-INC-FIG-CLM.1 ">If [TRU22.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p438">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:ResidentialPropertyAndCarriedInterest/MTR:DisposalProceeds">
        <sch:assert test="../MTR:NumberOfDisposals" id="a_CAP-RES-PROPERTY-PROCEEDS-AMT.0" diagnostics="errorCode.CAP-RES-PROPERTY-PROCEEDS-AMT.0 transactional.CAP-RES-PROPERTY-PROCEEDS-AMT.0 transactional.en.CAP-RES-PROPERTY-PROCEEDS-AMT.0 ">If [CGT4] is present then [CGT3] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p439">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:ResidentialPropertyAndCarriedInterest/MTR:GainsOnResidentialPropertyInTheYear">
        <sch:assert test="../MTR:NumberOfDisposals" id="a_CAP-RES-PROPERTY-TOT-GAINS-AMT.0" diagnostics="errorCode.CAP-RES-PROPERTY-TOT-GAINS-AMT.0 transactional.CAP-RES-PROPERTY-TOT-GAINS-AMT.0 transactional.en.CAP-RES-PROPERTY-TOT-GAINS-AMT.0 ">If [CGT6] is present then [CGT3] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p440">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:ResidentialPropertyAndCarriedInterest/MTR:GainsOnResidentialPropertyFIGclaim">
        <sch:assert test=". &lt;= sum(../MTR:GainsOnResidentialPropertyInTheYear)" id="a_CAP-RES-PROP-TOT-GAINS-FIG-CLM.0" diagnostics="errorCode.CAP-RES-PROP-TOT-GAINS-FIG-CLM.0 transactional.CAP-RES-PROP-TOT-GAINS-FIG-CLM.0 transactional.en.CAP-RES-PROP-TOT-GAINS-FIG-CLM.0 ">[CGT6.1] is valid only if this does not exceed [CGT6]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_CAP-RES-PROP-TOT-GAINS-FIG-CLM.1" diagnostics="errorCode.CAP-RES-PROP-TOT-GAINS-FIG-CLM.1 transactional.CAP-RES-PROP-TOT-GAINS-FIG-CLM.1 transactional.en.CAP-RES-PROP-TOT-GAINS-FIG-CLM.1 ">If [CGT6.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p441">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:ResidentialPropertyAndCarriedInterest/MTR:LossesInTheYear">
        <sch:assert test="../MTR:NumberOfDisposals" id="a_CAP-RES-PROPERTY-TOT-LOSS-AMT.0" diagnostics="errorCode.CAP-RES-PROPERTY-TOT-LOSS-AMT.0 transactional.CAP-RES-PROPERTY-TOT-LOSS-AMT.0 transactional.en.CAP-RES-PROPERTY-TOT-LOSS-AMT.0 ">If [CGT7] is present then [CGT3] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p442">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:ResidentialPropertyAndCarriedInterest/MTR:GainOrLossFromUKpropertyDisposal">
        <sch:assert test="not((.) &gt; 0) or ../MTR:GainsOnResidentialPropertyInTheYear" id="a_CAP-RES-PPTY-PDR-REP.0" diagnostics="errorCode.CAP-RES-PPTY-PDR-REP.0 transactional.CAP-RES-PPTY-PDR-REP.0 transactional.en.CAP-RES-PPTY-PDR-REP.0 ">If [CGT9] is positive then [CGT6] must be present.</sch:assert>
        <sch:assert test="not((.) &lt; 0) or ../MTR:LossesInTheYear" id="a_CAP-RES-PPTY-PDR-REP.1" diagnostics="errorCode.CAP-RES-PPTY-PDR-REP.1 transactional.CAP-RES-PPTY-PDR-REP.1 transactional.en.CAP-RES-PPTY-PDR-REP.1 ">If [CGT9] is negative then [CGT7] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p443">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:ResidentialPropertyAndCarriedInterest/MTR:UKpropertyDisposalTaxAlreadyCharged">
        <sch:assert test="../MTR:GainOrLossFromUKpropertyDisposal" id="a_CAP-RES-PPTY-PDR-TAX-CHARGED.0" diagnostics="errorCode.CAP-RES-PPTY-PDR-TAX-CHARGED.0 transactional.CAP-RES-PPTY-PDR-TAX-CHARGED.0 transactional.en.CAP-RES-PPTY-PDR-TAX-CHARGED.0 ">If [CGT10] is present the following should be true: [CGT9] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p444">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:ResidentialPropertyAndCarriedInterest/MTR:GainOrLossFromRTTreturn">
        <sch:assert test="not((.) &gt; 0) or ../MTR:GainsOnResidentialPropertyInTheYear" id="a_CAP-RES-PROPERTY-RTT-GAIN.0" diagnostics="errorCode.CAP-RES-PROPERTY-RTT-GAIN.0 transactional.CAP-RES-PROPERTY-RTT-GAIN.0 transactional.en.CAP-RES-PROPERTY-RTT-GAIN.0 ">If [CGT11] is positive then [CGT6] must be present.</sch:assert>
        <sch:assert test="not((.) &lt; 0) or ../MTR:LossesInTheYear" id="a_CAP-RES-PROPERTY-RTT-GAIN.2" diagnostics="errorCode.CAP-RES-PROPERTY-RTT-GAIN.2 transactional.CAP-RES-PROPERTY-RTT-GAIN.2 transactional.en.CAP-RES-PROPERTY-RTT-GAIN.2 ">If [CGT11] is negative then [CGT7] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p445">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:ResidentialPropertyAndCarriedInterest/MTR:RTTtaxAlreadyCharged">
        <sch:assert test="../MTR:GainOrLossFromRTTreturn" id="a_CAP-RES-PPTY-RTT-TAX-CHARGED.0" diagnostics="errorCode.CAP-RES-PPTY-RTT-TAX-CHARGED.0 transactional.CAP-RES-PPTY-RTT-TAX-CHARGED.0 transactional.en.CAP-RES-PPTY-RTT-TAX-CHARGED.0 ">If [CGT12] is present then [CGT11] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p446">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:ResidentialPropertyAndCarriedInterest/MTR:CarriedInterestArisingBasis">
        <sch:assert test="../MTR:GainsOnCarriedInterestInTheYear" id="a_CAP-RES-PPTY-CARRIED-INTEREST.0" diagnostics="errorCode.CAP-RES-PPTY-CARRIED-INTEREST.0 transactional.CAP-RES-PPTY-CARRIED-INTEREST.0 transactional.en.CAP-RES-PPTY-CARRIED-INTEREST.0 ">[CGT13B] should be present if [CGT13] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p447">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:ResidentialPropertyAndCarriedInterest/MTR:CarriedInterestAccrualsBasis">
        <sch:assert test="../MTR:GainsOnCarriedInterestInTheYear" id="a_CAP-RES-PPTY-CI-ACCRUALS.0" diagnostics="errorCode.CAP-RES-PPTY-CI-ACCRUALS.0 transactional.CAP-RES-PPTY-CI-ACCRUALS.0 transactional.en.CAP-RES-PPTY-CI-ACCRUALS.0 ">[CGT13B] should be present if [CGT13A] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p448">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:ResidentialPropertyAndCarriedInterest/MTR:GainsOnCarriedInterestFIGclaim">
        <sch:assert test=". &lt;= sum(../MTR:GainsOnCarriedInterestInTheYear)" id="a_CAP-RES-PPTY-CI-FIG-CLM.0" diagnostics="errorCode.CAP-RES-PPTY-CI-FIG-CLM.0 transactional.CAP-RES-PPTY-CI-FIG-CLM.0 transactional.en.CAP-RES-PPTY-CI-FIG-CLM.0 ">[CGT13C] is valid only if this does not exceed [CGT13B]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_CAP-RES-PPTY-CI-FIG-CLM.1" diagnostics="errorCode.CAP-RES-PPTY-CI-FIG-CLM.1 transactional.CAP-RES-PPTY-CI-FIG-CLM.1 transactional.en.CAP-RES-PPTY-CI-FIG-CLM.1 ">If [CGT13C] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p437">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:ResidentialPropertyAndCarriedInterest">
        <sch:assert test="(.)/*" id="a_RIM-CGT-PROPERTY-RES.1" diagnostics="errorCode.RIM-CGT-PROPERTY-RES.1 transactional.RIM-CGT-PROPERTY-RES.1 transactional.en.RIM-CGT-PROPERTY-RES.1 ">[CGT3-13C] should contain at least one element.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p450">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:Cryptoassets/MTR:NumberOfDisposals">
        <sch:assert test="../MTR:GainsInTheYear or ../MTR:LossesInTheYear or ../MTR:GainFromRTTreturn" id="a_CAP-CRYPTO-QUA.0" diagnostics="errorCode.CAP-CRYPTO-QUA.0 transactional.CAP-CRYPTO-QUA.0 transactional.en.CAP-CRYPTO-QUA.0 ">If [CGT13.1] is present then at least one of [CGT13.4], [CGT13.5] or [CGT13.7] must be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p451">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:Cryptoassets/MTR:GainFromRTTreturn">
        <sch:assert test="not((.) &gt; 0) or (../MTR:GainsInTheYear &gt; 0)" id="a_CAP-CRYPTO-RTT-GAIN.0" diagnostics="errorCode.CAP-CRYPTO-RTT-GAIN.0 transactional.CAP-CRYPTO-RTT-GAIN.0 transactional.en.CAP-CRYPTO-RTT-GAIN.0 ">If [CGT13.7] is positive then [CGT13.4] should be present and positive.</sch:assert>
        <sch:assert test="not(
                   (.) &gt; 0
                    and
                  (((.)) - (sum(../MTR:GainsInTheYear)) &gt;= 0.001)
                )" id="a_CAP-CRYPTO-RTT-GAIN.1" diagnostics="errorCode.CAP-CRYPTO-RTT-GAIN.1 transactional.CAP-CRYPTO-RTT-GAIN.1 transactional.en.CAP-CRYPTO-RTT-GAIN.1 ">If [CGT13.7] is positive it should not exceed [CGT13.4].</sch:assert>
        <sch:assert test="not((.) &lt; 0) or (../MTR:LossesInTheYear &gt; 0)" id="a_CAP-CRYPTO-RTT-GAIN.2" diagnostics="errorCode.CAP-CRYPTO-RTT-GAIN.2 transactional.CAP-CRYPTO-RTT-GAIN.2 transactional.en.CAP-CRYPTO-RTT-GAIN.2 ">If [CGT13.7] is negative then [CGT13.5] should be present and positive.</sch:assert>
        <sch:assert test="not(
                   (.) &lt; 0
                    and
                  ((math:abs((.))) - (sum(../MTR:LossesInTheYear)) &gt;= 0.001)
                )" id="a_CAP-CRYPTO-RTT-GAIN.3" diagnostics="errorCode.CAP-CRYPTO-RTT-GAIN.3 transactional.CAP-CRYPTO-RTT-GAIN.3 transactional.en.CAP-CRYPTO-RTT-GAIN.3 ">If [CGT13.7] is negative then its absolute value should not exceed [CGT13.5].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p449">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:Cryptoassets">
        <sch:assert test="(.)/*" id="a_RIM-CGT-CRYPTOASSETS.0" diagnostics="errorCode.RIM-CGT-CRYPTOASSETS.0 transactional.RIM-CGT-CRYPTOASSETS.0 transactional.en.RIM-CGT-CRYPTOASSETS.0 ">[CGT13.1-13.8] should contain at least one element.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p453">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:OtherPropertyAssetsAndGains/MTR:NumberOfDisposals">
        <sch:assert test="../MTR:GainsInTheYear or ../MTR:LossesInTheYear or ../MTR:GainFromRTTreturn" id="a_CAP3-TRANS-LAND-PPTY-QUA.0" diagnostics="errorCode.CAP3-TRANS-LAND-PPTY-QUA.0 transactional.CAP3-TRANS-LAND-PPTY-QUA.0 transactional.en.CAP3-TRANS-LAND-PPTY-QUA.0 ">If [CGT14] is present then at least one of [CGT17], [CGT19] or [CGT21] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p454">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:OtherPropertyAssetsAndGains/MTR:DisposalProceeds">
        <sch:assert test="../MTR:NumberOfDisposals" id="a_CAP-PROPERTY-PROCEEDS-AMT.0" diagnostics="errorCode.CAP-PROPERTY-PROCEEDS-AMT.0 transactional.CAP-PROPERTY-PROCEEDS-AMT.0 transactional.en.CAP-PROPERTY-PROCEEDS-AMT.0 ">If [CGT15] is present then [CGT14] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p455">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:OtherPropertyAssetsAndGains/MTR:GainsInTheYear">
        <sch:assert test="../MTR:NumberOfDisposals" id="a_CAP-PROPERTY-TOT-GAINS-AMT.0" diagnostics="errorCode.CAP-PROPERTY-TOT-GAINS-AMT.0 transactional.CAP-PROPERTY-TOT-GAINS-AMT.0 transactional.en.CAP-PROPERTY-TOT-GAINS-AMT.0 ">If [CGT17] is present then [CGT14] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p456">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:OtherPropertyAssetsAndGains/MTR:GainsFIGclaim">
        <sch:assert test=". &lt;= sum(../MTR:GainsInTheYear)" id="a_CAP-PROPERTY-TOT-GAINS-FIG-CLM.0" diagnostics="errorCode.CAP-PROPERTY-TOT-GAINS-FIG-CLM.0 transactional.CAP-PROPERTY-TOT-GAINS-FIG-CLM.0 transactional.en.CAP-PROPERTY-TOT-GAINS-FIG-CLM.0 ">[CGT17.0] is valid only if this does not exceed [CGT17]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_CAP-PROPERTY-TOT-GAINS-FIG-CLM.1" diagnostics="errorCode.CAP-PROPERTY-TOT-GAINS-FIG-CLM.1 transactional.CAP-PROPERTY-TOT-GAINS-FIG-CLM.1 transactional.en.CAP-PROPERTY-TOT-GAINS-FIG-CLM.1 ">If [CGT17.0] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p457">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:OtherPropertyAssetsAndGains/MTR:NonResidentialDisposalsIncludedInBox17">
        <sch:assert test="../MTR:GainsInTheYear" id="a_CAP-PROPERTY-GAIN-NR-LAND.0" diagnostics="errorCode.CAP-PROPERTY-GAIN-NR-LAND.0 transactional.CAP-PROPERTY-GAIN-NR-LAND.0 transactional.en.CAP-PROPERTY-GAIN-NR-LAND.0 ">If [CGT17.1] is present the following should be true: [CGT17] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p458">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:OtherPropertyAssetsAndGains/MTR:LandAndPropertyDisposalsWhereBADRisBeingClaimed">
        <sch:assert test="../MTR:GainsInTheYear" id="a_CAP-DISP-QUAL-BADR-RPROP.0" diagnostics="errorCode.CAP-DISP-QUAL-BADR-RPROP.0 transactional.CAP-DISP-QUAL-BADR-RPROP.0 transactional.en.CAP-DISP-QUAL-BADR-RPROP.0 ">If [CGT17.2] is present the following should be true: [CGT17] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p459">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:OtherPropertyAssetsAndGains/MTR:SharesDisposalsWhereBADRisBeingClaimed">
        <sch:assert test="../MTR:GainsInTheYear" id="a_CAP-DISP-QUAL-BADR-SHARES.0" diagnostics="errorCode.CAP-DISP-QUAL-BADR-SHARES.0 transactional.CAP-DISP-QUAL-BADR-SHARES.0 transactional.en.CAP-DISP-QUAL-BADR-SHARES.0 ">If [CGT17.3] is present the following should be true: [CGT17] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p460">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:OtherPropertyAssetsAndGains/MTR:OtherDisposalsWhereBADRisBeingClaimed">
        <sch:assert test="../MTR:GainsInTheYear" id="a_CAP-DISP-QUAL-BADR-OTHER.0" diagnostics="errorCode.CAP-DISP-QUAL-BADR-OTHER.0 transactional.CAP-DISP-QUAL-BADR-OTHER.0 transactional.en.CAP-DISP-QUAL-BADR-OTHER.0 ">If [CGT17.4] is present the following should be true: [CGT17] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p461">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:OtherPropertyAssetsAndGains/MTR:LossesInTheYear">
        <sch:assert test="../MTR:NumberOfDisposals" id="a_CAP-PROPERTY-TOT-LOSSES-AMT.0" diagnostics="errorCode.CAP-PROPERTY-TOT-LOSSES-AMT.0 transactional.CAP-PROPERTY-TOT-LOSSES-AMT.0 transactional.en.CAP-PROPERTY-TOT-LOSSES-AMT.0 ">If [CGT19] is present then [CGT14] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p462">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:OtherPropertyAssetsAndGains/MTR:GainFromRTTreturn">
        <sch:assert test="not((.) &gt; 0) or (../MTR:GainsInTheYear &gt; 0)" id="a_CAP-PROPERTY-RTT-GAIN.0" diagnostics="errorCode.CAP-PROPERTY-RTT-GAIN.0 transactional.CAP-PROPERTY-RTT-GAIN.0 transactional.en.CAP-PROPERTY-RTT-GAIN.0 ">If [CGT21] is positive then [CGT17] should be present and positive.</sch:assert>
        <sch:assert test="not(
                   (.) &gt; 0
                    and
                  (((.)) - (sum(../MTR:GainsInTheYear)) &gt;= 0.001)
                )" id="a_CAP-PROPERTY-RTT-GAIN.1" diagnostics="errorCode.CAP-PROPERTY-RTT-GAIN.1 transactional.CAP-PROPERTY-RTT-GAIN.1 transactional.en.CAP-PROPERTY-RTT-GAIN.1 ">If [CGT21] is positive it should not exceed [CGT17].</sch:assert>
        <sch:assert test="not((.) &lt; 0) or (../MTR:LossesInTheYear &gt; 0)" id="a_CAP-PROPERTY-RTT-GAIN.2" diagnostics="errorCode.CAP-PROPERTY-RTT-GAIN.2 transactional.CAP-PROPERTY-RTT-GAIN.2 transactional.en.CAP-PROPERTY-RTT-GAIN.2 ">If [CGT21] is negative then [CGT19] should be present and positive.</sch:assert>
        <sch:assert test="not(
                   (.) &lt; 0
                    and
                  ((math:abs((.))) - (sum(../MTR:LossesInTheYear)) &gt;= 0.001)
                )" id="a_CAP-PROPERTY-RTT-GAIN.3" diagnostics="errorCode.CAP-PROPERTY-RTT-GAIN.3 transactional.CAP-PROPERTY-RTT-GAIN.3 transactional.en.CAP-PROPERTY-RTT-GAIN.3 ">If [CGT21] is negative then its absolute value should not exceed [CGT19].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p463">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:OtherPropertyAssetsAndGains/MTR:RTTtaxAlreadyCharged">
        <sch:assert test="../MTR:GainFromRTTreturn" id="a_CAP-PROPERTY-RTT-TAX-CHARGED.0" diagnostics="errorCode.CAP-PROPERTY-RTT-TAX-CHARGED.0 transactional.CAP-PROPERTY-RTT-TAX-CHARGED.0 transactional.en.CAP-PROPERTY-RTT-TAX-CHARGED.0 ">If [CGT22] is present then [CGT21] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p452">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:OtherPropertyAssetsAndGains">
        <sch:assert test="(.)/*" id="a_RIM-CGT-PROPERTY-OTHER.1" diagnostics="errorCode.RIM-CGT-PROPERTY-OTHER.1 transactional.RIM-CGT-PROPERTY-OTHER.1 transactional.en.RIM-CGT-PROPERTY-OTHER.1 ">[CGT14-22] should contain at least one element.</sch:assert>
        <sch:assert test="(not(sum(MTR:LandAndPropertyDisposalsWhereBADRisBeingClaimed)) and not(sum(MTR:SharesDisposalsWhereBADRisBeingClaimed)) and not(sum(MTR:OtherDisposalsWhereBADRisBeingClaimed)))
            or
              ((sum(MTR:LandAndPropertyDisposalsWhereBADRisBeingClaimed) + sum(MTR:SharesDisposalsWhereBADRisBeingClaimed) + sum(MTR:OtherDisposalsWhereBADRisBeingClaimed)) - (sum(MTR:GainsInTheYear)) &lt; 0.001)" id="a_RIM-CGT-PROPERTY-OTHER.2" diagnostics="errorCode.RIM-CGT-PROPERTY-OTHER.2 transactional.RIM-CGT-PROPERTY-OTHER.2 transactional.en.RIM-CGT-PROPERTY-OTHER.2 ">If [CGT17.2] present or [CGT17.3] present or [CGT17.4] present then [CGT17.2] + [CGT17.3] + [CGT17.4] must be less than or equal to [CGT17]. This validation must run even if [CGT17.4] is absent</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p465">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:ListedSharesAndSecurities/MTR:NumberOfDisposals">
        <sch:assert test="../MTR:GainsInTheYear or ../MTR:LossesInTheYear or ../MTR:GainFromRTTreturn" id="a_CAP3-TRANS-QUOTED-SHARES-QUA.0" diagnostics="errorCode.CAP3-TRANS-QUOTED-SHARES-QUA.0 transactional.CAP3-TRANS-QUOTED-SHARES-QUA.0 transactional.en.CAP3-TRANS-QUOTED-SHARES-QUA.0 ">If [CGT23] is present then at least one of [CGT26], [CGT27] and [CGT29] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p466">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:ListedSharesAndSecurities/MTR:DisposalProceeds">
        <sch:assert test="../MTR:NumberOfDisposals" id="a_CAP4-QUOTED-SHARE-AMO.0" diagnostics="errorCode.CAP4-QUOTED-SHARE-AMO.0 transactional.CAP4-QUOTED-SHARE-AMO.0 transactional.en.CAP4-QUOTED-SHARE-AMO.0 ">If [CGT24] is present then [CGT23] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p467">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:ListedSharesAndSecurities/MTR:GainsInTheYear">
        <sch:assert test="../MTR:NumberOfDisposals" id="a_CAP-QUOTED-SHARE-TOT-GAINS-AMT.0" diagnostics="errorCode.CAP-QUOTED-SHARE-TOT-GAINS-AMT.0 transactional.CAP-QUOTED-SHARE-TOT-GAINS-AMT.0 transactional.en.CAP-QUOTED-SHARE-TOT-GAINS-AMT.0 ">If [CGT26] is present then [CGT23] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p468">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:ListedSharesAndSecurities/MTR:GainsFIGclaim">
        <sch:assert test=". &lt;= sum(../MTR:GainsInTheYear)" id="a_CAP-QUOTED-SHARE-TOT-FIG-CLM.0" diagnostics="errorCode.CAP-QUOTED-SHARE-TOT-FIG-CLM.0 transactional.CAP-QUOTED-SHARE-TOT-FIG-CLM.0 transactional.en.CAP-QUOTED-SHARE-TOT-FIG-CLM.0 ">[CGT26.1] is valid only if this does not exceed [CGT26]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_CAP-QUOTED-SHARE-TOT-FIG-CLM.1" diagnostics="errorCode.CAP-QUOTED-SHARE-TOT-FIG-CLM.1 transactional.CAP-QUOTED-SHARE-TOT-FIG-CLM.1 transactional.en.CAP-QUOTED-SHARE-TOT-FIG-CLM.1 ">If [CGT26.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p469">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:ListedSharesAndSecurities/MTR:LossesInTheYear">
        <sch:assert test="../MTR:NumberOfDisposals" id="a_CAP-QUOTED-SHARE-TOT-LOSS-AMT.0" diagnostics="errorCode.CAP-QUOTED-SHARE-TOT-LOSS-AMT.0 transactional.CAP-QUOTED-SHARE-TOT-LOSS-AMT.0 transactional.en.CAP-QUOTED-SHARE-TOT-LOSS-AMT.0 ">If [CGT27] is present then [CGT23] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p470">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:ListedSharesAndSecurities/MTR:GainFromRTTreturn">
        <sch:assert test="not((.) &gt; 0) or (../MTR:GainsInTheYear &gt; 0)" id="a_CAP-QUOTED-SHARE-RTT-GAIN.0" diagnostics="errorCode.CAP-QUOTED-SHARE-RTT-GAIN.0 transactional.CAP-QUOTED-SHARE-RTT-GAIN.0 transactional.en.CAP-QUOTED-SHARE-RTT-GAIN.0 ">If [CGT29] is positive then [CGT26] should be present and positive.</sch:assert>
        <sch:assert test="not(
                   (.) &gt; 0
                    and
                  (((.)) - (sum(../MTR:GainsInTheYear)) &gt;= 0.001)
                )" id="a_CAP-QUOTED-SHARE-RTT-GAIN.1" diagnostics="errorCode.CAP-QUOTED-SHARE-RTT-GAIN.1 transactional.CAP-QUOTED-SHARE-RTT-GAIN.1 transactional.en.CAP-QUOTED-SHARE-RTT-GAIN.1 ">If [CGT29] is positive it should not exceed [CGT26].</sch:assert>
        <sch:assert test="not((.) &lt; 0) or (../MTR:LossesInTheYear &gt; 0)" id="a_CAP-QUOTED-SHARE-RTT-GAIN.2" diagnostics="errorCode.CAP-QUOTED-SHARE-RTT-GAIN.2 transactional.CAP-QUOTED-SHARE-RTT-GAIN.2 transactional.en.CAP-QUOTED-SHARE-RTT-GAIN.2 ">If [CGT29] is negative then [CGT27] should be present and positive.</sch:assert>
        <sch:assert test="not(
                   (.) &lt; 0
                    and
                  ((math:abs((.))) - (sum(../MTR:LossesInTheYear)) &gt;= 0.001)
                )" id="a_CAP-QUOTED-SHARE-RTT-GAIN.3" diagnostics="errorCode.CAP-QUOTED-SHARE-RTT-GAIN.3 transactional.CAP-QUOTED-SHARE-RTT-GAIN.3 transactional.en.CAP-QUOTED-SHARE-RTT-GAIN.3 ">If [CGT29] is negative then its absolute value should not exceed [CGT27].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p471">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:ListedSharesAndSecurities/MTR:RTTtaxAlreadyCharged">
        <sch:assert test="../MTR:GainFromRTTreturn" id="a_CAP-QOTD-SHARE-RTT-TAX-CHARGED.0" diagnostics="errorCode.CAP-QOTD-SHARE-RTT-TAX-CHARGED.0 transactional.CAP-QOTD-SHARE-RTT-TAX-CHARGED.0 transactional.en.CAP-QOTD-SHARE-RTT-TAX-CHARGED.0 ">If [CGT30] is present then [CGT29] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p464">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:ListedSharesAndSecurities">
        <sch:assert test="(.)/*" id="a_RIM-CGT-LISTED-SHARES-SECURITIES.1" diagnostics="errorCode.RIM-CGT-LISTED-SHARES-SECURITIES.1 transactional.RIM-CGT-LISTED-SHARES-SECURITIES.1 transactional.en.RIM-CGT-LISTED-SHARES-SECURITIES.1 ">[CGT23-30] should contain at least one element.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p473">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:UnlistedSharesAndSecurities/MTR:NumberOfDisposals">
        <sch:assert test="../MTR:GainsInTheYear or ../MTR:LossesInTheYear or ../MTR:GainFromRTTreturn" id="a_CAP3-TRANS-UNQUOTED-SHARES-QUA.0" diagnostics="errorCode.CAP3-TRANS-UNQUOTED-SHARES-QUA.0 transactional.CAP3-TRANS-UNQUOTED-SHARES-QUA.0 transactional.en.CAP3-TRANS-UNQUOTED-SHARES-QUA.0 ">If [CGT31] is present then at least one of [CGT34], [CGT35] and [CGT37] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p474">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:UnlistedSharesAndSecurities/MTR:DisposalProceeds">
        <sch:assert test="../MTR:NumberOfDisposals" id="a_CAP-UNQOTD-SHARE-PROCEEDS-AMT.0" diagnostics="errorCode.CAP-UNQOTD-SHARE-PROCEEDS-AMT.0 transactional.CAP-UNQOTD-SHARE-PROCEEDS-AMT.0 transactional.en.CAP-UNQOTD-SHARE-PROCEEDS-AMT.0 ">If [CGT32] is present then [CGT31] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p475">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:UnlistedSharesAndSecurities/MTR:GainsInTheYear">
        <sch:assert test="../MTR:NumberOfDisposals" id="a_CAP-UNQOTD-SHARE-TOT-GAINS-AMT.0" diagnostics="errorCode.CAP-UNQOTD-SHARE-TOT-GAINS-AMT.0 transactional.CAP-UNQOTD-SHARE-TOT-GAINS-AMT.0 transactional.en.CAP-UNQOTD-SHARE-TOT-GAINS-AMT.0 ">If [CGT34] is present then [CGT31] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p476">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:UnlistedSharesAndSecurities/MTR:GainsFIGclaim">
        <sch:assert test=". &lt;= sum(../MTR:GainsInTheYear)" id="a_CAP-UNQOTD-SHARE-TOT-FIG-CLM.0" diagnostics="errorCode.CAP-UNQOTD-SHARE-TOT-FIG-CLM.0 transactional.CAP-UNQOTD-SHARE-TOT-FIG-CLM.0 transactional.en.CAP-UNQOTD-SHARE-TOT-FIG-CLM.0 ">[CGT34.1] is valid only if this does not exceed [CGT34]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_CAP-UNQOTD-SHARE-TOT-FIG-CLM.1" diagnostics="errorCode.CAP-UNQOTD-SHARE-TOT-FIG-CLM.1 transactional.CAP-UNQOTD-SHARE-TOT-FIG-CLM.1 transactional.en.CAP-UNQOTD-SHARE-TOT-FIG-CLM.1 ">If [CGT34.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p477">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:UnlistedSharesAndSecurities/MTR:LossesInTheYear">
        <sch:assert test="../MTR:NumberOfDisposals" id="a_CAP-UNQOTD-SHARE-TOT-LOSS-AMT.0" diagnostics="errorCode.CAP-UNQOTD-SHARE-TOT-LOSS-AMT.0 transactional.CAP-UNQOTD-SHARE-TOT-LOSS-AMT.0 transactional.en.CAP-UNQOTD-SHARE-TOT-LOSS-AMT.0 ">If [CGT35] is present then [CGT31] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p478">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:UnlistedSharesAndSecurities/MTR:GainFromRTTreturn">
        <sch:assert test="not((.) &gt; 0) or (../MTR:GainsInTheYear &gt; 0)" id="a_CAP-UNQOTD-SHARE-RTT-GAIN.0" diagnostics="errorCode.CAP-UNQOTD-SHARE-RTT-GAIN.0 transactional.CAP-UNQOTD-SHARE-RTT-GAIN.0 transactional.en.CAP-UNQOTD-SHARE-RTT-GAIN.0 ">If [CGT37] is positive then [CGT34] should be present and positive.</sch:assert>
        <sch:assert test="not(
                   (.) &gt; 0
                    and
                  (((.)) - (sum(../MTR:GainsInTheYear)) &gt;= 0.001)
                )" id="a_CAP-UNQOTD-SHARE-RTT-GAIN.1" diagnostics="errorCode.CAP-UNQOTD-SHARE-RTT-GAIN.1 transactional.CAP-UNQOTD-SHARE-RTT-GAIN.1 transactional.en.CAP-UNQOTD-SHARE-RTT-GAIN.1 ">If [CGT37] is positive it should not exceed [CGT34].</sch:assert>
        <sch:assert test="not((.) &lt; 0) or (../MTR:LossesInTheYear &gt; 0)" id="a_CAP-UNQOTD-SHARE-RTT-GAIN.2" diagnostics="errorCode.CAP-UNQOTD-SHARE-RTT-GAIN.2 transactional.CAP-UNQOTD-SHARE-RTT-GAIN.2 transactional.en.CAP-UNQOTD-SHARE-RTT-GAIN.2 ">If [CGT37] is negative then [CGT35] should be present and positive.</sch:assert>
        <sch:assert test="not(
                   (.) &lt; 0
                    and
                  ((math:abs((.))) - (sum(../MTR:LossesInTheYear)) &gt;= 0.001)
                )" id="a_CAP-UNQOTD-SHARE-RTT-GAIN.3" diagnostics="errorCode.CAP-UNQOTD-SHARE-RTT-GAIN.3 transactional.CAP-UNQOTD-SHARE-RTT-GAIN.3 transactional.en.CAP-UNQOTD-SHARE-RTT-GAIN.3 ">If [CGT37] is negative then its absolute value should not exceed [CGT35].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p479">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:UnlistedSharesAndSecurities/MTR:RTTtaxAlreadyCharged">
        <sch:assert test="../MTR:GainFromRTTreturn" id="a_CAP-UNQOTD-SHR-RTT-TAX-CHARGED.0" diagnostics="errorCode.CAP-UNQOTD-SHR-RTT-TAX-CHARGED.0 transactional.CAP-UNQOTD-SHR-RTT-TAX-CHARGED.0 transactional.en.CAP-UNQOTD-SHR-RTT-TAX-CHARGED.0 ">If [CGT38] is present then [CGT37] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p480">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:UnlistedSharesAndSecurities/MTR:GainsInvestedUnderSeedEIS">
        <sch:assert test=". &lt;= 100000" id="a_CAP-GAINS-INVEST-SEED-EIS-AMT.0" diagnostics="errorCode.CAP-GAINS-INVEST-SEED-EIS-AMT.0 transactional.CAP-GAINS-INVEST-SEED-EIS-AMT.0 transactional.en.CAP-GAINS-INVEST-SEED-EIS-AMT.0 ">[CGT40] should not exceed [£100,000]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p481">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:UnlistedSharesAndSecurities/MTR:LossesUsedAgainstReturnYearIncome">
        <sch:assert test="../MTR:LossesInTheYear" id="a_CAP-LOSS-SET-OFF-OTHER-INCOME.0" diagnostics="errorCode.CAP-LOSS-SET-OFF-OTHER-INCOME.0 transactional.CAP-LOSS-SET-OFF-OTHER-INCOME.0 transactional.en.CAP-LOSS-SET-OFF-OTHER-INCOME.0 ">If [CGT41] is present then [CGT35] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p482">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:UnlistedSharesAndSecurities/MTR:SEISandEISlossReliefInReturnYear">
        <sch:assert test="((.) - (sum(../MTR:LossesUsedAgainstReturnYearIncome)) &lt; 0.001)" id="a_CAP-UNCAPP-LOSS-SET-OFF-CY-AMT.0" diagnostics="errorCode.CAP-UNCAPP-LOSS-SET-OFF-CY-AMT.0 transactional.CAP-UNCAPP-LOSS-SET-OFF-CY-AMT.0 transactional.en.CAP-UNCAPP-LOSS-SET-OFF-CY-AMT.0 ">[CGT42] is valid only if this does not exceed [CGT41].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p483">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:UnlistedSharesAndSecurities/MTR:LossesUsedAgainstPreviousReturnYearIncome">
        <sch:assert test="../MTR:LossesInTheYear" id="a_CAP4-LOSS-SET-OFF-PREV-INC-AMO.0" diagnostics="errorCode.CAP4-LOSS-SET-OFF-PREV-INC-AMO.0 transactional.CAP4-LOSS-SET-OFF-PREV-INC-AMO.0 transactional.en.CAP4-LOSS-SET-OFF-PREV-INC-AMO.0 ">If [CGT43] is present then [CGT35] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p484">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:UnlistedSharesAndSecurities/MTR:SEISandEISlossReliefInPreviousReturnYear">
        <sch:assert test="((.) - (sum(../MTR:LossesUsedAgainstPreviousReturnYearIncome)) &lt; 0.001)" id="a_CAP-UNCAPP-LOSS-SET-OFF-PY-AMT.0" diagnostics="errorCode.CAP-UNCAPP-LOSS-SET-OFF-PY-AMT.0 transactional.CAP-UNCAPP-LOSS-SET-OFF-PY-AMT.0 transactional.en.CAP-UNCAPP-LOSS-SET-OFF-PY-AMT.0 ">[CGT44] is valid only if this does not exceed [CGT43].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p472">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:UnlistedSharesAndSecurities">
        <sch:assert test="(.)/*" id="a_RIM-CGT-UNLISTED-SHARES-SECURITIES.1" diagnostics="errorCode.RIM-CGT-UNLISTED-SHARES-SECURITIES.1 transactional.RIM-CGT-UNLISTED-SHARES-SECURITIES.1 transactional.en.RIM-CGT-UNLISTED-SHARES-SECURITIES.1 ">[CGT31-44] should contain at least one element.</sch:assert>
        <sch:assert test="not (MTR:LossesUsedAgainstReturnYearIncome or MTR:LossesUsedAgainstPreviousReturnYearIncome)
                or
              ((sum(MTR:LossesUsedAgainstReturnYearIncome) + sum(MTR:LossesUsedAgainstPreviousReturnYearIncome)) - (sum(MTR:LossesInTheYear)) &lt; 0.001)" id="a_RIM-CGT-UNLISTED-SHARES-SECURITIES.2" diagnostics="errorCode.RIM-CGT-UNLISTED-SHARES-SECURITIES.2 transactional.RIM-CGT-UNLISTED-SHARES-SECURITIES.2 transactional.en.RIM-CGT-UNLISTED-SHARES-SECURITIES.2 ">If [CGT41] or [CGT43] are present, [CGT41] plus [CGT43] should be less than or equal to [CGT35].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p486">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:LossesAndAdjustments/MTR:GainsQualifyingForInvestorsRelief">
        <sch:assert test=". &lt;= 1000000" id="a_CAP-INVESTORS-RELIEF-AMT.0" diagnostics="errorCode.CAP-INVESTORS-RELIEF-AMT.0 transactional.CAP-INVESTORS-RELIEF-AMT.0 transactional.en.CAP-INVESTORS-RELIEF-AMT.0 ">[CGT49] should not exceed [£1,000,000]</sch:assert>
        <sch:assert test=". &lt;= sum(../../MTR:UnlistedSharesAndSecurities/MTR:GainsInTheYear)" id="a_CAP-INVESTORS-RELIEF-AMT.1" diagnostics="errorCode.CAP-INVESTORS-RELIEF-AMT.1 transactional.CAP-INVESTORS-RELIEF-AMT.1 transactional.en.CAP-INVESTORS-RELIEF-AMT.1 ">[CGT49] is valid only if this does not exceed [CGT34]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p487">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:LossesAndAdjustments/MTR:GainsQualifyingForBusinessAssetDisposalRelief">
        <sch:assert test=". &lt;= 1000000" id="a_CAP-TOTAL-GAINS-BADR-AMT.0" diagnostics="errorCode.CAP-TOTAL-GAINS-BADR-AMT.0 transactional.CAP-TOTAL-GAINS-BADR-AMT.0 transactional.en.CAP-TOTAL-GAINS-BADR-AMT.0 ">[CGT50] is valid only if this does not exceed [£1,000,000]</sch:assert>
        <sch:assert test="../MTR:BADRandERclaimedToDate" id="a_CAP-TOTAL-GAINS-BADR-AMT.1" diagnostics="errorCode.CAP-TOTAL-GAINS-BADR-AMT.1 transactional.CAP-TOTAL-GAINS-BADR-AMT.1 transactional.en.CAP-TOTAL-GAINS-BADR-AMT.1 ">[CGT50.1] should be present if [CGT50] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p485">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:LossesAndAdjustments">
        <sch:assert test="(.)/*" id="a_RIM-CGT-LOSSES-ADJUSTMENTS.1" diagnostics="errorCode.RIM-CGT-LOSSES-ADJUSTMENTS.1 transactional.RIM-CGT-LOSSES-ADJUSTMENTS.1 transactional.en.RIM-CGT-LOSSES-ADJUSTMENTS.1 ">[CGT45-52] should contain at least one element.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p489">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:NRCGTonUKpropertyOrLandAndIndirectDisposals/MTR:GainsFromIndirectDisposals">
        <sch:assert test="../MTR:TotalGainsChargeableForDirectDisposalsForUKNRproperty" id="a_CAP-NRCGT-ID.0" diagnostics="errorCode.CAP-NRCGT-ID.0 transactional.CAP-NRCGT-ID.0 transactional.en.CAP-NRCGT-ID.0 ">If [CGT52.3] is present, [CGT52.2] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p490">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:NRCGTonUKpropertyOrLandAndIndirectDisposals/MTR:TaxOnGainsAlreadyCharged">
        <sch:assert test="../MTR:TotalGainsChargeableForDirectDisposalsForUKresidentialProperty or ../MTR:TotalGainsChargeableForDirectDisposalsForUKNRproperty" id="a_CAP-NRCGT-TAX-PAID.0" diagnostics="errorCode.CAP-NRCGT-TAX-PAID.0 transactional.CAP-NRCGT-TAX-PAID.0 transactional.en.CAP-NRCGT-TAX-PAID.0 ">If [CGT52.4] is present, [CGT52.1] or [CGT52.2] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p488">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:NRCGTonUKpropertyOrLandAndIndirectDisposals">
        <sch:assert test="(.)/*" id="a_RIM-CGT-NRCGT-UKL-PPTY.1" diagnostics="errorCode.RIM-CGT-NRCGT-UKL-PPTY.1 transactional.RIM-CGT-NRCGT-UKL-PPTY.1 transactional.en.RIM-CGT-NRCGT-UKL-PPTY.1 ">[CGT52.1-52.5] should contain at least one element.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p491">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:EISandQAHC/MTR:TotalGainsFromEIS">
        <sch:assert test="../../MTR:Cryptoassets/MTR:NumberOfDisposals or ../../MTR:OtherPropertyAssetsAndGains/MTR:NumberOfDisposals or ../../MTR:ListedSharesAndSecurities/MTR:NumberOfDisposals or ../../MTR:UnlistedSharesAndSecurities/MTR:NumberOfDisposals" id="a_CAP-EIS-GAIN.0" diagnostics="errorCode.CAP-EIS-GAIN.0 transactional.CAP-EIS-GAIN.0 transactional.en.CAP-EIS-GAIN.0 ">If [CGT52EG] is present the following should be true: [CGT13.1] is present or [CGT14] is present or [CGT23] is present or [CGT31] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p492">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:EISandQAHC/MTR:EISgainsFIGclaim">
        <sch:assert test=". &lt;= sum(../MTR:TotalGainsFromEIS)" id="a_CAP-EIS-FIG-CLM.0" diagnostics="errorCode.CAP-EIS-FIG-CLM.0 transactional.CAP-EIS-FIG-CLM.0 transactional.en.CAP-EIS-FIG-CLM.0 ">[CGT52EG.1] is valid only if this does not exceed [CGT52EG]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_CAP-EIS-FIG-CLM.1" diagnostics="errorCode.CAP-EIS-FIG-CLM.1 transactional.CAP-EIS-FIG-CLM.1 transactional.en.CAP-EIS-FIG-CLM.1 ">If [CGT52EG.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p493">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:EISandQAHC/MTR:TotalGainsFromQAHC">
        <sch:assert test="../../MTR:Cryptoassets/MTR:NumberOfDisposals or ../../MTR:OtherPropertyAssetsAndGains/MTR:NumberOfDisposals or ../../MTR:ListedSharesAndSecurities/MTR:NumberOfDisposals or ../../MTR:UnlistedSharesAndSecurities/MTR:NumberOfDisposals" id="a_CAP-QAHC-GAIN.0" diagnostics="errorCode.CAP-QAHC-GAIN.0 transactional.CAP-QAHC-GAIN.0 transactional.en.CAP-QAHC-GAIN.0 ">If [CGT52QG] is present the following should be true: [CGT13.1] is present or [CGT14] is present or [CGT23] is present or [CGT31] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p494">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:EISandQAHC/MTR:QAHCgainsFIGclaim">
        <sch:assert test=". &lt;= sum(../MTR:TotalGainsFromQAHC)" id="a_CAP-QAHC-FIG-CLM.0" diagnostics="errorCode.CAP-QAHC-FIG-CLM.0 transactional.CAP-QAHC-FIG-CLM.0 transactional.en.CAP-QAHC-FIG-CLM.0 ">[CGT52QG.1] is valid only if this does not exceed [CGT52QG]</sch:assert>
        <sch:assert test="not(../../../MTR:SA109/MTR:ResidenceStatus/MTR:NotResidentInUK) 
		  and 
		  (../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../../../MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)" id="a_CAP-QAHC-FIG-CLM.1" diagnostics="errorCode.CAP-QAHC-FIG-CLM.1 transactional.CAP-QAHC-FIG-CLM.1 transactional.en.CAP-QAHC-FIG-CLM.1 ">If [CGT52QG.1] is present, then [NRD1] should not be present and at least one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p495">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108/MTR:EISandQAHC/MTR:TotalLossesFromQAHC">
        <sch:assert test="../../MTR:Cryptoassets/MTR:NumberOfDisposals or ../../MTR:OtherPropertyAssetsAndGains/MTR:NumberOfDisposals or ../../MTR:ListedSharesAndSecurities/MTR:NumberOfDisposals or ../../MTR:UnlistedSharesAndSecurities/MTR:NumberOfDisposals" id="a_CAP-QAHC-LOSS.0" diagnostics="errorCode.CAP-QAHC-LOSS.0 transactional.CAP-QAHC-LOSS.0 transactional.en.CAP-QAHC-LOSS.0 ">If [CGT52QL] is present the following should be true: [CGT13.1] is present or [CGT14] is present or [CGT23] is present or [CGT31] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p436">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA108">
        <sch:assert test="../MTR:AttachedFiles or MTR:AnyOtherInformationSpace" id="a_MTR-ATTACHMENT-CGT.1" diagnostics="errorCode.MTR-ATTACHMENT-CGT.1 transactional.MTR-ATTACHMENT-CGT.1 transactional.en.MTR-ATTACHMENT-CGT.1 ">Submission must contain at least one attachment or an entry in the whitespace if Capital Gains Summary is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p497">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:ResidenceStatus/MTR:RequestForSplitYearTreatment">
        <sch:assert test="../MTR:SplitYearTreatmentDateFromWhichTheUKpartYearBeginsOrEnds" id="a_DOM4-SPLIT-YEAR-SIGNAL.0" diagnostics="errorCode.DOM4-SPLIT-YEAR-SIGNAL.0 transactional.DOM4-SPLIT-YEAR-SIGNAL.0 transactional.en.DOM4-SPLIT-YEAR-SIGNAL.0 ">[NRD6] should be present if [NRD3] is present</sch:assert>
        <sch:assert test="not(../MTR:NotResidentInUK)" id="a_DOM4-SPLIT-YEAR-SIGNAL.1" diagnostics="errorCode.DOM4-SPLIT-YEAR-SIGNAL.1 transactional.DOM4-SPLIT-YEAR-SIGNAL.1 transactional.en.DOM4-SPLIT-YEAR-SIGNAL.1 ">[NRD3] should not be present if [NRD1] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p498">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:ResidenceStatus/MTR:MoreThanOneCaseOfSplitYearTreatmentApplies">
        <sch:assert test="../MTR:RequestForSplitYearTreatment" id="a_DOM-MULTIPLE-SPLIT-YEAR-SIG.0" diagnostics="errorCode.DOM-MULTIPLE-SPLIT-YEAR-SIG.0 transactional.DOM-MULTIPLE-SPLIT-YEAR-SIG.0 transactional.en.DOM-MULTIPLE-SPLIT-YEAR-SIG.0 ">[NRD3] should be present if [NRD3.1] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p499">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:ResidenceStatus/MTR:SplitYearTreatmentDateFromWhichTheUKpartYearBeginsOrEnds">
        <sch:assert test="../MTR:RequestForSplitYearTreatment" id="a_DOM-PARTIAL-YEAR-DATE.0" diagnostics="errorCode.DOM-PARTIAL-YEAR-DATE.0 transactional.DOM-PARTIAL-YEAR-DATE.0 transactional.en.DOM-PARTIAL-YEAR-DATE.0 ">[NRD3] should be present if [NRD6] is present</sch:assert>
        <sch:assert test="(round(date:seconds(normalize-space(concat(2025, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))
                  and
                (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2026, &quot;-04-05&quot;))) div 86400))" id="a_DOM-PARTIAL-YEAR-DATE.1" diagnostics="errorCode.DOM-PARTIAL-YEAR-DATE.1 transactional.DOM-PARTIAL-YEAR-DATE.1 transactional.en.DOM-PARTIAL-YEAR-DATE.1 ">[NRD6] should be within the current return year</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p500">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:ResidenceStatus/MTR:MeetTheThirdAutomaticOverseasTest">
        <sch:assert test="../MTR:NotResidentInUK" id="a_DOM-AUTO-OVERSEAS-TEST-SIG.0" diagnostics="errorCode.DOM-AUTO-OVERSEAS-TEST-SIG.0 transactional.DOM-AUTO-OVERSEAS-TEST-SIG.0 transactional.en.DOM-AUTO-OVERSEAS-TEST-SIG.0 ">[NRD1] should be present if [NRD7] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p501">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:ResidenceStatus/MTR:HadAGapBetweenEmploymentsInThisTaxYear">
        <sch:assert test="../MTR:MeetTheThirdAutomaticOverseasTest" id="a_DOM-GAP-IN-EMPLOYMENTS-SIG.0" diagnostics="errorCode.DOM-GAP-IN-EMPLOYMENTS-SIG.0 transactional.DOM-GAP-IN-EMPLOYMENTS-SIG.0 transactional.en.DOM-GAP-IN-EMPLOYMENTS-SIG.0 ">[NRD8] should not be present if [NRD7] is not present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p502">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:TimeSpentInUK/MTR:NumberOfDaysDueToExceptionalCircumstances">
        <sch:assert test=". &lt;= sum(../MTR:NumberOfDaysSpentInUK)" id="a_DOM-UK-DAYS-EXCPTL-CIRC-IN-CY.2" diagnostics="errorCode.DOM-UK-DAYS-EXCPTL-CIRC-IN-CY.2 transactional.DOM-UK-DAYS-EXCPTL-CIRC-IN-CY.2 transactional.en.DOM-UK-DAYS-EXCPTL-CIRC-IN-CY.2 ">[NRD11] should not exceed [NRD10]</sch:assert>
        <sch:assert test="../MTR:NumberOfDaysSpentInUK" id="a_DOM-UK-DAYS-EXCPTL-CIRC-IN-CY.3" diagnostics="errorCode.DOM-UK-DAYS-EXCPTL-CIRC-IN-CY.3 transactional.DOM-UK-DAYS-EXCPTL-CIRC-IN-CY.3 transactional.en.DOM-UK-DAYS-EXCPTL-CIRC-IN-CY.3 ">If number of days due to exceptional circumstances is present the following should be true: [NRD10]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p503">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:FIGOWRTRF/MTR:UKresidentPriorToRecentArrival">
        <sch:assert test="(number(substring(string(.) , 1 , 4)) - number(substring(string(.) , 6 , 2))) mod 100 = 99" id="a_DOM-UK-RES-PRIOR-ARRIVAL.0" diagnostics="errorCode.DOM-UK-RES-PRIOR-ARRIVAL.0 transactional.DOM-UK-RES-PRIOR-ARRIVAL.0 transactional.en.DOM-UK-RES-PRIOR-ARRIVAL.0 ">Must be a valid pair of consecutive years in the format YYYY YY</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p504">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:QAHCincomeOrGains">
        <sch:assert test="../MTR:ClaimForReliefOnForeignIncomeUnderFIG or ../MTR:ClaimForReliefOnForeignGainsUnderFIG" id="a_DOM-FIG-QAHC-DEEMED-SIG.0" diagnostics="errorCode.DOM-FIG-QAHC-DEEMED-SIG.0 transactional.DOM-FIG-QAHC-DEEMED-SIG.0 transactional.en.DOM-FIG-QAHC-DEEMED-SIG.0 ">If [NRD30] is present then one of [NRD28] or [NRD29] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p506">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:OverseasWorkdayReliefOWR/MTR:OWRclaim">
        <sch:assert test="../MTR:QualifyingEmploymentIncomeAfterDeductions" id="a_DOM-OWR-CLAIM.0" diagnostics="errorCode.DOM-OWR-CLAIM.0 transactional.DOM-OWR-CLAIM.0 transactional.en.DOM-OWR-CLAIM.0 ">If [NRD41] is present, [NRD44] should be present</sch:assert>
        <sch:assert test="../MTR:QualifyingForeignEmploymentIncomeAfterDeductions" id="a_DOM-OWR-CLAIM.1" diagnostics="errorCode.DOM-OWR-CLAIM.1 transactional.DOM-OWR-CLAIM.1 transactional.en.DOM-OWR-CLAIM.1 ">If [NRD41] is present, [NRD46] should be present</sch:assert>
        <sch:assert test="../MTR:OWRclaimed" id="a_DOM-OWR-CLAIM.2" diagnostics="errorCode.DOM-OWR-CLAIM.2 transactional.DOM-OWR-CLAIM.2 transactional.en.DOM-OWR-CLAIM.2 ">If [NRD41] is present [NRD48] should be present</sch:assert>
        <sch:assert test="../MTR:TotalAmountReliefClaimed" id="a_DOM-OWR-CLAIM.3" diagnostics="errorCode.DOM-OWR-CLAIM.3 transactional.DOM-OWR-CLAIM.3 transactional.en.DOM-OWR-CLAIM.3 ">If [NRD41] is present [NRD49] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p507">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:OverseasWorkdayReliefOWR/MTR:QualifyingEmploymentIncomeAfterDeductions">
        <sch:assert test="../MTR:OWRclaim" id="a_DOM-OWR-QUAL-EI-AFT-DED.0" diagnostics="errorCode.DOM-OWR-QUAL-EI-AFT-DED.0 transactional.DOM-OWR-QUAL-EI-AFT-DED.0 transactional.en.DOM-OWR-QUAL-EI-AFT-DED.0 ">If [NRD44] is present then [NRD41] should be present</sch:assert>
        <sch:assert test="((.) - (sum(../../../MTR:SA102/MTR:Employment/MTR:PayFromEmployment) + sum(../../../MTR:SA102/MTR:Employment/MTR:TipsAndOtherPayments) + sum(../../../MTR:SA102/MTR:Benefits/MTR:CompanyCarsAndVansBenefit) + sum(../../../MTR:SA102/MTR:Benefits/MTR:FuelForCarsAndVans) + sum(../../../MTR:SA102/MTR:Benefits/MTR:PrivateMedicalDentalInsurance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:VouchersCreditCardsExcessMileageAllowance) + sum(../../../MTR:SA102/MTR:Benefits/MTR:GoodsEtcProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:AccommodationProvidedByEmployer) + sum(../../../MTR:SA102/MTR:Benefits/MTR:OtherBenefits) + sum(../../../MTR:SA102/MTR:Benefits/MTR:ExpensesPaymentsReceived) + sum(../../../MTR:SA102M/MTR:TaxableIncome/MTR:TaxableIncomeMinusExpenses) + sum(../../../MTR:SA101/MTR:SharesEmploymentCompensationsAndDeductions/MTR:ShareSchemesTaxableAmount) + sum(../../../MTR:SA101/MTR:SharesEmploymentCompensationsAndDeductions/MTR:LumpSums/MTR:LumpSumSalariesAndOtherPayments) + sum(../../../MTR:SA101/MTR:SharesEmploymentCompensationsAndDeductions/MTR:LumpSums/MTR:LumpSumsOrBenefitsFromRetirementSchemes) + sum(../../../MTR:SA101/MTR:SharesEmploymentCompensationsAndDeductions/MTR:LumpSums/MTR:RedundancyAndOtherCompensationPayments) + 1) &lt; 0.001)" id="a_DOM-OWR-QUAL-EI-AFT-DED.1" diagnostics="errorCode.DOM-OWR-QUAL-EI-AFT-DED.1 transactional.DOM-OWR-QUAL-EI-AFT-DED.1 transactional.en.DOM-OWR-QUAL-EI-AFT-DED.1 ">[NRD44] must not exceed by more than £1 the total of all instances of ([EMP1] + [EMP3] + [EMP9] + [EMP10] + [EMP11] + [EMP12] + [EMP13] + [EMP14] + [EMP15] + [EMP16] + [MOR38]) + [ASE1] + [ASE3] + [ASE4] + [ASE5]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p508">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:OverseasWorkdayReliefOWR/MTR:QualifyingForeignEmploymentIncomeAfterDeductions">
        <sch:assert test="../MTR:OWRclaim" id="a_DOM-OWR-QUAL-FOR-EI-AFT-DED.0" diagnostics="errorCode.DOM-OWR-QUAL-FOR-EI-AFT-DED.0 transactional.DOM-OWR-QUAL-FOR-EI-AFT-DED.0 transactional.en.DOM-OWR-QUAL-FOR-EI-AFT-DED.0 ">If [NRD46] is present [NRD41] should be present</sch:assert>
        <sch:assert test=". &lt;= sum(../MTR:QualifyingEmploymentIncomeAfterDeductions)" id="a_DOM-OWR-QUAL-FOR-EI-AFT-DED.1" diagnostics="errorCode.DOM-OWR-QUAL-FOR-EI-AFT-DED.1 transactional.DOM-OWR-QUAL-FOR-EI-AFT-DED.1 transactional.en.DOM-OWR-QUAL-FOR-EI-AFT-DED.1 ">[NRD46] is valid only if this does not exceed [NRD44]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p509">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:OverseasWorkdayReliefOWR/MTR:MaximumRelief">
        <sch:assert test="../MTR:OWRclaim" id="a_DOM-OWR-MAX-REL.0" diagnostics="errorCode.DOM-OWR-MAX-REL.0 transactional.DOM-OWR-MAX-REL.0 transactional.en.DOM-OWR-MAX-REL.0 ">If [NRD47] is present [NRD41] should be present</sch:assert>
        <sch:assert test="(../MTR:OWRtransitionalProvisionsClaim) 
		  or 
		(((.) - (300000) &lt; 0.001) and ((.) - ((sum(../MTR:QualifyingEmploymentIncomeAfterDeductions) * 0.30) + 1) &lt; 0.001))" id="a_DOM-OWR-MAX-REL.1" diagnostics="errorCode.DOM-OWR-MAX-REL.1 transactional.DOM-OWR-MAX-REL.1 transactional.en.DOM-OWR-MAX-REL.1 ">If [NRD43] is not present, [NRD47] if present must be less than or equal to the lower of ([NRD44] x [30%]) + £1 and [£300,000]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p510">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:OverseasWorkdayReliefOWR/MTR:OWRclaimed">
        <sch:assert test="../MTR:OWRclaim" id="a_DOM-OWR-CLAIMED-EMP-INC.0" diagnostics="errorCode.DOM-OWR-CLAIMED-EMP-INC.0 transactional.DOM-OWR-CLAIMED-EMP-INC.0 transactional.en.DOM-OWR-CLAIMED-EMP-INC.0 ">If [NRD48] is present [NRD41] should be present</sch:assert>
        <sch:assert test="(../MTR:OWRtransitionalProvisionsClaim) 
		  or 
		(((.) - (sum(../MTR:MaximumRelief)) &lt; 0.001) and ((.) - (sum(../MTR:QualifyingForeignEmploymentIncomeAfterDeductions)) &lt; 0.001))" id="a_DOM-OWR-CLAIMED-EMP-INC.1" diagnostics="errorCode.DOM-OWR-CLAIMED-EMP-INC.1 transactional.DOM-OWR-CLAIMED-EMP-INC.1 transactional.en.DOM-OWR-CLAIMED-EMP-INC.1 ">If [NRD43] is not present, [NRD48] if present must be less than or equal to the lower of [NRD46] and [NRD47]</sch:assert>
        <sch:assert test="not(../MTR:OWRtransitionalProvisionsClaim) 
		  or 
		(((.) - (sum(../MTR:QualifyingForeignEmploymentIncomeAfterDeductions)) &lt; 0.001))" id="a_DOM-OWR-CLAIMED-EMP-INC.2" diagnostics="errorCode.DOM-OWR-CLAIMED-EMP-INC.2 transactional.DOM-OWR-CLAIMED-EMP-INC.2 transactional.en.DOM-OWR-CLAIMED-EMP-INC.2 ">If [NRD43] is present, [NRD48] if present must be less than or equal to [NRD46]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p511">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:OverseasWorkdayReliefOWR/MTR:TotalAmountReliefClaimed">
        <sch:assert test="../MTR:OWRclaim" id="a_DOM-OWR-TOT-CLAIMED.0" diagnostics="errorCode.DOM-OWR-TOT-CLAIMED.0 transactional.DOM-OWR-TOT-CLAIMED.0 transactional.en.DOM-OWR-TOT-CLAIMED.0 ">If [NRD49] is present, [NRD41] should be present</sch:assert>
        <sch:assert test=". &gt;= sum(../MTR:OWRclaimed)" id="a_DOM-OWR-TOT-CLAIMED.1" diagnostics="errorCode.DOM-OWR-TOT-CLAIMED.1 transactional.DOM-OWR-TOT-CLAIMED.1 transactional.en.DOM-OWR-TOT-CLAIMED.1 ">[NRD49] is valid only when it is not less than [NRD48]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p505">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:OverseasWorkdayReliefOWR">
        <sch:assert test="not(MTR:OWRclaim and not(MTR:OWRtransitionalProvisionsClaim)) or MTR:MaximumRelief" id="a_RIM-OWR.0" diagnostics="errorCode.RIM-OWR.0 transactional.RIM-OWR.0 transactional.en.RIM-OWR.0 ">[NRD47] should be present if [NRD41] is present and [NRD43] is not present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p512">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:TemporaryRepatriationFacilityTRF/MTR:ElectionUnderTRF">
        <sch:assert test="not(../../MTR:ResidenceStatus/MTR:NotResidentInUK)" id="a_DOM-TRF-ELECTION.0" diagnostics="errorCode.DOM-TRF-ELECTION.0 transactional.DOM-TRF-ELECTION.0 transactional.en.DOM-TRF-ELECTION.0 ">[NRD50] should not be present if [NRD1] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p513">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:TemporaryRepatriationFacilityTRF/MTR:PersonalTRFdesignationAmount">
        <sch:assert test="not(../../MTR:ResidenceStatus/MTR:NotResidentInUK)" id="a_DOM-TRF-AMT-PERS-DES.0" diagnostics="errorCode.DOM-TRF-AMT-PERS-DES.0 transactional.DOM-TRF-AMT-PERS-DES.0 transactional.en.DOM-TRF-AMT-PERS-DES.0 ">[NRD51] should not be present if [NRD1] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p514">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:TemporaryRepatriationFacilityTRF/MTR:CapitalPaymentsAndBenefitsReceivedFromTrusts">
        <sch:assert test="not(../../MTR:ResidenceStatus/MTR:NotResidentInUK)" id="a_DOM-TRF-CP-BEN-TRUSTS.0" diagnostics="errorCode.DOM-TRF-CP-BEN-TRUSTS.0 transactional.DOM-TRF-CP-BEN-TRUSTS.0 transactional.en.DOM-TRF-CP-BEN-TRUSTS.0 ">[NRD52] should not be present if [NRD1] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p515">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109/MTR:TemporaryRepatriationFacilityTRF/MTR:PersonalTRFdesignationRemittedAmount">
        <sch:assert test="not(../../MTR:ResidenceStatus/MTR:NotResidentInUK)" id="a_DOM-TRF-AMT-PERS-DES-REMT.0" diagnostics="errorCode.DOM-TRF-AMT-PERS-DES-REMT.0 transactional.DOM-TRF-AMT-PERS-DES-REMT.0 transactional.en.DOM-TRF-AMT-PERS-DES-REMT.0 ">[NRD53] should not be present if [NRD1] is present</sch:assert>
        <sch:assert test="((.) - ((sum(../MTR:PersonalTRFdesignationAmount) + sum(../MTR:CapitalPaymentsAndBenefitsReceivedFromTrusts))) &lt; 0.001)" id="a_DOM-TRF-AMT-PERS-DES-REMT.1" diagnostics="errorCode.DOM-TRF-AMT-PERS-DES-REMT.1 transactional.DOM-TRF-AMT-PERS-DES-REMT.1 transactional.en.DOM-TRF-AMT-PERS-DES-REMT.1 ">[NRD53] is valid only if this does not exceed ( [NRD51] plus [NRD52] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p496">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA109">
        <sch:assert test="not(MTR:ResidenceStatus/MTR:NotResidentInUK) or MTR:TimeSpentInUK/MTR:NumberOfDaysSpentInUK" id="a_SA109.0" diagnostics="errorCode.SA109.0 transactional.SA109.0 transactional.en.SA109.0 ">number of days spent in UK should be present if [NRD1]</sch:assert>
        <sch:assert test="not(MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG)
		  or 
	  		(not(../MTR:SA100/MTR:Income/MTR:UKInterestAndDividends/MTR:UntaxedForeignInterest or ../MTR:SA100/MTR:Income/MTR:UKInterestAndDividends/MTR:ForeignDividends or ../MTR:SA100/MTR:Income/MTR:UKInterestAndDividends/MTR:TaxTakenOffForeignDividends))
	  	  and 
	  (../MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:TotalTaxableBusinessProfitsFIGclaim or 
	  ../MTR:SA103F/MTR:Losses/MTR:AdjustedLossForTheYearFIGclaim or
	  ../MTR:SA104F/MTR:ShareOfProfits/MTR:TotalTaxableBusinessProfitsFIGclaim or
	  ../MTR:SA104F/MTR:ShareOfLosses/MTR:AdjustedLossForYearFIGclaim or
	  ../MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:SavingsIncome/MTR:TotalUntaxedSavingsIncomeFIGclaim or
	  ../MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OffshoreFundsIncome/MTR:OffshoreFundTaxableIncomeFIGclaim or
	  ../MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedForeignIncome/MTR:TaxableProfitFIGclaim or
	  ../MTR:SA104F/MTR:ShareOfPartnershipIncome/MTR:ShareOfDividendIncome/MTR:TotalDividendIncomeFIGclaim or
	  ../MTR:SA104F/MTR:ShareOfPartnershipIncome/MTR:ShareOfOtherTaxedIncome/MTR:ShareOfOtherTaxedIncomeFIGclaim or
	  ../MTR:SA104F/MTR:ShareOfPartnershipIncome/MTR:TotalTaxedAndUntaxedIncomeFIGclaim or
	  ../MTR:SA106/MTR:OverseasSavings/MTR:InterestTotalClaimedFIGregime or
	  ../MTR:SA106/MTR:ForeignCompanies/MTR:DividendsTotalClaimedFIGregime or
	  ../MTR:SA106/MTR:OverseasPensions/MTR:PensionsTotalClaimedFIGregime or
	  ../MTR:SA106/MTR:OverseasDividendIncome/MTR:DividendFromOverseasTrustEtcTotalClaimedFIGregime or
	  ../MTR:SA106/MTR:OverseasTrustIncome/MTR:OverseasTrustsEtcOtherIncomeTotalClaimedFIGregime or
	  ../MTR:SA106/MTR:PropertyAbroadTotalClaimedFIGregime or
	  ../MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:NonSavingsIncomeNRSItrusts/MTR:NonSavingsIncomeNRSItrustsTotalClaimedFIGregime or
	  ../MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:SavingsIncomeNRSItrusts/MTR:SavingsIncomeNRSItrustsTotalClaimedFIGregime or
	  ../MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:DividendIncomeNRSItrusts/MTR:DividendIncomeNRSItrustsTotalClaimedFIGregime or
	  ../MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:DiscretionaryIncomeArisingFromNSINRtrustsFIGregimeClaimAmount or
	  ../MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:CapitalSumsPaidToSettlorByTrusteesFIGregimeClaimAmount or
	  ../MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:GainsOnDisposalOfHoldingsInOffshoreFundFIGregimeClaimAmount or
	  ../MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:NonTradeIncomeFIGregimeClaimAmount or
	  ../MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:BenefitsReceivedByNonTransferorsUnderToAAFIGregimeClaimAmount or
	  ../MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:BenefitsReceivedByTransferorMatchedToTPIorPFSItaxableUnderToAAFIGregimeClaimAmount or
	  ../MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:BenefitsChargeableUnderCloseFamilyMemberRulesFIGregimeClaimAmount or
	  ../MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:BenefitsChargeableUnderOnwardGiftsRulesUnderToAAFIGregimeClaimAmount or
	  ../MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:BenefitsReceivedBySettlorMatchedToTTIorPFSIFIGregimeClaimAmount or
	  ../MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:BenefitsReceivedByCloseFamilyMemberMatchedToTTIorPFSIFIGregimeClaimAmount or
	  ../MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:BenefitsChargeableUnderOnwardGiftsRulesUnderSettlementsFIGregimeClaimAmount or
	  ../MTR:SA107/MTR:IncomeFromEstates/MTR:ForeignEstates/MTR:ForeignEstateIncomeFIGclaim or
	  ../MTR:SA108/MTR:ResidentialPropertyAndCarriedInterest/MTR:GainsOnResidentialPropertyFIGclaim or
	  ../MTR:SA108/MTR:ResidentialPropertyAndCarriedInterest/MTR:GainsOnCarriedInterestFIGclaim or
	  ../MTR:SA108/MTR:OtherPropertyAssetsAndGains/MTR:GainsFIGclaim or
	  ../MTR:SA108/MTR:ListedSharesAndSecurities/MTR:GainsFIGclaim or
	  ../MTR:SA108/MTR:UnlistedSharesAndSecurities/MTR:GainsFIGclaim or
	  ../MTR:SA108/MTR:EISandQAHC/MTR:EISgainsFIGclaim or
	  ../MTR:SA108/MTR:EISandQAHC/MTR:QAHCgainsFIGclaim
	  )" id="a_SA109.2" diagnostics="errorCode.SA109.2 transactional.SA109.2 transactional.en.SA109.2 ">If [NRD28] or [NRD29] is present then [INC3], [INC6] and [INC7] should be absent and at least one of [FSE76.1] or [FSE77.1] or [FPS20.1] or [FPS21.1] or [FPS35.1] or [FPS55.1] or [FPS60.1] or [FPS70.1] or [FPS75.1] or [FPS76.1] or [FOR4.1] or [FOR6.1] or [FOR9.1] or [FOR11.1] or [FOR13.0] or [FOR30.1] or [FOR48.1] or [FOR51.1] or [FOR53.1] or [FOR54.1] or [FOR55.1] or [FOR56.1] or [FOR57.1] or [FOR58.1] or [FOR59.1] or [FOR60.1] or [FOR61.1] or [FOR62.1] or [FOR63.1] or [FOR64.1] or [TRU22.1] or [CGT6.1] or [CGT13C] or [CGT17.0] or [CGT26.1] or [CGT34.1] or [CGT52EG.1] or [CGT52QG.1] should be present</sch:assert>
        <sch:assert test="(not(MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG or MTR:OverseasWorkdayReliefOWR/MTR:OWRclaim))
		or
	  (not(../MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedForeignIncome/MTR:ResidentialFinanceCosts or
	   ../MTR:SA104F/MTR:ShareOfUntaxedIncome/MTR:OtherUntaxedForeignIncome/MTR:UnusedResidentialFinanceCostsBroughtForward or
	   ../MTR:SA106/MTR:ResidentialPropertyIncomeOrRestrictedFinanceCosts or
	   ../MTR:SA106/MTR:UnusedTOAAresidentialFinanceCostsBroughtForward or
	   ../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:ResidentialFinanceCosts or
	   ../MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:UnusedResidentialFinanceCostsBroughtForward or
	   ../MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:OverseasResidentialPropertyOrRestrictedFinanceCostsForNonResidentTrust or
	   ../MTR:SA106/MTR:OtherOverseasIncomeAndGains/MTR:UnusedOverseasResidentialFinanceCostsBroughtForward))" id="a_SA109.3" diagnostics="errorCode.SA109.3 transactional.SA109.3 transactional.en.SA109.3 ">If any of [NRD28] or [NRD29] or [NRD41] are present, then [FPS63.1], [FPS63.2], [FOR13.1], [FOR13.2], [FOR24.1], [FOR24.2], [FOR49] and [FOR49.1] must be absent</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p516">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA110/MTR:SelfAssessment/MTR:StudentLoanRepaymentDue">
        <sch:assert test="../../../MTR:SA100/MTR:StudentLoanRepayments/MTR:IncomeContingentStudentLoanNotification" id="a_ITF4-STUDENT-LOAN-REPAYT-AMO.0" diagnostics="errorCode.ITF4-STUDENT-LOAN-REPAYT-AMO.0 transactional.ITF4-STUDENT-LOAN-REPAYT-AMO.0 transactional.en.ITF4-STUDENT-LOAN-REPAYT-AMO.0 ">If [CAL3] present including an entry of zero, then [SLR1] must be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p517">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA110/MTR:SelfAssessment/MTR:Class4NICsDue">
        <sch:assert test="not(../../../MTR:SA103F/MTR:NICs/MTR:Class4NICexempt or ../../../MTR:SA103L/MTR:NICs/MTR:Class4NICexempt or ../../../MTR:SA104S/MTR:NICs/MTR:Class4NICexempt or ../../../MTR:SA104F/MTR:NICs/MTR:Class4NICexempt or ../../../MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:Class4NICexempt) or (.) = 0" id="a_ITF-SELF-CALC-NIC-DUE-TOTAL.1" diagnostics="errorCode.ITF-SELF-CALC-NIC-DUE-TOTAL.1 transactional.ITF-SELF-CALC-NIC-DUE-TOTAL.1 transactional.en.ITF-SELF-CALC-NIC-DUE-TOTAL.1 ">c) If one of [FSE101], [LUN64], [SPS26], [FPS26] or [SSE37] is Y, [CAL4] must be zero or absent ( Error number 310). (see section F)</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p518">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA110/MTR:SelfAssessment/MTR:Class2NICsDue">
        <sch:assert test=". &lt;= 219.95" id="a_ITF-SELF-CALC-CLASS2-NIC-TOTAL.0" diagnostics="errorCode.ITF-SELF-CALC-CLASS2-NIC-TOTAL.0 transactional.ITF-SELF-CALC-CLASS2-NIC-TOTAL.0 transactional.en.ITF-SELF-CALC-CLASS2-NIC-TOTAL.0 ">[CAL4.1] is valid only if this does not exceed [£219.95]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p519">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA110/MTR:PaymentsOnAccount/MTR:ClaimToReducePaymentsOnAccount">
        <sch:assert test="../MTR:FirstPaymentOnAccount" id="a_ITF3-AUTO-CALC-POA-AMT.1" diagnostics="errorCode.ITF3-AUTO-CALC-POA-AMT.1 transactional.ITF3-AUTO-CALC-POA-AMT.1 transactional.en.ITF3-AUTO-CALC-POA-AMT.1 ">first payment on account should be present if [CAL10] present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p520">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA110/MTR:PaymentsOnAccount/MTR:FirstPaymentOnAccount">
        <sch:assert test="not(. = 0) or ../MTR:ClaimToReducePaymentsOnAccount" id="a_ITF3-AUTO-CALC-POA-AMT.2" diagnostics="errorCode.ITF3-AUTO-CALC-POA-AMT.2 transactional.ITF3-AUTO-CALC-POA-AMT.2 transactional.en.ITF3-AUTO-CALC-POA-AMT.2 ">Entry must not be zero except where a claim to reduce payments on account has been made by ticking box [CAL10] and the claim is to reduce the payments on account to zero</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p521">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA110/MTR:SurplusAllowances/MTR:SurplusBlindPersonsAllowance">
        <sch:assert test="(.) &lt;= 3130" id="a_ITF-BPA-AMOUNT.1" diagnostics="errorCode.ITF-BPA-AMOUNT.1 transactional.ITF-BPA-AMOUNT.1 transactional.en.ITF-BPA-AMOUNT.1 ">[CAL12] must not exceed [£3,130] for the year.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p522">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA110/MTR:SurplusAllowances/MTR:SurplusMarriedCouplesAllowance">
        <sch:assert test="(.) &lt;= 11270" id="a_ITF4-MCA-AMOUNT.0" diagnostics="errorCode.ITF4-MCA-AMOUNT.0 transactional.ITF4-MCA-AMOUNT.0 transactional.en.ITF4-MCA-AMOUNT.0 ">[CAL13] must not exceed [£11,270] for the year.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p523">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA110/MTR:AdjustmentsToTaxDue/MTR:IncreaseInTaxFromAdjustmentToEarlierYears">
        <sch:assert test="../../../MTR:SA101/MTR:BusinessTaxedIncome/MTR:PostCessationOrOtherBusinessReceipts or ../../../MTR:SA103L/MTR:RepaymentOfForeignTaxTaxCreditRelief or ../../../MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:ChangeOfAccountingPracticeAdjustment or ../../../MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:AveragingAdjustment or ../../../MTR:SA104F/MTR:ShareOfProfits/MTR:AveragingAdjustment or ../../../MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:AveragingAdjustment" id="a_X-SCHEDULE.o" diagnostics="errorCode.X-SCHEDULE.o transactional.X-SCHEDULE.o transactional.en.X-SCHEDULE.o ">If there is an entry in box [CAL14], box [AOI14] or [LUN28] or [FSE71] or [FSE72] or [FPS11] or [SPS11] must be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p524">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:SA110/MTR:AdjustmentsToTaxDue/MTR:DecreaseInTaxFromAdjustmentToEarlierYears">
        <sch:assert test="../../../MTR:SA103F/MTR:Losses/MTR:LossToCarryBack 
                or 
                ../../../MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:LossToCarryBack 
                or 
                ../../../MTR:SA103L/MTR:AllowableLosses/MTR:LossCarriedBack 
                or 
                ../../../MTR:SA104F/MTR:ShareOfLosses/MTR:LossToBeCarriedBack 
                or 
                ../../../MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalLosses/MTR:LossToBeCarriedBack 
                or 
                ../../../MTR:SA108/MTR:LossesAndAdjustments/MTR:LossesUsedAgainstEarlierReturnYearsGain 
                or 
                ../../../MTR:SA108/MTR:UnlistedSharesAndSecurities/MTR:LossesUsedAgainstPreviousReturnYearIncome 
                or 
                ../../../MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:AveragingAdjustment
                or
                ../../../MTR:SA104F/MTR:ShareOfProfits/MTR:AveragingAdjustment
                or
                ../../../MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:AveragingAdjustment" id="a_ITF-TAX-OP-FOR-EY-TOT.0" diagnostics="errorCode.ITF-TAX-OP-FOR-EY-TOT.0 transactional.ITF-TAX-OP-FOR-EY-TOT.0 transactional.en.ITF-TAX-OP-FOR-EY-TOT.0 ">If there is an entry in box [CAL15] there must be an entry in at least one of the loss to carry back boxes: [FSE79], [SSE34], [LUN57], [FPS23], [SPS23], [CGT48] or [CGT43], or an entry in at least one of the adjustment boxes [FSE72], [FPS11] or [SPS11]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p525">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR/MTR:AttachedFiles/MTR:Attachment">
        <sch:assert test="starts-with(translate(normalize-space(.), &apos; &apos;, &apos;&apos;), &apos;JVBERi0x&apos;)" id="a_MTR-ATTACHMENT.1" diagnostics="errorCode.MTR-ATTACHMENT.1 transactional.MTR-ATTACHMENT.1 transactional.en.MTR-ATTACHMENT.1 ">Attachment content must be a PDF file starting with the byte sequence "%PDF-1" (i.e. the Base 64 encoded content starts with "JVBERi0x")</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p3">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/MTR:IRenvelope/MTR:MTR">
        <sch:assert test="not(@AmendedReturn)
          or
            not(../../../hd:Header/hd:MessageDetails/hd:GatewayTimestamp)
          or
            (
              date:date(normalize-space(concat(../../../hd:Header/hd:MessageDetails/hd:GatewayTimestamp, &apos;Z&apos;))) != &apos;&apos;
            and
              date:seconds(normalize-space(concat(../../../hd:Header/hd:MessageDetails/hd:GatewayTimestamp, &apos;Z&apos;))) &lt; date:seconds(normalize-space(date:add(normalize-space(&apos;2027-01-31T00:00:00Z&apos;),normalize-space(&apos;P1Y1D&apos;))))
            )
          or
            (
              date:date(normalize-space(concat(../../../hd:Header/hd:MessageDetails/hd:GatewayTimestamp, &apos;Z&apos;))) = &apos;&apos;
            and
              date:seconds(normalize-space(../../../hd:Header/hd:MessageDetails/hd:GatewayTimestamp)) &lt; date:seconds(normalize-space(date:add(normalize-space(&apos;2027-01-31T00:00:00Z&apos;),normalize-space(&apos;P1Y1D&apos;))))
            )" id="a_IND-AMENDED-RETURN-IND.0" diagnostics="errorCode.IND-AMENDED-RETURN-IND.0 transactional.IND-AMENDED-RETURN-IND.0 transactional.en.IND-AMENDED-RETURN-IND.0 ">Date of receipt of amendment must be less than 12 months following statutory due date</sch:assert>
        <sch:assert test="not(MTR:SA110/MTR:AdjustmentsToTaxDue/MTR:NextYearsRepaymentClaimedNow) or (MTR:SA101/MTR:OtherInformation/MTR:IncomeTaxLosses/MTR:NextYearsTradingAndCapitalLossesRelief and MTR:SA101/MTR:OtherInformation/MTR:IncomeTaxLosses/MTR:YearForWhichReliefClaimed and MTR:SA100/MTR:FinishingYourTaxReturn/MTR:SigningYourForm/MTR:OtherInformationSpace)" id="a_X-SCHEDULE.4" diagnostics="errorCode.X-SCHEDULE.4 transactional.X-SCHEDULE.4 transactional.en.X-SCHEDULE.4 ">If there is an entry in box [CAL16], boxes [AIL3], [AIL5] and [FIN19] must be present (error 215)</sch:assert>
        <sch:assert test="contains(/hd:GovTalkMessage/hd:Header/hd:MessageDetails/hd:Class, &apos;-ATT&apos;) or not(MTR:AttachedFiles)" id="a_MTR-ATTACHMENT-CLASS.1" diagnostics="errorCode.MTR-ATTACHMENT-CLASS.1 transactional.MTR-ATTACHMENT-CLASS.1 transactional.en.MTR-ATTACHMENT-CLASS.1 ">Submission must not contain any attachments if the message class indicates no attachments</sch:assert>
        <sch:assert test="not(contains(/hd:GovTalkMessage/hd:Header/hd:MessageDetails/hd:Class, &apos;-ATT&apos;)) or (MTR:AttachedFiles)" id="a_MTR-ATTACHMENT-CLASS.2" diagnostics="errorCode.MTR-ATTACHMENT-CLASS.2 transactional.MTR-ATTACHMENT-CLASS.2 transactional.en.MTR-ATTACHMENT-CLASS.2 ">Submission must contain at least one attachment if the message class indicates attachments</sch:assert>
        <sch:assert test="(count(MTR:SA103F/MTR:NICs/MTR:Class4NICexempt) + count(MTR:SA103F/MTR:NICs/MTR:AdjustmentToClass4NICProfits) + count(MTR:SA103L/MTR:NICs/MTR:Class4NICexempt) + count(MTR:SA103L/MTR:NICs/MTR:AdjustmentToClass4NICProfits) + count(MTR:SA104F/MTR:NICs/MTR:Class4NICexempt) + count(MTR:SA104F/MTR:NICs/MTR:AdjustmentToClass4NICProfits) + count(MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:Class4NICexempt) + count(MTR:SA104S/MTR:NICs/MTR:Class4NICexempt) + count(MTR:SA104S/MTR:NICs/MTR:AdjustmentToClass4NICProfits))      
          &lt;= 1" id="a_X-SCHEDULE.1" diagnostics="errorCode.X-SCHEDULE.1 transactional.X-SCHEDULE.1 transactional.en.X-SCHEDULE.1 ">There should only be an entry in one set of Class 4 NIC boxes on the return</sch:assert>
        <sch:assert test="not(MTR:SA100/MTR:FinishingYourTaxReturn/MTR:PaidTooMuch/MTR:PaymentDetails/MTR:BankAccountDetails/MTR:BankOrBuildingSocietyName and MTR:SA100/MTR:FinishingYourTaxReturn/MTR:PaidTooMuch/MTR:NoBankOrBuildingSocietyAccount)" id="a_X-SCHEDULE.2" diagnostics="errorCode.X-SCHEDULE.2 transactional.X-SCHEDULE.2 transactional.en.X-SCHEDULE.2 ">There should not be entries in both [FIN4] and [FIN9].</sch:assert>
        <sch:assert test="MTR:SA101/MTR:SharesEmploymentCompensationsAndDeductions/MTR:TaxTakenOffLumpSumsLeftBlank or ((sum(MTR:SA102/MTR:Employment/MTR:TaxTakenOffPay)) - (sum(MTR:SA102/MTR:Employment/MTR:PayFromEmployment) + sum(MTR:SA102/MTR:Employment/MTR:TipsAndOtherPayments)) &lt; 0.001)" id="a_X-SCHEDULE.3" diagnostics="errorCode.X-SCHEDULE.3 transactional.X-SCHEDULE.3 transactional.en.X-SCHEDULE.3 ">If [ASE7] is absent, [EMP2] must not exceed [EMP1] + [EMP3]</sch:assert>
        <sch:assert test="(MTR:SA103F/MTR:NICs/MTR:Class4NICexempt = &apos;yes&apos; or MTR:SA103L/MTR:NICs/MTR:Class4NICexempt = &apos;yes&apos; or MTR:SA104S/MTR:NICs/MTR:Class4NICexempt = &apos;yes&apos; or MTR:SA104F/MTR:NICs/MTR:Class4NICexempt = &apos;yes&apos; or MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:Class4NICexempt = &apos;yes&apos;) or not((MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:TotalTaxableBusinessProfits or MTR:SA103L/MTR:TaxableProfits/MTR:TotalTaxableProfits or MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:TotalTaxableBusinessProfits or MTR:SA104F/MTR:ShareOfProfits/MTR:TotalTaxableBusinessProfits or MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:TotalTaxableBusinessProfits) and MTR:SA100/MTR:YourPersonalDetails/MTR:DateOfBirth and (translate(date:add(string(MTR:SA100/MTR:YourPersonalDetails/MTR:DateOfBirth), &apos;P66Y&apos;), &apos;-&apos;, &apos;&apos;) &lt;= &apos;20250406&apos;))" id="a_X-SCHEDULE-AMC.4" diagnostics="errorCode.X-SCHEDULE-AMC.4 transactional.X-SCHEDULE-AMC.4 transactional.en.X-SCHEDULE-AMC.4 ">One of boxes [FSE101], [LUN64], [SPS26], [FPS26] or [SSE37] must be set to Y if any of boxes [FSE76], [LUN52], [SPS20], [FPS20] or [SSE31] are present and box [YPD1] is present and box [YPD1] date + [66 years] is prior to the beginning of the return year or on 6 April of the return year.</sch:assert>
        <sch:assert test="((sum(MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:Class2NICamount)
            + sum(MTR:SA103F/MTR:NICs/MTR:Class2NICamount)
            + sum(MTR:SA103L/MTR:NICs/MTR:Class2NICamount)
            + sum(MTR:SA104F/MTR:NICs/MTR:Class2NICamount)
            + sum(MTR:SA104S/MTR:NICs/MTR:Class2NICamount)) - (219.95) &lt; 0.001)" id="a_X-SCHEDULE.5" diagnostics="errorCode.X-SCHEDULE.5 transactional.X-SCHEDULE.5 transactional.en.X-SCHEDULE.5 ">(Total all instances [SSECL2] + [FSECL2] + [FPSCL2] + [SPSCL2]) + [LUNCL2] must be less than or equal to [£219.95].</sch:assert>
        <sch:assert test="not(
             count(MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:PayClass2NICvoluntarily) &gt; 0
           or
             count(MTR:SA103F/MTR:NICs/MTR:PayClass2NICvoluntarily) &gt; 0
           or
             MTR:SA103L/MTR:NICs/MTR:PayClass2NICvoluntarily
           or
             count(MTR:SA104S/MTR:NICs/MTR:PayClass2NICvoluntarily) &gt; 0
           or
             count(MTR:SA104F/MTR:NICs/MTR:PayClass2NICvoluntarily) &gt; 0
          )
        or
          ((sum(MTR:SA103S/MTR:ProfitsLossesNICsAndCIS/MTR:TotalTaxableBusinessProfits)
            + sum(MTR:SA103F/MTR:TaxableProfitOrLoss/MTR:TotalTaxableBusinessProfits)
            + sum(MTR:SA103L/MTR:TaxableProfits/MTR:TotalTaxableProfits)
            + sum(MTR:SA104S/MTR:ShareOfPartnershipTradingOrProfessionalProfits/MTR:TotalTaxableBusinessProfits)
            + sum(MTR:SA104F/MTR:ShareOfProfits/MTR:TotalTaxableBusinessProfits)
            - (
              sum(MTR:SA103F/MTR:NICs/MTR:AdjustmentToClass4NICProfits)
              + sum(MTR:SA103L/MTR:NICs/MTR:AdjustmentToClass4NICProfits)
              + sum(MTR:SA104S/MTR:NICs/MTR:AdjustmentToClass4NICProfits)
              + sum(MTR:SA104F/MTR:NICs/MTR:AdjustmentToClass4NICProfits)
            )) - (6845) &lt;= -0.001)" id="a_X-SCHEDULE.6" diagnostics="errorCode.X-SCHEDULE.6 transactional.X-SCHEDULE.6 transactional.en.X-SCHEDULE.6 ">Where any of [SSE36], [FSE100], [LUN63], [SPS25] or [FPS25] are present then the sum of all instances [SSE31] + sum of all instances [FSE76] + [LUN52] + sum of all instances [SPS20] + sum of all instances [FPS20] - (sum of all instances [FSE102] + [LUN65] + sum of all instances [SPS27] + sum of all instances [FPS27]) should be less than [£6,845]</sch:assert>
        <sch:assert test="((sum(MTR:SA103S/MTR:BusinessIncome/MTR:TradingIncomeAllowance)
            + sum(MTR:SA103F/MTR:BusinessIncome/MTR:TradingIncomeAllowance)) - (1000) &lt; 0.001)" id="a_PRE-CALC.l" diagnostics="errorCode.PRE-CALC.l transactional.PRE-CALC.l transactional.en.PRE-CALC.l ">The total of all instances of [SSE10.1] and [FSE16.1] must not exceed [£1,000].</sch:assert>
        <sch:assert test="((sum(MTR:SA105/MTR:PropertyIncomeAndExpenses/MTR:PropertyIncomeAllowance) + sum(MTR:SA106/MTR:OverseasLandAndPropertyIncomeDetails/MTR:PropertyIncomeAllowance)) - (1000) &lt; 0.001)" id="a_PRE-CALC.m" diagnostics="errorCode.PRE-CALC.m transactional.PRE-CALC.m transactional.en.PRE-CALC.m ">The total of all instances of [PRO20.1] and [FOR14.1] must not exceed [£1,000].</sch:assert>
        <sch:assert test="((sum(MTR:SA102/MTR:Employment/MTR:CloseCompanyDividend)) - (0) &lt; 0.001) or ((sum(MTR:SA100/MTR:Income/MTR:UKInterestAndDividends/MTR:CompanyDividends) + sum(MTR:SA101/MTR:StockDistributionsAndLoansWrittenOff/MTR:StockDividends) + sum(MTR:SA101/MTR:StockDistributionsAndLoansWrittenOff/MTR:BonusIssuesOfSecuritiesAndRedeemableShares)) - (sum(MTR:SA102/MTR:Employment/MTR:CloseCompanyDividend)) &gt; -0.001)" id="a_PRE-CALC.u" diagnostics="errorCode.PRE-CALC.u transactional.PRE-CALC.u transactional.en.PRE-CALC.u ">If the total of all instances of [EMP7.3] is greater than 0.00 then the total of [INC4] + [AOI12] + [AOI13] must be equal to or greater than the total of all instances of [EMP7.3]</sch:assert>
        <sch:assert test="not(MTR:SA106/MTR:TotalAdjustedProfitOrLoss) or not((MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignIncomeUnderFIG or MTR:SA109/MTR:ForeignIncomeAndGainsFIGrelief/MTR:ClaimForReliefOnForeignGainsUnderFIG or MTR:SA109/MTR:OverseasWorkdayReliefOWR/MTR:OWRclaim) and ((sum(MTR:SA106/MTR:TotalAdjustedProfitOrLoss)) - (0) &gt; -0.001) and ((sum(MTR:SA106/MTR:LossBroughtForward)) - (0) &gt;= 0.001) and not(MTR:SA106/MTR:TotalTaxableProfit)) or not(((sum(MTR:SA106/MTR:LossToCarryForward)) - (0) &gt;= 0.001)) or (math:abs((sum(MTR:SA106/MTR:LossToCarryForward)) - (sum(MTR:SA106/MTR:LossBroughtForward) - sum(MTR:SA106/MTR:TotalAdjustedProfitOrLoss))) &lt; 0.001)" id="a_PRE-CALC.ab" diagnostics="errorCode.PRE-CALC.ab transactional.PRE-CALC.ab transactional.en.PRE-CALC.ab ">If [NRD28] or [NRD29] or [NRD41] are 'Y' and [FOR25] is equal to or greater than zero and [FOR26] is present (greater than zero) and [FOR27] is absent then if [FOR32] is present (greater than zero) it must equal [FOR26] minus [FOR25]</sch:assert>
      </sch:rule>
    </sch:pattern>
  <sch:diagnostics>
    <sch:diagnostic id="errorCode.header.r1005">5004</sch:diagnostic>
    <sch:diagnostic id="transactional.header.r1005">At least one key must exist in the IRheader</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.header.r1005">At least one key must exist in the IRheader</sch:diagnostic>
    <sch:diagnostic id="errorCode.header.r1004">5005</sch:diagnostic>
    <sch:diagnostic id="transactional.header.r1004">Keys in the GovTalkDetails do not match those in the IRheader.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.header.r1004">Keys in the GovTalkDetails do not match those in the IRheader.</sch:diagnostic>
    <sch:diagnostic id="errorCode.IND-AMENDED-RETURN-IND.0">5090</sch:diagnostic>
    <sch:diagnostic id="transactional.IND-AMENDED-RETURN-IND.0">You have indicated an amended submission but the amendment window has now closed for the year of assessment to which your submission relates.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.IND-AMENDED-RETURN-IND.0">You have indicated an amended submission but the amendment window has now closed for the year of assessment to which your submission relates.</sch:diagnostic>
    <sch:diagnostic id="errorCode.X-SCHEDULE.4">6215</sch:diagnostic>
    <sch:diagnostic id="transactional.X-SCHEDULE.4">There is an entry in box [CAL16], boxes [AIL3], [AIL5] and [FIN19] must also be completed. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.X-SCHEDULE.4">There is an entry in box [CAL16], boxes [AIL3], [AIL5] and [FIN19] must also be completed. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.MTR-ATTACHMENT-CLASS.1">6001</sch:diagnostic>
    <sch:diagnostic id="transactional.MTR-ATTACHMENT-CLASS.1">Submission must not contain any attachments if the message class indicates no attachments</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MTR-ATTACHMENT-CLASS.1">Submission must not contain any attachments if the message class indicates no attachments</sch:diagnostic>
    <sch:diagnostic id="errorCode.MTR-ATTACHMENT-CLASS.2">6015</sch:diagnostic>
    <sch:diagnostic id="transactional.MTR-ATTACHMENT-CLASS.2">Submission must contain at least one attachment if the message class indicates attachments</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MTR-ATTACHMENT-CLASS.2">Submission must contain at least one attachment if the message class indicates attachments</sch:diagnostic>
    <sch:diagnostic id="errorCode.X-SCHEDULE.1">6511</sch:diagnostic>
    <sch:diagnostic id="transactional.X-SCHEDULE.1">There should only be an entry in one set of Class 4 NIC boxes on the return</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.X-SCHEDULE.1">There should only be an entry in one set of Class 4 NIC boxes on the return</sch:diagnostic>
    <sch:diagnostic id="errorCode.X-SCHEDULE.2">6343</sch:diagnostic>
    <sch:diagnostic id="transactional.X-SCHEDULE.2">There should not be entries in both [FIN4] and [FIN9]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.X-SCHEDULE.2">There should not be entries in both [FIN4] and [FIN9]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.X-SCHEDULE.3">6038</sch:diagnostic>
    <sch:diagnostic id="transactional.X-SCHEDULE.3">Box [ASE7] is absent, but the amount in box [EMP2] exceeds the total of boxes [EMP1] + [EMP3]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.X-SCHEDULE.3">Box [ASE7] is absent, but the amount in box [EMP2] exceeds the total of boxes [EMP1] + [EMP3]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.X-SCHEDULE-AMC.4">6791</sch:diagnostic>
    <sch:diagnostic id="transactional.X-SCHEDULE-AMC.4">There must be an entry in one of [FSE101], [LUN64], [SPS26], [FPS26] or [SSE37] as there is an entry in one of the boxes [FSE76], [LUN52], [SPS20], [FPS20] or [SSE31] and there is an entry in [YPD1], and box [YPD1] date + [66 years] is prior to the beginning of the return year or on 6 April of the return year.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.X-SCHEDULE-AMC.4">There must be an entry in one of [FSE101], [LUN64], [SPS26], [FPS26] or [SSE37] as there is an entry in one of the boxes [FSE76], [LUN52], [SPS20], [FPS20] or [SSE31] and there is an entry in [YPD1], and box [YPD1] date + [66 years] is prior to the beginning of the return year or on 6 April of the return year.</sch:diagnostic>
    <sch:diagnostic id="errorCode.X-SCHEDULE.5">8324</sch:diagnostic>
    <sch:diagnostic id="transactional.X-SCHEDULE.5">The total of all instances [SSECL2] + [FSECL2] + [FPSCL2] + [SPSCL2]) + [LUNCL2] must be less than or equal to [£219.95]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.X-SCHEDULE.5">The total of all instances [SSECL2] + [FSECL2] + [FPSCL2] + [SPSCL2]) + [LUNCL2] must be less than or equal to [£219.95]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.X-SCHEDULE.6">8374</sch:diagnostic>
    <sch:diagnostic id="transactional.X-SCHEDULE.6">As there is an entry in any of [SSE36], [FSE100], [LUN63], [SPS25] or [FPS25] the sum of all instances [SSE31] + sum of all instances [FSE76] + [LUN52] + sum of all instances [SPS20] + sum of all instances [FPS20] - (sum of all instances [FSE102] + [LUN65] + sum of all instances [SPS27] + sum of all instances [FPS27]) should be less than [£6,845]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.X-SCHEDULE.6">As there is an entry in any of [SSE36], [FSE100], [LUN63], [SPS25] or [FPS25] the sum of all instances [SSE31] + sum of all instances [FSE76] + [LUN52] + sum of all instances [SPS20] + sum of all instances [FPS20] - (sum of all instances [FSE102] + [LUN65] + sum of all instances [SPS27] + sum of all instances [FPS27]) should be less than [£6,845]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PRE-CALC.l">8554</sch:diagnostic>
    <sch:diagnostic id="transactional.PRE-CALC.l">The total of all instances of [SSE10.1] and [FSE16.1] exceeds [£1,000]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PRE-CALC.l">The total of all instances of [SSE10.1] and [FSE16.1] exceeds [£1,000]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PRE-CALC.m">8449</sch:diagnostic>
    <sch:diagnostic id="transactional.PRE-CALC.m">The total of all instances of [PRO20.1] and [FOR14.1] must not exceed [£1,000]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PRE-CALC.m">The total of all instances of [PRO20.1] and [FOR14.1] must not exceed [£1,000]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PRE-CALC.u">8657</sch:diagnostic>
    <sch:diagnostic id="transactional.PRE-CALC.u">If the total of all instances of [EMP7.3] is greater than 0.00 then the total of [INC4] + [AOI12] + [AOI13] must be equal to or greater than the total of all instances of [EMP7.3]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PRE-CALC.u">If the total of all instances of [EMP7.3] is greater than 0.00 then the total of [INC4] + [AOI12] + [AOI13] must be equal to or greater than the total of all instances of [EMP7.3]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PRE-CALC.ab">8658</sch:diagnostic>
    <sch:diagnostic id="transactional.PRE-CALC.ab">If [NRD28] or [NRD29] or [NRD41] are 'Y' and [FOR25] is equal to or greater than zero and [FOR26] is present (greater than zero) and [FOR27] is absent then if [FOR32] is present (greater than zero) it must equal [FOR26] minus [FOR25]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PRE-CALC.ab">If [NRD28] or [NRD29] or [NRD41] are 'Y' and [FOR25] is equal to or greater than zero and [FOR26] is present (greater than zero) and [FOR27] is absent then if [FOR32] is present (greater than zero) it must equal [FOR26] minus [FOR25]</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA100.0">6180</sch:diagnostic>
    <sch:diagnostic id="transactional.SA100.0">There is an entry in box [YTR1A.1A]. Please complete box [YTR1A.1B].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA100.0">There is an entry in box [YTR1A.1A]. Please complete box [YTR1A.1B].</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF1-TAXPAYER-DATE-OF-BIRTH.0">6428</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF1-TAXPAYER-DATE-OF-BIRTH.0">Date of birth cannot be later than 5 April of the year of the return. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF1-TAXPAYER-DATE-OF-BIRTH.0">Date of birth cannot be later than 5 April of the year of the return. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.Included_in_ITF-TAXPAYER-ADDRESS-TEXT-3.1">6509</sch:diagnostic>
    <sch:diagnostic id="transactional.Included_in_ITF-TAXPAYER-ADDRESS-TEXT-3.1">[A14] is completed, [A11], [A12] and [A13] must also be completed. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.Included_in_ITF-TAXPAYER-ADDRESS-TEXT-3.1">[A14] is completed, [A11], [A12] and [A13] must also be completed. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-EFFECTIVE-DATE.0">8325</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-EFFECTIVE-DATE.0">The entry in [YPD2] must be on or before today. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-EFFECTIVE-DATE.0">The entry in [YPD2] must be on or before today. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF4-EMPLOYMENT-SCH-REQD-SIG.0">6554</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF4-EMPLOYMENT-SCH-REQD-SIG.0">There is an entry in box [YTR1.1A]. Please complete box [YTR1.1B].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF4-EMPLOYMENT-SCH-REQD-SIG.0">There is an entry in box [YTR1.1A]. Please complete box [YTR1.1B].</sch:diagnostic>
    <sch:diagnostic id="errorCode.RTN-SELF-EMPLOYMENT-QTY.0">6555</sch:diagnostic>
    <sch:diagnostic id="transactional.RTN-SELF-EMPLOYMENT-QTY.0">There is an entry in box [YTR2.2A]. Please complete box [YTR2.2B].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RTN-SELF-EMPLOYMENT-QTY.0">There is an entry in box [YTR2.2A]. Please complete box [YTR2.2B].</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-SHORT-SELF-E-SCH-REQD-SIG.0">6556</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-SHORT-SELF-E-SCH-REQD-SIG.0">There is an entry in box [YTR2A.2A]. Please complete box [YTR2A.2B].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-SHORT-SELF-E-SCH-REQD-SIG.0">There is an entry in box [YTR2A.2A]. Please complete box [YTR2A.2B].</sch:diagnostic>
    <sch:diagnostic id="errorCode.RTN-PARTNER-INCOME-QTY.0">6557</sch:diagnostic>
    <sch:diagnostic id="transactional.RTN-PARTNER-INCOME-QTY.0">There is an entry in box [YTR3.3A]. Please complete box [YTR3.3B].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RTN-PARTNER-INCOME-QTY.0">There is an entry in box [YTR3.3A]. Please complete box [YTR3.3B].</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF4-SHORT-PSHIP-SCH-REQD-SIG.0">6558</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF4-SHORT-PSHIP-SCH-REQD-SIG.0">There is an entry in box [YTR3A.3A]. Please complete box [YTR3A.3B].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF4-SHORT-PSHIP-SCH-REQD-SIG.0">There is an entry in box [YTR3A.3A]. Please complete box [YTR3A.3B].</sch:diagnostic>
    <sch:diagnostic id="errorCode.MPL4-STUDENT-LOAN-EMPT-DED-AMO.0">8370</sch:diagnostic>
    <sch:diagnostic id="transactional.MPL4-STUDENT-LOAN-EMPT-DED-AMO.0">There is an entry in [SLR2]. Please complete [SLR1].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MPL4-STUDENT-LOAN-EMPT-DED-AMO.0">There is an entry in [SLR2]. Please complete [SLR1].</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-PGL-EMPT-DED-AMO.0">8371</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-PGL-EMPT-DED-AMO.0">There is an entry in [SLR3]. Please complete [SLR1].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-PGL-EMPT-DED-AMO.0">There is an entry in [SLR3]. Please complete [SLR1].</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-STUDENT-LOAN-PLAN-TYPE-NO.0">8376</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-STUDENT-LOAN-PLAN-TYPE-NO.0">There is an entry in [SLRPT]. Please complete [SLR1].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-STUDENT-LOAN-PLAN-TYPE-NO.0">There is an entry in [SLRPT]. Please complete [SLR1].</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-PGL-PLAN-TYPE-NO.0">8375</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-PGL-PLAN-TYPE-NO.0">There is an entry in [PGLRPT]. Please complete [SLR1].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-PGL-PLAN-TYPE-NO.0">There is an entry in [PGLRPT]. Please complete [SLR1].</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-FRGN-INV-INT-PAID-GROSS.0">8326</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-FRGN-INV-INT-PAID-GROSS.0">The amount in box [INC3] exceeds [£2,000]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-FRGN-INV-INT-PAID-GROSS.0">The amount in box [INC3] exceeds [£2,000]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-FOREIGN-DIV-TAX-PAID-AMT.0">8296</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-FOREIGN-DIV-TAX-PAID-AMT.0">The amount in box [INC7] exceeds box [INC6]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-FOREIGN-DIV-TAX-PAID-AMT.0">The amount in box [INC7] exceeds box [INC6]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-STATE-RETIREMENT-PENSION.0">6220</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-STATE-RETIREMENT-PENSION.0">The amount in box [INC8] must be less than [£99,999]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-STATE-RETIREMENT-PENSION.0">The amount in box [INC8] must be less than [£99,999]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-STATE-PENSION-LS-TAX-AMT.0">8297</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-STATE-PENSION-LS-TAX-AMT.0">[INC10] is valid only if this does not exceed ( ( [45%] times [INC9] ) plus 1.00 )</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-STATE-PENSION-LS-TAX-AMT.0">[INC10] is valid only if this does not exceed ( ( [45%] times [INC9] ) plus 1.00 )</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF2-OTHER-PENSION-TAX-PAID-1.0">6221</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF2-OTHER-PENSION-TAX-PAID-1.0">The amount in box [INC12] exceeds the amount in box [INC11]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF2-OTHER-PENSION-TAX-PAID-1.0">The amount in box [INC12] exceeds the amount in box [INC11]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-TAX-DED-INCAPACITY-BENEFIT.0">6317</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-TAX-DED-INCAPACITY-BENEFIT.0">Tax deducted entered in box [INC14] but no figure in [INC13]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-TAX-DED-INCAPACITY-BENEFIT.0">Tax deducted entered in box [INC14] but no figure in [INC13]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-TAX-DED-INCAPACITY-BENEFIT.1">6035</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-TAX-DED-INCAPACITY-BENEFIT.1">The amount in box [INC14] exceeds the amount in box [INC13]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-TAX-DED-INCAPACITY-BENEFIT.1">The amount in box [INC14] exceeds the amount in box [INC13]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-JOBSEEKERS-ALLCE-AMT.0">6222</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-JOBSEEKERS-ALLCE-AMT.0">The amount in box [INC15] must be less than [£99,999]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-JOBSEEKERS-ALLCE-AMT.0">The amount in box [INC15] must be less than [£99,999]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-OTHER_DEEMED-INC_BENS-DESC.1">6568</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-OTHER_DEEMED-INC_BENS-DESC.1">There is an entry in box [INC17] and/or [INC20]. Please complete box [INC21]. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-OTHER_DEEMED-INC_BENS-DESC.1">There is an entry in box [INC17] and/or [INC20]. Please complete box [INC21]. </sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF3-OTHER-INCOME-TAX-DEDUCTED.1">6567</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF3-OTHER-INCOME-TAX-DEDUCTED.1">The amount in box [INC19] exceeds the amount in box [INC17]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF3-OTHER-INCOME-TAX-DEDUCTED.1">The amount in box [INC19] exceeds the amount in box [INC17]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-GROSS-STKHOLD-ONE-OFF.0">6181</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-GROSS-STKHOLD-ONE-OFF.0">The amount in [REL1.1] exceeds [REL1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-GROSS-STKHOLD-ONE-OFF.0">The amount in [REL1.1] exceeds [REL1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-GIFT-AID-AMOUNT.1">6129</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-GIFT-AID-AMOUNT.1">The amount in box [REL6] exceeds the amount in box [REL5]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-GIFT-AID-AMOUNT.1">The amount in box [REL6] exceeds the amount in box [REL5]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-GIFT-AID-PAID-PREV-YR-AMT.1">6360</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-GIFT-AID-PAID-PREV-YR-AMT.1">The amount in box [REL7] exceeds the amount in box [REL5]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-GIFT-AID-PAID-PREV-YR-AMT.1">The amount in box [REL7] exceeds the amount in box [REL5]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-SURPLUS-BPA-TO-SPOUSE-SIG.1">6512</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-SURPLUS-BPA-TO-SPOUSE-SIG.1">There is an entry in box [REL16], box [CAL12] must be absent.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-SURPLUS-BPA-TO-SPOUSE-SIG.1">There is an entry in box [REL16], box [CAL12] must be absent.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-BPA-LOCAL-AUTHORITY.1">6261</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-BPA-LOCAL-AUTHORITY.1">There is an entry at box [REL14], please complete box [REL13].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-BPA-LOCAL-AUTHORITY.1">There is an entry at box [REL14], please complete box [REL13].</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-SURPLUS-BPA-FROM-SPSE-SIG.0">6732</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-SURPLUS-BPA-FROM-SPSE-SIG.0">There is an entry in box [REL15]. Please complete box [CAL12].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-SURPLUS-BPA-FROM-SPSE-SIG.0">There is an entry in box [REL15]. Please complete box [CAL12].</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-HIGH-INCOME-CB-CHARGE.0">8310</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-HIGH-INCOME-CB-CHARGE.0">[CBC1-3] is present so the following should be true: [CBC1] is present or [CBC2] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-HIGH-INCOME-CB-CHARGE.0">[CBC1-3] is present so the following should be true: [CBC1] is present or [CBC2] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-CHILD-BENEFIT-CHILDREN-NUM.0">8298</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-CHILD-BENEFIT-CHILDREN-NUM.0">If [CBC2] is present and greater than 0, then [CBC1] must be present.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-CHILD-BENEFIT-CHILDREN-NUM.0">If [CBC2] is present and greater than 0, then [CBC1] must be present.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-CHILD-BENEFIT-CEASED-PYT.0">8311</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-CHILD-BENEFIT-CEASED-PYT.0">[CBC1] must be present if [CBC3] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-CHILD-BENEFIT-CEASED-PYT.0">[CBC1] must be present if [CBC3] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-CHILD-BENEFIT-CEASED-PYT.1">8312</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-CHILD-BENEFIT-CEASED-PYT.1">[CBC2] must be present if [CBC3] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-CHILD-BENEFIT-CEASED-PYT.1">[CBC2] must be present if [CBC3] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-CHILD-BENEFIT-CEASED-PYT.2">8313</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-CHILD-BENEFIT-CEASED-PYT.2">[CBC3] must be within the current return year</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-CHILD-BENEFIT-CEASED-PYT.2">[CBC3] must be within the current return year</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-WFP-PAWHP.0">8659</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-WFP-PAWHP.0">[WFHP1] is valid only if this does not exceed [£310]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-WFP-PAWHP.0">[WFHP1] is valid only if this does not exceed [£310]</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-WFP-PAWHP.1">8705</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-WFP-PAWHP.1">[WFHP1] is valid only when greater than or equal to [£100]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-WFP-PAWHP.1">[WFHP1] is valid only when greater than or equal to [£100]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-MA-PARTNER-FIRST-NAME.0">8327</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-MA-PARTNER-FIRST-NAME.0">There is an entry in [MAT1]. Please complete [MAT-OUT]. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-MA-PARTNER-FIRST-NAME.0">There is an entry in [MAT1]. Please complete [MAT-OUT]. </sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-MA-PARTNERSHIP-DATE.0">8330</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-MA-PARTNERSHIP-DATE.0">The entry in [MAT5] must be on or before [5 April 2026]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-MA-PARTNERSHIP-DATE.0">The entry in [MAT5] must be on or before [5 April 2026]</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-NAME-OF-ACCOUNT.0">6223</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-NAME-OF-ACCOUNT.0">There are entries in [FIN10] and [FIN12-FIN13]. Please complete box [FIN5].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-NAME-OF-ACCOUNT.0">There are entries in [FIN10] and [FIN12-FIN13]. Please complete box [FIN5].</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF1-NOMINEE-ADDRESS.0">8253</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF1-NOMINEE-ADDRESS.0">Line 4 is completed, lines 1,2 &amp; 3 must also be completed. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF1-NOMINEE-ADDRESS.0">Line 4 is completed, lines 1,2 &amp; 3 must also be completed. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF4-AGENT-CONTACT-ADDRESS.0">8253</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF4-AGENT-CONTACT-ADDRESS.0">Line 4 is completed, lines 1,2 &amp; 3 must also be completed. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF4-AGENT-CONTACT-ADDRESS.0">Line 4 is completed, lines 1,2 &amp; 3 must also be completed. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-ALT-SIGNEE-ADDRESS.0">8253</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-ALT-SIGNEE-ADDRESS.0">Line 4 is completed, lines 1,2 &amp; 3 must also be completed. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-ALT-SIGNEE-ADDRESS.0">Line 4 is completed, lines 1,2 &amp; 3 must also be completed. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-CEG-INPUT-AMOUNT.1">6525</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-CEG-INPUT-AMOUNT.1">If Box1A present then boxes [AOI7], [AOI5], [AOI9] and [FOR44] must be absent.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-CEG-INPUT-AMOUNT.1">If Box1A present then boxes [AOI7], [AOI5], [AOI9] and [FOR44] must be absent.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PRE-CALC.h">6225</sch:diagnostic>
    <sch:diagnostic id="transactional.PRE-CALC.h">The amount in box [ASE11] is greater than zero. Please complete box [FIN19].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PRE-CALC.h">The amount in box [ASE11] is greater than zero. Please complete box [FIN19].</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-CEG-WITH-NOTL-NUMBER-YEARS.1">6250</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-CEG-WITH-NOTL-NUMBER-YEARS.1">Number of years entered in box [AOI5], but no gain in box [AOI4]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-CEG-WITH-NOTL-NUMBER-YEARS.1">Number of years entered in box [AOI5], but no gain in box [AOI4]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-NOS-YEARS-CEG-WITHOUT-NOTL.1">6256</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-NOS-YEARS-CEG-WITHOUT-NOTL.1">Number of years entered in box [AOI7] but no gain in box [AOI6]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-NOS-YEARS-CEG-WITHOUT-NOTL.1">Number of years entered in box [AOI7] but no gain in box [AOI6]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF3-NOS-YEARS-GAINS-VOID-ISA.1">6316</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF3-NOS-YEARS-GAINS-VOID-ISA.1">Number of years entered in box [AOI9] but no gain in box [AOI8]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF3-NOS-YEARS-GAINS-VOID-ISA.1">Number of years entered in box [AOI9] but no gain in box [AOI8]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF3-VOID-ISA-TAX-DEDUCTED.0">6318</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF3-VOID-ISA-TAX-DEDUCTED.0">[AOI10] is present so the following should be true: [AOI8] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF3-VOID-ISA-TAX-DEDUCTED.0">[AOI10] is present so the following should be true: [AOI8] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF3-VOID-ISA-TAX-DEDUCTED.1">6319</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF3-VOID-ISA-TAX-DEDUCTED.1">[AOI10] is valid only if this does not exceed ( ( [AOI8] times [20%] ) plus 1 )</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF3-VOID-ISA-TAX-DEDUCTED.1">[AOI10] is valid only if this does not exceed ( ( [AOI8] times [20%] ) plus 1 )</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-BUS-RCPTS-TAXED-IN-YEAR.0">8661</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-BUS-RCPTS-TAXED-IN-YEAR.0">The entry must be a valid pair of consecutive years in the format YYYY YY. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-BUS-RCPTS-TAXED-IN-YEAR.0">The entry must be a valid pair of consecutive years in the format YYYY YY. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.MPL2-TOT-TAX-DED-FROM-LUMP-SUM.1">6358</sch:diagnostic>
    <sch:diagnostic id="transactional.MPL2-TOT-TAX-DED-FROM-LUMP-SUM.1">Box [ASE7] must be absent if there is an entry greater than zero in box [ASE6]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MPL2-TOT-TAX-DED-FROM-LUMP-SUM.1">Box [ASE7] must be absent if there is an entry greater than zero in box [ASE6]</sch:diagnostic>
    <sch:diagnostic id="errorCode.MPL-LUMP-SUM-TAX-INCLUDED-SIG.1">6357</sch:diagnostic>
    <sch:diagnostic id="transactional.MPL-LUMP-SUM-TAX-INCLUDED-SIG.1">There is an entry in box [ASE7]. There must be an entry greater than zero in box [EMP2]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MPL-LUMP-SUM-TAX-INCLUDED-SIG.1">There is an entry in box [ASE7]. There must be an entry greater than zero in box [EMP2]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.MPL-LUMP-SUM-EXEMPTION.1">6257</sch:diagnostic>
    <sch:diagnostic id="transactional.MPL-LUMP-SUM-EXEMPTION.1">The amount in box [ASE9] exceeds the maximum relief allowable of [£30,000]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MPL-LUMP-SUM-EXEMPTION.1">The amount in box [ASE9] exceeds the maximum relief allowable of [£30,000]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.MPL3-FOREIGN-EARNINGS-DEDN.1">6526</sch:diagnostic>
    <sch:diagnostic id="transactional.MPL3-FOREIGN-EARNINGS-DEDN.1">The entry in box [ASE11] exceeds the total of boxes ( [MOR38] +  [EMP1] + [EMP3] + [EMP9] + [EMP10] + [EMP11] + [EMP12] + [EMP13] + [EMP14] + [EMP15] + [EMP16] + [ASE3] + [ASE4] + [ASE5]) less ( [ASE12] + [EMP19] + [EMP18] + [EMP20] + [EMP17]). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MPL3-FOREIGN-EARNINGS-DEDN.1">The entry in box [ASE11] exceeds the total of boxes ( [MOR38] +  [EMP1] + [EMP3] + [EMP9] + [EMP10] + [EMP11] + [EMP12] + [EMP13] + [EMP14] + [EMP15] + [EMP16] + [ASE3] + [ASE4] + [ASE5]) less ( [ASE12] + [EMP19] + [EMP18] + [EMP20] + [EMP17]). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.MPL3-FOREIGN-EARNINGS-NOT-TXBL.1">6429</sch:diagnostic>
    <sch:diagnostic id="transactional.MPL3-FOREIGN-EARNINGS-NOT-TXBL.1">The entry in box [ASE12] exceeds the total of boxes [MOR38] +  [EMP1] + [EMP3] + [EMP9] + [EMP10] + [EMP11] + [EMP12] + [EMP13] + [EMP14] + [EMP15] + [EMP16] + [ASE3] + [ASE4] + [ASE5]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MPL3-FOREIGN-EARNINGS-NOT-TXBL.1">The entry in box [ASE12] exceeds the total of boxes [MOR38] +  [EMP1] + [EMP3] + [EMP9] + [EMP10] + [EMP11] + [EMP12] + [EMP13] + [EMP14] + [EMP15] + [EMP16] + [ASE3] + [ASE4] + [ASE5]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.MPL3-FOREIGN-TAX.1">6527</sch:diagnostic>
    <sch:diagnostic id="transactional.MPL3-FOREIGN-TAX.1">The entry in box [ASE13] exceeds the  total of boxes ( [MOR38] + [EMP1] + [EMP3] + [EMP9] + [EMP10] + [EMP11] + [EMP12] + [EMP13] + [EMP14] + [EMP15] + [EMP16] + [ASE3] + [ASE4] + [ASE5] ) less ( [ASE12] + [EMP17] + [EMP18] + [EMP19] + [EMP20] + [ASE11]). Please check.  If the sum is negative please treat as zero.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MPL3-FOREIGN-TAX.1">The entry in box [ASE13] exceeds the  total of boxes ( [MOR38] + [EMP1] + [EMP3] + [EMP9] + [EMP10] + [EMP11] + [EMP12] + [EMP13] + [EMP14] + [EMP15] + [EMP16] + [ASE3] + [ASE4] + [ASE5] ) less ( [ASE12] + [EMP17] + [EMP18] + [EMP19] + [EMP20] + [ASE11]). Please check.  If the sum is negative please treat as zero.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-VENT-CAP-TRUST-SHARE-SUBS.0">6280</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-VENT-CAP-TRUST-SHARE-SUBS.0">The amount in box [AOR1] exceeds the maximum relief allowable of [£200,000]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-VENT-CAP-TRUST-SHARE-SUBS.0">The amount in box [AOR1] exceeds the maximum relief allowable of [£200,000]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-EIS-RELIEF-CLAIMED.0">6268</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-EIS-RELIEF-CLAIMED.0">The amount in box [AOR2] exceeds the maximum relief allowable of [£2,000,000]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-EIS-RELIEF-CLAIMED.0">The amount in box [AOR2] exceeds the maximum relief allowable of [£2,000,000]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-ALIMONY-NEW-RULES-RELIEF.0">6409</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-ALIMONY-NEW-RULES-RELIEF.0">The amount in box [AOR7] exceeds the upper limit for relief of  [£4,360]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-ALIMONY-NEW-RULES-RELIEF.0">The amount in box [AOR7] exceeds the upper limit for relief of  [£4,360]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-TRADE-UNION-DEATH-BENEFITS.0">6022</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-TRADE-UNION-DEATH-BENEFITS.0">The amount in box [AOR8] exceeds [£100]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-TRADE-UNION-DEATH-BENEFITS.0">The amount in box [AOR8] exceeds [£100]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-SEED-EIS-AMT.0">8291</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-SEED-EIS-AMT.0">The amount in box [AOR10] exceeds the maximum relief allowable of [£200,000]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-SEED-EIS-AMT.0">The amount in box [AOR10] exceeds the maximum relief allowable of [£200,000]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF4-WIFES-NAME.0">6064</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF4-WIFES-NAME.0">There is an entry in box [MCA1]. An entry must be present in at least one of boxes [MCA2], [MCA5] or [YPD1] with a date before 6th April 1935. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF4-WIFES-NAME.0">There is an entry in box [MCA1]. An entry must be present in at least one of boxes [MCA2], [MCA5] or [YPD1] with a date before 6th April 1935. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF4-WIFES-NAME.1">8331</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF4-WIFES-NAME.1">The entry in box [MCA1] should not be present as there is an entry in box [MAT1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF4-WIFES-NAME.1">The entry in box [MCA1] should not be present as there is an entry in box [MAT1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-SPOUSES-BIRTH-DATE.1">6102</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-SPOUSES-BIRTH-DATE.1">If present date of birth must be before 6 April 1935.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-SPOUSES-BIRTH-DATE.1">If present date of birth must be before 6 April 1935.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-WHOLE-ALLOCN-TO-WIFE-SIG.2">6419</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-WHOLE-ALLOCN-TO-WIFE-SIG.2">Box [MCA3] completed, you cannot complete box [MCA4]. Please amend box [MCA3] or [MCA4].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-WHOLE-ALLOCN-TO-WIFE-SIG.2">Box [MCA3] completed, you cannot complete box [MCA4]. Please amend box [MCA3] or [MCA4].</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF4-PERSNL-HUSBANDS-NAME.0">8332</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF4-PERSNL-HUSBANDS-NAME.0">The entry in box [MCA8] should not be present as there is an entry in box [MAT1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF4-PERSNL-HUSBANDS-NAME.0">The entry in box [MCA8] should not be present as there is an entry in box [MAT1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-MARRIAGE-DATE.1">6414</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-MARRIAGE-DATE.1">Must be a date between 6 April and 5 April of the year of the return. Please amend the entry.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-MARRIAGE-DATE.1">Must be a date between 6 April and 5 April of the year of the return. Please amend the entry.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-MARRIAGE-DATE.2">6545</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-MARRIAGE-DATE.2">Box [MCA9] completed, an entry is required in box either [MCA1] or [MCA8]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-MARRIAGE-DATE.2">Box [MCA9] completed, an entry is required in box either [MCA1] or [MCA8]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-SOMEONE-ELSES-ALLCES-SIG.1">6529</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-SOMEONE-ELSES-ALLCES-SIG.1">Box [CAL13] must be completed if box [MCA10] completed. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-SOMEONE-ELSES-ALLCES-SIG.1">Box [CAL13] must be completed if box [MCA10] completed. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-TRANS-ALLCES-TO-SPOUSE-SIG.1">6303</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-TRANS-ALLCES-TO-SPOUSE-SIG.1">Box [MCA11] completed. You cannot complete box [CAL13]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-TRANS-ALLCES-TO-SPOUSE-SIG.1">Box [MCA11] completed. You cannot complete box [CAL13]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-FY-LOSS-RELIEF-AMT.0">6551</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-FY-LOSS-RELIEF-AMT.0">[AIL5] must be present if [AIL3] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-FY-LOSS-RELIEF-AMT.0">[AIL5] must be present if [AIL3] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-FY-UNCAPP-LOSS-RELIEF-AMT.0">8299</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-FY-UNCAPP-LOSS-RELIEF-AMT.0">[AIL4] is valid only if this does not exceed [AIL3].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-FY-UNCAPP-LOSS-RELIEF-AMT.0">[AIL4] is valid only if this does not exceed [AIL3].</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-FY-LOSS-RELIEF-SOURCE-YEAR.0">6227</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-FY-LOSS-RELIEF-SOURCE-YEAR.0">The entry must be a valid pair of consecutive years in the format YYYY YY. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-FY-LOSS-RELIEF-SOURCE-YEAR.0">The entry must be a valid pair of consecutive years in the format YYYY YY. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-FY-LOSS-RELIEF-SOURCE-YEAR.1">6551</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-FY-LOSS-RELIEF-SOURCE-YEAR.1">There is an entry in box [AIL5], an entry must be present in [AIL3]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-FY-LOSS-RELIEF-SOURCE-YEAR.1">There is an entry in box [AIL5], an entry must be present in [AIL3]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PEN-ANNL-ALLCE-TAX-PAID-AMT.0">8254</sch:diagnostic>
    <sch:diagnostic id="transactional.PEN-ANNL-ALLCE-TAX-PAID-AMT.0">The amount in box [AIL11] must be less than [AIL10]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PEN-ANNL-ALLCE-TAX-PAID-AMT.0">The amount in box [AIL11] must be less than [AIL10]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PEN-BEN-OVERSEAS-TRANS-TAX.0">8430</sch:diagnostic>
    <sch:diagnostic id="transactional.PEN-BEN-OVERSEAS-TRANS-TAX.0">There is an entry in[AIL11.2]  so please complete [AIL11.1] </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PEN-BEN-OVERSEAS-TRANS-TAX.0">There is an entry in[AIL11.2]  so please complete [AIL11.1] </sch:diagnostic>
    <sch:diagnostic id="errorCode.PEN-BEN-OVERSEAS-TRANS-TAX.1">8431</sch:diagnostic>
    <sch:diagnostic id="transactional.PEN-BEN-OVERSEAS-TRANS-TAX.1">The amount in box [AIL11.2] exceeds [AIL11.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PEN-BEN-OVERSEAS-TRANS-TAX.1">The amount in box [AIL11.2] exceeds [AIL11.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PEN-FRGN-TAX-ON-PAYTS-PAID-AMT.0">8432</sch:diagnostic>
    <sch:diagnostic id="transactional.PEN-FRGN-TAX-ON-PAYTS-PAID-AMT.0">There is an entry in[AIL15] so please complete  [AIL13] or [AIL14] </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PEN-FRGN-TAX-ON-PAYTS-PAID-AMT.0">There is an entry in[AIL15] so please complete  [AIL13] or [AIL14] </sch:diagnostic>
    <sch:diagnostic id="errorCode.PEN-FRGN-TAX-ON-PAYTS-PAID-AMT.1">8433</sch:diagnostic>
    <sch:diagnostic id="transactional.PEN-FRGN-TAX-ON-PAYTS-PAID-AMT.1">The entry in [AIL15] must be less than ( [AIL13] plus [AIL14] ) Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PEN-FRGN-TAX-ON-PAYTS-PAID-AMT.1">The entry in [AIL15] must be less than ( [AIL13] plus [AIL14] ) Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-AVOIDANCE-SCHEME-YEAR.0">8565</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-AVOIDANCE-SCHEME-YEAR.0">[AIL20] must be a valid pair of consecutive years in the format YYYY-YY.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-AVOIDANCE-SCHEME-YEAR.0">[AIL20] must be a valid pair of consecutive years in the format YYYY-YY.</sch:diagnostic>
    <sch:diagnostic id="errorCode.MPL-PYRLD-BIK-SLR.0">8634</sch:diagnostic>
    <sch:diagnostic id="transactional.MPL-PYRLD-BIK-SLR.0">[EMP1.1] is valid only if this does not exceed [EMP1]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MPL-PYRLD-BIK-SLR.0">[EMP1.1] is valid only if this does not exceed [EMP1]</sch:diagnostic>
    <sch:diagnostic id="errorCode.MPL2-TAX-DEDUCTED-AT-SOURCE.1">6504</sch:diagnostic>
    <sch:diagnostic id="transactional.MPL2-TAX-DEDUCTED-AT-SOURCE.1">This box must not be negative because there is only one [SA102] employment page present, and no positive instances of [MOR3].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MPL2-TAX-DEDUCTED-AT-SOURCE.1">This box must not be negative because there is only one [SA102] employment page present, and no positive instances of [MOR3].</sch:diagnostic>
    <sch:diagnostic id="errorCode.MPL-COMPANY-DIRECTOR-SIGNAL.0">8662</sch:diagnostic>
    <sch:diagnostic id="transactional.MPL-COMPANY-DIRECTOR-SIGNAL.0">[EMP7] must be present if [EMP6] equals 'yes'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MPL-COMPANY-DIRECTOR-SIGNAL.0">[EMP7] must be present if [EMP6] equals 'yes'</sch:diagnostic>
    <sch:diagnostic id="errorCode.MPL-COMPANY-DIRECTOR-CEASED.0">8315</sch:diagnostic>
    <sch:diagnostic id="transactional.MPL-COMPANY-DIRECTOR-CEASED.0">[EMP6] must equal 'yes' if [EMP6.1] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MPL-COMPANY-DIRECTOR-CEASED.0">[EMP6] must equal 'yes' if [EMP6.1] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.MPL-COMPANY-DIRECTOR-CEASED.1">8323</sch:diagnostic>
    <sch:diagnostic id="transactional.MPL-COMPANY-DIRECTOR-CEASED.1">[EMP6.1] must be within the current return year</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MPL-COMPANY-DIRECTOR-CEASED.1">[EMP6.1] must be within the current return year</sch:diagnostic>
    <sch:diagnostic id="errorCode.MPL-CLOSE-COMPANY-DIRECTOR-SIG.0">8663</sch:diagnostic>
    <sch:diagnostic id="transactional.MPL-CLOSE-COMPANY-DIRECTOR-SIG.0">[EMP7.1] must be present if [EMP7] equals 'yes'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MPL-CLOSE-COMPANY-DIRECTOR-SIG.0">[EMP7.1] must be present if [EMP7] equals 'yes'</sch:diagnostic>
    <sch:diagnostic id="errorCode.MPL-CLOSE-COMPANY-DIRECTOR-SIG.1">8664</sch:diagnostic>
    <sch:diagnostic id="transactional.MPL-CLOSE-COMPANY-DIRECTOR-SIG.1">[EMP7.2] must be present if [EMP7] equals 'yes'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MPL-CLOSE-COMPANY-DIRECTOR-SIG.1">[EMP7.2] must be present if [EMP7] equals 'yes'</sch:diagnostic>
    <sch:diagnostic id="errorCode.MPL-CLOSE-COMPANY-DIRECTOR-SIG.2">8665</sch:diagnostic>
    <sch:diagnostic id="transactional.MPL-CLOSE-COMPANY-DIRECTOR-SIG.2">[EMP7.3] must be present if [EMP7] equals 'yes'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MPL-CLOSE-COMPANY-DIRECTOR-SIG.2">[EMP7.3] must be present if [EMP7] equals 'yes'</sch:diagnostic>
    <sch:diagnostic id="errorCode.MPL-CLOSE-COMPANY-DIRECTOR-SIG.3">8666</sch:diagnostic>
    <sch:diagnostic id="transactional.MPL-CLOSE-COMPANY-DIRECTOR-SIG.3">[EMP7.4] must be present if [EMP7] equals 'yes'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MPL-CLOSE-COMPANY-DIRECTOR-SIG.3">[EMP7.4] must be present if [EMP7] equals 'yes'</sch:diagnostic>
    <sch:diagnostic id="errorCode.MPL-FIXED-DEDUCTION-EXPENSES.0">8328</sch:diagnostic>
    <sch:diagnostic id="transactional.MPL-FIXED-DEDUCTION-EXPENSES.0">[EMP18] is valid only if this does not exceed [£1,132]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MPL-FIXED-DEDUCTION-EXPENSES.0">[EMP18] is valid only if this does not exceed [£1,132]</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA102M.1">6024</sch:diagnostic>
    <sch:diagnostic id="transactional.SA102M.1">There is an entry in [MOR13] or [MOR14] or [MOR15] or [MOR16] or [MOR17] or [MOR18]. Please complete [MOR19].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA102M.1">There is an entry in [MOR13] or [MOR14] or [MOR15] or [MOR16] or [MOR17] or [MOR18]. Please complete [MOR19].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA102M.2">6025</sch:diagnostic>
    <sch:diagnostic id="transactional.SA102M.2">There is an entry in [MOR12] or [MOR19]. Please complete box [MOR20].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA102M.2">There is an entry in [MOR12] or [MOR19]. Please complete box [MOR20].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA102M.3">6026</sch:diagnostic>
    <sch:diagnostic id="transactional.SA102M.3">There is an entry in [MOR21] or [MOR22] or [MOR23] or [MOR24] or [MOR25]. Please complete [MOR26].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA102M.3">There is an entry in [MOR21] or [MOR22] or [MOR23] or [MOR24] or [MOR25]. Please complete [MOR26].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA102M.5">6029</sch:diagnostic>
    <sch:diagnostic id="transactional.SA102M.5">The sum of ( ( [MOR20] plus [MOR36] ) minus ( [MOR26] plus [MOR35] ) ) exceeds 0. Please complete [MOR38].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA102M.5">The sum of ( ( [MOR20] plus [MOR36] ) minus ( [MOR26] plus [MOR35] ) ) exceeds 0. Please complete [MOR38].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA102M.6">6030</sch:diagnostic>
    <sch:diagnostic id="transactional.SA102M.6">There is an entry in [MOR3] or [MOR9] or [MOR11] or [MOR37]. Please complete [MOR39].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA102M.6">There is an entry in [MOR3] or [MOR9] or [MOR11] or [MOR37]. Please complete [MOR39].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA102M.0">8635</sch:diagnostic>
    <sch:diagnostic id="transactional.SA102M.0">[MOR12] must be present if [MOR2] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA102M.0">[MOR12] must be present if [MOR2] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA102M.4">8636</sch:diagnostic>
    <sch:diagnostic id="transactional.SA102M.4">[MOR12] must be present if [MOR4] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA102M.4">[MOR12] must be present if [MOR4] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA102M.8">8638</sch:diagnostic>
    <sch:diagnostic id="transactional.SA102M.8">[MOR12] must be present if [MOR5] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA102M.8">[MOR12] must be present if [MOR5] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA102M.9">8639</sch:diagnostic>
    <sch:diagnostic id="transactional.SA102M.9">[MOR12] must be present if [MOR6] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA102M.9">[MOR12] must be present if [MOR6] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA102M.10">8640</sch:diagnostic>
    <sch:diagnostic id="transactional.SA102M.10">[MOR12] must be present if [MOR7] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA102M.10">[MOR12] must be present if [MOR7] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA102M.11">8641</sch:diagnostic>
    <sch:diagnostic id="transactional.SA102M.11">[MOR12] must be present if [MOR8] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA102M.11">[MOR12] must be present if [MOR8] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA102M.12">8642</sch:diagnostic>
    <sch:diagnostic id="transactional.SA102M.12">[MOR12] must be present if [MOR10] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA102M.12">[MOR12] must be present if [MOR10] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.MOR4-PYRLD-BIK-SLR.0">8643</sch:diagnostic>
    <sch:diagnostic id="transactional.MOR4-PYRLD-BIK-SLR.0">[MOR2.1] is valid only if this does not exceed [MOR2]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MOR4-PYRLD-BIK-SLR.0">[MOR2.1] is valid only if this does not exceed [MOR2]</sch:diagnostic>
    <sch:diagnostic id="errorCode.MOR4-SALARY-STIPEND-TAX-AMO.1">6792</sch:diagnostic>
    <sch:diagnostic id="transactional.MOR4-SALARY-STIPEND-TAX-AMO.1">There is an amount in box [MOR3]. Please complete box [MOR2].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MOR4-SALARY-STIPEND-TAX-AMO.1">There is an amount in box [MOR3]. Please complete box [MOR2].</sch:diagnostic>
    <sch:diagnostic id="errorCode.MOR4-SALARY-STIPEND-TAX-AMO.2">6505</sch:diagnostic>
    <sch:diagnostic id="transactional.MOR4-SALARY-STIPEND-TAX-AMO.2">This box must not be negative because there is only one [SA102M] minister of religion page present, and no positive instances of [EMP2].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MOR4-SALARY-STIPEND-TAX-AMO.2">This box must not be negative because there is only one [SA102M] minister of religion page present, and no positive instances of [EMP2].</sch:diagnostic>
    <sch:diagnostic id="errorCode.MOR4-ROUND-SUM-RENT-TAX-AMOUNT.1">6794</sch:diagnostic>
    <sch:diagnostic id="transactional.MOR4-ROUND-SUM-RENT-TAX-AMOUNT.1">There is an amount in box [MOR9]. Please complete box [MOR8].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MOR4-ROUND-SUM-RENT-TAX-AMOUNT.1">There is an amount in box [MOR9]. Please complete box [MOR8].</sch:diagnostic>
    <sch:diagnostic id="errorCode.MOR4-MOR-OTHER-INC-BC-TAX-AMO.1">6795</sch:diagnostic>
    <sch:diagnostic id="transactional.MOR4-MOR-OTHER-INC-BC-TAX-AMO.1">There is an amount in box [MOR11]. Please complete box [MOR10].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MOR4-MOR-OTHER-INC-BC-TAX-AMO.1">There is an amount in box [MOR11]. Please complete box [MOR10].</sch:diagnostic>
    <sch:diagnostic id="errorCode.MOR4-MOR-INCOME-TOT.0">6028</sch:diagnostic>
    <sch:diagnostic id="transactional.MOR4-MOR-INCOME-TOT.0">[MOR12] is valid only if this equals ( The sum of [MOR2], [MOR4], [MOR5], [MOR6], [MOR7], [MOR8], and [MOR10] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MOR4-MOR-INCOME-TOT.0">[MOR12] is valid only if this equals ( The sum of [MOR2], [MOR4], [MOR5], [MOR6], [MOR7], [MOR8], and [MOR10] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.MOR4-MOR-BENEFIT-TOT.1">6039</sch:diagnostic>
    <sch:diagnostic id="transactional.MOR4-MOR-BENEFIT-TOT.1">The amount in box [MOR19] must equal ( the sum of [MOR13], [MOR14], [MOR15], [MOR16], [MOR17], and [MOR18] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MOR4-MOR-BENEFIT-TOT.1">The amount in box [MOR19] must equal ( the sum of [MOR13], [MOR14], [MOR15], [MOR16], [MOR17], and [MOR18] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.MOR4-MOR-TAXABLE-INC-TOT.0">6796</sch:diagnostic>
    <sch:diagnostic id="transactional.MOR4-MOR-TAXABLE-INC-TOT.0">The amount in box [MOR20] exceeds ( [MOR12] plus [MOR19] ). Please check. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MOR4-MOR-TAXABLE-INC-TOT.0">The amount in box [MOR20] exceeds ( [MOR12] plus [MOR19] ). Please check. </sch:diagnostic>
    <sch:diagnostic id="errorCode.MOR4-MOR-TOTAL-EXPENSE-AMO.1">6040</sch:diagnostic>
    <sch:diagnostic id="transactional.MOR4-MOR-TOTAL-EXPENSE-AMO.1">The amount in box [MOR26] must equal ( the sum of [MOR23], [MOR22], [MOR21], [MOR24], and [MOR25] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MOR4-MOR-TOTAL-EXPENSE-AMO.1">The amount in box [MOR26] must equal ( the sum of [MOR23], [MOR22], [MOR21], [MOR24], and [MOR25] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.MOR4-SBCC-GROSS-INCOME-AMT.0">6041</sch:diagnostic>
    <sch:diagnostic id="transactional.MOR4-SBCC-GROSS-INCOME-AMT.0">The amount in box [MOR27] exceeds the amount of [MOR20] minus ([MOR5] plus [MOR13]). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MOR4-SBCC-GROSS-INCOME-AMT.0">The amount in box [MOR27] exceeds the amount of [MOR20] minus ([MOR5] plus [MOR13]). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.MOR4-SBCC-NET-INCOME-AMT.1">6231</sch:diagnostic>
    <sch:diagnostic id="transactional.MOR4-SBCC-NET-INCOME-AMT.1">The amount in box [MOR31] must equal ( ( [MOR27] plus [MOR28] ) minus ( the sum of [MOR26], [MOR29], and [MOR30] ) ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MOR4-SBCC-NET-INCOME-AMT.1">The amount in box [MOR31] must equal ( ( [MOR27] plus [MOR28] ) minus ( the sum of [MOR26], [MOR29], and [MOR30] ) ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.MOR4-SBCC-10PC-NET-INCOME-AMT.1">6232</sch:diagnostic>
    <sch:diagnostic id="transactional.MOR4-SBCC-10PC-NET-INCOME-AMT.1">The amount in box [MOR32] must be less than or equal to ([MOR31] x 10%). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MOR4-SBCC-10PC-NET-INCOME-AMT.1">The amount in box [MOR32] must be less than or equal to ([MOR31] x 10%). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.MOR4-SBCC-SERVICE-BEN-RECD-AMT.1">6233</sch:diagnostic>
    <sch:diagnostic id="transactional.MOR4-SBCC-SERVICE-BEN-RECD-AMT.1">The amount in box [MOR34] must equal ( [MOR5] plus [MOR13] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MOR4-SBCC-SERVICE-BEN-RECD-AMT.1">The amount in box [MOR34] must equal ( [MOR5] plus [MOR13] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.MOR4-SERVICE-BEN-CAP-EXP-AMO.1">6049</sch:diagnostic>
    <sch:diagnostic id="transactional.MOR4-SERVICE-BEN-CAP-EXP-AMO.1">The amount in box [MOR35] must equal ( [MOR33] plus [MOR34] minus [MOR32] ). Please check.  </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MOR4-SERVICE-BEN-CAP-EXP-AMO.1">The amount in box [MOR35] must equal ( [MOR33] plus [MOR34] minus [MOR32] ). Please check.  </sch:diagnostic>
    <sch:diagnostic id="errorCode.MOR4-OTHER-MNSTRY-TAX-TOT.2">6050</sch:diagnostic>
    <sch:diagnostic id="transactional.MOR4-OTHER-MNSTRY-TAX-TOT.2">The amount in box [MOR37] exceeds [MOR36]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MOR4-OTHER-MNSTRY-TAX-TOT.2">The amount in box [MOR37] exceeds [MOR36]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.MOR4-OTHER-MNSTRY-TAX-TOT.3">6590</sch:diagnostic>
    <sch:diagnostic id="transactional.MOR4-OTHER-MNSTRY-TAX-TOT.3">There is an amount in box [MOR37]. Please complete box [MOR36].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MOR4-OTHER-MNSTRY-TAX-TOT.3">There is an amount in box [MOR37]. Please complete box [MOR36].</sch:diagnostic>
    <sch:diagnostic id="errorCode.MOR-MOR-TOTAL-TAXABLE-INCOME.1">6051</sch:diagnostic>
    <sch:diagnostic id="transactional.MOR-MOR-TOTAL-TAXABLE-INCOME.1">The amount in box [MOR38] must equal ( ( [MOR20] plus [MOR36] ) minus ( [MOR26] plus [MOR35] ) ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MOR-MOR-TOTAL-TAXABLE-INCOME.1">The amount in box [MOR38] must equal ( ( [MOR20] plus [MOR36] ) minus ( [MOR26] plus [MOR35] ) ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.MOR-MOR-TOTAL-TAX-PAID.1">6052</sch:diagnostic>
    <sch:diagnostic id="transactional.MOR-MOR-TOTAL-TAX-PAID.1">The amount in box [MOR39] must equal ( the sum of [MOR3], [MOR9], [MOR11], and [MOR37] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MOR-MOR-TOTAL-TAX-PAID.1">The amount in box [MOR39] must equal ( the sum of [MOR3], [MOR9], [MOR11], and [MOR37] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103F.0">6031</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103F.0">There is an entry in [FSE8]. Please complete [FSE9].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103F.0">There is an entry in [FSE8]. Please complete [FSE9].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103F.1">6032</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103F.1">There is an entry in [FSE17] or [FSE18] or [FSE19] or [FSE20] or [FSE21] or [FSE22] or [FSE23] or [FSE24] or [FSE25] or [FSE26] or [FSE27] or [FSE28] or [FSE29] or [FSE30]. Please complete box [FSE31].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103F.1">There is an entry in [FSE17] or [FSE18] or [FSE19] or [FSE20] or [FSE21] or [FSE22] or [FSE23] or [FSE24] or [FSE25] or [FSE26] or [FSE27] or [FSE28] or [FSE29] or [FSE30]. Please complete box [FSE31].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103F.2">6033</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103F.2">There is an entry in [FSE32] or [FSE33] or [FSE34] or [FSE35] or [FSE36] or [FSE37] or [FSE38] or [FSE39] or [FSE40] or [FSE41] or [FSE42] or [FSE43] or [FSE44] or [FSE45]. Please complete box [FSE46].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103F.2">There is an entry in [FSE32] or [FSE33] or [FSE34] or [FSE35] or [FSE36] or [FSE37] or [FSE38] or [FSE39] or [FSE40] or [FSE41] or [FSE42] or [FSE43] or [FSE44] or [FSE45]. Please complete box [FSE46].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103F.3">6034</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103F.3">The sum of ( ( [FSE15] plus [FSE16] ) minus [FSE31] ) is non-zero. Please complete [FSE47/FSE48].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103F.3">The sum of ( ( [FSE15] plus [FSE16] ) minus [FSE31] ) is non-zero. Please complete [FSE47/FSE48].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103F.6">6042</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103F.6">There is an entry in [FSE57] or [FSE62]. Please complete box [FSE63].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103F.6">There is an entry in [FSE57] or [FSE62]. Please complete box [FSE63].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103F.7">6044</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103F.7">The sum of ( ( [FSE47/FSE48] plus [FSE61] ) minus ( [FSE63] ) ) is non-zero. Please complete [FSE64 / FSE65].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103F.7">The sum of ( ( [FSE47/FSE48] plus [FSE61] ) minus ( [FSE63] ) ) is non-zero. Please complete [FSE64 / FSE65].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103F.8">6045</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103F.8">The entry in any of the boxes [FSE73] or [FSE74] or [FSE75] exceeds 0. Please complete box [FSE76].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103F.8">The entry in any of the boxes [FSE73] or [FSE74] or [FSE75] exceeds 0. Please complete box [FSE76].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103F.10">6048</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103F.10">There is an entry in [FSE83] or [FSE84] or [FSE85] or [FSE86] or [FSE87] or [FSE88] or [FSE89]. Please complete box [FSE90].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103F.10">There is an entry in [FSE83] or [FSE84] or [FSE85] or [FSE86] or [FSE87] or [FSE88] or [FSE89]. Please complete box [FSE90].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103F.11">6057</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103F.11">There is an entry in [FSE90] or [FSE91] or [FSE92] or [FSE93]. Please complete box [FSE94].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103F.11">There is an entry in [FSE90] or [FSE91] or [FSE92] or [FSE93]. Please complete box [FSE94].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103F.12">6058</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103F.12">There is an entry in [FSE95] or [FSE96] or [FSE97] or [FSE98]. Please complete box [FSE99].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103F.12">There is an entry in [FSE95] or [FSE96] or [FSE97] or [FSE98]. Please complete box [FSE99].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103F.4">8434</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103F.4">There is an entry in box [FSE46] please complete [FSE61] </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103F.4">There is an entry in box [FSE46] please complete [FSE61] </sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103F.5">8435</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103F.5">There is an entry in box [FSE59] please complete [FSE61] </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103F.5">There is an entry in box [FSE59] please complete [FSE61] </sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103F.9">8436</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103F.9">There is an entry in box [FSE60] please complete [FSE61]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103F.9">There is an entry in box [FSE60] please complete [FSE61]</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103F.13">8215</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103F.13">The amount in box [FSE73] must equal ([FSE64 / FSE65] + [FSE68] - [FSE16.1] + [FSE72] +  [FSE71]) if the sum of ([FSE64 / FSE65] + [FSE68] - [FSE16.1] ) is positive. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103F.13">The amount in box [FSE73] must equal ([FSE64 / FSE65] + [FSE68] - [FSE16.1] + [FSE72] +  [FSE71]) if the sum of ([FSE64 / FSE65] + [FSE68] - [FSE16.1] ) is positive. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103F.14">8216</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103F.14">The sum of ([FSE64 / FSE65] + [FSE68] - [FSE16.1]) is negative or zero. If ([FSE71] + [FSE72]) is greater than zero, the amount in box [FSE73] must equal ([FSE71] + [FSE72]) or [FSE73] must be zero or absent. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103F.14">The sum of ([FSE64 / FSE65] + [FSE68] - [FSE16.1]) is negative or zero. If ([FSE71] + [FSE72]) is greater than zero, the amount in box [FSE73] must equal ([FSE71] + [FSE72]) or [FSE73] must be zero or absent. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103F.15">8217</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103F.15">The sum of ([FSE64 / FSE65] + [FSE68] - [FSE16.1]) is negative. Please complete box [FSE77] with the positive equivalent.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103F.15">The sum of ([FSE64 / FSE65] + [FSE68] - [FSE16.1]) is negative. Please complete box [FSE77] with the positive equivalent.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-BUSINESS-COMM-QUES.0">8667</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-BUSINESS-COMM-QUES.0">[FSE6] must be present if [FSE6Q] equals 'yes'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-BUSINESS-COMM-QUES.0">[FSE6] must be present if [FSE6Q] equals 'yes'</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF1-COMMENCEMENT-DATE.1">6433</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF1-COMMENCEMENT-DATE.1">Must be a date between 6 April and 5 April of the year of the return. Please amend the entry.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF1-COMMENCEMENT-DATE.1">Must be a date between 6 April and 5 April of the year of the return. Please amend the entry.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-BUSINESS-CESS-QUES.0">8668</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-BUSINESS-CESS-QUES.0">[FSE7] must be present if [FSE7Q] equals 'yes'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-BUSINESS-CESS-QUES.0">[FSE7] must be present if [FSE7Q] equals 'yes'</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-CESSATION-DATE.1">6433</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-CESSATION-DATE.1">Must be a date between 6 April and 5 April of the year of the return. Please amend the entry.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-CESSATION-DATE.1">Must be a date between 6 April and 5 April of the year of the return. Please amend the entry.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-CESSATION-DATE.2">6434</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-CESSATION-DATE.2">The date cannot be earlier than [FSE6]. Please amend the entry.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-CESSATION-DATE.2">The date cannot be earlier than [FSE6]. Please amend the entry.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-ACCOUNT-END-DATE.1">6195</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-ACCOUNT-END-DATE.1">The date cannot be earlier than [FSE8]. Please amend the entry.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-ACCOUNT-END-DATE.1">The date cannot be earlier than [FSE8]. Please amend the entry.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-ACCOUNT-END-DATE.2">6061</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-ACCOUNT-END-DATE.2">There is a date entered in [FSE9]. Please enter a date in [FSE8].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-ACCOUNT-END-DATE.2">There is a date entered in [FSE9]. Please enter a date in [FSE8].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-BUSINESS-SALES-TURNOVER.1">6435</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-BUSINESS-SALES-TURNOVER.1">There is an amount in box [FSE15]. Please complete box [FSE8].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-BUSINESS-SALES-TURNOVER.1">There is an amount in box [FSE15]. Please complete box [FSE8].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-OTHER-INCOME-PROFITS.1">6437</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-OTHER-INCOME-PROFITS.1">There is an amount in box [FSE16]. Please complete box [FSE8].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-OTHER-INCOME-PROFITS.1">There is an amount in box [FSE16]. Please complete box [FSE8].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-TRADING-INCOME-ALLOWANCE.0">8450</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-TRADING-INCOME-ALLOWANCE.0">[FSE16.1] must be less than or equal to ( [FSE64 / FSE65] + [FSE68] ).</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-TRADING-INCOME-ALLOWANCE.0">[FSE16.1] must be less than or equal to ( [FSE64 / FSE65] + [FSE68] ).</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-TRADING-INCOME-ALLOWANCE.2">8560</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-TRADING-INCOME-ALLOWANCE.2">If there is an entry in box [FSE16.1] then all instances of [SSE21/SSE22] can not be negative. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-TRADING-INCOME-ALLOWANCE.2">If there is an entry in box [FSE16.1] then all instances of [SSE21/SSE22] can not be negative. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF2-COST-OF-SALES.0">8452</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF2-COST-OF-SALES.0">The entry in box [FSE17] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF2-COST-OF-SALES.0">The entry in box [FSE17] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-SUB-CONTRACTOR-COSTS.0">8453</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-SUB-CONTRACTOR-COSTS.0">The entry in box [FSE18] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-SUB-CONTRACTOR-COSTS.0">The entry in box [FSE18] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-EMPLOYEE-COSTS.0">8454</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-EMPLOYEE-COSTS.0">The entry in box [FSE19] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-EMPLOYEE-COSTS.0">The entry in box [FSE19] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-MOTOR-EXPENSES.0">8455</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-MOTOR-EXPENSES.0">The entry in box [FSE20] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-MOTOR-EXPENSES.0">The entry in box [FSE20] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF2-PREMISES-COSTS.0">8456</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF2-PREMISES-COSTS.0">The entry in box [FSE21] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF2-PREMISES-COSTS.0">The entry in box [FSE21] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF2-REPAIRS.0">8457</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF2-REPAIRS.0">The entry in box [FSE22] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF2-REPAIRS.0">The entry in box [FSE22] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-GENERAL-ADMIN-EXPENSES.0">8458</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-GENERAL-ADMIN-EXPENSES.0">The entry in box [FSE23] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-GENERAL-ADMIN-EXPENSES.0">The entry in box [FSE23] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-ADVERTISING.0">8459</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-ADVERTISING.0">The entry in box [FSE24] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-ADVERTISING.0">The entry in box [FSE24] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF2-LOAN-INTEREST.0">8460</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF2-LOAN-INTEREST.0">The entry in box [FSE25] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF2-LOAN-INTEREST.0">The entry in box [FSE25] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF2-FINANCE-CHARGES.0">8461</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF2-FINANCE-CHARGES.0">The entry in box [FSE26] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF2-FINANCE-CHARGES.0">The entry in box [FSE26] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-BAD-DEBTS.0">8462</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-BAD-DEBTS.0">The entry in box [FSE27] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-BAD-DEBTS.0">The entry in box [FSE27] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-LEGAL-COSTS.0">8463</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-LEGAL-COSTS.0">The entry in box [FSE28] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-LEGAL-COSTS.0">The entry in box [FSE28] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-DEPRECIATION.0">8464</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-DEPRECIATION.0">The entry in box [FSE29] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-DEPRECIATION.0">The entry in box [FSE29] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-OTHER-EXPENDITURE.0">8465</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-OTHER-EXPENDITURE.0">The entry in box [FSE30] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-OTHER-EXPENDITURE.0">The entry in box [FSE30] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-TOTAL-EXPENDITURE.1">6053</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-TOTAL-EXPENDITURE.1">The amount in box [FSE31] must equal ( the sum of [FSE17],[FSE18],[FSE19],[FSE20],[FSE21],[FSE22],[FSE23],[FSE24],[FSE25],[FSE26],[FSE27],[FSE28],[FSE29] and [FSE30] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-TOTAL-EXPENDITURE.1">The amount in box [FSE31] must equal ( the sum of [FSE17],[FSE18],[FSE19],[FSE20],[FSE21],[FSE22],[FSE23],[FSE24],[FSE25],[FSE26],[FSE27],[FSE28],[FSE29] and [FSE30] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-TOTAL-EXPENDITURE.0">8466</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-TOTAL-EXPENDITURE.0">The entry in box [FSE31] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-TOTAL-EXPENDITURE.0">The entry in box [FSE31] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF2-DISALLOW-COST-OF-SALES.0">8467</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF2-DISALLOW-COST-OF-SALES.0">The entry in box [FSE32] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF2-DISALLOW-COST-OF-SALES.0">The entry in box [FSE32] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-DISALLOW-SUB-CON-COSTS.0">8468</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-DISALLOW-SUB-CON-COSTS.0">The entry in box [FSE33] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-DISALLOW-SUB-CON-COSTS.0">The entry in box [FSE33] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-DISALLOW-EMPLOYEE-COSTS.0">8469</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-DISALLOW-EMPLOYEE-COSTS.0">The entry in box [FSE34] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-DISALLOW-EMPLOYEE-COSTS.0">The entry in box [FSE34] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-DISALLOW-MOTOR-EXPENSES.0">8470</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-DISALLOW-MOTOR-EXPENSES.0">The entry in box [FSE35] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-DISALLOW-MOTOR-EXPENSES.0">The entry in box [FSE35] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF2-DISALLOW-PREMISES-COSTS.0">8471</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF2-DISALLOW-PREMISES-COSTS.0">The entry in box [FSE36] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF2-DISALLOW-PREMISES-COSTS.0">The entry in box [FSE36] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF2-DISALLOW-REPAIRS.0">8472</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF2-DISALLOW-REPAIRS.0">The entry in box [FSE37] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF2-DISALLOW-REPAIRS.0">The entry in box [FSE37] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-DISALLOW-GENERAL-ADMIN-EXP.0">8473</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-DISALLOW-GENERAL-ADMIN-EXP.0">The entry in box [FSE38] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-DISALLOW-GENERAL-ADMIN-EXP.0">The entry in box [FSE38] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-DISALLOW-ADVERTISING.0">8474</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-DISALLOW-ADVERTISING.0">The entry in box [FSE39] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-DISALLOW-ADVERTISING.0">The entry in box [FSE39] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF2-DISALLOW-LOAN-INTEREST.0">8475</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF2-DISALLOW-LOAN-INTEREST.0">The entry in box [FSE40] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF2-DISALLOW-LOAN-INTEREST.0">The entry in box [FSE40] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF2-DISALLOW-FINANCE-CHARGES.0">8476</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF2-DISALLOW-FINANCE-CHARGES.0">The entry in box [FSE41] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF2-DISALLOW-FINANCE-CHARGES.0">The entry in box [FSE41] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-DISALLOW-BAD-DEBTS.0">8477</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-DISALLOW-BAD-DEBTS.0">The entry in box [FSE42] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-DISALLOW-BAD-DEBTS.0">The entry in box [FSE42] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-DISALLOW-LEGAL-COSTS.0">8478</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-DISALLOW-LEGAL-COSTS.0">The entry in box [FSE43] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-DISALLOW-LEGAL-COSTS.0">The entry in box [FSE43] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-DISALLOW-DEPRECIATION.0">8479</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-DISALLOW-DEPRECIATION.0">The entry in box [FSE44] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-DISALLOW-DEPRECIATION.0">The entry in box [FSE44] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-DISALLOW-OTHER.0">8480</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-DISALLOW-OTHER.0">The entry in box [FSE45] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-DISALLOW-OTHER.0">The entry in box [FSE45] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-DISALLOW-EXPENDITURE.1">8301</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-DISALLOW-EXPENDITURE.1">If entry in any of [FSE32], [FSE33], [FSE34], [FSE35], [FSE36], [FSE37], [FSE38], [FSE39], [FSE40], [FSE41], [FSE42], [FSE43], [FSE44], [FSE45] then total of those boxes must equal [FSE46]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-DISALLOW-EXPENDITURE.1">If entry in any of [FSE32], [FSE33], [FSE34], [FSE35], [FSE36], [FSE37], [FSE38], [FSE39], [FSE40], [FSE41], [FSE42], [FSE43], [FSE44], [FSE45] then total of those boxes must equal [FSE46]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-DISALLOW-EXPENDITURE.0">8481</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-DISALLOW-EXPENDITURE.0">The entry in box [FSE46] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-DISALLOW-EXPENDITURE.0">The entry in box [FSE46] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-NET-PROFIT-LOSS-AMT-merged.1">6055</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-NET-PROFIT-LOSS-AMT-merged.1">The amount in box [FSE47/FSE48] must equal the sum of [FSE15] plus [FSE16] minus [FSE31]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-NET-PROFIT-LOSS-AMT-merged.1">The amount in box [FSE47/FSE48] must equal the sum of [FSE15] plus [FSE16] minus [FSE31]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-ANNUAL-INV-ALLCE-AMT.1">8333</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-ANNUAL-INV-ALLCE-AMT.1">There is an entry in [FSE49]. Please complete [FSE57].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-ANNUAL-INV-ALLCE-AMT.1">There is an entry in [FSE49]. Please complete [FSE57].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-PLANT-MACHINERY-ALLCE.0">8334</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-PLANT-MACHINERY-ALLCE.0">There is an entry in [FSE50]. Please complete [FSE57].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-PLANT-MACHINERY-ALLCE.0">There is an entry in [FSE50]. Please complete [FSE57].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-YEAR1-ALLCE-AMT.0">8335</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-YEAR1-ALLCE-AMT.0">There is an entry in [FSE51]. Please complete [FSE57].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-YEAR1-ALLCE-AMT.0">There is an entry in [FSE51]. Please complete [FSE57].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-ZERO-EMISSIONS-GV-ALLCE.0">8377</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-ZERO-EMISSIONS-GV-ALLCE.0">There is an entry in [FSE52]. Please complete [FSE57].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-ZERO-EMISSIONS-GV-ALLCE.0">There is an entry in [FSE52]. Please complete [FSE57].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-ZERO-EMISSION-CAR-ALLCE.1">8563</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-ZERO-EMISSION-CAR-ALLCE.1">There is an entry in [FSE52.1]. Please complete [FSE57].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-ZERO-EMISSION-CAR-ALLCE.1">There is an entry in [FSE52.1]. Please complete [FSE57].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-SB-ALLCE.1">8372</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-SB-ALLCE.1">There is an entry in [FSE53]. Please complete [FSE57].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-SB-ALLCE.1">There is an entry in [FSE53]. Please complete [FSE57].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-FREEPORT-SB-ALLCE.1">8564</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-FREEPORT-SB-ALLCE.1">There is an entry in [FSE53.1]. Please complete [FSE57].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-FREEPORT-SB-ALLCE.1">There is an entry in [FSE53.1]. Please complete [FSE57].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-ECP-ALLCE.1">8373</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-ECP-ALLCE.1">There is an entry in [FSE54]. Please complete [FSE57].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-ECP-ALLCE.1">There is an entry in [FSE54]. Please complete [FSE57].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF3-OTHER-CAPITAL-ALLOWANCES.0">8338</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF3-OTHER-CAPITAL-ALLOWANCES.0">There is an entry in [FSE55]. Please complete [FSE57].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF3-OTHER-CAPITAL-ALLOWANCES.0">There is an entry in [FSE55]. Please complete [FSE57].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-DISPOSAL-LOWVAL-ALLCE-AMT.0">8339</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-DISPOSAL-LOWVAL-ALLCE-AMT.0">There is an entry in [FSE56]. Please complete [FSE57]. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-DISPOSAL-LOWVAL-ALLCE-AMT.0">There is an entry in [FSE56]. Please complete [FSE57]. </sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-ANNUAL-INV-ALLCE-AMT.0">6062</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-ANNUAL-INV-ALLCE-AMT.0">The amount in box [FSE49] exceeds [£1,500,000]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-ANNUAL-INV-ALLCE-AMT.0">The amount in box [FSE49] exceeds [£1,500,000]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-ANNUAL-INV-ALLCE-AMT.2">8482</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-ANNUAL-INV-ALLCE-AMT.2">The entry in box [FSE49] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-ANNUAL-INV-ALLCE-AMT.2">The entry in box [FSE49] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-PLANT-MACHINERY-ALLCE.1">8483</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-PLANT-MACHINERY-ALLCE.1">The entry in box [FSE50] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-PLANT-MACHINERY-ALLCE.1">The entry in box [FSE50] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-YEAR1-ALLCE-AMT.1">8484</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-YEAR1-ALLCE-AMT.1">The entry in box [FSE51] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-YEAR1-ALLCE-AMT.1">The entry in box [FSE51] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-ZERO-EMISSIONS-GV-ALLCE.1">8485</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-ZERO-EMISSIONS-GV-ALLCE.1">The entry in box [FSE52] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-ZERO-EMISSIONS-GV-ALLCE.1">The entry in box [FSE52] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-ZERO-EMISSION-CAR-ALLCE.0">8572</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-ZERO-EMISSION-CAR-ALLCE.0">The entry in box [FSE52.1] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-ZERO-EMISSION-CAR-ALLCE.0">The entry in box [FSE52.1] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-SB-ALLCE.0">8590</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-SB-ALLCE.0">The entry in box [FSE53] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-SB-ALLCE.0">The entry in box [FSE53] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-FREEPORT-SB-ALLCE.0">8566</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-FREEPORT-SB-ALLCE.0">The entry in box [FSE53.1] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-FREEPORT-SB-ALLCE.0">The entry in box [FSE53.1] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-ECP-ALLCE.0">8591</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-ECP-ALLCE.0">The entry in box [FSE54] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-ECP-ALLCE.0">The entry in box [FSE54] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF3-OTHER-CAPITAL-ALLOWANCES.1">8486</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF3-OTHER-CAPITAL-ALLOWANCES.1">The entry in box [FSE55] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF3-OTHER-CAPITAL-ALLOWANCES.1">The entry in box [FSE55] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-DISPOSAL-LOWVAL-ALLCE-AMT.1">8487</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-DISPOSAL-LOWVAL-ALLCE-AMT.1">The entry in box [FSE56] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-DISPOSAL-LOWVAL-ALLCE-AMT.1">The entry in box [FSE56] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF4-TOTAL-CAPITAL-ALLOWANCES.1">8488</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF4-TOTAL-CAPITAL-ALLOWANCES.1">The entry in box [FSE57] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF4-TOTAL-CAPITAL-ALLOWANCES.1">The entry in box [FSE57] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF4-TOTAL-CAPITAL-ALLOWANCES.0">6056</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF4-TOTAL-CAPITAL-ALLOWANCES.0">[FSE57] is valid only if this equals ( The sum of [FSE49], [FSE50], [FSE51], [FSE52], [FSE52.1], [FSE53], [FSE53.1], [FSE54], [FSE55], and [FSE56] )</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF4-TOTAL-CAPITAL-ALLOWANCES.0">[FSE57] is valid only if this equals ( The sum of [FSE49], [FSE50], [FSE51], [FSE52], [FSE52.1], [FSE53], [FSE53.1], [FSE54], [FSE55], and [FSE56] )</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF1-ADDITIONS-TO-NET-PROFIT.0">6059</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF1-ADDITIONS-TO-NET-PROFIT.0">The amount in box [FSE61] must equal ( the sum of [FSE46], [FSE59], and [FSE60] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF1-ADDITIONS-TO-NET-PROFIT.0">The amount in box [FSE61] must equal ( the sum of [FSE46], [FSE59], and [FSE60] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-TOTAL-DEDUCTIONS.1">6065</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-TOTAL-DEDUCTIONS.1">The amount in box [FSE63] must equal ( [FSE57] plus [FSE62] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-TOTAL-DEDUCTIONS.1">The amount in box [FSE63] must equal ( [FSE57] plus [FSE62] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-NET-BUSINESS-PROFIT-LOSS-AMT-merged.1">6111</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-NET-BUSINESS-PROFIT-LOSS-AMT-merged.1">The amount in box [FSE64 / FSE65] must equal the sum of [FSE47/FSE48] plus [FSE61] minus [FSE63]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-NET-BUSINESS-PROFIT-LOSS-AMT-merged.1">The amount in box [FSE64 / FSE65] must equal the sum of [FSE47/FSE48] plus [FSE61] minus [FSE63]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-TRPO-LOSSES-USED-THIS-YEAR.0">8615</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-TRPO-LOSSES-USED-THIS-YEAR.0">[FSE73.4] is valid only if this does not exceed [FSE73.3].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-TRPO-LOSSES-USED-THIS-YEAR.0">[FSE73.4] is valid only if this does not exceed [FSE73.3].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-LOSSES-USED-THIS-YEAR.1">6226</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-LOSSES-USED-THIS-YEAR.1">[FSE74] exceeds the amount entered in either [FSE64 / FSE65] or [FSE73]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-LOSSES-USED-THIS-YEAR.1">[FSE74] exceeds the amount entered in either [FSE64 / FSE65] or [FSE73]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF1-TOTAL-TAXABLE-PROFITS.1">6115</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF1-TOTAL-TAXABLE-PROFITS.1">The amount in box [FSE76] must equal ([FSE73] minus [FSE74]) plus [FSE75]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF1-TOTAL-TAXABLE-PROFITS.1">The amount in box [FSE76] must equal ([FSE73] minus [FSE74]) plus [FSE75]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF1-TOTAL-TAX-PROF-FIG-CLM.0">8669</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF1-TOTAL-TAX-PROF-FIG-CLM.0">[FSE76.1] is valid only if this does not exceed [FSE76]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF1-TOTAL-TAX-PROF-FIG-CLM.0">[FSE76.1] is valid only if this does not exceed [FSE76]</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF1-TOTAL-TAX-PROF-FIG-CLM.1">8670</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF1-TOTAL-TAX-PROF-FIG-CLM.1">[FSE76.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF1-TOTAL-TAX-PROF-FIG-CLM.1">[FSE76.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-FSE-TAXABLE-PL.3">8218</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-FSE-TAXABLE-PL.3">The sum of ([FSE64 / FSE65] + [FSE68] - [FSE16.1]) is greater than or equal to zero. The entry in box [FSE77] must equal 0 or be absent. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-FSE-TAXABLE-PL.3">The sum of ([FSE64 / FSE65] + [FSE68] - [FSE16.1]) is greater than or equal to zero. The entry in box [FSE77] must equal 0 or be absent. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF3-ALLOW-LOSS-FIG-CLM.0">8671</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF3-ALLOW-LOSS-FIG-CLM.0">[FSE77.1] is valid only if this equals [FSE77]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF3-ALLOW-LOSS-FIG-CLM.0">[FSE77.1] is valid only if this equals [FSE77]</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF3-ALLOW-LOSS-FIG-CLM.1">8672</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF3-ALLOW-LOSS-FIG-CLM.1">[FSE77.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF3-ALLOW-LOSS-FIG-CLM.1">[FSE77.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF1-LOSS-SET-OFF-OTHER-INC.1">6281</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF1-LOSS-SET-OFF-OTHER-INC.1">The amount in box [FSE78] exceeds the amount in box [FSE77]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF1-LOSS-SET-OFF-OTHER-INC.1">The amount in box [FSE78] exceeds the amount in box [FSE77]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF1-LOSS-SET-OFF-OTHER-INC.0">8673</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF1-LOSS-SET-OFF-OTHER-INC.0">[FSE78] must not be present if [FSE77.1] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF1-LOSS-SET-OFF-OTHER-INC.0">[FSE78] must not be present if [FSE77.1] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-LOSS-TO-CARRY-BACK.1">6449</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-LOSS-TO-CARRY-BACK.1">The amount in box [FSE79] exceeds ( [FSE77] minus [FSE78]). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-LOSS-TO-CARRY-BACK.1">The amount in box [FSE79] exceeds ( [FSE77] minus [FSE78]). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-LOSS-TO-CARRY-BACK.0">8674</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-LOSS-TO-CARRY-BACK.0">[FSE79] must not be present if [FSE77.1] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-LOSS-TO-CARRY-BACK.0">[FSE79] must not be present if [FSE77.1] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF3-TOTAL-ASSETS.1">6131</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF3-TOTAL-ASSETS.1">The amount in box [FSE90] must equal ( the sum of [FSE83], [FSE84], [FSE85], [FSE86], [FSE87], [FSE88], and [FSE89] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF3-TOTAL-ASSETS.1">The amount in box [FSE90] must equal ( the sum of [FSE83], [FSE84], [FSE85], [FSE86], [FSE87], [FSE88], and [FSE89] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF3-NET-BUSINESS-ASSETS.1">6142</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF3-NET-BUSINESS-ASSETS.1">The amount in box [FSE94] must equal ( [FSE90] minus ( the sum of [FSE91], [FSE92], and [FSE93] ) ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF3-NET-BUSINESS-ASSETS.1">The amount in box [FSE94] must equal ( [FSE90] minus ( the sum of [FSE91], [FSE92], and [FSE93] ) ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF3-ACCOUNT-NET-PROFIT-LOSS.0">6836</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF3-ACCOUNT-NET-PROFIT-LOSS.0">The amount entered in box [FSE96] must equal the amount entered in [FSE47/FSE48]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF3-ACCOUNT-NET-PROFIT-LOSS.0">The amount entered in box [FSE96] must equal the amount entered in [FSE47/FSE48]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF3-TOTAL-BALANCE.1">6146</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF3-TOTAL-BALANCE.1">The amount in box [FSE99] must equal ( ( the sum of [FSE95], [FSE96], and [FSE97] ) minus [FSE98] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF3-TOTAL-BALANCE.1">The amount in box [FSE99] must equal ( ( the sum of [FSE95], [FSE96], and [FSE97] ) minus [FSE98] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-FSE-NIC.0">8340</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-FSE-NIC.0">If [FSE100-102] is present there must be an entry in at least one of [FSE100], [FSECL2], [FSE101] or [FSE102]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-FSE-NIC.0">If [FSE100-102] is present there must be an entry in at least one of [FSE100], [FSECL2], [FSE101] or [FSE102]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-FSE-NIC.1">8341</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-FSE-NIC.1">There is an entry in [FSE100]. Please complete [FSECL2].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-FSE-NIC.1">There is an entry in [FSE100]. Please complete [FSECL2].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SLF-CLASS-2-NIC-AMOUNT.0">8342</sch:diagnostic>
    <sch:diagnostic id="transactional.SLF-CLASS-2-NIC-AMOUNT.0">The amount in box [FSECL2] exceeds [£219.95]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SLF-CLASS-2-NIC-AMOUNT.0">The amount in box [FSECL2] exceeds [£219.95]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103S.0">6063</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103S.0">There is an entry in [SSE11] or [SSE12] or [SSE13] or [SSE14] or [SSE15] or [SSE16] or [SSE17] or [SSE18] or [SSE19]. Please complete box [SSE20].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103S.0">There is an entry in [SSE11] or [SSE12] or [SSE13] or [SSE14] or [SSE15] or [SSE16] or [SSE17] or [SSE18] or [SSE19]. Please complete box [SSE20].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103S.1">6066</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103S.1">The sum of ( ( [SSE9] plus [SSE10] ) minus [SSE20] ) is non-zero. Please complete box [SSE21/SSE22].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103S.1">The sum of ( ( [SSE9] plus [SSE10] ) minus [SSE20] ) is non-zero. Please complete box [SSE21/SSE22].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103S.2">6067</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103S.2">The sum of ( ( [SSE21/SSE22], [SSE26], and [SSE27] ) minus ( [SSE10.1], [SSE23], [SSE24], [SSE24.1], [SSE25], [SSE25.1] and [SSE25.2])) exceeds 0. Please complete box [SSE28].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103S.2">The sum of ( ( [SSE21/SSE22], [SSE26], and [SSE27] ) minus ( [SSE10.1], [SSE23], [SSE24], [SSE24.1], [SSE25], [SSE25.1] and [SSE25.2])) exceeds 0. Please complete box [SSE28].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103S.3">6068</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103S.3">The sum of ( ( [SSE28] plus [SSE30] ) minus [SSE29] ) exceeds 0. Please complete box [SSE31].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103S.3">The sum of ( ( [SSE28] plus [SSE30] ) minus [SSE29] ) exceeds 0. Please complete box [SSE31].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103S.4">6069</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103S.4">The sum of ( ( [SSE23], [SSE24], [SSE24.1], [SSE25], [SSE25.1] and  [SSE25.2]) minus ( [SSE21/SSE22], [SSE26], and [SSE27] ) ) exceeds 0. Please complete box [SSE32].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103S.4">The sum of ( ( [SSE23], [SSE24], [SSE24.1], [SSE25], [SSE25.1] and  [SSE25.2]) minus ( [SSE21/SSE22], [SSE26], and [SSE27] ) ) exceeds 0. Please complete box [SSE32].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103S.5">8489</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103S.5">The amount in box [SSE10.1] must be less than or equal to the sum of ( [SSE21/SSE22] + [SSE26] + [SSE27] ) if [SSE21/SSE22] is not negative. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103S.5">The amount in box [SSE10.1] must be less than or equal to the sum of ( [SSE21/SSE22] + [SSE26] + [SSE27] ) if [SSE21/SSE22] is not negative. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-BUSINESS-COMM-QUES.0">8675</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-BUSINESS-COMM-QUES.0">[SSE5] must be present if [SSE5Q] equals 'yes'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-BUSINESS-COMM-QUES.0">[SSE5] must be present if [SSE5Q] equals 'yes'</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-COMMENCEMENT-DATE.1">6433</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-COMMENCEMENT-DATE.1">Must be a date between 6 April and 5 April of the year of the return. Please amend the entry.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-COMMENCEMENT-DATE.1">Must be a date between 6 April and 5 April of the year of the return. Please amend the entry.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-BUSINESS-CESS-QUES.0">8676</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-BUSINESS-CESS-QUES.0">[SSE6] must be present if [SSE6Q] equals 'yes'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-BUSINESS-CESS-QUES.0">[SSE6] must be present if [SSE6Q] equals 'yes'</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-CESSATION-DATE.1">6433</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-CESSATION-DATE.1">Must be a date between 6 April and 5 April of the year of the return. Please amend the entry.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-CESSATION-DATE.1">Must be a date between 6 April and 5 April of the year of the return. Please amend the entry.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-CESSATION-DATE.2">6147</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-CESSATION-DATE.2">The date cannot be earlier than [SSE5]. Please amend the entry.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-CESSATION-DATE.2">The date cannot be earlier than [SSE5]. Please amend the entry.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-BUSINESS-SALES-TURNOVER.0">6235</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-BUSINESS-SALES-TURNOVER.0">The amount in box [SSE9] must be below [£90,000] as [SSE5] and [SSE6] are both absent. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-BUSINESS-SALES-TURNOVER.0">The amount in box [SSE9] must be below [£90,000] as [SSE5] and [SSE6] are both absent. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-BUSINESS-SALES-TURNOVER.1">6236</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-BUSINESS-SALES-TURNOVER.1">As there is an entry in [SSE5] but [SSE6] is absent, the amount in box [SSE9] must be below ([£90,000] x number of days / (365 or 366) ) where number of days equals the number of days from [SSE5]  to [5 April 2026] inclusive. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-BUSINESS-SALES-TURNOVER.1">As there is an entry in [SSE5] but [SSE6] is absent, the amount in box [SSE9] must be below ([£90,000] x number of days / (365 or 366) ) where number of days equals the number of days from [SSE5]  to [5 April 2026] inclusive. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-BUSINESS-SALES-TURNOVER.2">6237</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-BUSINESS-SALES-TURNOVER.2">As there is an entry in [SSE6] but [SSE5] is absent, the amount in box [SSE9] must be below ( [£90,000] x number of days / (365 or 366) ) where number of days equals the number of days from [6 April 2025] to [SSE6] inclusive. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-BUSINESS-SALES-TURNOVER.2">As there is an entry in [SSE6] but [SSE5] is absent, the amount in box [SSE9] must be below ( [£90,000] x number of days / (365 or 366) ) where number of days equals the number of days from [6 April 2025] to [SSE6] inclusive. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-BUSINESS-SALES-TURNOVER.3">6238</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-BUSINESS-SALES-TURNOVER.3">As there is an entry in both [SSE5] and [SSE6], the amount in box [SSE9] must be below ( [£90,000] x number of days / (365 or 366) ) where number of days equals the number of days from [SSE5] to [SSE6] inclusive. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-BUSINESS-SALES-TURNOVER.3">As there is an entry in both [SSE5] and [SSE6], the amount in box [SSE9] must be below ( [£90,000] x number of days / (365 or 366) ) where number of days equals the number of days from [SSE5] to [SSE6] inclusive. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-TRADING-INCOME-ALLOWANCE.1">8490</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-TRADING-INCOME-ALLOWANCE.1">If there is an entry in box [SSE10.1] then all instances of [SSE21/SSE22] can not be negative. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-TRADING-INCOME-ALLOWANCE.1">If there is an entry in box [SSE10.1] then all instances of [SSE21/SSE22] can not be negative. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-COST-OF-SALES.0">8491</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-COST-OF-SALES.0">The entry in box [SSE11] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-COST-OF-SALES.0">The entry in box [SSE11] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-MOTOR-EXPENSES.0">8492</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-MOTOR-EXPENSES.0">The entry in box [SSE12] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-MOTOR-EXPENSES.0">The entry in box [SSE12] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-EMPLOYEE-COSTS.0">8493</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-EMPLOYEE-COSTS.0">The entry in box [SSE13] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-EMPLOYEE-COSTS.0">The entry in box [SSE13] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-PREMISES-COSTS.0">8494</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-PREMISES-COSTS.0">The entry in box [SSE14] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-PREMISES-COSTS.0">The entry in box [SSE14] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-REPAIRS.0">8495</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-REPAIRS.0">The entry in box [SSE15] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-REPAIRS.0">The entry in box [SSE15] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-LEGAL-COSTS.0">8496</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-LEGAL-COSTS.0">The entry in box [SSE16] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-LEGAL-COSTS.0">The entry in box [SSE16] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-LOAN-INTEREST.0">8497</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-LOAN-INTEREST.0">The entry in box [SSE17] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-LOAN-INTEREST.0">The entry in box [SSE17] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-GENERAL-ADMIN-EXPENSES.0">8498</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-GENERAL-ADMIN-EXPENSES.0">The entry in box [SSE18] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-GENERAL-ADMIN-EXPENSES.0">The entry in box [SSE18] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-OTHER-EXPENDITURE.0">8499</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-OTHER-EXPENDITURE.0">The entry in box [SSE19] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-OTHER-EXPENDITURE.0">The entry in box [SSE19] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-TOTAL-EXPENDITURE.1">6163</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-TOTAL-EXPENDITURE.1">As the amount in box [SSE20] is greater than zero and [SSE9] is equal to or greater than [£90,000] there must be an entry in at least one of [SSE11] to [SSE19] and [SSE20] must equal the total of those boxes. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-TOTAL-EXPENDITURE.1">As the amount in box [SSE20] is greater than zero and [SSE9] is equal to or greater than [£90,000] there must be an entry in at least one of [SSE11] to [SSE19] and [SSE20] must equal the total of those boxes. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-TOTAL-EXPENDITURE.0">8500</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-TOTAL-EXPENDITURE.0">The entry in box [SSE20] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-TOTAL-EXPENDITURE.0">The entry in box [SSE20] should not be present as there is an entry in [FSE16.1] or [SSE10.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-NET-PROFIT-LOSS-AMT-merged.1">6176</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-NET-PROFIT-LOSS-AMT-merged.1">The amount in [SSE21/SSE22] must equal the sum of [SSE9] plus [SSE10] minus [SSE20]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-NET-PROFIT-LOSS-AMT-merged.1">The amount in [SSE21/SSE22] must equal the sum of [SSE9] plus [SSE10] minus [SSE20]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-ANNUAL-INV-ALLCE-AMT.0">6070</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-ANNUAL-INV-ALLCE-AMT.0">The amount in box [SSE23] exceeds [£1,500,000]. Please check. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-ANNUAL-INV-ALLCE-AMT.0">The amount in box [SSE23] exceeds [£1,500,000]. Please check. </sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-ANNUAL-INV-ALLCE-AMT.1">8501</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-ANNUAL-INV-ALLCE-AMT.1">The entry in box [SSE23] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-ANNUAL-INV-ALLCE-AMT.1">The entry in box [SSE23] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-SMALL-BAL-EXP-ALLCE-AMT.0">8502</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-SMALL-BAL-EXP-ALLCE-AMT.0">The entry in box [SSE24] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-SMALL-BAL-EXP-ALLCE-AMT.0">The entry in box [SSE24] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-SMALL-BAL-EXP-ALLCE-AMT.1">8568</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-SMALL-BAL-EXP-ALLCE-AMT.1">[SSE24] is valid only if this does not exceed [£2,000]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-SMALL-BAL-EXP-ALLCE-AMT.1">[SSE24] is valid only if this does not exceed [£2,000]</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-ZERO-EMISSION-CAR-ALLCE.0">8569</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-ZERO-EMISSION-CAR-ALLCE.0">The entry in box [SSE24.1] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-ZERO-EMISSION-CAR-ALLCE.0">The entry in box [SSE24.1] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-TOTAL-CAPITAL-ALLOWANCES.0">8503</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-TOTAL-CAPITAL-ALLOWANCES.0">The entry in box [SSE25] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-TOTAL-CAPITAL-ALLOWANCES.0">The entry in box [SSE25] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-SB-ALLCE.0">8592</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-SB-ALLCE.0">The entry in box [SSE25.1] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-SB-ALLCE.0">The entry in box [SSE25.1] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-FREEPORT-SB-ALLCE.0">8570</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-FREEPORT-SB-ALLCE.0">The entry in box [SSE25.2] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-FREEPORT-SB-ALLCE.0">The entry in box [SSE25.2] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-NET-BUSINESS-PROFIT-LOSS.0">6177</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-NET-BUSINESS-PROFIT-LOSS.0">The amount in box [SSE28] must equal the sum of ( ( [SSE21/SSE22] plus [SSE26] plus [SSE27] ) minus ( [SSE10.1] plus [SSE23] plus [SSE24] plus [SSE24.1] plus [SSE25] plus [SSE25.1] plus [SSE25.2] )) if positive. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-NET-BUSINESS-PROFIT-LOSS.0">The amount in box [SSE28] must equal the sum of ( ( [SSE21/SSE22] plus [SSE26] plus [SSE27] ) minus ( [SSE10.1] plus [SSE23] plus [SSE24] plus [SSE24.1] plus [SSE25] plus [SSE25.1] plus [SSE25.2] )) if positive. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-LOSSES-USED-THIS-YEAR.1">6282</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-LOSSES-USED-THIS-YEAR.1">The amount in box [SSE29] exceeds the amount in box [SSE28]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-LOSSES-USED-THIS-YEAR.1">The amount in box [SSE29] exceeds the amount in box [SSE28]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-TOTAL-TAXABLE-PROFITS.0">6178</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-TOTAL-TAXABLE-PROFITS.0">The amount in box [SSE31] must equal ( ( [SSE28] plus [SSE30] ) minus [SSE29] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-TOTAL-TAXABLE-PROFITS.0">The amount in box [SSE31] must equal ( ( [SSE28] plus [SSE30] ) minus [SSE29] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-ALLOWABLE-LOSS-FOR-YEAR.0">6183</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-ALLOWABLE-LOSS-FOR-YEAR.0">The amount in box [SSE32] must equal [SSE23] plus [SSE24] plus [SSE24.1] plus  [SSE25] plus [SSE25.1] plus [SSE25.2] minus ([SSE21/SSE22] plus [SSE26] plus [SSE27]) if positive or zero. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-ALLOWABLE-LOSS-FOR-YEAR.0">The amount in box [SSE32] must equal [SSE23] plus [SSE24] plus [SSE24.1] plus  [SSE25] plus [SSE25.1] plus [SSE25.2] minus ([SSE21/SSE22] plus [SSE26] plus [SSE27]) if positive or zero. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-ALLOWABLE-LOSS-FOR-YEAR.1">8504</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-ALLOWABLE-LOSS-FOR-YEAR.1">The entry in box [SSE32] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-ALLOWABLE-LOSS-FOR-YEAR.1">The entry in box [SSE32] should not be present as there is an entry in [FSE16.1] or [SSE10.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-LOSS-SET-OFF-OTHER-INC.1">6224</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-LOSS-SET-OFF-OTHER-INC.1">The amount in box [SSE33] exceeds the amount in box [SSE32]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-LOSS-SET-OFF-OTHER-INC.1">The amount in box [SSE33] exceeds the amount in box [SSE32]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-LOSS-TO-CARRY-BACK.1">6510</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-LOSS-TO-CARRY-BACK.1">The amount in box [SSE34] exceeds [SSE32] minus [SSE33]. Please check</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-LOSS-TO-CARRY-BACK.1">The amount in box [SSE34] exceeds [SSE32] minus [SSE33]. Please check</sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-CLASS-2-NIC-VOLUNTARY-SIG.0">8344</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-CLASS-2-NIC-VOLUNTARY-SIG.0">There is an entry in [SSE36]. Please complete [SSECL2]. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-CLASS-2-NIC-VOLUNTARY-SIG.0">There is an entry in [SSE36]. Please complete [SSECL2]. </sch:diagnostic>
    <sch:diagnostic id="errorCode.SSE-CLASS-2-NIC-AMOUNT.0">8345</sch:diagnostic>
    <sch:diagnostic id="transactional.SSE-CLASS-2-NIC-AMOUNT.0">The amount in box [SSECL2] exceeds [£219.95]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SSE-CLASS-2-NIC-AMOUNT.0">The amount in box [SSECL2] exceeds [£219.95]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103L.0">6071</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103L.0">There is an entry in [LUN1] or [LUN2] or [LUN3] or [LUN4]. Please complete box [LUN5].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103L.0">There is an entry in [LUN1] or [LUN2] or [LUN3] or [LUN4]. Please complete box [LUN5].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103L.3">6074</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103L.3">There is an entry in [LUN12] or [LUN13] or [LUN14] or [LUN15] or [LUN16] or [LUN17]. Please complete box [LUN18].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103L.3">There is an entry in [LUN12] or [LUN13] or [LUN14] or [LUN15] or [LUN16] or [LUN17]. Please complete box [LUN18].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103L.5">6076</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103L.5">There is an entry in [LUN5] or [LUN11] or [LUN18] or [LUN26]. Please complete box [LUN27].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103L.5">There is an entry in [LUN5] or [LUN11] or [LUN18] or [LUN26]. Please complete box [LUN27].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103L.6">6077</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103L.6">The sum of ( [LUN29], [LUN30], [LUN31], [LUN32], [LUN33], [LUN34], [LUN35], [LUN36], [LUN37], [LUN38], and [LUN39] ) exceeds 0. Please complete box [LUN40].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103L.6">The sum of ( [LUN29], [LUN30], [LUN31], [LUN32], [LUN33], [LUN34], [LUN35], [LUN36], [LUN37], [LUN38], and [LUN39] ) exceeds 0. Please complete box [LUN40].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103L.7">6078</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103L.7">The sum of ( [LUN27] minus [LUN40] ) exceeds 0. Please complete box [LUN41].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103L.7">The sum of ( [LUN27] minus [LUN40] ) exceeds 0. Please complete box [LUN41].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103L.8">6079</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103L.8">The sum of ( [LUN40] minus [LUN27] ) exceeds 0. Please complete box [LUN42].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103L.8">The sum of ( [LUN40] minus [LUN27] ) exceeds 0. Please complete box [LUN42].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103L.9">6080</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103L.9">There is an entry in [LUN13] or [LUN16]. Please complete box [LUN43].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103L.9">There is an entry in [LUN13] or [LUN16]. Please complete box [LUN43].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103L.12">6081</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103L.12">There is an entry in box [LUN42]. Please complete box [LUN53].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103L.12">There is an entry in box [LUN42]. Please complete box [LUN53].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103L.14">6083</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103L.14">There is an entry in [LUN53] or [LUN54]. Please complete box [LUN55].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103L.14">There is an entry in [LUN53] or [LUN54]. Please complete box [LUN55].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103L.15">6084</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103L.15">There is an entry in box [LUN51]. Please complete box [LUN60].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103L.15">There is an entry in box [LUN51]. Please complete box [LUN60].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103L.16">6085</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103L.16">There is an entry in box [LUN58]. Please complete box [LUN61].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103L.16">There is an entry in box [LUN58]. Please complete box [LUN61].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103L.17">6184</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103L.17">The amount in box [LUN41] exceeds 0. Please complete box [LUN49].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103L.17">The amount in box [LUN41] exceeds 0. Please complete box [LUN49].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103L.20">6239</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103L.20">The sum of ( ( [LUN59] plus [LUN61] ) minus [LUN60] ) exceeds 0. Please complete box [LUN62].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103L.20">The sum of ( ( [LUN59] plus [LUN61] ) minus [LUN60] ) exceeds 0. Please complete box [LUN62].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103L.1">8437</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103L.1">There is an entry in box [LUN6] please complete [LUN11] </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103L.1">There is an entry in box [LUN6] please complete [LUN11] </sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103L.2">8438</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103L.2">There is an entry in box [LUN8] please complete [LUN11] </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103L.2">There is an entry in box [LUN8] please complete [LUN11] </sch:diagnostic>
    <sch:diagnostic id="errorCode.SA103L.4">8439</sch:diagnostic>
    <sch:diagnostic id="transactional.SA103L.4">There is an entry in box [LUN9] please complete [LUN11] </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA103L.4">There is an entry in box [LUN9] please complete [LUN11] </sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW-UK-INT-TAX-DEDUCTED-AMT.1">6194</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW-UK-INT-TAX-DEDUCTED-AMT.1">The amount in box [LUN4] must be less than the amount in box [LUN3]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW-UK-INT-TAX-DEDUCTED-AMT.1">The amount in box [LUN4] must be less than the amount in box [LUN3]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-UK-INTEREST-INCOME-AMO.1">6531</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-UK-INTEREST-INCOME-AMO.1">The amount in box [LUN5] must equal ( the sum of [LUN1], [LUN2], [LUN3], and [LUN4] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-UK-INTEREST-INCOME-AMO.1">The amount in box [LUN5] must equal ( the sum of [LUN1], [LUN2], [LUN3], and [LUN4] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-LUWU-TOTAL-DIV-GROSS-AMO.0">6279</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-LUWU-TOTAL-DIV-GROSS-AMO.0">The amount in box [LUN11] must equal ( the sum of [LUN6], [LUN8], and [LUN9] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-LUWU-TOTAL-DIV-GROSS-AMO.0">The amount in box [LUN11] must equal ( the sum of [LUN6], [LUN8], and [LUN9] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-FOREIGN-DIV-GROSS-AMO.1">6299</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-FOREIGN-DIV-GROSS-AMO.1">The amount in box [LUN18] must equal ( the sum of [LUN12], [LUN13], [LUN14], [LUN15], [LUN16], and [LUN17] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-FOREIGN-DIV-GROSS-AMO.1">The amount in box [LUN18] must equal ( the sum of [LUN12], [LUN13], [LUN14], [LUN15], [LUN16], and [LUN17] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-AGGREGATE-SYND-PROFIT-AMO.0">6240</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-AGGREGATE-SYND-PROFIT-AMO.0">There is an entry in [LUN20]. Please complete box [LUN26].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-AGGREGATE-SYND-PROFIT-AMO.0">There is an entry in [LUN20]. Please complete box [LUN26].</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-SPECIAL-RESERVE-FUND-AMO.0">6241</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-SPECIAL-RESERVE-FUND-AMO.0">There is an entry in [LUN21]. Please complete box [LUN26].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-SPECIAL-RESERVE-FUND-AMO.0">There is an entry in [LUN21]. Please complete box [LUN26].</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-STOP-LOSS-RECOVERY-AMO.0">6242</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-STOP-LOSS-RECOVERY-AMO.0">There is an entry in [LUN22]. Please complete box [LUN26].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-STOP-LOSS-RECOVERY-AMO.0">There is an entry in [LUN22]. Please complete box [LUN26].</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-COMPENSATION-RECEIPT-AMO.0">6244</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-COMPENSATION-RECEIPT-AMO.0">There is an entry in [LUN23]. Please complete box [LUN26].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-COMPENSATION-RECEIPT-AMO.0">There is an entry in [LUN23]. Please complete box [LUN26].</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-REPAYT-FOREIGN-TAX-AMO.0">6245</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-REPAYT-FOREIGN-TAX-AMO.0">There is an entry in [LUN24]. Please complete box [LUN26].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-REPAYT-FOREIGN-TAX-AMO.0">There is an entry in [LUN24]. Please complete box [LUN26].</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-OTHER-NON-SYND-INCOME-AMO.0">6246</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-OTHER-NON-SYND-INCOME-AMO.0">There is an entry in [LUN25]. Please complete box [LUN26].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-OTHER-NON-SYND-INCOME-AMO.0">There is an entry in [LUN25]. Please complete box [LUN26].</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-OTHER-LLOYDS-RCPT-TOTAL.0">6247</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-OTHER-LLOYDS-RCPT-TOTAL.0">The amount in box [LUN26] must equal ( the sum of [LUN20], [LUN21], [LUN22], [LUN23], [LUN24], and [LUN25] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-OTHER-LLOYDS-RCPT-TOTAL.0">The amount in box [LUN26] must equal ( the sum of [LUN20], [LUN21], [LUN22], [LUN23], [LUN24], and [LUN25] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-LLOYDS-INCOME-TOTAL.1">6301</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-LLOYDS-INCOME-TOTAL.1">The amount in box [LUN27] must equal ( the sum of [LUN5], [LUN11], [LUN18], and [LUN26] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-LLOYDS-INCOME-TOTAL.1">The amount in box [LUN27] must equal ( the sum of [LUN5], [LUN11], [LUN18], and [LUN26] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-AGGREGATE-SYND-LOSSES-AMO.3">6838</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-AGGREGATE-SYND-LOSSES-AMO.3">Box [LUN29] is completed, box [LUN20] must not be completed. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-AGGREGATE-SYND-LOSSES-AMO.3">Box [LUN29] is completed, box [LUN20] must not be completed. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-LLOYDS-OUTGOINGS-TOTAL.1">6326</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-LLOYDS-OUTGOINGS-TOTAL.1">The amount in box [LUN40] must equal ( the sum of [LUN29], [LUN30], [LUN31], [LUN32], [LUN33], [LUN34], [LUN35], [LUN36], [LUN37], [LUN38], and [LUN39] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-LLOYDS-OUTGOINGS-TOTAL.1">The amount in box [LUN40] must equal ( the sum of [LUN29], [LUN30], [LUN31], [LUN32], [LUN33], [LUN34], [LUN35], [LUN36], [LUN37], [LUN38], and [LUN39] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-LUWU-NET-PROFIT-AMO.2">6248</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-LUWU-NET-PROFIT-AMO.2">There is an entry in box [LUN41] greater than 0. Please complete box [LUN52].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-LUWU-NET-PROFIT-AMO.2">There is an entry in box [LUN41] greater than 0. Please complete box [LUN52].</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-LUWU-NET-PROFIT-AMO.1">6332</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-LUWU-NET-PROFIT-AMO.1">The amount in box [LUN41] must equal [LUN27] minus [LUN40] if zero or positive. Please check. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-LUWU-NET-PROFIT-AMO.1">The amount in box [LUN41] must equal [LUN27] minus [LUN40] if zero or positive. Please check. </sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-LUWU-NET-PROFIT-AMO.0">6187</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-LUWU-NET-PROFIT-AMO.0">The amount in box [LUN41] must equal the amount in box [LUN49]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-LUWU-NET-PROFIT-AMO.0">The amount in box [LUN41] must equal the amount in box [LUN49]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-NET-LOSS-PRE-FRGN-TAX-AMO.1">6334</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-NET-LOSS-PRE-FRGN-TAX-AMO.1">The entry in box [LUN42] must not be present as [LUN27] minus [LUN40] exceeds 0. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-NET-LOSS-PRE-FRGN-TAX-AMO.1">The entry in box [LUN42] must not be present as [LUN27] minus [LUN40] exceeds 0. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-NET-LOSS-PRE-FRGN-TAX-AMO.2">6532</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-NET-LOSS-PRE-FRGN-TAX-AMO.2">The amount in box [LUN42] must equal the positive equivalent of  [LUN27] minus [LUN40] if negative. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-NET-LOSS-PRE-FRGN-TAX-AMO.2">The amount in box [LUN42] must equal the positive equivalent of  [LUN27] minus [LUN40] if negative. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-FRGN-TAX-PERSNL-FUND-AMO.0">6283</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-FRGN-TAX-PERSNL-FUND-AMO.0">There is an entry in [LUN43]. Please complete box [LUN48].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-FRGN-TAX-PERSNL-FUND-AMO.0">There is an entry in [LUN43]. Please complete box [LUN48].</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-FRGN-TAX-PERSNL-FUND-AMO.1">6385</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-FRGN-TAX-PERSNL-FUND-AMO.1">The amount in box [LUN43] must equal ( [LUN13] plus [LUN16] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-FRGN-TAX-PERSNL-FUND-AMO.1">The amount in box [LUN43] must equal ( [LUN13] plus [LUN16] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-US-FEDERAL-TAX-AMO.0">6284</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-US-FEDERAL-TAX-AMO.0">There is an entry in [LUN44]. Please complete box [LUN48].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-US-FEDERAL-TAX-AMO.0">There is an entry in [LUN44]. Please complete box [LUN48].</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-CANADIAN-FEDERAL-TAX-AMO.0">6285</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-CANADIAN-FEDERAL-TAX-AMO.0">There is an entry in [LUN45]. Please complete box [LUN48].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-CANADIAN-FEDERAL-TAX-AMO.0">There is an entry in [LUN45]. Please complete box [LUN48].</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-SYNDICATE-FOREIGN-TAX-AMO.0">6287</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-SYNDICATE-FOREIGN-TAX-AMO.0">There is an entry in [LUN46]. Please complete box [LUN48].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-SYNDICATE-FOREIGN-TAX-AMO.0">There is an entry in [LUN46]. Please complete box [LUN48].</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-ADDNL-FOREIGN-TAX-AMO.0">6288</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-ADDNL-FOREIGN-TAX-AMO.0">There is an entry in [LUN47]. Please complete box [LUN48].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-ADDNL-FOREIGN-TAX-AMO.0">There is an entry in [LUN47]. Please complete box [LUN48].</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-FOREIGN-TAX-POOL-AMO.0">6289</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-FOREIGN-TAX-POOL-AMO.0">The amount in box  [LUN48] must equal (the sum of  [LUN43], [LUN44], [LUN45], [LUN46], and [LUN47] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-FOREIGN-TAX-POOL-AMO.0">The amount in box  [LUN48] must equal (the sum of  [LUN43], [LUN44], [LUN45], [LUN46], and [LUN47] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW-NET-PROF-PRE-FRGN-TAX-AMT.1">6087</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW-NET-PROF-PRE-FRGN-TAX-AMT.1">The amount in box [LUN49] must equal the amount in box [LUN41]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW-NET-PROF-PRE-FRGN-TAX-AMT.1">The amount in box [LUN49] must equal the amount in box [LUN41]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-PROFIT-FRGN-TAX-DEDN-AMO.0">6249</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-PROFIT-FRGN-TAX-DEDN-AMO.0">There is an entry in box [LUN50] greater than 0. Please complete box [LUN52].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-PROFIT-FRGN-TAX-DEDN-AMO.0">There is an entry in box [LUN50] greater than 0. Please complete box [LUN52].</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-PROFIT-FRGN-TAX-DEDN-AMO.1">6534</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-PROFIT-FRGN-TAX-DEDN-AMO.1">Box [LUN50] completed with an entry greater than zero, box [LUN41] must also be completed and greater than zero. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-PROFIT-FRGN-TAX-DEDN-AMO.1">Box [LUN50] completed with an entry greater than zero, box [LUN41] must also be completed and greater than zero. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-LOSSES-BROUGHT-FWD-AMO.2">6251</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-LOSSES-BROUGHT-FWD-AMO.2">There is an entry in box [LUN51] greater than 0. Please complete box [LUN52].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-LOSSES-BROUGHT-FWD-AMO.2">There is an entry in box [LUN51] greater than 0. Please complete box [LUN52].</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-LOSSES-BROUGHT-FWD-AMO.1">6535</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-LOSSES-BROUGHT-FWD-AMO.1">Box [LUN51] completed with an entry greater than zero, box [LUN41] must also be completed and greater than zero. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-LOSSES-BROUGHT-FWD-AMO.1">Box [LUN51] completed with an entry greater than zero, box [LUN41] must also be completed and greater than zero. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW3-TOT-LLOYDS-TAXABLE-PROFIT.0">6290</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW3-TOT-LLOYDS-TAXABLE-PROFIT.0">The amount in box [LUN52] must equal the sum of [LUN41] minus ( [LUN50] plus [LUN51] ) if positive or zero. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW3-TOT-LLOYDS-TAXABLE-PROFIT.0">The amount in box [LUN52] must equal the sum of [LUN41] minus ( [LUN50] plus [LUN51] ) if positive or zero. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW-NET-LOSS-PRE-FRGN-TAX-AMT.2">6393</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW-NET-LOSS-PRE-FRGN-TAX-AMT.2">The entry in box [LUN53] must not be present as [LUN27] minus [LUN40] exceeds 0. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW-NET-LOSS-PRE-FRGN-TAX-AMT.2">The entry in box [LUN53] must not be present as [LUN27] minus [LUN40] exceeds 0. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW-NET-LOSS-PRE-FRGN-TAX-AMT.3">6402</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW-NET-LOSS-PRE-FRGN-TAX-AMT.3">The amount in box [LUN53] must equal [LUN42]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW-NET-LOSS-PRE-FRGN-TAX-AMT.3">The amount in box [LUN53] must equal [LUN42]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.0">8209</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.0">There is an entry in [LUN42] greater than zero. The amount in box [LUN54] must be less than or equal to [LUN48]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.0">There is an entry in [LUN42] greater than zero. The amount in box [LUN54] must be less than or equal to [LUN48]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.1">6574</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.1">There is an entry greater than zero in box [LUN54] therefore an entry greater than zero must be present in [LUN42]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.1">There is an entry greater than zero in box [LUN54] therefore an entry greater than zero must be present in [LUN42]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.2">6406</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.2">The entry in box [LUN54] must not be present as [LUN27] minus [LUN40] exceeds 0. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-LOSS-FRGN-TAX-AS-DEDN-AMO.2">The entry in box [LUN54] must not be present as [LUN27] minus [LUN40] exceeds 0. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW4-LUWU-LOSS-AMO.1">6410</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW4-LUWU-LOSS-AMO.1">The amount in box [LUN55] must equal ( [LUN53] plus [LUN54] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW4-LUWU-LOSS-AMO.1">The amount in box [LUN55] must equal ( [LUN53] plus [LUN54] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW-LOSS-SET-OFF-OTHER-INC.1">6575</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW-LOSS-SET-OFF-OTHER-INC.1">The amount in box [LUN56] exceeds the amount in box [LUN55]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW-LOSS-SET-OFF-OTHER-INC.1">The amount in box [LUN56] exceeds the amount in box [LUN55]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW-LOSS-CARRIED-BACK.0">6583</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW-LOSS-CARRIED-BACK.0">The amount in box [LUN57] exceeds ( [LUN55] minus [LUN56] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW-LOSS-CARRIED-BACK.0">The amount in box [LUN57] exceeds ( [LUN55] minus [LUN56] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW-LOSSES-BF-USED-IN-CY-AMT.1">6576</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW-LOSSES-BF-USED-IN-CY-AMT.1">The amount in box [LUN60] must equal the amount in box [LUN51]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW-LOSSES-BF-USED-IN-CY-AMT.1">The amount in box [LUN60] must equal the amount in box [LUN51]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW-LOSSES-UNUSED-IN-CY-AMT.1">6577</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW-LOSSES-UNUSED-IN-CY-AMT.1">The amount in box [LUN61] must equal the amount in box [LUN58]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW-LOSSES-UNUSED-IN-CY-AMT.1">The amount in box [LUN61] must equal the amount in box [LUN58]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW-LOSSES-AVAILABLE-TO-CF-AMT.1">6253</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW-LOSSES-AVAILABLE-TO-CF-AMT.1">The amount in box [LUN62] must equal the sum of ( ( [LUN59] plus [LUN61] ) minus [LUN60] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW-LOSSES-AVAILABLE-TO-CF-AMT.1">The amount in box [LUN62] must equal the sum of ( ( [LUN59] plus [LUN61] ) minus [LUN60] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-LUW-NIC.0">8346</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-LUW-NIC.0">If [LUN63-65] is present there must be an entry in at least one of [LUN63], [LUNCL2], [LUN64] or [LUN65]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-LUW-NIC.0">If [LUN63-65] is present there must be an entry in at least one of [LUN63], [LUNCL2], [LUN64] or [LUN65]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW-CLASS-2-NIC-VOLUNTARY-SIG.0">8347</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW-CLASS-2-NIC-VOLUNTARY-SIG.0">There is an entry in [LUN63]. Please complete [LUNCL2].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW-CLASS-2-NIC-VOLUNTARY-SIG.0">There is an entry in [LUN63]. Please complete [LUNCL2].</sch:diagnostic>
    <sch:diagnostic id="errorCode.LUW-CLASS-2-NIC-AMOUNT.0">8348</sch:diagnostic>
    <sch:diagnostic id="transactional.LUW-CLASS-2-NIC-AMOUNT.0">The amount in box [LUNCL2] exceeds [£219.95]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.LUW-CLASS-2-NIC-AMOUNT.0">The amount in box [LUNCL2] exceeds [£219.95]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA104F.2">6090</sch:diagnostic>
    <sch:diagnostic id="transactional.SA104F.2">There is an entry in [FPS16] or [FPS17]. Please complete box [FPS18].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA104F.2">There is an entry in [FPS16] or [FPS17]. Please complete box [FPS18].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA104F.3">6091</sch:diagnostic>
    <sch:diagnostic id="transactional.SA104F.3">There is an entry in [FPS18] or [FPS19]. Please complete box [FPS20].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA104F.3">There is an entry in [FPS18] or [FPS19]. Please complete box [FPS20].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA104F.4">6092</sch:diagnostic>
    <sch:diagnostic id="transactional.SA104F.4">There is an entry in [FPS28] or [FPS29]. Please complete box [FPS30].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA104F.4">There is an entry in [FPS28] or [FPS29]. Please complete box [FPS30].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA104F.5">6093</sch:diagnostic>
    <sch:diagnostic id="transactional.SA104F.5">There is an entry in [FPS31] or [FPS32] or [FPS33]. Please complete box [FPS34].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA104F.5">There is an entry in [FPS31] or [FPS32] or [FPS33]. Please complete box [FPS34].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA104F.6">6094</sch:diagnostic>
    <sch:diagnostic id="transactional.SA104F.6">There is an entry in [FPS30] or [FPS34]. Please complete box [FPS35].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA104F.6">There is an entry in [FPS30] or [FPS34]. Please complete box [FPS35].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA104F.9">6097</sch:diagnostic>
    <sch:diagnostic id="transactional.SA104F.9">The sum of ( ( [FPS52] plus [FPS53] ) minus [FPS54] ) exceeds 0. Please complete box [FPS55]. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA104F.9">The sum of ( ( [FPS52] plus [FPS53] ) minus [FPS54] ) exceeds 0. Please complete box [FPS55]. </sch:diagnostic>
    <sch:diagnostic id="errorCode.SA104F.13">6101</sch:diagnostic>
    <sch:diagnostic id="transactional.SA104F.13">The sum of ( [FPS68] minus [FPS69] ) exceeds 0. Please complete box [FPS70].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA104F.13">The sum of ( [FPS68] minus [FPS69] ) exceeds 0. Please complete box [FPS70].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA104F.14">6103</sch:diagnostic>
    <sch:diagnostic id="transactional.SA104F.14">The sum of ( [FPS71] minus [FPS72] ) exceeds 0. Please complete box [FPS73].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA104F.14">The sum of ( [FPS71] minus [FPS72] ) exceeds 0. Please complete box [FPS73].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA104F.15">6104</sch:diagnostic>
    <sch:diagnostic id="transactional.SA104F.15">The sum of ( ( [FPS20], [FPS67], and [FPS74] ) minus [FPS75] ) exceeds 0. Please complete box [FPS76].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA104F.15">The sum of ( ( [FPS20], [FPS67], and [FPS74] ) minus [FPS75] ) exceeds 0. Please complete box [FPS76].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA104F.18">6201</sch:diagnostic>
    <sch:diagnostic id="transactional.SA104F.18">There is an entry in [FPS36] or [FPS37] or [FPS38]. Please complete box [FPS41].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA104F.18">There is an entry in [FPS36] or [FPS37] or [FPS38]. Please complete box [FPS41].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA104F.0">6100</sch:diagnostic>
    <sch:diagnostic id="transactional.SA104F.0">[FPS67] must be present if ( The sum of [FPS41], [FPS48], [FPS55], and [FPS60] ) exceeds 0</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA104F.0">[FPS67] must be present if ( The sum of [FPS41], [FPS48], [FPS55], and [FPS60] ) exceeds 0</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR2-PARTNERSHIP-REF-NUMBER.0">6254</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR2-PARTNERSHIP-REF-NUMBER.0">The entry must be valid against the UTR algorithm. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR2-PARTNERSHIP-REF-NUMBER.0">The entry must be valid against the UTR algorithm. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR2-PARTNERSHIP-REF-NUMBER.1">8210</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR2-PARTNERSHIP-REF-NUMBER.1">The entry must not be 1111111111, 2222222222, 3333333333, 4444444444, 5555555555, 6666666666, 7777777777, 8888888888, or 9999999999. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR2-PARTNERSHIP-REF-NUMBER.1">The entry must not be 1111111111, 2222222222, 3333333333, 4444444444, 5555555555, 6666666666, 7777777777, 8888888888, or 9999999999. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-BUSINESS-JOIN-QUES.0">8678</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-BUSINESS-JOIN-QUES.0">[FPS3] must be present if [FPS3Q] equals 'yes'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-BUSINESS-JOIN-QUES.0">[FPS3] must be present if [FPS3Q] equals 'yes'</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR3-STARTED-AS-PARTNER-DATE.1">6731</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR3-STARTED-AS-PARTNER-DATE.1">The date entered must be within the return period.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR3-STARTED-AS-PARTNER-DATE.1">The date entered must be within the return period.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-BUSINESS-LEAVE-QUES.0">8679</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-BUSINESS-LEAVE-QUES.0">[FPS4] must be present if [FPS4Q] equals 'yes'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-BUSINESS-LEAVE-QUES.0">[FPS4] must be present if [FPS4Q] equals 'yes'</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-DATE-CEASED-AS-PARTNER.1">6731</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-DATE-CEASED-AS-PARTNER.1">The date entered must be within the return period.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-DATE-CEASED-AS-PARTNER.1">The date entered must be within the return period.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-DATE-CEASED-AS-PARTNER.2">6106</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-DATE-CEASED-AS-PARTNER.2">The date in [FPS4] must be the same as or later than the date in [FPS3], if both [FPS3] and [FPS4] completed. Please check. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-DATE-CEASED-AS-PARTNER.2">The date in [FPS4] must be the same as or later than the date in [FPS3], if both [FPS3] and [FPS4] completed. Please check. </sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-FPS-SHARE-PROFIT.0">8219</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-FPS-SHARE-PROFIT.0">The amount in box [FPS16] must equal ([FPS8] + [FPS9]  + [FPS10] + [FPS11] - [FPS12]) if the sum of ([FPS8] + [FPS9] - [FPS12]) is positive. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-FPS-SHARE-PROFIT.0">The amount in box [FPS16] must equal ([FPS8] + [FPS9]  + [FPS10] + [FPS11] - [FPS12]) if the sum of ([FPS8] + [FPS9] - [FPS12]) is positive. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-FPS-SHARE-PROFIT.5">8220</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-FPS-SHARE-PROFIT.5">The sum of ([FPS8] + [FPS9] - [FPS12]) is negative or zero. If ([FPS10] + [FPS11]) is greater than zero, the amount in box [FPS16] must equal ([FPS10] + [FPS11] or [FPS16] must be zero or absent. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-FPS-SHARE-PROFIT.5">The sum of ([FPS8] + [FPS9] - [FPS12]) is negative or zero. If ([FPS10] + [FPS11]) is greater than zero, the amount in box [FPS16] must equal ([FPS10] + [FPS11] or [FPS16] must be zero or absent. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-FPS-SHARE-PROFIT.2">8221</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-FPS-SHARE-PROFIT.2">The sum of ([FPS8] + [FPS9] - [FPS12]) is less than zero. Please complete box [FPS21] with the positive equivalent.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-FPS-SHARE-PROFIT.2">The sum of ([FPS8] + [FPS9] - [FPS12]) is less than zero. Please complete box [FPS21] with the positive equivalent.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-TRPO-LOSSES-USED-THIS-YEAR.0">8628</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-TRPO-LOSSES-USED-THIS-YEAR.0">[FPS16.4] is valid only if this does not exceed [FPS16.3]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-TRPO-LOSSES-USED-THIS-YEAR.0">[FPS16.4] is valid only if this does not exceed [FPS16.3]</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-LOSSES-USED-THIS-YR.1">6737</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-LOSSES-USED-THIS-YR.1">[FPS17] is valid only if this does not exceed [FPS16]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-LOSSES-USED-THIS-YR.1">[FPS17] is valid only if this does not exceed [FPS16]</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-PROFIT-AFTER-LOSSES.1">6738</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-PROFIT-AFTER-LOSSES.1">The amount in box [FPS18] must equal ( [FPS16] minus [FPS17] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-PROFIT-AFTER-LOSSES.1">The amount in box [FPS18] must equal ( [FPS16] minus [FPS17] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-TOTAL-TAXABLE-PROFITS.1">6739</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-TOTAL-TAXABLE-PROFITS.1">The amount in box [FPS20] must equal ( [FPS18] plus [FPS19] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-TOTAL-TAXABLE-PROFITS.1">The amount in box [FPS20] must equal ( [FPS18] plus [FPS19] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-TOTAL-TAX-PROF-FIG-CLM.0">8680</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-TOTAL-TAX-PROF-FIG-CLM.0">[FPS20.1] is valid only if this does not exceed [FPS20]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-TOTAL-TAX-PROF-FIG-CLM.0">[FPS20.1] is valid only if this does not exceed [FPS20]</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-TOTAL-TAX-PROF-FIG-CLM.1">8681</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-TOTAL-TAX-PROF-FIG-CLM.1">There is an entry in [FPS20.1]. Please complete box [FPS76.1].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-TOTAL-TAX-PROF-FIG-CLM.1">There is an entry in [FPS20.1]. Please complete box [FPS76.1].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-TOTAL-TAX-PROF-FIG-CLM.2">8682</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-TOTAL-TAX-PROF-FIG-CLM.2">[FPS20.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-TOTAL-TAX-PROF-FIG-CLM.2">[FPS20.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-FPS-SHARE-PROFIT.3">8222</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-FPS-SHARE-PROFIT.3">The sum of ([FPS8] + [FPS9] - [FPS12]) is greater than or equal to zero. The entry in box [FPS21] must be equal to zero or be absent. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-FPS-SHARE-PROFIT.3">The sum of ([FPS8] + [FPS9] - [FPS12]) is greater than or equal to zero. The entry in box [FPS21] must be equal to zero or be absent. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR3-ALLOW-LOSS-FIG-CLM.0">8683</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR3-ALLOW-LOSS-FIG-CLM.0">[FPS21.1] is valid only if this equals [FPS21]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR3-ALLOW-LOSS-FIG-CLM.0">[FPS21.1] is valid only if this equals [FPS21]</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR3-ALLOW-LOSS-FIG-CLM.1">8684</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR3-ALLOW-LOSS-FIG-CLM.1">[FPS21.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR3-ALLOW-LOSS-FIG-CLM.1">[FPS21.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR1-LOSS-TO-SET-OFF-OTHER-INC.0">6108</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR1-LOSS-TO-SET-OFF-OTHER-INC.0">The amount in box [FPS22] exceeds the amount in box [FPS21]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR1-LOSS-TO-SET-OFF-OTHER-INC.0">The amount in box [FPS22] exceeds the amount in box [FPS21]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR1-LOSS-TO-SET-OFF-OTHER-INC.1">8685</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR1-LOSS-TO-SET-OFF-OTHER-INC.1">[FPS22] must not be present if [FPS21.1] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR1-LOSS-TO-SET-OFF-OTHER-INC.1">[FPS22] must not be present if [FPS21.1] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-LOSS-TO-CARRY-BACK.0">6741</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-LOSS-TO-CARRY-BACK.0">The amount in box [FPS23] exceeds ( [FPS21] minus [FPS22] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-LOSS-TO-CARRY-BACK.0">The amount in box [FPS23] exceeds ( [FPS21] minus [FPS22] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-LOSS-TO-CARRY-BACK.1">8686</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-LOSS-TO-CARRY-BACK.1">[FPS23] must not be present if [FPS21.1] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-LOSS-TO-CARRY-BACK.1">[FPS23] must not be present if [FPS21.1] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-FPS-NIC.0">8351</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-FPS-NIC.0">If [FPS25-27] is present there must be an entry in at least one of [FPS25], [FPSCL2], [FPS26] or [FPS27]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-FPS-NIC.0">If [FPS25-27] is present there must be an entry in at least one of [FPS25], [FPSCL2], [FPS26] or [FPS27]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-CLASS-2-NIC-VOLUNTARY-SIG.0">8352</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-CLASS-2-NIC-VOLUNTARY-SIG.0">There is an entry in [FPS25]. Please complete [FPSCL2]. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-CLASS-2-NIC-VOLUNTARY-SIG.0">There is an entry in [FPS25]. Please complete [FPSCL2]. </sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-CLASS-2-NIC-AMOUNT.0">8353</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-CLASS-2-NIC-AMOUNT.0">The amount in box [FPSCL2] exceeds [£219.95]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-CLASS-2-NIC-AMOUNT.0">The amount in box [FPSCL2] exceeds [£219.95]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-ADJ-UK-SAVING-BASIS-PERIOD.1">6743</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-ADJ-UK-SAVING-BASIS-PERIOD.1">The amount in box [FPS30] must equal ( [FPS28] plus [FPS29] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-ADJ-UK-SAVING-BASIS-PERIOD.1">The amount in box [FPS30] must equal ( [FPS28] plus [FPS29] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-TAXABLE-FOREIGN-INCOME.1">6744</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-TAXABLE-FOREIGN-INCOME.1">The amount in box [FPS34] must equal ( ( [FPS31] plus [FPS32] ) minus [FPS33] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-TAXABLE-FOREIGN-INCOME.1">The amount in box [FPS34] must equal ( ( [FPS31] plus [FPS32] ) minus [FPS33] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-UNTAXED-INC-LIABLE-AT-LR.1">6745</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-UNTAXED-INC-LIABLE-AT-LR.1">The entry in box [FPS35] must equal the sum of ([FPS30] plus [FPS34]) if this sum is positive or zero. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-UNTAXED-INC-LIABLE-AT-LR.1">The entry in box [FPS35] must equal the sum of ([FPS30] plus [FPS34]) if this sum is positive or zero. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-UNTAXED-INC-LIABLE-AT-LR.2">8632</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-UNTAXED-INC-LIABLE-AT-LR.2">The sum of ([FPS30] plus [FPS34]) is negative. The entry in box [FPS35] must equal zero. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-UNTAXED-INC-LIABLE-AT-LR.2">The sum of ([FPS30] plus [FPS34]) is negative. The entry in box [FPS35] must equal zero. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-UNTAXED-INC-LATLR-FIG-CLM.0">8687</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-UNTAXED-INC-LATLR-FIG-CLM.0">[FPS35.1] is valid only if this does not exceed [FPS35]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-UNTAXED-INC-LATLR-FIG-CLM.0">[FPS35.1] is valid only if this does not exceed [FPS35]</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-UNTAXED-INC-LATLR-FIG-CLM.1">8688</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-UNTAXED-INC-LATLR-FIG-CLM.1">[FPS35.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-UNTAXED-INC-LATLR-FIG-CLM.1">[FPS35.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR4-UK-LAND-LOSS-BF-AMO.1">6746</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR4-UK-LAND-LOSS-BF-AMO.1">The amount in box [FPS38] cannot exceed the sum of [FPS36]+[FPS37] where the sum is positive. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR4-UK-LAND-LOSS-BF-AMO.1">The amount in box [FPS38] cannot exceed the sum of [FPS36]+[FPS37] where the sum is positive. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-TAXABLE-PROFIT-FROM-IFP.0">6204</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-TAXABLE-PROFIT-FROM-IFP.0">The entry in box [FPS41] must equal the sum of ([FPS36] + [FPS37] - [FPS38]) if positive or zero. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-TAXABLE-PROFIT-FROM-IFP.0">The entry in box [FPS41] must equal the sum of ([FPS36] + [FPS37] - [FPS38]) if positive or zero. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-TAXABLE-PROFIT-FROM-IFP.1">6205</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-TAXABLE-PROFIT-FROM-IFP.1">The sum of ([FPS36] + [FPS37] - [FPS38]) is negative. The entry in box [FPS41] must equal 0. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-TAXABLE-PROFIT-FROM-IFP.1">The sum of ([FPS36] + [FPS37] - [FPS38]) is negative. The entry in box [FPS41] must equal 0. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-FPS-OTHER-UK-INC.0">6206</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-FPS-OTHER-UK-INC.0">The sum of ([FPS45] + [FPS46] - [FPS47] ) is equal to or greater than zero. Please complete box [FPS48].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-FPS-OTHER-UK-INC.0">The sum of ([FPS45] + [FPS46] - [FPS47] ) is equal to or greater than zero. Please complete box [FPS48].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR4-OTHER-UK-LOSS-BF-AMO.1">6753</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR4-OTHER-UK-LOSS-BF-AMO.1">The amount in box [FPS47] exceeds ( [FPS45] plus [FPS46] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR4-OTHER-UK-LOSS-BF-AMO.1">The amount in box [FPS47] exceeds ( [FPS45] plus [FPS46] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-TXBLE-PROFIT-OTH-UNT-INC.0">6259</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-TXBLE-PROFIT-OTH-UNT-INC.0">The amount in box [FPS48] exceeds the sum of ( ( [FPS45] plus [FPS46] ) minus [FPS47] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-TXBLE-PROFIT-OTH-UNT-INC.0">The amount in box [FPS48] exceeds the sum of ( ( [FPS45] plus [FPS46] ) minus [FPS47] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-TXBLE-PROFIT-OFFSHORE-FUND.1">6755</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-TXBLE-PROFIT-OFFSHORE-FUND.1">The amount in box [FPS55] must equal ( ( [FPS52] plus [FPS53] ) minus [FPS54] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-TXBLE-PROFIT-OFFSHORE-FUND.1">The amount in box [FPS55] must equal ( ( [FPS52] plus [FPS53] ) minus [FPS54] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-TXBLE-PROF-OSF-FIG-CLM.0">8689</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-TXBLE-PROF-OSF-FIG-CLM.0">[FPS55.1] is valid only if this does not exceed [FPS55]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-TXBLE-PROF-OSF-FIG-CLM.0">[FPS55.1] is valid only if this does not exceed [FPS55]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-TXBLE-PROF-OSF-FIG-CLM.1">8690</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-TXBLE-PROF-OSF-FIG-CLM.1">There is an entry in [FPS55.1]. Please complete box [FPS76.1].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-TXBLE-PROF-OSF-FIG-CLM.1">There is an entry in [FPS55.1]. Please complete box [FPS76.1].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-TXBLE-PROF-OSF-FIG-CLM.2">8691</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-TXBLE-PROF-OSF-FIG-CLM.2">[FPS55.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-TXBLE-PROF-OSF-FIG-CLM.2">[FPS55.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR2-OTHER-UNTAXED-FOREIGN-INC.0">6260</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR2-OTHER-UNTAXED-FOREIGN-INC.0">There is an entry in [FPS56]. Please complete box [FPS60].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR2-OTHER-UNTAXED-FOREIGN-INC.0">There is an entry in [FPS56]. Please complete box [FPS60].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR4-OTHR-FRGN-PROFIT-ADJ-AMO.0">6262</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR4-OTHR-FRGN-PROFIT-ADJ-AMO.0">There is an entry in [FPS57]. Please complete box [FPS60].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR4-OTHR-FRGN-PROFIT-ADJ-AMO.0">There is an entry in [FPS57]. Please complete box [FPS60].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR4-OTHER-FRGN-LOSS-BF-AMO.0">6263</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR4-OTHER-FRGN-LOSS-BF-AMO.0">There is an entry in [FPS58]. Please complete box [FPS60].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR4-OTHER-FRGN-LOSS-BF-AMO.0">There is an entry in [FPS58]. Please complete box [FPS60].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR4-OTHER-FRGN-LOSS-BF-AMO.1">6756</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR4-OTHER-FRGN-LOSS-BF-AMO.1">The amount in box [FPS58] exceeds ( [FPS56] plus [FPS57] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR4-OTHER-FRGN-LOSS-BF-AMO.1">The amount in box [FPS58] exceeds ( [FPS56] plus [FPS57] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-TXBLE-PROFIT-UNTAXED-FI.0">6264</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-TXBLE-PROFIT-UNTAXED-FI.0">There is an entry in [FPS59]. Please complete box [FPS60].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-TXBLE-PROFIT-UNTAXED-FI.0">There is an entry in [FPS59]. Please complete box [FPS60].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR2-FOREIGN-LET-PROPERTY-LOSS.0">6266</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR2-FOREIGN-LET-PROPERTY-LOSS.0">The amount in box [FPS60] must equal the sum of ([FPS56] + [FPS57]) minus ([FPS58] + [FPS59]) if greater than or equal to zero. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR2-FOREIGN-LET-PROPERTY-LOSS.0">The amount in box [FPS60] must equal the sum of ([FPS56] + [FPS57]) minus ([FPS58] + [FPS59]) if greater than or equal to zero. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR2-FOREIGN-LET-PROPERTY-LOSS.1">6267</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR2-FOREIGN-LET-PROPERTY-LOSS.1">The amount in box [FPS60] must equal zero if the sum of ([FPS56] + [FPS57]) minus ([FPS58] + [FPS59]) is negative. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR2-FOREIGN-LET-PROPERTY-LOSS.1">The amount in box [FPS60] must equal zero if the sum of ([FPS56] + [FPS57]) minus ([FPS58] + [FPS59]) is negative. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR2-FOREIGN-LET-PROP-FIG-CLM.0">8692</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR2-FOREIGN-LET-PROP-FIG-CLM.0">[FPS60.1] is valid only if this does not exceed [FPS60]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR2-FOREIGN-LET-PROP-FIG-CLM.0">[FPS60.1] is valid only if this does not exceed [FPS60]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR2-FOREIGN-LET-PROP-FIG-CLM.1">8693</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR2-FOREIGN-LET-PROP-FIG-CLM.1">There is an entry in [FPS60.1]. Please complete box [FPS76.1].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR2-FOREIGN-LET-PROP-FIG-CLM.1">There is an entry in [FPS60.1]. Please complete box [FPS76.1].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR2-FOREIGN-LET-PROP-FIG-CLM.2">8694</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR2-FOREIGN-LET-PROP-FIG-CLM.2">[FPS60.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR2-FOREIGN-LET-PROP-FIG-CLM.2">[FPS60.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-TOTAL-UNTAXED-INCOME.0">6759</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-TOTAL-UNTAXED-INCOME.0">The amount in box [FPS67] must equal ( [FPS41] + [FPS48] + [FPS55] + [FPS60] ) Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-TOTAL-UNTAXED-INCOME.0">The amount in box [FPS67] must equal ( [FPS41] + [FPS48] + [FPS55] + [FPS60] ) Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR3-TOTAL-TAXED-INC-SCHF-RATE.1">6760</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR3-TOTAL-TAXED-INC-SCHF-RATE.1">The amount in box [FPS70] must equal ( [FPS68] minus [FPS69] ). Please check. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR3-TOTAL-TAXED-INC-SCHF-RATE.1">The amount in box [FPS70] must equal ( [FPS68] minus [FPS69] ). Please check. </sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR3-TOT-TAXD-INC-SCHF-FIG-CLM.0">8695</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR3-TOT-TAXD-INC-SCHF-FIG-CLM.0">[FPS70.1] is valid only if this does not exceed [FPS70]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR3-TOT-TAXD-INC-SCHF-FIG-CLM.0">[FPS70.1] is valid only if this does not exceed [FPS70]</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR3-TOT-TAXD-INC-SCHF-FIG-CLM.1">8696</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR3-TOT-TAXD-INC-SCHF-FIG-CLM.1">[FPS70.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR3-TOT-TAXD-INC-SCHF-FIG-CLM.1">[FPS70.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-TOTAL-DIV-INC-WITH-TAX-CRD.1">6761</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-TOTAL-DIV-INC-WITH-TAX-CRD.1">The amount in box [FPS73] must equal ( [FPS71] minus [FPS72] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-TOTAL-DIV-INC-WITH-TAX-CRD.1">The amount in box [FPS73] must equal ( [FPS71] minus [FPS72] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-ADJ-SHARE-OTHER-FIG-CLM.0">8697</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-ADJ-SHARE-OTHER-FIG-CLM.0">If [FPS75.1] is present and equal to [FPS74], then [FPS75] must be absent. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-ADJ-SHARE-OTHER-FIG-CLM.0">If [FPS75.1] is present and equal to [FPS74], then [FPS75] must be absent. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-ADJ-SHARE-OTHER-FIG-CLM.1">8698</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-ADJ-SHARE-OTHER-FIG-CLM.1">If [FPS75.1] is present and not equal to [FPS74], then [FPS75.1] must be less than or equal to [FPS74] minus [FPS75]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-ADJ-SHARE-OTHER-FIG-CLM.1">If [FPS75.1] is present and not equal to [FPS74], then [FPS75.1] must be less than or equal to [FPS74] minus [FPS75]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-ADJ-SHARE-OTHER-FIG-CLM.2">8699</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-ADJ-SHARE-OTHER-FIG-CLM.2">There is an entry in [FPS75.1]. Please complete box [FPS76.1].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-ADJ-SHARE-OTHER-FIG-CLM.2">There is an entry in [FPS75.1]. Please complete box [FPS76.1].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-ADJ-SHARE-OTHER-FIG-CLM.3">8700</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-ADJ-SHARE-OTHER-FIG-CLM.3">[FPS75.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-ADJ-SHARE-OTHER-FIG-CLM.3">[FPS75.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-TOT-TAX-SHARE-OF-PSHIP-INC.1">6762</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-TOT-TAX-SHARE-OF-PSHIP-INC.1">The amount in box [FPS76] must equal ( ( the sum of [FPS20], [FPS67], and [FPS74] ) minus [FPS75] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-TOT-TAX-SHARE-OF-PSHIP-INC.1">The amount in box [FPS76] must equal ( ( the sum of [FPS20], [FPS67], and [FPS74] ) minus [FPS75] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-TOT-TAX-SHRE-PSHIP-FIG-CLM.0">8701</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-TOT-TAX-SHRE-PSHIP-FIG-CLM.0">[FPS76.1] should be equal to the sum of [FPS20.1], [FPS55.1], [FPS60.1] and [FPS75.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-TOT-TAX-SHRE-PSHIP-FIG-CLM.0">[FPS76.1] should be equal to the sum of [FPS20.1], [FPS55.1], [FPS60.1] and [FPS75.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-TOT-TAX-SHRE-PSHIP-FIG-CLM.1">8702</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-TOT-TAX-SHRE-PSHIP-FIG-CLM.1">[FPS76.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-TOT-TAX-SHRE-PSHIP-FIG-CLM.1">[FPS76.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PARTNERSHIP-SHARE-TAX-PAYED.0">8378</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PARTNERSHIP-SHARE-TAX-PAYED.0">There is an entry in [FPS77]. Please complete [FPS80].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PARTNERSHIP-SHARE-TAX-PAYED.0">There is an entry in [FPS77]. Please complete [FPS80].</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PARTNERSHIP-SHARE-TAX-PAYED.1">8379</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PARTNERSHIP-SHARE-TAX-PAYED.1">There is an entry in [FPS78]. Please complete [FPS80].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PARTNERSHIP-SHARE-TAX-PAYED.1">There is an entry in [FPS78]. Please complete [FPS80].</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PARTNERSHIP-SHARE-TAX-PAYED.2">8380</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PARTNERSHIP-SHARE-TAX-PAYED.2">There is an entry in [FPS79]. Please complete [FPS80].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PARTNERSHIP-SHARE-TAX-PAYED.2">There is an entry in [FPS79]. Please complete [FPS80].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-TOTAL-ADJ-TAX-EX-NOTIONAL.1">6763</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-TOTAL-ADJ-TAX-EX-NOTIONAL.1">The amount in box [FPS80] must equal ( the sum of [FPS77], [FPS78], and [FPS79]). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-TOTAL-ADJ-TAX-EX-NOTIONAL.1">The amount in box [FPS80] must equal ( the sum of [FPS77], [FPS78], and [FPS79]). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA104S.0">6109</sch:diagnostic>
    <sch:diagnostic id="transactional.SA104S.0">The sum of ( [SPS16] minus [SPS17] ) exceeds 0. Please complete box [SPS18].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA104S.0">The sum of ( [SPS16] minus [SPS17] ) exceeds 0. Please complete box [SPS18].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA104S.1">6110</sch:diagnostic>
    <sch:diagnostic id="transactional.SA104S.1">There is an entry in [SPS18] or [SPS19]. Please complete box [SPS20].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA104S.1">There is an entry in [SPS18] or [SPS19]. Please complete box [SPS20].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SPS-PARTNERSHIP-REF-NUMBER.0">6269</sch:diagnostic>
    <sch:diagnostic id="transactional.SPS-PARTNERSHIP-REF-NUMBER.0">The entry must be valid against the UTR algorithm. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SPS-PARTNERSHIP-REF-NUMBER.0">The entry must be valid against the UTR algorithm. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SPS-PARTNERSHIP-REF-NUMBER.1">8210</sch:diagnostic>
    <sch:diagnostic id="transactional.SPS-PARTNERSHIP-REF-NUMBER.1">The entry must not be 1111111111, 2222222222, 3333333333, 4444444444, 5555555555, 6666666666, 7777777777, 8888888888, or 9999999999. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SPS-PARTNERSHIP-REF-NUMBER.1">The entry must not be 1111111111, 2222222222, 3333333333, 4444444444, 5555555555, 6666666666, 7777777777, 8888888888, or 9999999999. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SPS-BUSINESS-JOIN-QUES.0">8703</sch:diagnostic>
    <sch:diagnostic id="transactional.SPS-BUSINESS-JOIN-QUES.0">[SPS3] must be present if [SPS3Q] equals 'yes'. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SPS-BUSINESS-JOIN-QUES.0">[SPS3] must be present if [SPS3Q] equals 'yes'. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SPS-STARTED-AS-PARTNER-DATE.1">6731</sch:diagnostic>
    <sch:diagnostic id="transactional.SPS-STARTED-AS-PARTNER-DATE.1">The date entered must be within the return period.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SPS-STARTED-AS-PARTNER-DATE.1">The date entered must be within the return period.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SPS-BUSINESS-LEAVE-QUES.0">8704</sch:diagnostic>
    <sch:diagnostic id="transactional.SPS-BUSINESS-LEAVE-QUES.0">[SPS4] must be present if [SPS4Q] equals 'yes'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SPS-BUSINESS-LEAVE-QUES.0">[SPS4] must be present if [SPS4Q] equals 'yes'</sch:diagnostic>
    <sch:diagnostic id="errorCode.SPS-DATE-CEASED-AS-PARTNER.1">6731</sch:diagnostic>
    <sch:diagnostic id="transactional.SPS-DATE-CEASED-AS-PARTNER.1">The date entered must be within the return period.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SPS-DATE-CEASED-AS-PARTNER.1">The date entered must be within the return period.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SPS-DATE-CEASED-AS-PARTNER.2">6112</sch:diagnostic>
    <sch:diagnostic id="transactional.SPS-DATE-CEASED-AS-PARTNER.2">The date in [SPS4] must be same as or later than the date in [SPS3], if both [SPS3] and [SPS4] completed. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SPS-DATE-CEASED-AS-PARTNER.2">The date in [SPS4] must be same as or later than the date in [SPS3], if both [SPS3] and [SPS4] completed. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PARTNERSHIP-PROFITS.0">8223</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PARTNERSHIP-PROFITS.0">(([SPS8] + [SPS9]) - [SPS12]) is greater than zero, [SPS16] must equal (([SPS8] + [SPS9]) - [SPS12] + [SPS10] + [SPS11]). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PARTNERSHIP-PROFITS.0">(([SPS8] + [SPS9]) - [SPS12]) is greater than zero, [SPS16] must equal (([SPS8] + [SPS9]) - [SPS12] + [SPS10] + [SPS11]). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PARTNERSHIP-PROFITS.1">8224</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PARTNERSHIP-PROFITS.1">The sum of ([SPS8] + [SPS9]) is less than or equal to zero. If ([SPS10] + [SPS11]) is greater than zero, the amount in box [SPS16] must equal ([SPS10] + [SPS11]) or [SPS16] must be zero or absent. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PARTNERSHIP-PROFITS.1">The sum of ([SPS8] + [SPS9]) is less than or equal to zero. If ([SPS10] + [SPS11]) is greater than zero, the amount in box [SPS16] must equal ([SPS10] + [SPS11]) or [SPS16] must be zero or absent. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PARTNERSHIP-PROFITS.2">8225</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PARTNERSHIP-PROFITS.2">The sum of (([SPS8] + [SPS9]) - [SPS12]) is negative. Please complete box [SPS21] with the positive equivalent.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PARTNERSHIP-PROFITS.2">The sum of (([SPS8] + [SPS9]) - [SPS12]) is negative. Please complete box [SPS21] with the positive equivalent.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SPS-LOSSES-USED-THIS-YR.1">6781</sch:diagnostic>
    <sch:diagnostic id="transactional.SPS-LOSSES-USED-THIS-YR.1">The amount in box [SPS17] exceeds the amount in box [SPS16]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SPS-LOSSES-USED-THIS-YR.1">The amount in box [SPS17] exceeds the amount in box [SPS16]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SPS-PROFIT-AFTER-LOSSES.1">6783</sch:diagnostic>
    <sch:diagnostic id="transactional.SPS-PROFIT-AFTER-LOSSES.1">The amount in box [SPS18] must equal ( [SPS16] minus [SPS17] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SPS-PROFIT-AFTER-LOSSES.1">The amount in box [SPS18] must equal ( [SPS16] minus [SPS17] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SPS-TOTAL-TAXABLE-PROFITS.1">6784</sch:diagnostic>
    <sch:diagnostic id="transactional.SPS-TOTAL-TAXABLE-PROFITS.1">The amount in box [SPS20] must equal ( [SPS18] plus [SPS19] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SPS-TOTAL-TAXABLE-PROFITS.1">The amount in box [SPS20] must equal ( [SPS18] plus [SPS19] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PARTNERSHIP-PROFITS.3">8226</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PARTNERSHIP-PROFITS.3">The sum of (([SPS8] + [SPS9]) - [SPS12]) is greater than or equal to zero. The entry in box [SPS21] must be equal to zero or be absent. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PARTNERSHIP-PROFITS.3">The sum of (([SPS8] + [SPS9]) - [SPS12]) is greater than or equal to zero. The entry in box [SPS21] must be equal to zero or be absent. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SPS-LOSS-TO-SET-OFF-OTHER-INC.0">6116</sch:diagnostic>
    <sch:diagnostic id="transactional.SPS-LOSS-TO-SET-OFF-OTHER-INC.0">The amount in box [SPS22] exceeds the amount in box [SPS21]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SPS-LOSS-TO-SET-OFF-OTHER-INC.0">The amount in box [SPS22] exceeds the amount in box [SPS21]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SPS-LOSS-TO-CARRY-BACK.0">6785</sch:diagnostic>
    <sch:diagnostic id="transactional.SPS-LOSS-TO-CARRY-BACK.0">The amount in box [SPS23] exceeds ( [SPS21] minus [SPS22] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SPS-LOSS-TO-CARRY-BACK.0">The amount in box [SPS23] exceeds ( [SPS21] minus [SPS22] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-CLASS-4-NICS-CONTRIBUTIONS.0">8355</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-CLASS-4-NICS-CONTRIBUTIONS.0">If [SPS25-27] is present there must be an entry in at least one of [SPS25], [SPSCL2], [SPS26] or [SPS27]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-CLASS-4-NICS-CONTRIBUTIONS.0">If [SPS25-27] is present there must be an entry in at least one of [SPS25], [SPSCL2], [SPS26] or [SPS27]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SPS-CLASS-2-NIC-VOLUNTARY-SIG.0">8356</sch:diagnostic>
    <sch:diagnostic id="transactional.SPS-CLASS-2-NIC-VOLUNTARY-SIG.0">There is an entry in [SPS25]. Please complete [SPSCL2]. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SPS-CLASS-2-NIC-VOLUNTARY-SIG.0">There is an entry in [SPS25]. Please complete [SPSCL2]. </sch:diagnostic>
    <sch:diagnostic id="errorCode.SPS-CLASS-2-NIC-AMOUNT.0">8357</sch:diagnostic>
    <sch:diagnostic id="transactional.SPS-CLASS-2-NIC-AMOUNT.0">The amount in box [SPSCL2] exceeds [£219.95]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SPS-CLASS-2-NIC-AMOUNT.0">The amount in box [SPSCL2] exceeds [£219.95]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA105.2">6119</sch:diagnostic>
    <sch:diagnostic id="transactional.SA105.2">The sum of ( [PRO38] minus [PRO39] ) exceeds 0. Please complete box [PRO40].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA105.2">The sum of ( [PRO38] minus [PRO39] ) exceeds 0. Please complete box [PRO40].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA105.6">8506</sch:diagnostic>
    <sch:diagnostic id="transactional.SA105.6">The total of ( [PRO20], [PRO22], [PRO23] and [PRO31] ) must not exceed [£150,000] if [PRO20.2] is absent.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA105.6">The total of ( [PRO20], [PRO22], [PRO23] and [PRO31] ) must not exceed [£150,000] if [PRO20.2] is absent.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA105.0">8262</sch:diagnostic>
    <sch:diagnostic id="transactional.SA105.0">[PRO38] must be present if ( ( The sum of [PRO20], [PRO22], [PRO23], [PRO30], and [PRO31] ) minus ( The sum of [PRO20.1], [PRO24], [PRO25], [PRO26], [PRO27], [PRO28], [PRO29], [PRO32], [PRO33], [PRO33.1], [PRO33.2], [PRO34.1], [PRO35], [PRO36], and [PRO37] ) ) exceeds 0</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA105.0">[PRO38] must be present if ( ( The sum of [PRO20], [PRO22], [PRO23], [PRO30], and [PRO31] ) minus ( The sum of [PRO20.1], [PRO24], [PRO25], [PRO26], [PRO27], [PRO28], [PRO29], [PRO32], [PRO33], [PRO33.1], [PRO33.2], [PRO34.1], [PRO35], [PRO36], and [PRO37] ) ) exceeds 0</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA105.1">8263</sch:diagnostic>
    <sch:diagnostic id="transactional.SA105.1">[PRO41] must be present if ( ( The sum of [PRO24], [PRO25], [PRO26], [PRO27], [PRO28], [PRO29], [PRO32], [PRO33], [PRO33.1], [PRO33.2], [PRO34.1], [PRO35], [PRO36], and [PRO37] ) minus ( The sum of [PRO20], [PRO22], [PRO23], [PRO30], and [PRO31] ) ) exceeds 0</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA105.1">[PRO41] must be present if ( ( The sum of [PRO24], [PRO25], [PRO26], [PRO27], [PRO28], [PRO29], [PRO32], [PRO33], [PRO33.1], [PRO33.2], [PRO34.1], [PRO35], [PRO36], and [PRO37] ) minus ( The sum of [PRO20], [PRO22], [PRO23], [PRO30], and [PRO31] ) ) exceeds 0</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-PPTY-INCOME-ALLCE.1">8517</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-PPTY-INCOME-ALLCE.1">The amount in box [PRO20.1] exceeds [PRO20], [PRO22], [PRO23] and [PRO31]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-PPTY-INCOME-ALLCE.1">The amount in box [PRO20.1] exceeds [PRO20], [PRO22], [PRO23] and [PRO31]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-PPTY-RENT-RATES.0">8518</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-PPTY-RENT-RATES.0">The entry in box [PRO24] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-PPTY-RENT-RATES.0">The entry in box [PRO24] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-PPTY-REPAIRS-RENEWALS.0">8519</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-PPTY-REPAIRS-RENEWALS.0">The entry in box [PRO25] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-PPTY-REPAIRS-RENEWALS.0">The entry in box [PRO25] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-PPTY-FINANCE-CHARGES.0">8520</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-PPTY-FINANCE-CHARGES.0">The entry in box [PRO26] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-PPTY-FINANCE-CHARGES.0">The entry in box [PRO26] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-PPTY-LEGAL-CHARGES.0">8521</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-PPTY-LEGAL-CHARGES.0">The entry in box [PRO27] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-PPTY-LEGAL-CHARGES.0">The entry in box [PRO27] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-PPTY-SERVICE-COSTS.0">8522</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-PPTY-SERVICE-COSTS.0">The entry in box [PRO28] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-PPTY-SERVICE-COSTS.0">The entry in box [PRO28] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-PPTY-OTHER-DEDUCTIONS.0">8523</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-PPTY-OTHER-DEDUCTIONS.0">The entry in box [PRO29] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-PPTY-OTHER-DEDUCTIONS.0">The entry in box [PRO29] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-PPTY-PRIVATE-USE-ADJUST.0">8524</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-PPTY-PRIVATE-USE-ADJUST.0">The entry in box [PRO30] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-PPTY-PRIVATE-USE-ADJUST.0">The entry in box [PRO30] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-PPTY-CAPITAL-ALLOWANCES.0">6122</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-PPTY-CAPITAL-ALLOWANCES.0">The amount in box [PRO32] exceeds [£1,000,000]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-PPTY-CAPITAL-ALLOWANCES.0">The amount in box [PRO32] exceeds [£1,000,000]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-PPTY-CAPITAL-ALLOWANCES.1">8525</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-PPTY-CAPITAL-ALLOWANCES.1">The entry in box [PRO32] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-PPTY-CAPITAL-ALLOWANCES.1">The entry in box [PRO32] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-PPTY-CAPITAL-ALLOWANCES.2">8526</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-PPTY-CAPITAL-ALLOWANCES.2">The entry in box [PRO32] should not be present as there is no entry in [PRO20.2] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-PPTY-CAPITAL-ALLOWANCES.2">The entry in box [PRO32] should not be present as there is no entry in [PRO20.2] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-PPTY-SB-ALLCE.0">8594</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-PPTY-SB-ALLCE.0">The entry in box [PRO33] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-PPTY-SB-ALLCE.0">The entry in box [PRO33] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-PPTY-ECP-ALLCE.0">8595</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-PPTY-ECP-ALLCE.0">The entry in box [PRO33.1] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-PPTY-ECP-ALLCE.0">The entry in box [PRO33.1] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-PPTY-FREEPORT-SB-ALLCE.0">8530</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-PPTY-FREEPORT-SB-ALLCE.0">The entry in box [PRO33.2] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-PPTY-FREEPORT-SB-ALLCE.0">The entry in box [PRO33.2] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-P-ZERO-EMISSION-CAR-ALLCE.0">8559</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-P-ZERO-EMISSION-CAR-ALLCE.0">The entry in box [PRO34.1] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-P-ZERO-EMISSION-CAR-ALLCE.0">The entry in box [PRO34.1] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-ENH-CAPITAL-ALLCES-AMT.0">8528</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-ENH-CAPITAL-ALLCES-AMT.0">The entry in box [PRO35] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-ENH-CAPITAL-ALLCES-AMT.0">The entry in box [PRO35] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-PPTY-WEAR-AND-TEAR.0">8529</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-PPTY-WEAR-AND-TEAR.0">The entry in box [PRO36] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-PPTY-WEAR-AND-TEAR.0">The entry in box [PRO36] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-RENT-ROOM-EXEMPT-AMOUNT.1">6468</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-RENT-ROOM-EXEMPT-AMOUNT.1">There is an entry in box [PRO37], box [PRO4] must be absent. Please amend the incorrect entry.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-RENT-ROOM-EXEMPT-AMOUNT.1">There is an entry in box [PRO37], box [PRO4] must be absent. Please amend the incorrect entry.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-RENT-ROOM-EXEMPT-AMOUNT.2">6469</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-RENT-ROOM-EXEMPT-AMOUNT.2">The amount in box [PRO37] exceeds [£7,500]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-RENT-ROOM-EXEMPT-AMOUNT.2">The amount in box [PRO37] exceeds [£7,500]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-ADJUSTED-PROFIT-4-YEAR-AMT.0">8269</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-ADJUSTED-PROFIT-4-YEAR-AMT.0">The amount in box [PRO38] must equal ( the sum of [PRO20], [PRO22], [PRO23], [PRO30] and [PRO31] ) minus ( the sum of [PRO20.1], [PRO24], [PRO25], [PRO26], [PRO27], [PRO28], [PRO29], [PRO32], [PRO33], [PRO33.1], [PRO33.2], [PRO34.1], [PRO35], [PRO36] and [PRO37] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-ADJUSTED-PROFIT-4-YEAR-AMT.0">The amount in box [PRO38] must equal ( the sum of [PRO20], [PRO22], [PRO23], [PRO30] and [PRO31] ) minus ( the sum of [PRO20.1], [PRO24], [PRO25], [PRO26], [PRO27], [PRO28], [PRO29], [PRO32], [PRO33], [PRO33.1], [PRO33.2], [PRO34.1], [PRO35], [PRO36] and [PRO37] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-PPTY-LOSS-BROUGHT-FWD.0">8441</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-PPTY-LOSS-BROUGHT-FWD.0">The amount in box [PRO39] exceeds [PRO38] Please check</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-PPTY-LOSS-BROUGHT-FWD.0">The amount in box [PRO39] exceeds [PRO38] Please check</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-TAXABLE-PROFIT-FOR-YR-AMT.1">6472</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-TAXABLE-PROFIT-FOR-YR-AMT.1">The amount in box [PRO40] must equal( [PRO38] minus [PRO39] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-TAXABLE-PROFIT-FOR-YR-AMT.1">The amount in box [PRO40] must equal( [PRO38] minus [PRO39] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-ADJUSTED-LOSS-AMT.0">8531</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-ADJUSTED-LOSS-AMT.0">The entry in box [PRO41] should not be present as there is an entry in box [PRO20.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-ADJUSTED-LOSS-AMT.0">The entry in box [PRO41] should not be present as there is an entry in box [PRO20.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-ADJUSTED-LOSS-AMT.1">8270</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-ADJUSTED-LOSS-AMT.1">[PRO41] is present so the following should be true: [PRO41] equals ( ( The sum of [PRO24], [PRO25], [PRO26], [PRO27], [PRO28], [PRO29], [PRO32], [PRO33], [PRO33.1], [PRO33.2], [PRO34.1], [PRO35], [PRO36], and [PRO37] ) minus ( The sum of [PRO20], [PRO22], [PRO23], [PRO30], and [PRO31] ) )</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-ADJUSTED-LOSS-AMT.1">[PRO41] is present so the following should be true: [PRO41] equals ( ( The sum of [PRO24], [PRO25], [PRO26], [PRO27], [PRO28], [PRO29], [PRO32], [PRO33], [PRO33.1], [PRO33.2], [PRO34.1], [PRO35], [PRO36], and [PRO37] ) minus ( The sum of [PRO20], [PRO22], [PRO23], [PRO30], and [PRO31] ) )</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-PPTY-LOSS-OFFSET-INCOME.0">8532</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-PPTY-LOSS-OFFSET-INCOME.0">The entry in box [PRO42] should not be present as there is an entry in [PRO20.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-PPTY-LOSS-OFFSET-INCOME.0">The entry in box [PRO42] should not be present as there is an entry in [PRO20.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-PPTY-LOSS-OFFSET-INCOME.1">8533</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-PPTY-LOSS-OFFSET-INCOME.1">The entry in box [PRO42] should not be present as there is no entry in [PRO20.2] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-PPTY-LOSS-OFFSET-INCOME.1">The entry in box [PRO42] should not be present as there is no entry in [PRO20.2] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-PPTY-RES-FIN-COSTS.2">8534</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-PPTY-RES-FIN-COSTS.2">The entry in box [PRO44] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-PPTY-RES-FIN-COSTS.2">The entry in box [PRO44] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.UKL-PPTY-RES-FIN-COSTS-BF.0">8596</sch:diagnostic>
    <sch:diagnostic id="transactional.UKL-PPTY-RES-FIN-COSTS-BF.0">The entry in box [PRO45] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.UKL-PPTY-RES-FIN-COSTS-BF.0">The entry in box [PRO45] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA106.3">6124</sch:diagnostic>
    <sch:diagnostic id="transactional.SA106.3">There is an entry in [FOR14] or [FOR16] or [FOR17]. Please complete box [FOR18].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA106.3">There is an entry in [FOR14] or [FOR16] or [FOR17]. Please complete box [FOR18].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA106.6">6127</sch:diagnostic>
    <sch:diagnostic id="transactional.SA106.6">The sum of ( [FOR25] minus [FOR26] ) exceeds 0. Please complete box [FOR27].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA106.6">The sum of ( [FOR25] minus [FOR26] ) exceeds 0. Please complete box [FOR27].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA106.7">6128</sch:diagnostic>
    <sch:diagnostic id="transactional.SA106.7">There is an entry in box [FOR30C]. Please complete box [FOR28].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA106.7">There is an entry in box [FOR30C]. Please complete box [FOR28].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA106.8">6130</sch:diagnostic>
    <sch:diagnostic id="transactional.SA106.8">There is an entry in box [FOR30D]. Please complete box [FOR29].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA106.8">There is an entry in box [FOR30D]. Please complete box [FOR29].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA106.9">8535</sch:diagnostic>
    <sch:diagnostic id="transactional.SA106.9">Total of all instances of [FOR14.1] must not exceed [£1,000] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA106.9">Total of all instances of [FOR14.1] must not exceed [£1,000] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PRE-CALC.n">8536</sch:diagnostic>
    <sch:diagnostic id="transactional.PRE-CALC.n">All values in [FOR14.2] must match values in [FOR14-FOR24.2 / FOR30A-FOR30F]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PRE-CALC.n">All values in [FOR14.2] must match values in [FOR14-FOR24.2 / FOR30A-FOR30F]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA106.10">8537</sch:diagnostic>
    <sch:diagnostic id="transactional.SA106.10">Total across all instances of [FOR14], [FOR16] &amp; [FOR20] must not exceed [£150,000] if no [FOR14.2] is present.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA106.10">Total across all instances of [FOR14], [FOR16] &amp; [FOR20] must not exceed [£150,000] if no [FOR14.2] is present.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA106.0">8571</sch:diagnostic>
    <sch:diagnostic id="transactional.SA106.0">[FOR30] must be present if [FOR30F] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA106.0">[FOR30] must be present if [FOR30F] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-OTHER-DIVIDENDS-ETC.1">6598</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-OTHER-DIVIDENDS-ETC.1">The amount in box [FOR4F] must equal [FOR4B] if box [FOR4E] completed. If box [FOR4E] not completed,   [FOR4F] must equal [FOR4B] minus [FOR4C]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-OTHER-DIVIDENDS-ETC.1">The amount in box [FOR4F] must equal [FOR4B] if box [FOR4E] completed. If box [FOR4E] not completed,   [FOR4F] must equal [FOR4B] minus [FOR4C]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-OTHR-FI-SAV-GROSS-INC-AMO.1">6133</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-OTHR-FI-SAV-GROSS-INC-AMO.1">There is an entry in box [FOR4B]. Please complete box [FOR4F].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-OTHR-FI-SAV-GROSS-INC-AMO.1">There is an entry in box [FOR4B]. Please complete box [FOR4F].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-OTHER-FI-SAV-FOR-TAX-AMO.1">6599</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-OTHER-FI-SAV-FOR-TAX-AMO.1">The amount in box [FOR4C] exceeds the amount in box [FOR4B]. Please check. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-OTHER-FI-SAV-FOR-TAX-AMO.1">The amount in box [FOR4C] exceeds the amount in box [FOR4B]. Please check. </sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-OTHER-FI-SAV-UK-TAX-AMO.1">6700</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-OTHER-FI-SAV-UK-TAX-AMO.1">The amount in box [FOR4D] exceeds the amount in box [FOR4B] when [FOR1] is not submitted. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-OTHER-FI-SAV-UK-TAX-AMO.1">The amount in box [FOR4D] exceeds the amount in box [FOR4B] when [FOR1] is not submitted. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-OTHER-FI-SAV-UK-TAX-AMO.2">6134</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-OTHER-FI-SAV-UK-TAX-AMO.2">There is an entry in box [FOR4D]. Please complete box [FOR3].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-OTHER-FI-SAV-UK-TAX-AMO.2">There is an entry in box [FOR4D]. Please complete box [FOR3].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-OTHER-FI-SAV-UK-CHRG-AMO.1">6137</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-OTHER-FI-SAV-UK-CHRG-AMO.1">There is an entry in box [FOR4F]. Please complete box [FOR4].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-OTHER-FI-SAV-UK-CHRG-AMO.1">There is an entry in box [FOR4F]. Please complete box [FOR4].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1">6701</sch:diagnostic>
    <sch:diagnostic id="transactional.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</sch:diagnostic>
    <sch:diagnostic id="errorCode.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1">6702</sch:diagnostic>
    <sch:diagnostic id="transactional.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG3-TOT-AMO-FIG-CLM-INT.0">8706</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG3-TOT-AMO-FIG-CLM-INT.0">[FOR4.1] is valid only if this does not exceed [FOR4]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG3-TOT-AMO-FIG-CLM-INT.0">[FOR4.1] is valid only if this does not exceed [FOR4]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG3-TOT-AMO-FIG-CLM-INT.1">8707</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG3-TOT-AMO-FIG-CLM-INT.1">[FOR4.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG3-TOT-AMO-FIG-CLM-INT.1">[FOR4.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG3-TOT-AMO-FIG-CLM-INT.2">8708</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG3-TOT-AMO-FIG-CLM-INT.2">If [FOR4.1] present and equals [FOR4] then all iterations of [FOR4E] must not be 'Y'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG3-TOT-AMO-FIG-CLM-INT.2">If [FOR4.1] present and equals [FOR4] then all iterations of [FOR4E] must not be 'Y'</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-FOREIGN-DIVIDENDS.1">6138</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-FOREIGN-DIVIDENDS.1">The amount in box [FOR6F] must equal [FOR6B] if box [FOR6E] completed. If box [FOR6E] not completed,   [FOR6F] must equal [FOR6B] minus [FOR6C]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-FOREIGN-DIVIDENDS.1">The amount in box [FOR6F] must equal [FOR6B] if box [FOR6E] completed. If box [FOR6E] not completed,   [FOR6F] must equal [FOR6B] minus [FOR6C]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-FRGN-DIV-GROSS-INC-AMO.1">6139</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-FRGN-DIV-GROSS-INC-AMO.1">There is an entry in box [FOR6B]. Please complete box [FOR6F].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-FRGN-DIV-GROSS-INC-AMO.1">There is an entry in box [FOR6B]. Please complete box [FOR6F].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-DIVIDENDS-FRGN-TAX-AMO.1">6141</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-DIVIDENDS-FRGN-TAX-AMO.1">The amount in box [FOR6C] exceeds the amount in box [FOR6B]. Please check. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-DIVIDENDS-FRGN-TAX-AMO.1">The amount in box [FOR6C] exceeds the amount in box [FOR6B]. Please check. </sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-DIVIDENDS-UK-TAX-AMT.1">6143</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-DIVIDENDS-UK-TAX-AMT.1">The amount in box [FOR6D] exceeds the amount in box [FOR6B] when [FOR1] is not submitted. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-DIVIDENDS-UK-TAX-AMT.1">The amount in box [FOR6D] exceeds the amount in box [FOR6B] when [FOR1] is not submitted. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-DIVIDENDS-UK-TAX-AMT.2">6144</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-DIVIDENDS-UK-TAX-AMT.2">There is an entry in box [FOR6D]. Please complete box [FOR5].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-DIVIDENDS-UK-TAX-AMT.2">There is an entry in box [FOR6D]. Please complete box [FOR5].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-DIV-UK-CHARGEABLE-AMO.1">6145</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-DIV-UK-CHARGEABLE-AMO.1">There is an entry in box [FOR6F]. Please complete box [FOR6].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-DIV-UK-CHARGEABLE-AMO.1">There is an entry in box [FOR6F]. Please complete box [FOR6].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.0">6701</sch:diagnostic>
    <sch:diagnostic id="transactional.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.0">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.0">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</sch:diagnostic>
    <sch:diagnostic id="errorCode.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.0">6702</sch:diagnostic>
    <sch:diagnostic id="transactional.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.0">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.0">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG3-TOT-AMO-FIG-CLM-DIVS.0">8709</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG3-TOT-AMO-FIG-CLM-DIVS.0">[FOR6.1] must be less than or equal to [FOR6]. Please check</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG3-TOT-AMO-FIG-CLM-DIVS.0">[FOR6.1] must be less than or equal to [FOR6]. Please check</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG3-TOT-AMO-FIG-CLM-DIVS.1">8710</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG3-TOT-AMO-FIG-CLM-DIVS.1">[FOR6.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG3-TOT-AMO-FIG-CLM-DIVS.1">[FOR6.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG3-TOT-AMO-FIG-CLM-DIVS.2">8711</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG3-TOT-AMO-FIG-CLM-DIVS.2">If [FOR6.1] present and equals [FOR6] then all iterations of [FOR6E] must not be 'Y'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG3-TOT-AMO-FIG-CLM-DIVS.2">If [FOR6.1] present and equals [FOR6] then all iterations of [FOR6E] must not be 'Y'</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-REM-FOR-INC-GROSS-AMT.0">8712</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-REM-FOR-INC-GROSS-AMT.0">There is an entry in box [FOR7.2B]. Please complete box [FOR7.2F (pseudo)].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-REM-FOR-INC-GROSS-AMT.0">There is an entry in box [FOR7.2B]. Please complete box [FOR7.2F (pseudo)].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-REM-FOR-INC-FORGN-TAX-AMT.0">8713</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-REM-FOR-INC-FORGN-TAX-AMT.0">[FOR7.2C] is valid only if this does not exceed [FOR7.2B]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-REM-FOR-INC-FORGN-TAX-AMT.0">[FOR7.2C] is valid only if this does not exceed [FOR7.2B]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-REM-FOR-INC-TAX-ITEM-AMT.0">8714</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-REM-FOR-INC-TAX-ITEM-AMT.0">[FOR7.2D (pseudo)] is valid only if this does not exceed [FOR7.2B]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-REM-FOR-INC-TAX-ITEM-AMT.0">[FOR7.2D (pseudo)] is valid only if this does not exceed [FOR7.2B]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-REM-FOR-INC-TAX-ITEM-AMT.1">8715</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-REM-FOR-INC-TAX-ITEM-AMT.1">There is an entry in box [FOR7.2D (pseudo)]. Please complete box [FOR7.1].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-REM-FOR-INC-TAX-ITEM-AMT.1">There is an entry in box [FOR7.2D (pseudo)]. Please complete box [FOR7.1].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-REM-FOR-INC-UK-CHRG-AMT.3">8716</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-REM-FOR-INC-UK-CHRG-AMT.3">There is an entry in box [FOR7.2F (pseudo)]. Please complete box [FOR7.2].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-REM-FOR-INC-UK-CHRG-AMT.3">There is an entry in box [FOR7.2F (pseudo)]. Please complete box [FOR7.2].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-REM-FOR-INC-UK-CHRG-AMT.0">8717</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-REM-FOR-INC-UK-CHRG-AMT.0">[FOR7.2F (pseudo)] must be equal to [FOR7.2B] if [FOR7.2E] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-REM-FOR-INC-UK-CHRG-AMT.0">[FOR7.2F (pseudo)] must be equal to [FOR7.2B] if [FOR7.2E] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-REM-FOR-INC-UK-CHRG-AMT.2">8718</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-REM-FOR-INC-UK-CHRG-AMT.2">[FOR7.2F (pseudo)] must be equal to [FOR7.2B] - [FOR7.2C] if [FOR7.2E] is absent</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-REM-FOR-INC-UK-CHRG-AMT.2">[FOR7.2F (pseudo)] must be equal to [FOR7.2B] - [FOR7.2C] if [FOR7.2E] is absent</sch:diagnostic>
    <sch:diagnostic id="errorCode.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC2.1">6701</sch:diagnostic>
    <sch:diagnostic id="transactional.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC2.1">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC2.1">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</sch:diagnostic>
    <sch:diagnostic id="errorCode.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC2.1">6702</sch:diagnostic>
    <sch:diagnostic id="transactional.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC2.1">Must equal the sum of all occurrences of box 'TaxableAmount' within income sources.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC2.1">Must equal the sum of all occurrences of box 'TaxableAmount' within income sources.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-REMITTED-FORG-DIVIDENDS.0">6482</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-REMITTED-FORG-DIVIDENDS.0">[FOR7.4F (pseudo)] must be equal to [FOR7.4B] if [FOR7.4E] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-REMITTED-FORG-DIVIDENDS.0">[FOR7.4F (pseudo)] must be equal to [FOR7.4B] if [FOR7.4E] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-REMITTED-FORG-DIVIDENDS.1">6483</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-REMITTED-FORG-DIVIDENDS.1">[FOR7.4F (pseudo)] must be equal to [FOR7.4B] - [FOR7.4C] if [FOR7.4E] is absent</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-REMITTED-FORG-DIVIDENDS.1">[FOR7.4F (pseudo)] must be equal to [FOR7.4B] - [FOR7.4C] if [FOR7.4E] is absent</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-REM-DIV-GROSS-AMT.1">6484</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-REM-DIV-GROSS-AMT.1">There is an entry in box [FOR7.4B]. Please complete box [FOR7.4F (pseudo)].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-REM-DIV-GROSS-AMT.1">There is an entry in box [FOR7.4B]. Please complete box [FOR7.4F (pseudo)].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-REM-DIV-FOREIGN-TAX-AMT.1">6485</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-REM-DIV-FOREIGN-TAX-AMT.1">The amount in box [FOR7.4C] exceeds the amount in box [FOR7.4B]. Please check. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-REM-DIV-FOREIGN-TAX-AMT.1">The amount in box [FOR7.4C] exceeds the amount in box [FOR7.4B]. Please check. </sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-REM-DIV-TAX-ITEM-AMT.1">6486</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-REM-DIV-TAX-ITEM-AMT.1">The amount in box [FOR7.4D (pseudo)] exceeds the amount in box [FOR7.4B]. Please check. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-REM-DIV-TAX-ITEM-AMT.1">The amount in box [FOR7.4D (pseudo)] exceeds the amount in box [FOR7.4B]. Please check. </sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-REM-DIV-TAX-ITEM-AMT.2">6487</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-REM-DIV-TAX-ITEM-AMT.2">There is an entry in box [FOR7.4D (pseudo)]. Please complete box [FOR7.3].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-REM-DIV-TAX-ITEM-AMT.2">There is an entry in box [FOR7.4D (pseudo)]. Please complete box [FOR7.3].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-REM-DIV-UK-CHARGEABLE-AMO.1">6488</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-REM-DIV-UK-CHARGEABLE-AMO.1">There is an entry in box [FOR7.4F (pseudo)]. Please complete box [FOR7.4].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-REM-DIV-UK-CHARGEABLE-AMO.1">There is an entry in box [FOR7.4F (pseudo)]. Please complete box [FOR7.4].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC2.1.0">6701</sch:diagnostic>
    <sch:diagnostic id="transactional.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC2.1.0">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC2.1.0">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</sch:diagnostic>
    <sch:diagnostic id="errorCode.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC2.1.0">6702</sch:diagnostic>
    <sch:diagnostic id="transactional.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC2.1.0">Must equal the sum of all occurrences of box 'TaxableAmount' within income sources.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC2.1.0">Must equal the sum of all occurrences of box 'TaxableAmount' within income sources.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-REM-DIV-CHRG-AMO-SUB-DTC.1">6489</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-REM-DIV-CHRG-AMO-SUB-DTC.1">The amount in box [FOR7.5] exceeds the amount in box [FOR7.4]. Please check. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-REM-DIV-CHRG-AMO-SUB-DTC.1">The amount in box [FOR7.5] exceeds the amount in box [FOR7.4]. Please check. </sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-PENSIONS-GROSS-AMT.1">6150</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-PENSIONS-GROSS-AMT.1">There is an entry in box [FOR9B]. Please complete box [FOR9F (pseudo)].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-PENSIONS-GROSS-AMT.1">There is an entry in box [FOR9B]. Please complete box [FOR9F (pseudo)].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-PENSIONS-FOREIGN-TAX-AMT.1">6151</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-PENSIONS-FOREIGN-TAX-AMT.1">The amount in box [FOR9C] exceeds the amount in box [FOR9B]. Please check. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-PENSIONS-FOREIGN-TAX-AMT.1">The amount in box [FOR9C] exceeds the amount in box [FOR9B]. Please check. </sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-PENSIONS-UK-TAX-ITEM-AMT.1">6152</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-PENSIONS-UK-TAX-ITEM-AMT.1">The amount in box [FOR9D (pseudo)] exceeds the amount in box [FOR9B] when [FOR1] is not submitted. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-PENSIONS-UK-TAX-ITEM-AMT.1">The amount in box [FOR9D (pseudo)] exceeds the amount in box [FOR9B] when [FOR1] is not submitted. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-PENSIONS-UK-TAX-ITEM-AMT.2">6153</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-PENSIONS-UK-TAX-ITEM-AMT.2">There is an entry in box [FOR9D (pseudo)]. Please complete box [FOR8].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-PENSIONS-UK-TAX-ITEM-AMT.2">There is an entry in box [FOR9D (pseudo)]. Please complete box [FOR8].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-PENSIONS-CHARGEABLE-AMT.1">6154</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-PENSIONS-CHARGEABLE-AMT.1">There is an entry in box [FOR9F (pseudo)]. Please complete box [FOR9].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-PENSIONS-CHARGEABLE-AMT.1">There is an entry in box [FOR9F (pseudo)]. Please complete box [FOR9].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.1">6701</sch:diagnostic>
    <sch:diagnostic id="transactional.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.1">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.1">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</sch:diagnostic>
    <sch:diagnostic id="errorCode.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.1">6702</sch:diagnostic>
    <sch:diagnostic id="transactional.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.1">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.1">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG3-TOT-AMO-FIG-CLM-PENS.1">8719</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG3-TOT-AMO-FIG-CLM-PENS.1">[FOR9.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG3-TOT-AMO-FIG-CLM-PENS.1">[FOR9.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG3-TOT-AMO-FIG-CLM-PENS.0">8720</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG3-TOT-AMO-FIG-CLM-PENS.0">[FOR9.1] is valid only if this does not exceed [FOR9]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG3-TOT-AMO-FIG-CLM-PENS.0">[FOR9.1] is valid only if this does not exceed [FOR9]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG3-TOT-AMO-FIG-CLM-PENS.2">8721</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG3-TOT-AMO-FIG-CLM-PENS.2">If [FOR9.1] is present and equal to [FOR9] then all iterations of [FOR9E] must not be 'Y'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG3-TOT-AMO-FIG-CLM-PENS.2">If [FOR9.1] is present and equal to [FOR9] then all iterations of [FOR9E] must not be 'Y'</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-FOREIGN-SAVINGS.1">6155</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-FOREIGN-SAVINGS.1">The amount in box [FOR11F (psuedo)] must equal [FOR11B] if box [FOR11E] completed. If box [FOR11E] not completed,   [FOR11F (psuedo)] must equal [FOR11B] minus [FOR11C]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-FOREIGN-SAVINGS.1">The amount in box [FOR11F (psuedo)] must equal [FOR11B] if box [FOR11E] completed. If box [FOR11E] not completed,   [FOR11F (psuedo)] must equal [FOR11B] minus [FOR11C]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-INTEREST-GROSS-INCOME-AMO.1">6156</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-INTEREST-GROSS-INCOME-AMO.1">There is an entry in box [FOR11B]. Please complete box [FOR11F (psuedo)].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-INTEREST-GROSS-INCOME-AMO.1">There is an entry in box [FOR11B]. Please complete box [FOR11F (psuedo)].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-INTEREST-FOREIGN-TAX-AMO.1">6157</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-INTEREST-FOREIGN-TAX-AMO.1">The amount in box [FOR11C] exceeds the amount in box [FOR11B]. Please check. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-INTEREST-FOREIGN-TAX-AMO.1">The amount in box [FOR11C] exceeds the amount in box [FOR11B]. Please check. </sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-INTEREST-UK-TAX-ITEM-AMT.1">6159</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-INTEREST-UK-TAX-ITEM-AMT.1">The amount in box [FOR11D (pseudo)] exceeds the amount in box [FOR11B] when [FOR1] is not submitted. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-INTEREST-UK-TAX-ITEM-AMT.1">The amount in box [FOR11D (pseudo)] exceeds the amount in box [FOR11B] when [FOR1] is not submitted. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-INTEREST-UK-TAX-ITEM-AMT.2">6160</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-INTEREST-UK-TAX-ITEM-AMT.2">There is an entry in box [FOR11D (pseudo)]. Please complete box [FOR10].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-INTEREST-UK-TAX-ITEM-AMT.2">There is an entry in box [FOR11D (pseudo)]. Please complete box [FOR10].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-FRGN-INT-UK-CHRGBLE-AMO.1">6161</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-FRGN-INT-UK-CHRGBLE-AMO.1">There is an entry in box [FOR11F (psuedo)]. Please complete box [FOR11].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-FRGN-INT-UK-CHRGBLE-AMO.1">There is an entry in box [FOR11F (psuedo)]. Please complete box [FOR11].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.2">6701</sch:diagnostic>
    <sch:diagnostic id="transactional.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.2">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.2">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</sch:diagnostic>
    <sch:diagnostic id="errorCode.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.2">6702</sch:diagnostic>
    <sch:diagnostic id="transactional.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.2">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.2">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG2-TOT-AMO-FIG-CLM-OT.0">8722</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG2-TOT-AMO-FIG-CLM-OT.0">[FOR11.1] is valid only if this does not exceed [FOR11]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG2-TOT-AMO-FIG-CLM-OT.0">[FOR11.1] is valid only if this does not exceed [FOR11]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG2-TOT-AMO-FIG-CLM-OT.2">8723</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG2-TOT-AMO-FIG-CLM-OT.2">If [FOR11.1] is present and equal to [FOR11] then all iterations of [FOR11E] must not be 'Y'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG2-TOT-AMO-FIG-CLM-OT.2">If [FOR11.1] is present and equal to [FOR11] then all iterations of [FOR11E] must not be 'Y'</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG2-TOT-AMO-FIG-CLM-OT.1">8724</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG2-TOT-AMO-FIG-CLM-OT.1">[FOR11.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG2-TOT-AMO-FIG-CLM-OT.1">[FOR11.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-OTCOE-INCOME.1">6162</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-OTCOE-INCOME.1">The amount in box [FOR13F (psuedo)] must equal [FOR13B] if box [FOR13E] completed. If box [FOR13E] not completed,   [FOR13F (psuedo)] must equal [FOR13B] minus [FOR13C]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-OTCOE-INCOME.1">The amount in box [FOR13F (psuedo)] must equal [FOR13B] if box [FOR13E] completed. If box [FOR13E] not completed,   [FOR13F (psuedo)] must equal [FOR13B] minus [FOR13C]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-DIV-OTCOE-SAV-GROSS-AMO.1">6164</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-DIV-OTCOE-SAV-GROSS-AMO.1">There is an entry in box [FOR13B]. Please complete box [FOR13F (psuedo)].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-DIV-OTCOE-SAV-GROSS-AMO.1">There is an entry in box [FOR13B]. Please complete box [FOR13F (psuedo)].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-DIV-OTCOE-SAV-FOR-TAX-AMO.1">6165</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-DIV-OTCOE-SAV-FOR-TAX-AMO.1">The amount in box [FOR13C] exceeds the amount in box [FOR13B]. Please check. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-DIV-OTCOE-SAV-FOR-TAX-AMO.1">The amount in box [FOR13C] exceeds the amount in box [FOR13B]. Please check. </sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-DIV-OTCOE-SAV-UK-TAX-AMO.1">6166</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-DIV-OTCOE-SAV-UK-TAX-AMO.1">The amount in box [FOR13D (psuedo)] exceeds the amount in box [FOR13B] when [FOR1] is not submitted. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-DIV-OTCOE-SAV-UK-TAX-AMO.1">The amount in box [FOR13D (psuedo)] exceeds the amount in box [FOR13B] when [FOR1] is not submitted. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-DIV-OTCOE-SAV-UK-TAX-AMO.2">6167</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-DIV-OTCOE-SAV-UK-TAX-AMO.2">There is an entry in box [FOR13D (psuedo)]. Please complete box [FOR12].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-DIV-OTCOE-SAV-UK-TAX-AMO.2">There is an entry in box [FOR13D (psuedo)]. Please complete box [FOR12].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-DIV-OTCOE-SAV-UK-CHRG-AMO.1">6168</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-DIV-OTCOE-SAV-UK-CHRG-AMO.1">There is an entry in box [FOR13F (psuedo)]. Please complete box [FOR13].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-DIV-OTCOE-SAV-UK-CHRG-AMO.1">There is an entry in box [FOR13F (psuedo)]. Please complete box [FOR13].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.3">6701</sch:diagnostic>
    <sch:diagnostic id="transactional.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.3">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.3">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</sch:diagnostic>
    <sch:diagnostic id="errorCode.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.3">6702</sch:diagnostic>
    <sch:diagnostic id="transactional.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.3">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.3">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG3-TOT-AMO-FIG-CLM-OTCOE.0">8725</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG3-TOT-AMO-FIG-CLM-OTCOE.0">[FOR13.0] is valid only if this does not exceed [FOR13]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG3-TOT-AMO-FIG-CLM-OTCOE.0">[FOR13.0] is valid only if this does not exceed [FOR13]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG3-TOT-AMO-FIG-CLM-OTCOE.1">8726</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG3-TOT-AMO-FIG-CLM-OTCOE.1">[FOR13.0] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG3-TOT-AMO-FIG-CLM-OTCOE.1">[FOR13.0] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG3-TOT-AMO-FIG-CLM-OTCOE.2">8727</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG3-TOT-AMO-FIG-CLM-OTCOE.2">If [FOR13.0] is present and equal to [FOR13] then all iterations of [FOR13E] must not be 'Y'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG3-TOT-AMO-FIG-CLM-OTCOE.2">If [FOR13.0] is present and equal to [FOR13] then all iterations of [FOR13E] must not be 'Y'</sch:diagnostic>
    <sch:diagnostic id="errorCode.RES-PPTY-INC-OR-REST-FIN.1">8445</sch:diagnostic>
    <sch:diagnostic id="transactional.RES-PPTY-INC-OR-REST-FIN.1">There is an entry in box [FOR13.1] please complete [FOR13] </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RES-PPTY-INC-OR-REST-FIN.1">There is an entry in box [FOR13.1] please complete [FOR13] </sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-INCOME-LET-PROPERTY.0">8538</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-INCOME-LET-PROPERTY.0">Within each [FOR14-FOR24.2 / FOR30A-FOR30F], the total of [FOR14], [FOR16] and [FOR20] must not exceed [£150,000] if there is no entry in [FOR14.2] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-INCOME-LET-PROPERTY.0">Within each [FOR14-FOR24.2 / FOR30A-FOR30F], the total of [FOR14], [FOR16] and [FOR20] must not exceed [£150,000] if there is no entry in [FOR14.2] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-PROPERTY-INCOME-AMO.1">6586</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-PROPERTY-INCOME-AMO.1">Box [FOR15] must be present if [FOR14] is present. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-PROPERTY-INCOME-AMO.1">Box [FOR15] must be present if [FOR14] is present. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-PROPERTY-INCOME-ALLOWANCE.0">8540</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-PROPERTY-INCOME-ALLOWANCE.0">There is an entry in [FOR14.1]. Please complete [FOR24].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-PROPERTY-INCOME-ALLOWANCE.0">There is an entry in [FOR14.1]. Please complete [FOR24].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-PROPERTY-TOTAL-EXP-AMO.0">8541</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-PROPERTY-TOTAL-EXP-AMO.0">The entry in box [FOR17] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-PROPERTY-TOTAL-EXP-AMO.0">The entry in box [FOR17] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-PROPERTY-NET-PROFIT-AMO.1">6703</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-PROPERTY-NET-PROFIT-AMO.1">The amount in box [FOR18] must equal ( ( [FOR14] plus [FOR16] ) minus [FOR17] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-PROPERTY-NET-PROFIT-AMO.1">The amount in box [FOR18] must equal ( ( [FOR14] plus [FOR16] ) minus [FOR17] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-PROPERTY-NET-PROFIT-AMO.2">8358</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-PROPERTY-NET-PROFIT-AMO.2">There is an entry in [FOR18]. Please complete [FOR24].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-PROPERTY-NET-PROFIT-AMO.2">There is an entry in [FOR18]. Please complete [FOR24].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-PPTY-ADJUST-PERSNL-AMO.1">6860</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-PPTY-ADJUST-PERSNL-AMO.1">The amount in box [FOR19] exceeds the amount in box [FOR17]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-PPTY-ADJUST-PERSNL-AMO.1">The amount in box [FOR19] exceeds the amount in box [FOR17]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-PPTY-ADJUST-PERSNL-AMO.2">8359</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-PPTY-ADJUST-PERSNL-AMO.2">There is an entry in [FOR19]. Please complete [FOR24].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-PPTY-ADJUST-PERSNL-AMO.2">There is an entry in [FOR19]. Please complete [FOR24].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-PPTY-ADJUST-PERSNL-AMO.0">8542</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-PPTY-ADJUST-PERSNL-AMO.0">The entry in box [FOR19] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-PPTY-ADJUST-PERSNL-AMO.0">The entry in box [FOR19] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-PROPERTY-BC-AMO.1">8360</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-PROPERTY-BC-AMO.1">There is an entry in [FOR20]. Please complete [FOR24]. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-PROPERTY-BC-AMO.1">There is an entry in [FOR20]. Please complete [FOR24]. </sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-PROPERTY-CAP-AMO.1">8361</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-PROPERTY-CAP-AMO.1">There is an entry in [FOR21]. Please complete [FOR24]. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-PROPERTY-CAP-AMO.1">There is an entry in [FOR21]. Please complete [FOR24]. </sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-PROPERTY-CAP-AMO.0">8543</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-PROPERTY-CAP-AMO.0">The entry in box [FOR21] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-PROPERTY-CAP-AMO.0">The entry in box [FOR21] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-ZERO-EMISSION-CAR-ALLCE.1">8555</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-ZERO-EMISSION-CAR-ALLCE.1">There is an entry in [FOR21.1]. Please complete [FOR24].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-ZERO-EMISSION-CAR-ALLCE.1">There is an entry in [FOR21.1]. Please complete [FOR24].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-ZERO-EMISSION-CAR-ALLCE.0">8551</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-ZERO-EMISSION-CAR-ALLCE.0">The entry in box [FOR21.1] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-ZERO-EMISSION-CAR-ALLCE.0">The entry in box [FOR21.1] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-SB-ALLCE.0">8597</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-SB-ALLCE.0">The entry in box [FOR22.1] should not be present as there is an entry in [PRO20.1] or [FOR14.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-SB-ALLCE.0">The entry in box [FOR22.1] should not be present as there is an entry in [PRO20.1] or [FOR14.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-SB-ALLCE.1">8598</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-SB-ALLCE.1">There is an entry in [FOR22.1]. Please complete [FOR24].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-SB-ALLCE.1">There is an entry in [FOR22.1]. Please complete [FOR24].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-ECP-ALLCE.0">8599</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-ECP-ALLCE.0">The entry in box [FOR22.2] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-ECP-ALLCE.0">The entry in box [FOR22.2] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-ECP-ALLCE.1">8600</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-ECP-ALLCE.1">There is an entry in [FOR22.2]. Please complete [FOR24].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-ECP-ALLCE.1">There is an entry in [FOR22.2]. Please complete [FOR24].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-PROPERTY-WEAR-TEAR-AMO.1">8362</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-PROPERTY-WEAR-TEAR-AMO.1">There is an entry in [FOR23]. Please complete [FOR24].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-PROPERTY-WEAR-TEAR-AMO.1">There is an entry in [FOR23]. Please complete [FOR24].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-PROPERTY-WEAR-TEAR-AMO.0">8545</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-PROPERTY-WEAR-TEAR-AMO.0">The entry in box [FOR23] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-PROPERTY-WEAR-TEAR-AMO.0">The entry in box [FOR23] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-PPTY-ADJUSTD-PROF-LOSS-AMT.1">8546</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-PPTY-ADJUSTD-PROF-LOSS-AMT.1">If [FOR14.1] is present then [FOR24] must not be negative</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-PPTY-ADJUSTD-PROF-LOSS-AMT.1">If [FOR14.1] is present then [FOR24] must not be negative</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-PPTY-ADJUSTD-PROF-LOSS-AMT.0">6718</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-PPTY-ADJUSTD-PROF-LOSS-AMT.0">[FOR24] is valid only if this equals ( ( The sum of [FOR18], [FOR19], and [FOR20] ) minus ( The sum of [FOR14.1], [FOR21], [FOR21.1], [FOR22.1], [FOR22.2], and [FOR23] ) )</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-PPTY-ADJUSTD-PROF-LOSS-AMT.0">[FOR24] is valid only if this equals ( ( The sum of [FOR18], [FOR19], and [FOR20] ) minus ( The sum of [FOR14.1], [FOR21], [FOR21.1], [FOR22.1], [FOR22.2], and [FOR23] ) )</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-PPTY-RES-FIN-COSTS.2">8547</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-PPTY-RES-FIN-COSTS.2">The entry in box [FOR24.1] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-PPTY-RES-FIN-COSTS.2">The entry in box [FOR24.1] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-LET-PPTY-RES-FIN-COSTS-BF.0">8601</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-LET-PPTY-RES-FIN-COSTS-BF.0">The entry in box [FOR24.2] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-LET-PPTY-RES-FIN-COSTS-BF.0">The entry in box [FOR24.2] should not be present as there is an entry in [PRO20.1] or [FOR14.1] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-LET-PPTY-PROFIT-AMO.0">6272</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-LET-PPTY-PROFIT-AMO.0">The amount in box [FOR30B] exceeds 0. Please complete box [FOR25].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-LET-PPTY-PROFIT-AMO.0">The amount in box [FOR30B] exceeds 0. Please complete box [FOR25].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-LET-PPTY-PROFIT-TOT.0">8548</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-LET-PPTY-PROFIT-TOT.0">If a [FOR14.1] is present then [FOR25] must not be negative</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-LET-PPTY-PROFIT-TOT.0">If a [FOR14.1] is present then [FOR25] must not be negative</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-LET-PPTY-PROFIT-TOT.1">6719</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-LET-PPTY-PROFIT-TOT.1">Must equal the sum of all occurrences of box [FOR30B].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-LET-PPTY-PROFIT-TOT.1">Must equal the sum of all occurrences of box [FOR30B].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-LET-PPTY-TAXABLE-TOT.1">6507</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-LET-PPTY-TAXABLE-TOT.1">The amount in box [FOR27] must equal [FOR25] minus [FOR26] if this is positive or zero, or [FOR27] must be absent or zero. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-LET-PPTY-TAXABLE-TOT.1">The amount in box [FOR27] must equal [FOR25] minus [FOR26] if this is positive or zero, or [FOR27] must be absent or zero. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-LET-PPTY-FOREIGN-TAX-TOT.1">6720</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-LET-PPTY-FOREIGN-TAX-TOT.1">Must equal the sum of all occurrences of box [FOR30C].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-LET-PPTY-FOREIGN-TAX-TOT.1">Must equal the sum of all occurrences of box [FOR30C].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-LET-PPTY-TOT-WHOLD-TAX-AMT.1">6721</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-LET-PPTY-TOT-WHOLD-TAX-AMT.1">Must equal the sum of all occurrences of box [FOR30D].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-LET-PPTY-TOT-WHOLD-TAX-AMT.1">Must equal the sum of all occurrences of box [FOR30D].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-LET-PPTY-TOT-AMO-FIG-CLM.0">8728</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-LET-PPTY-TOT-AMO-FIG-CLM.0">[FOR30.1] is valid only if this does not exceed [FOR30]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-LET-PPTY-TOT-AMO-FIG-CLM.0">[FOR30.1] is valid only if this does not exceed [FOR30]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-LET-PPTY-TOT-AMO-FIG-CLM.1">8729</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-LET-PPTY-TOT-AMO-FIG-CLM.1">[FOR30.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-LET-PPTY-TOT-AMO-FIG-CLM.1">[FOR30.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-LET-PPTY-TOT-AMO-FIG-CLM.2">8730</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-LET-PPTY-TOT-AMO-FIG-CLM.2">If [FOR30.1] is present and equal to [FOR30] then all iterations of [FOR30E] must not be 'Y'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-LET-PPTY-TOT-AMO-FIG-CLM.2">If [FOR30.1] is present and equal to [FOR30] then all iterations of [FOR30E] must not be 'Y'</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-MLOFFSET-ON-INC-AMT.0">8549</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-MLOFFSET-ON-INC-AMT.0">As [FOR14.1] is present you cannot have an entry in [FOR31] Please check</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-MLOFFSET-ON-INC-AMT.0">As [FOR14.1] is present you cannot have an entry in [FOR31] Please check</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-MLOFFSET-ON-INC-AMT.1">8550</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-MLOFFSET-ON-INC-AMT.1">You cannot have an entry in [FOR31] as there is no entry in  [FOR14.2] Please check</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-MLOFFSET-ON-INC-AMT.1">You cannot have an entry in [FOR31] as there is no entry in  [FOR14.2] Please check</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-LET-PPTY-LOSS-CF-AMO.0">8731</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-LET-PPTY-LOSS-CF-AMO.0">If [NRD28] or [NRD29] or [NRD41] are 'Y' and [FOR25] is less than zero and [FOR26] is present (greater than zero) then, if [FOR32] is present (greater than zero) it must equal [FOR26]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-LET-PPTY-LOSS-CF-AMO.0">If [NRD28] or [NRD29] or [NRD41] are 'Y' and [FOR25] is less than zero and [FOR26] is present (greater than zero) then, if [FOR32] is present (greater than zero) it must equal [FOR26]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-LET-PPTY-LOSS-CF-AMO.1">8732</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-LET-PPTY-LOSS-CF-AMO.1">If [NRD28] or [NRD29] or [NRD41] are 'Y' and [FOR25] is equal to or greater than zero and [FOR26] and [FOR27] are present (greater than zero) then [FOR32] must be zero or absent</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-LET-PPTY-LOSS-CF-AMO.1">If [NRD28] or [NRD29] or [NRD41] are 'Y' and [FOR25] is equal to or greater than zero and [FOR26] and [FOR27] are present (greater than zero) then [FOR32] must be zero or absent</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-CRED-RLF-SAV-FRGN-TAX-AMO.0">6273</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-CRED-RLF-SAV-FRGN-TAX-AMO.0">There is an entry in box [FORC]. Please complete box [FORF].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-CRED-RLF-SAV-FRGN-TAX-AMO.0">There is an entry in box [FORC]. Please complete box [FORF].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG4-CRED-RLF-SAV-UK-CHRG-AMO.1">6858</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG4-CRED-RLF-SAV-UK-CHRG-AMO.1">The amount in box [FORF] must exceed [FORC]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG4-CRED-RLF-SAV-UK-CHRG-AMO.1">The amount in box [FORF] must exceed [FORC]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-YEARS-ON-FOREIGN-CE-GAINS.1">6135</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-YEARS-ON-FOREIGN-CE-GAINS.1">Number of years entered in box [FOR44] but no gain in box [FOR43]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-YEARS-ON-FOREIGN-CE-GAINS.1">Number of years entered in box [FOR44] but no gain in box [FOR43]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-NOTNAL-IT-FOREIGN-CE-GAINS.1">6136</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-NOTNAL-IT-FOREIGN-CE-GAINS.1">The amount in box [FOR45] must be less than the amount in box [FOR43]. Please amend the entry.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-NOTNAL-IT-FOREIGN-CE-GAINS.1">The amount in box [FOR45] must be less than the amount in box [FOR43]. Please amend the entry.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-NS-NRSIT-GROSS-AMO.1">8733</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-NS-NRSIT-GROSS-AMO.1">There is an entry in box [FOR48B]. Please complete box [FOR48F (pseudo)].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-NS-NRSIT-GROSS-AMO.1">There is an entry in box [FOR48B]. Please complete box [FOR48F (pseudo)].</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-NS-NRSIT-FOR-TAX-AMO.0">8734</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-NS-NRSIT-FOR-TAX-AMO.0">[FOR48C] is valid only if this does not exceed [FOR48B]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-NS-NRSIT-FOR-TAX-AMO.0">[FOR48C] is valid only if this does not exceed [FOR48B]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-NS-NRSIT-UK-TAX-AMO.0">8735</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-NS-NRSIT-UK-TAX-AMO.0">If [FOR1] is not 'Y' then [FOR48D (pseudo)] must be less than or equal to [FOR48B]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-NS-NRSIT-UK-TAX-AMO.0">If [FOR1] is not 'Y' then [FOR48D (pseudo)] must be less than or equal to [FOR48B]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-NS-NRSIT-UK-TAX-AMO.1">8736</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-NS-NRSIT-UK-TAX-AMO.1">[FOR47] must be present if [FOR48D (pseudo)] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-NS-NRSIT-UK-TAX-AMO.1">[FOR47] must be present if [FOR48D (pseudo)] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-NS-NRSIT-UK-CHRG-AMO.0">8737</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-NS-NRSIT-UK-CHRG-AMO.0">If [FOR48E] is 'Y' then [FOR48F (pseudo)] must eq [FOR48B]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-NS-NRSIT-UK-CHRG-AMO.0">If [FOR48E] is 'Y' then [FOR48F (pseudo)] must eq [FOR48B]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-NS-NRSIT-UK-CHRG-AMO.1">8738</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-NS-NRSIT-UK-CHRG-AMO.1">If [FOR48E] is not 'Y' then [FOR48F (pseudo)] must eq [FOR48B] minus [FOR48C]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-NS-NRSIT-UK-CHRG-AMO.1">If [FOR48E] is not 'Y' then [FOR48F (pseudo)] must eq [FOR48B] minus [FOR48C]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-NS-NRSIT-UK-CHRG-AMO.2">8739</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-NS-NRSIT-UK-CHRG-AMO.2">[FOR48] must be present if [FOR48F (pseudo)] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-NS-NRSIT-UK-CHRG-AMO.2">[FOR48] must be present if [FOR48F (pseudo)] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.4">6701</sch:diagnostic>
    <sch:diagnostic id="transactional.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.4">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.4">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</sch:diagnostic>
    <sch:diagnostic id="errorCode.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.4">6702</sch:diagnostic>
    <sch:diagnostic id="transactional.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.4">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.4">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-NS-NRSIT-TOT-AMO-FIG-CLM.0">8740</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-NS-NRSIT-TOT-AMO-FIG-CLM.0">[FOR48.1] is valid only if this does not exceed [FOR48]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-NS-NRSIT-TOT-AMO-FIG-CLM.0">[FOR48.1] is valid only if this does not exceed [FOR48]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-NS-NRSIT-TOT-AMO-FIG-CLM.1">8741</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-NS-NRSIT-TOT-AMO-FIG-CLM.1">[FOR48.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-NS-NRSIT-TOT-AMO-FIG-CLM.1">[FOR48.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-NS-NRSIT-TOT-AMO-FIG-CLM.2">8742</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-NS-NRSIT-TOT-AMO-FIG-CLM.2">If [FOR48.1] is present and equal to [FOR48] then all iterations of [FOR48E] must not be 'Y'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-NS-NRSIT-TOT-AMO-FIG-CLM.2">If [FOR48.1] is present and equal to [FOR48] then all iterations of [FOR48E] must not be 'Y'</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-ORPROP-FIN-COST-NRT.0">8743</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-ORPROP-FIN-COST-NRT.0">[FOR49] is present so the following should be true: [FOR48] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-ORPROP-FIN-COST-NRT.0">[FOR49] is present so the following should be true: [FOR48] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-SAV-NRSIT-GROSS-AMO.0">8744</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-SAV-NRSIT-GROSS-AMO.0">[FOR51F (pseudo)] must be present if [FOR51B] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-SAV-NRSIT-GROSS-AMO.0">[FOR51F (pseudo)] must be present if [FOR51B] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-SAV-NRSIT-FOR-TAX-AMO.0">8745</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-SAV-NRSIT-FOR-TAX-AMO.0">[FOR51C] is valid only if this does not exceed [FOR51B]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-SAV-NRSIT-FOR-TAX-AMO.0">[FOR51C] is valid only if this does not exceed [FOR51B]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-SAV-NRSIT-UK-TAX-AMO.0">8746</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-SAV-NRSIT-UK-TAX-AMO.0">[FOR50] must be present if [FOR51D (pseudo)] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-SAV-NRSIT-UK-TAX-AMO.0">[FOR50] must be present if [FOR51D (pseudo)] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-SAV-NRSIT-UK-TAX-AMO.1">8747</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-SAV-NRSIT-UK-TAX-AMO.1">If [FOR1] is not 'Y' then, if present, [FOR51D (pseudo)] must be less than or equal to [FOR51B]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-SAV-NRSIT-UK-TAX-AMO.1">If [FOR1] is not 'Y' then, if present, [FOR51D (pseudo)] must be less than or equal to [FOR51B]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-SAV-NRSIT-UK-CHRG-AMO.0">8748</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-SAV-NRSIT-UK-CHRG-AMO.0">[FOR51] must be present if [FOR51F (pseudo)] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-SAV-NRSIT-UK-CHRG-AMO.0">[FOR51] must be present if [FOR51F (pseudo)] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-SAV-NRSIT-UK-CHRG-AMO.1">8749</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-SAV-NRSIT-UK-CHRG-AMO.1">If [FOR51E] is 'Y' then [FOR51F (pseudo)] must eq [FOR51B]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-SAV-NRSIT-UK-CHRG-AMO.1">If [FOR51E] is 'Y' then [FOR51F (pseudo)] must eq [FOR51B]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-SAV-NRSIT-UK-CHRG-AMO.2">8750</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-SAV-NRSIT-UK-CHRG-AMO.2">If [FOR51E] is not 'Y' then [FOR51F (pseudo)] must eq [FOR51B] minus [FOR51C]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-SAV-NRSIT-UK-CHRG-AMO.2">If [FOR51E] is not 'Y' then [FOR51F (pseudo)] must eq [FOR51B] minus [FOR51C]</sch:diagnostic>
    <sch:diagnostic id="errorCode.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.5">6701</sch:diagnostic>
    <sch:diagnostic id="transactional.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.5">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.5">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</sch:diagnostic>
    <sch:diagnostic id="errorCode.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.5">6702</sch:diagnostic>
    <sch:diagnostic id="transactional.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.5">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.5">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.0">8751</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.0">[FOR51.1] is valid only if this does not exceed [FOR51]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.0">[FOR51.1] is valid only if this does not exceed [FOR51]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.1">8752</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.1">[FOR51.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.1">[FOR51.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.2">8753</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.2">If [FOR51.1] is present and equal to [FOR51] then all iterations of [FOR51E] must not be 'Y'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-SAV-NRSIT-TOT-AMO-FIG-CLM.2">If [FOR51.1] is present and equal to [FOR51] then all iterations of [FOR51E] must not be 'Y'</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-DIV-NRSIT-GROSS-AMO.0">8754</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-DIV-NRSIT-GROSS-AMO.0">[FOR53F (pseudo)] must be present if [FOR53B] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-DIV-NRSIT-GROSS-AMO.0">[FOR53F (pseudo)] must be present if [FOR53B] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-DIV-NRSIT-FOR-TAX-AMO.0">8755</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-DIV-NRSIT-FOR-TAX-AMO.0">[FOR53C] is valid only if this does not exceed [FOR53B]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-DIV-NRSIT-FOR-TAX-AMO.0">[FOR53C] is valid only if this does not exceed [FOR53B]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-DIV-NRSIT-UK-TAX-AMO.0">8756</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-DIV-NRSIT-UK-TAX-AMO.0">[FOR52] must be present if [FOR53D (pseudo)] is present. Please check</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-DIV-NRSIT-UK-TAX-AMO.0">[FOR52] must be present if [FOR53D (pseudo)] is present. Please check</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-DIV-NRSIT-UK-TAX-AMO.1">8757</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-DIV-NRSIT-UK-TAX-AMO.1">If [FOR1] is not 'Y' then, if present, [FOR53D (pseudo)] must be less than or equal to [FOR53B]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-DIV-NRSIT-UK-TAX-AMO.1">If [FOR1] is not 'Y' then, if present, [FOR53D (pseudo)] must be less than or equal to [FOR53B]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-DIV-NRSIT-UK-CHRG-AMO.0">8758</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-DIV-NRSIT-UK-CHRG-AMO.0">[FOR53] must be present if [FOR53F (pseudo)] is present. Please check</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-DIV-NRSIT-UK-CHRG-AMO.0">[FOR53] must be present if [FOR53F (pseudo)] is present. Please check</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-DIV-NRSIT-UK-CHRG-AMO.1">8759</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-DIV-NRSIT-UK-CHRG-AMO.1">If [FOR53E] is 'Y' then [FOR53F (pseudo)] must eq [FOR53B]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-DIV-NRSIT-UK-CHRG-AMO.1">If [FOR53E] is 'Y' then [FOR53F (pseudo)] must eq [FOR53B]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-DIV-NRSIT-UK-CHRG-AMO.2">8760</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-DIV-NRSIT-UK-CHRG-AMO.2">If [FOR53E] is not 'Y' then [FOR53F (pseudo)] must eq [FOR53B] minus [FOR53C]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-DIV-NRSIT-UK-CHRG-AMO.2">If [FOR53E] is not 'Y' then [FOR53F (pseudo)] must eq [FOR53B] minus [FOR53C]</sch:diagnostic>
    <sch:diagnostic id="errorCode.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.6">6701</sch:diagnostic>
    <sch:diagnostic id="transactional.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.6">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SWT-OR-UK-TAX-FOREIGN-INTEREST-ETC.1.6">Must equal the sum of all occurrences of box 'SpecialWithholdingTax'.</sch:diagnostic>
    <sch:diagnostic id="errorCode.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.6">6702</sch:diagnostic>
    <sch:diagnostic id="transactional.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.6">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.TAXABLE-AMOUNT-FOREIGN-INTEREST-ETC.1.6">Must equal the sum of all occurrences of box 'TaxableAmountOnInterestAndOtherSavings'.</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.0">8761</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.0">[FOR53.1] is valid only if this does not exceed [FOR53]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.0">[FOR53.1] is valid only if this does not exceed [FOR53]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.1">8762</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.1">[FOR53.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.1">[FOR53.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.2">8763</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.2">If [FOR53.1] is present and equal to [FOR53] then all iterations of [FOR53E] must not be 'Y'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-DIV-NRSIT-TOT-AMO-FIG-CLM.2">If [FOR53.1] is present and equal to [FOR53] then all iterations of [FOR53E] must not be 'Y'</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-DI-NSINRT-FIG-CLM.0">8764</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-DI-NSINRT-FIG-CLM.0">[FOR54.1] is valid only if this does not exceed [FOR54]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-DI-NSINRT-FIG-CLM.0">[FOR54.1] is valid only if this does not exceed [FOR54]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-DI-NSINRT-FIG-CLM.1">8765</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-DI-NSINRT-FIG-CLM.1">[FOR54.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-DI-NSINRT-FIG-CLM.1">[FOR54.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-CS-TRSTS-NR-SETT-FIG-CLM.0">8766</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-CS-TRSTS-NR-SETT-FIG-CLM.0">[FOR55.1] is valid only if this does not exceed [FOR55]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-CS-TRSTS-NR-SETT-FIG-CLM.0">[FOR55.1] is valid only if this does not exceed [FOR55]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-CS-TRSTS-NR-SETT-FIG-CLM.1">8767</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-CS-TRSTS-NR-SETT-FIG-CLM.1">[FOR55.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-CS-TRSTS-NR-SETT-FIG-CLM.1">[FOR55.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-GOD-HOLD-OFF-FIG-CLM.0">8768</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-GOD-HOLD-OFF-FIG-CLM.0">[FOR56.1] is valid only if this does not exceed [FOR56]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-GOD-HOLD-OFF-FIG-CLM.0">[FOR56.1] is valid only if this does not exceed [FOR56]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-GOD-HOLD-OFF-FIG-CLM.1">8769</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-GOD-HOLD-OFF-FIG-CLM.1">[FOR56.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-GOD-HOLD-OFF-FIG-CLM.1">[FOR56.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-NON-TRADE-INC-FIG-CLM.0">8770</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-NON-TRADE-INC-FIG-CLM.0">[FOR57.1] is valid only if this does not exceed [FOR57]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-NON-TRADE-INC-FIG-CLM.0">[FOR57.1] is valid only if this does not exceed [FOR57]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-NON-TRADE-INC-FIG-CLM.1">8771</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-NON-TRADE-INC-FIG-CLM.1">[FOR57.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-NON-TRADE-INC-FIG-CLM.1">[FOR57.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-BEN-NT-TOAA-FIG-CLM.0">8772</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-BEN-NT-TOAA-FIG-CLM.0">[FOR58.1] is valid only if this does not exceed [FOR58]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-BEN-NT-TOAA-FIG-CLM.0">[FOR58.1] is valid only if this does not exceed [FOR58]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-BEN-NT-TOAA-FIG-CLM.1">8773</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-BEN-NT-TOAA-FIG-CLM.1">[FOR58.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-BEN-NT-TOAA-FIG-CLM.1">[FOR58.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-BEN-T-TPI-TOAA-FIG-CLM.0">8774</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-BEN-T-TPI-TOAA-FIG-CLM.0">[FOR59.1] is valid only if this does not exceed [FOR59]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-BEN-T-TPI-TOAA-FIG-CLM.0">[FOR59.1] is valid only if this does not exceed [FOR59]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-BEN-T-TPI-TOAA-FIG-CLM.1">8775</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-BEN-T-TPI-TOAA-FIG-CLM.1">[FOR59.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-BEN-T-TPI-TOAA-FIG-CLM.1">[FOR59.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-BEN-FMR-TOAA-FIG-CLM.0">8776</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-BEN-FMR-TOAA-FIG-CLM.0">[FOR60.1] is valid only if this does not exceed [FOR60]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-BEN-FMR-TOAA-FIG-CLM.0">[FOR60.1] is valid only if this does not exceed [FOR60]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-BEN-FMR-TOAA-FIG-CLM.1">8777</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-BEN-FMR-TOAA-FIG-CLM.1">[FOR60.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-BEN-FMR-TOAA-FIG-CLM.1">[FOR60.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-BEN-OGR-TOAA-FIG-CLM.0">8778</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-BEN-OGR-TOAA-FIG-CLM.0">[FOR61.1] is valid only if this does not exceed [FOR61]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-BEN-OGR-TOAA-FIG-CLM.0">[FOR61.1] is valid only if this does not exceed [FOR61]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-BEN-OGR-TOAA-FIG-CLM.1">8779</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-BEN-OGR-TOAA-FIG-CLM.1">[FOR61.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-BEN-OGR-TOAA-FIG-CLM.1">[FOR61.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-BEN-S-TTI-PFSI-FIG-CLM.0">8780</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-BEN-S-TTI-PFSI-FIG-CLM.0">[FOR62.1] is valid only if this does not exceed [FOR62]. Please check</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-BEN-S-TTI-PFSI-FIG-CLM.0">[FOR62.1] is valid only if this does not exceed [FOR62]. Please check</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-BEN-S-TTI-PFSI-FIG-CLM.1">8781</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-BEN-S-TTI-PFSI-FIG-CLM.1">[FOR62.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-BEN-S-TTI-PFSI-FIG-CLM.1">[FOR62.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-BEN-CFM-TTI-PFSI-FIG-CLM.0">8782</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-BEN-CFM-TTI-PFSI-FIG-CLM.0">[FOR63.1] is valid only if this does not exceed [FOR63]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-BEN-CFM-TTI-PFSI-FIG-CLM.0">[FOR63.1] is valid only if this does not exceed [FOR63]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-BEN-CFM-TTI-PFSI-FIG-CLM.1">8783</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-BEN-CFM-TTI-PFSI-FIG-CLM.1">[FOR63.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-BEN-CFM-TTI-PFSI-FIG-CLM.1">[FOR63.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-BEN-OGR-SETTLE-FIG-CLM.0">8784</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-BEN-OGR-SETTLE-FIG-CLM.0">[FOR64.1] is valid only if this does not exceed [FOR64]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-BEN-OGR-SETTLE-FIG-CLM.0">[FOR64.1] is valid only if this does not exceed [FOR64]</sch:diagnostic>
    <sch:diagnostic id="errorCode.FIG-BEN-OGR-SETTLE-FIG-CLM.1">8785</sch:diagnostic>
    <sch:diagnostic id="transactional.FIG-BEN-OGR-SETTLE-FIG-CLM.1">[FOR64.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.FIG-BEN-OGR-SETTLE-FIG-CLM.1">[FOR64.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.TRU-FRGN-ESTATE-INC-FIG-CLM.0">8786</sch:diagnostic>
    <sch:diagnostic id="transactional.TRU-FRGN-ESTATE-INC-FIG-CLM.0">[TRU22.1] is valid only if this does not exceed [TRU22]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.TRU-FRGN-ESTATE-INC-FIG-CLM.0">[TRU22.1] is valid only if this does not exceed [TRU22]</sch:diagnostic>
    <sch:diagnostic id="errorCode.TRU-FRGN-ESTATE-INC-FIG-CLM.1">8787</sch:diagnostic>
    <sch:diagnostic id="transactional.TRU-FRGN-ESTATE-INC-FIG-CLM.1">[TRU22.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.TRU-FRGN-ESTATE-INC-FIG-CLM.1">[TRU22.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.MTR-ATTACHMENT-CGT.1">6020</sch:diagnostic>
    <sch:diagnostic id="transactional.MTR-ATTACHMENT-CGT.1">Submission must contain at least one attachment or an entry in the whitespace if Capital Gains Summary is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MTR-ATTACHMENT-CGT.1">Submission must contain at least one attachment or an entry in the whitespace if Capital Gains Summary is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-CGT-PROPERTY-RES.1">8382</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-CGT-PROPERTY-RES.1">[CGT3-13C] must not be empty.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-CGT-PROPERTY-RES.1">[CGT3-13C] must not be empty.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-RES-PROPERTY-PROCEEDS-AMT.0">8384</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-RES-PROPERTY-PROCEEDS-AMT.0">There is an entry in [CGT4]. Please complete [CGT3].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-RES-PROPERTY-PROCEEDS-AMT.0">There is an entry in [CGT4]. Please complete [CGT3].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-RES-PROPERTY-TOT-GAINS-AMT.0">8385</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-RES-PROPERTY-TOT-GAINS-AMT.0">There is an entry in [CGT6]. Please complete [CGT3].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-RES-PROPERTY-TOT-GAINS-AMT.0">There is an entry in [CGT6]. Please complete [CGT3].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-RES-PROP-TOT-GAINS-FIG-CLM.0">8788</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-RES-PROP-TOT-GAINS-FIG-CLM.0">[CGT6.1] is valid only if this does not exceed [CGT6]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-RES-PROP-TOT-GAINS-FIG-CLM.0">[CGT6.1] is valid only if this does not exceed [CGT6]</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-RES-PROP-TOT-GAINS-FIG-CLM.1">8789</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-RES-PROP-TOT-GAINS-FIG-CLM.1">[CGT6.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-RES-PROP-TOT-GAINS-FIG-CLM.1">[CGT6.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-RES-PROPERTY-TOT-LOSS-AMT.0">8386</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-RES-PROPERTY-TOT-LOSS-AMT.0">There is an entry in [CGT7]. Please complete [CGT3].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-RES-PROPERTY-TOT-LOSS-AMT.0">There is an entry in [CGT7]. Please complete [CGT3].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-RES-PPTY-PDR-REP.0">8387</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-RES-PPTY-PDR-REP.0">[CGT9] is positive so [CGT6] should be present.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-RES-PPTY-PDR-REP.0">[CGT9] is positive so [CGT6] should be present.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-RES-PPTY-PDR-REP.1">8388</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-RES-PPTY-PDR-REP.1">If [CGT9] is negative then [CGT7] should be present.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-RES-PPTY-PDR-REP.1">If [CGT9] is negative then [CGT7] should be present.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-RES-PPTY-PDR-TAX-CHARGED.0">8392</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-RES-PPTY-PDR-TAX-CHARGED.0">[CGT10] is present so the following should be true: [CGT9] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-RES-PPTY-PDR-TAX-CHARGED.0">[CGT10] is present so the following should be true: [CGT9] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-RES-PROPERTY-RTT-GAIN.0">8389</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-RES-PROPERTY-RTT-GAIN.0">[CGT11] is positive so [CGT6] should be present.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-RES-PROPERTY-RTT-GAIN.0">[CGT11] is positive so [CGT6] should be present.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-RES-PROPERTY-RTT-GAIN.2">8391</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-RES-PROPERTY-RTT-GAIN.2">If [CGT11] is negative then [CGT7] should be present.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-RES-PROPERTY-RTT-GAIN.2">If [CGT11] is negative then [CGT7] should be present.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-RES-PPTY-RTT-TAX-CHARGED.0">8393</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-RES-PPTY-RTT-TAX-CHARGED.0">There is an entry in [CGT12]. Please complete [CGT11].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-RES-PPTY-RTT-TAX-CHARGED.0">There is an entry in [CGT12]. Please complete [CGT11].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-RES-PPTY-CARRIED-INTEREST.0">8644</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-RES-PPTY-CARRIED-INTEREST.0">[CGT13B] must be present if [CGT13] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-RES-PPTY-CARRIED-INTEREST.0">[CGT13B] must be present if [CGT13] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-RES-PPTY-CI-ACCRUALS.0">8645</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-RES-PPTY-CI-ACCRUALS.0">[CGT13B] must be present if [CGT13A] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-RES-PPTY-CI-ACCRUALS.0">[CGT13B] must be present if [CGT13A] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-RES-PPTY-CI-FIG-CLM.0">8790</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-RES-PPTY-CI-FIG-CLM.0">[CGT13C] is valid only if this does not exceed [CGT13B]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-RES-PPTY-CI-FIG-CLM.0">[CGT13C] is valid only if this does not exceed [CGT13B]</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-RES-PPTY-CI-FIG-CLM.1">8791</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-RES-PPTY-CI-FIG-CLM.1">[CGT13C] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-RES-PPTY-CI-FIG-CLM.1">[CGT13C] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-CGT-CRYPTOASSETS.0">8646</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-CGT-CRYPTOASSETS.0">[CGT13.1-13.8] must not be empty.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-CGT-CRYPTOASSETS.0">[CGT13.1-13.8] must not be empty.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-CRYPTO-QUA.0">8647</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-CRYPTO-QUA.0">There is an entry in [CGT13.1]. Please complete at least one of [CGT13.4], [CGT13.5] or [CGT13.7].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-CRYPTO-QUA.0">There is an entry in [CGT13.1]. Please complete at least one of [CGT13.4], [CGT13.5] or [CGT13.7].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-CRYPTO-RTT-GAIN.0">8648</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-CRYPTO-RTT-GAIN.0">If [CGT13.7] is positive then [CGT13.4] should be present and positive.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-CRYPTO-RTT-GAIN.0">If [CGT13.7] is positive then [CGT13.4] should be present and positive.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-CRYPTO-RTT-GAIN.1">8649</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-CRYPTO-RTT-GAIN.1">The positive amount in [CGT13.7] exceeds the amount in [CGT13.4]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-CRYPTO-RTT-GAIN.1">The positive amount in [CGT13.7] exceeds the amount in [CGT13.4]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-CRYPTO-RTT-GAIN.2">8650</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-CRYPTO-RTT-GAIN.2">If [CGT13.7] is negative then [CGT13.5] should be present and positive.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-CRYPTO-RTT-GAIN.2">If [CGT13.7] is negative then [CGT13.5] should be present and positive.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-CRYPTO-RTT-GAIN.3">8651</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-CRYPTO-RTT-GAIN.3">The absolute value of the negative amount in [CGT13.7] exceeds the amount in [CGT13.5]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-CRYPTO-RTT-GAIN.3">The absolute value of the negative amount in [CGT13.7] exceeds the amount in [CGT13.5]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-CGT-PROPERTY-OTHER.1">8394</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-CGT-PROPERTY-OTHER.1">[CGT14-22] must not be empty.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-CGT-PROPERTY-OTHER.1">[CGT14-22] must not be empty.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-CGT-PROPERTY-OTHER.2">8652</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-CGT-PROPERTY-OTHER.2">If [CGT17.2] present or [CGT17.3] present or [CGT17.4] present then [CGT17.2] + [CGT17.3] + [CGT17.4] must be less than or equal to [CGT17]. This validation must run even if [CGT17.4] is absent</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-CGT-PROPERTY-OTHER.2">If [CGT17.2] present or [CGT17.3] present or [CGT17.4] present then [CGT17.2] + [CGT17.3] + [CGT17.4] must be less than or equal to [CGT17]. This validation must run even if [CGT17.4] is absent</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP3-TRANS-LAND-PPTY-QUA.0">8395</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP3-TRANS-LAND-PPTY-QUA.0">There is an entry in [CGT14]. Please complete at least one of [CGT17], [CGT19] and [CGT21].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP3-TRANS-LAND-PPTY-QUA.0">There is an entry in [CGT14]. Please complete at least one of [CGT17], [CGT19] and [CGT21].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-PROPERTY-PROCEEDS-AMT.0">8396</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-PROPERTY-PROCEEDS-AMT.0">There is an entry in [CGT15]. Please complete [CGT14].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-PROPERTY-PROCEEDS-AMT.0">There is an entry in [CGT15]. Please complete [CGT14].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-PROPERTY-TOT-GAINS-AMT.0">8397</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-PROPERTY-TOT-GAINS-AMT.0">There is an entry in [CGT17]. Please complete [CGT14].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-PROPERTY-TOT-GAINS-AMT.0">There is an entry in [CGT17]. Please complete [CGT14].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-PROPERTY-TOT-GAINS-FIG-CLM.0">8792</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-PROPERTY-TOT-GAINS-FIG-CLM.0">[CGT17.0] is valid only if this does not exceed [CGT17]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-PROPERTY-TOT-GAINS-FIG-CLM.0">[CGT17.0] is valid only if this does not exceed [CGT17]</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-PROPERTY-TOT-GAINS-FIG-CLM.1">8793</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-PROPERTY-TOT-GAINS-FIG-CLM.1">[CGT17.0] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-PROPERTY-TOT-GAINS-FIG-CLM.1">[CGT17.0] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-PROPERTY-GAIN-NR-LAND.0">8653</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-PROPERTY-GAIN-NR-LAND.0">[CGT17.1] is present so the following should be true: [CGT17] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-PROPERTY-GAIN-NR-LAND.0">[CGT17.1] is present so the following should be true: [CGT17] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-DISP-QUAL-BADR-RPROP.0">8654</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-DISP-QUAL-BADR-RPROP.0">[CGT17.2] is present so the following should be true: [CGT17] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-DISP-QUAL-BADR-RPROP.0">[CGT17.2] is present so the following should be true: [CGT17] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-DISP-QUAL-BADR-SHARES.0">8655</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-DISP-QUAL-BADR-SHARES.0">[CGT17.3] is present so the following should be true: [CGT17] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-DISP-QUAL-BADR-SHARES.0">[CGT17.3] is present so the following should be true: [CGT17] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-DISP-QUAL-BADR-OTHER.0">8656</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-DISP-QUAL-BADR-OTHER.0">[CGT17.4] is present so the following should be true: [CGT17] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-DISP-QUAL-BADR-OTHER.0">[CGT17.4] is present so the following should be true: [CGT17] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-PROPERTY-TOT-LOSSES-AMT.0">8398</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-PROPERTY-TOT-LOSSES-AMT.0">There is an entry in [CGT19]. Please complete [CGT14].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-PROPERTY-TOT-LOSSES-AMT.0">There is an entry in [CGT19]. Please complete [CGT14].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-PROPERTY-RTT-GAIN.0">8399</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-PROPERTY-RTT-GAIN.0">There is a positive amount in [CGT21]. Please complete [CGT17].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-PROPERTY-RTT-GAIN.0">There is a positive amount in [CGT21]. Please complete [CGT17].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-PROPERTY-RTT-GAIN.1">8400</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-PROPERTY-RTT-GAIN.1">The positive amount in [CGT21] exceeds the amount in [CGT17]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-PROPERTY-RTT-GAIN.1">The positive amount in [CGT21] exceeds the amount in [CGT17]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-PROPERTY-RTT-GAIN.2">8401</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-PROPERTY-RTT-GAIN.2">If [CGT21] is negative then [CGT19] should be present and positive.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-PROPERTY-RTT-GAIN.2">If [CGT21] is negative then [CGT19] should be present and positive.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-PROPERTY-RTT-GAIN.3">8402</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-PROPERTY-RTT-GAIN.3">The absolute value of the negative amount in [CGT21] exceeds the amount in [CGT19]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-PROPERTY-RTT-GAIN.3">The absolute value of the negative amount in [CGT21] exceeds the amount in [CGT19]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-PROPERTY-RTT-TAX-CHARGED.0">8403</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-PROPERTY-RTT-TAX-CHARGED.0">There is an entry in [CGT22]. Please complete [CGT21].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-PROPERTY-RTT-TAX-CHARGED.0">There is an entry in [CGT22]. Please complete [CGT21].</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-CGT-LISTED-SHARES-SECURITIES.1">8404</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-CGT-LISTED-SHARES-SECURITIES.1">[CGT23-30] must not be empty.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-CGT-LISTED-SHARES-SECURITIES.1">[CGT23-30] must not be empty.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP3-TRANS-QUOTED-SHARES-QUA.0">8405</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP3-TRANS-QUOTED-SHARES-QUA.0">There is an entry in [CGT23]. Please complete at least one of [CGT26], [CGT27] and [CGT29].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP3-TRANS-QUOTED-SHARES-QUA.0">There is an entry in [CGT23]. Please complete at least one of [CGT26], [CGT27] and [CGT29].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP4-QUOTED-SHARE-AMO.0">8406</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP4-QUOTED-SHARE-AMO.0">There is an entry in [CGT24]. Please complete [CGT23].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP4-QUOTED-SHARE-AMO.0">There is an entry in [CGT24]. Please complete [CGT23].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-QUOTED-SHARE-TOT-GAINS-AMT.0">6397</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-QUOTED-SHARE-TOT-GAINS-AMT.0">There is an entry in [CGT26]. Please complete [CGT23].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-QUOTED-SHARE-TOT-GAINS-AMT.0">There is an entry in [CGT26]. Please complete [CGT23].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-QUOTED-SHARE-TOT-FIG-CLM.0">8794</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-QUOTED-SHARE-TOT-FIG-CLM.0">[CGT26.1] is valid only if this does not exceed [CGT26]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-QUOTED-SHARE-TOT-FIG-CLM.0">[CGT26.1] is valid only if this does not exceed [CGT26]</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-QUOTED-SHARE-TOT-FIG-CLM.1">8795</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-QUOTED-SHARE-TOT-FIG-CLM.1">[CGT26.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-QUOTED-SHARE-TOT-FIG-CLM.1">[CGT26.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-QUOTED-SHARE-TOT-LOSS-AMT.0">8407</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-QUOTED-SHARE-TOT-LOSS-AMT.0">There is an entry in [CGT27]. Please complete [CGT23].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-QUOTED-SHARE-TOT-LOSS-AMT.0">There is an entry in [CGT27]. Please complete [CGT23].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-QUOTED-SHARE-RTT-GAIN.0">8408</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-QUOTED-SHARE-RTT-GAIN.0">If [CGT29] is positive then [CGT26] should be present and positive.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-QUOTED-SHARE-RTT-GAIN.0">If [CGT29] is positive then [CGT26] should be present and positive.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-QUOTED-SHARE-RTT-GAIN.1">8409</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-QUOTED-SHARE-RTT-GAIN.1">The positive amount in [CGT29] exceeds the amount in [CGT26]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-QUOTED-SHARE-RTT-GAIN.1">The positive amount in [CGT29] exceeds the amount in [CGT26]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-QUOTED-SHARE-RTT-GAIN.2">8410</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-QUOTED-SHARE-RTT-GAIN.2">If [CGT29] is negative then [CGT27] should be present and positive.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-QUOTED-SHARE-RTT-GAIN.2">If [CGT29] is negative then [CGT27] should be present and positive.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-QUOTED-SHARE-RTT-GAIN.3">8411</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-QUOTED-SHARE-RTT-GAIN.3">The absolute value of the negative amount in [CGT29] exceeds the amount in [CGT27]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-QUOTED-SHARE-RTT-GAIN.3">The absolute value of the negative amount in [CGT29] exceeds the amount in [CGT27]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-QOTD-SHARE-RTT-TAX-CHARGED.0">8412</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-QOTD-SHARE-RTT-TAX-CHARGED.0">There is an entry in [CGT30]. Please complete [CGT29].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-QOTD-SHARE-RTT-TAX-CHARGED.0">There is an entry in [CGT30]. Please complete [CGT29].</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-CGT-UNLISTED-SHARES-SECURITIES.1">8413</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-CGT-UNLISTED-SHARES-SECURITIES.1">[CGT31-44] must not be empty.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-CGT-UNLISTED-SHARES-SECURITIES.1">[CGT31-44] must not be empty.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-CGT-UNLISTED-SHARES-SECURITIES.2">8414</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-CGT-UNLISTED-SHARES-SECURITIES.2">There is an entry in [CGT41] or [CGT43]. [CGT41] plus [CGT43] must be less than or equal to [CGT35]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-CGT-UNLISTED-SHARES-SECURITIES.2">There is an entry in [CGT41] or [CGT43]. [CGT41] plus [CGT43] must be less than or equal to [CGT35]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP3-TRANS-UNQUOTED-SHARES-QUA.0">8415</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP3-TRANS-UNQUOTED-SHARES-QUA.0">There is an entry in [CGT31]. Please complete at least one of [CGT34], [CGT35] and [CGT37].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP3-TRANS-UNQUOTED-SHARES-QUA.0">There is an entry in [CGT31]. Please complete at least one of [CGT34], [CGT35] and [CGT37].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-UNQOTD-SHARE-PROCEEDS-AMT.0">8416</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-UNQOTD-SHARE-PROCEEDS-AMT.0">There is an entry in [CGT32]. Please complete [CGT31].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-UNQOTD-SHARE-PROCEEDS-AMT.0">There is an entry in [CGT32]. Please complete [CGT31].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-UNQOTD-SHARE-TOT-GAINS-AMT.0">6398</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-UNQOTD-SHARE-TOT-GAINS-AMT.0">There is an entry in [CGT34]. Please complete [CGT31].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-UNQOTD-SHARE-TOT-GAINS-AMT.0">There is an entry in [CGT34]. Please complete [CGT31].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-UNQOTD-SHARE-TOT-FIG-CLM.0">8796</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-UNQOTD-SHARE-TOT-FIG-CLM.0">[CGT34.1] is valid only if this does not exceed [CGT34]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-UNQOTD-SHARE-TOT-FIG-CLM.0">[CGT34.1] is valid only if this does not exceed [CGT34]</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-UNQOTD-SHARE-TOT-FIG-CLM.1">8797</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-UNQOTD-SHARE-TOT-FIG-CLM.1">[CGT34.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-UNQOTD-SHARE-TOT-FIG-CLM.1">[CGT34.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-UNQOTD-SHARE-TOT-LOSS-AMT.0">8417</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-UNQOTD-SHARE-TOT-LOSS-AMT.0">There is an entry in [CGT35]. Please complete [CGT31].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-UNQOTD-SHARE-TOT-LOSS-AMT.0">There is an entry in [CGT35]. Please complete [CGT31].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-UNQOTD-SHARE-RTT-GAIN.0">8418</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-UNQOTD-SHARE-RTT-GAIN.0">If [CGT37] is positive then [CGT34] should be present and positive.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-UNQOTD-SHARE-RTT-GAIN.0">If [CGT37] is positive then [CGT34] should be present and positive.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-UNQOTD-SHARE-RTT-GAIN.1">8419</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-UNQOTD-SHARE-RTT-GAIN.1">The positive amount in [CGT37] exceeds the amount in [CGT34]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-UNQOTD-SHARE-RTT-GAIN.1">The positive amount in [CGT37] exceeds the amount in [CGT34]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-UNQOTD-SHARE-RTT-GAIN.2">8420</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-UNQOTD-SHARE-RTT-GAIN.2">If [CGT37] is negative then [CGT35] should be present and positive.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-UNQOTD-SHARE-RTT-GAIN.2">If [CGT37] is negative then [CGT35] should be present and positive.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-UNQOTD-SHARE-RTT-GAIN.3">8421</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-UNQOTD-SHARE-RTT-GAIN.3">The absolute value of the negative amount in [CGT37] exceeds the amount in [CGT35]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-UNQOTD-SHARE-RTT-GAIN.3">The absolute value of the negative amount in [CGT37] exceeds the amount in [CGT35]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-UNQOTD-SHR-RTT-TAX-CHARGED.0">8422</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-UNQOTD-SHR-RTT-TAX-CHARGED.0">There is an entry in [CGT38]. Please complete [CGT37].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-UNQOTD-SHR-RTT-TAX-CHARGED.0">There is an entry in [CGT38]. Please complete [CGT37].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-GAINS-INVEST-SEED-EIS-AMT.0">8426</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-GAINS-INVEST-SEED-EIS-AMT.0">[CGT40] must not exceed [£100,000]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-GAINS-INVEST-SEED-EIS-AMT.0">[CGT40] must not exceed [£100,000]</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-LOSS-SET-OFF-OTHER-INCOME.0">8423</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-LOSS-SET-OFF-OTHER-INCOME.0">There is an entry in [CGT41]. Please complete [CGT35].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-LOSS-SET-OFF-OTHER-INCOME.0">There is an entry in [CGT41]. Please complete [CGT35].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-UNCAPP-LOSS-SET-OFF-CY-AMT.0">8305</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-UNCAPP-LOSS-SET-OFF-CY-AMT.0">[CGT42] is valid only if this does not exceed [CGT41].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-UNCAPP-LOSS-SET-OFF-CY-AMT.0">[CGT42] is valid only if this does not exceed [CGT41].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP4-LOSS-SET-OFF-PREV-INC-AMO.0">8424</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP4-LOSS-SET-OFF-PREV-INC-AMO.0">There is an entry in [CGT43]. Please complete [CGT35].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP4-LOSS-SET-OFF-PREV-INC-AMO.0">There is an entry in [CGT43]. Please complete [CGT35].</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-UNCAPP-LOSS-SET-OFF-PY-AMT.0">8306</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-UNCAPP-LOSS-SET-OFF-PY-AMT.0">[CGT44] is valid only if this does not exceed [CGT43].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-UNCAPP-LOSS-SET-OFF-PY-AMT.0">[CGT44] is valid only if this does not exceed [CGT43].</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-CGT-LOSSES-ADJUSTMENTS.1">8425</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-CGT-LOSSES-ADJUSTMENTS.1">[CGT45-52] must not be empty.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-CGT-LOSSES-ADJUSTMENTS.1">[CGT45-52] must not be empty.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-INVESTORS-RELIEF-AMT.0">6170</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-INVESTORS-RELIEF-AMT.0">The amount in [CGT49] exceeds [£1,000,000]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-INVESTORS-RELIEF-AMT.0">The amount in [CGT49] exceeds [£1,000,000]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-INVESTORS-RELIEF-AMT.1">6171</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-INVESTORS-RELIEF-AMT.1">[CGT49] is valid only if this does not exceed [CGT34]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-INVESTORS-RELIEF-AMT.1">[CGT49] is valid only if this does not exceed [CGT34]</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-TOTAL-GAINS-BADR-AMT.0">6173</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-TOTAL-GAINS-BADR-AMT.0">[CGT50] is valid only if this does not exceed [£1,000,000]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-TOTAL-GAINS-BADR-AMT.0">[CGT50] is valid only if this does not exceed [£1,000,000]</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-TOTAL-GAINS-BADR-AMT.1">6175</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-TOTAL-GAINS-BADR-AMT.1">[CGT50.1] must be present if [CGT50] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-TOTAL-GAINS-BADR-AMT.1">[CGT50.1] must be present if [CGT50] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-CGT-NRCGT-UKL-PPTY.1">8231</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-CGT-NRCGT-UKL-PPTY.1">[CGT52.1-52.5] must not be empty.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-CGT-NRCGT-UKL-PPTY.1">[CGT52.1-52.5] must not be empty.</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-NRCGT-ID.0">8232</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-NRCGT-ID.0">There is an entry in [CGT52.3] so an entry in [CGT52.2] should be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-NRCGT-ID.0">There is an entry in [CGT52.3] so an entry in [CGT52.2] should be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-NRCGT-TAX-PAID.0">8233</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-NRCGT-TAX-PAID.0">There is an entry in [CGT52.4] so an entry in [CGT52.1] or [CGT52.2] should be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-NRCGT-TAX-PAID.0">There is an entry in [CGT52.4] so an entry in [CGT52.1] or [CGT52.2] should be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-EIS-GAIN.0">8602</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-EIS-GAIN.0">[CGT52EG] is present so at least one of [CGT13.1], [CGT14], [CGT23] or [CGT31] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-EIS-GAIN.0">[CGT52EG] is present so at least one of [CGT13.1], [CGT14], [CGT23] or [CGT31] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-EIS-FIG-CLM.0">8798</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-EIS-FIG-CLM.0">[CGT52EG.1] is valid only if this does not exceed [CGT52EG]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-EIS-FIG-CLM.0">[CGT52EG.1] is valid only if this does not exceed [CGT52EG]</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-EIS-FIG-CLM.1">8799</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-EIS-FIG-CLM.1">[CGT52EG.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-EIS-FIG-CLM.1">[CGT52EG.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-QAHC-GAIN.0">8603</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-QAHC-GAIN.0">[CGT52QG] is present so at least one of [CGT13.1], [CGT14], [CGT23] or [CGT31] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-QAHC-GAIN.0">[CGT52QG] is present so at least one of [CGT13.1], [CGT14], [CGT23] or [CGT31] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-QAHC-FIG-CLM.0">8800</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-QAHC-FIG-CLM.0">[CGT52QG.1] is valid only if this does not exceed [CGT52QG]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-QAHC-FIG-CLM.0">[CGT52QG.1] is valid only if this does not exceed [CGT52QG]</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-QAHC-FIG-CLM.1">8801</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-QAHC-FIG-CLM.1">[CGT52QG.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-QAHC-FIG-CLM.1">[CGT52QG.1] is present, [NRD1] must not be present and at least one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.CAP-QAHC-LOSS.0">8604</sch:diagnostic>
    <sch:diagnostic id="transactional.CAP-QAHC-LOSS.0">[CGT52QL] is present so at least one of [CGT13.1], [CGT14], [CGT23] or [CGT31] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.CAP-QAHC-LOSS.0">[CGT52QL] is present so at least one of [CGT13.1], [CGT14], [CGT23] or [CGT31] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA109.0">6876</sch:diagnostic>
    <sch:diagnostic id="transactional.SA109.0">There is an entry in box [NRD1]. Please complete box [NRD10].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA109.0">There is an entry in box [NRD1]. Please complete box [NRD10].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA109.2">8802</sch:diagnostic>
    <sch:diagnostic id="transactional.SA109.2">[NRD28] or [NRD29] is present, [INC3], [INC6] and [INC7] must be absent and at least one of [FSE76.1] or [FSE77.1] or [FPS20.1] or [FPS21.1] or [FPS35.1] or [FPS55.1] or [FPS60.1] or [FPS70.1] or [FPS75.1] or [FPS76.1] or [FOR4.1] or [FOR6.1] or [FOR9.1] or [FOR11.1] or [FOR13.0] or [FOR30.1] or [FOR48.1] or [FOR51.1] or [FOR53.1] or [FOR54.1] or [FOR55.1] or [FOR56.1] or [FOR57.1] or [FOR58.1] or [FOR59.1] or [FOR60.1] or [FOR61.1] or [FOR62.1] or [FOR63.1] or [FOR64.1] or [TRU22.1] or [CGT6.1] or [CGT13C] or [CGT17.0] or [CGT26.1] or [CGT34.1] or [CGT52EG.1] or [CGT52QG.1] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA109.2">[NRD28] or [NRD29] is present, [INC3], [INC6] and [INC7] must be absent and at least one of [FSE76.1] or [FSE77.1] or [FPS20.1] or [FPS21.1] or [FPS35.1] or [FPS55.1] or [FPS60.1] or [FPS70.1] or [FPS75.1] or [FPS76.1] or [FOR4.1] or [FOR6.1] or [FOR9.1] or [FOR11.1] or [FOR13.0] or [FOR30.1] or [FOR48.1] or [FOR51.1] or [FOR53.1] or [FOR54.1] or [FOR55.1] or [FOR56.1] or [FOR57.1] or [FOR58.1] or [FOR59.1] or [FOR60.1] or [FOR61.1] or [FOR62.1] or [FOR63.1] or [FOR64.1] or [TRU22.1] or [CGT6.1] or [CGT13C] or [CGT17.0] or [CGT26.1] or [CGT34.1] or [CGT52EG.1] or [CGT52QG.1] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA109.3">8803</sch:diagnostic>
    <sch:diagnostic id="transactional.SA109.3">One of [NRD28], [NRD29] and [NRD41] is present, [FPS63.1], [FPS63.2], [FOR13.1], [FOR13.2], [FOR24.1], [FOR24.2], [FOR49] and [FOR49.1] must be absent</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA109.3">One of [NRD28], [NRD29] and [NRD41] is present, [FPS63.1], [FPS63.2], [FOR13.1], [FOR13.2], [FOR24.1], [FOR24.2], [FOR49] and [FOR49.1] must be absent</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM4-SPLIT-YEAR-SIGNAL.0">8317</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM4-SPLIT-YEAR-SIGNAL.0">[NRD6] must be present if [NRD3] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM4-SPLIT-YEAR-SIGNAL.0">[NRD6] must be present if [NRD3] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM4-SPLIT-YEAR-SIGNAL.1">8429</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM4-SPLIT-YEAR-SIGNAL.1">The entry in [NRD3] must not be present as there is an entry in [NRD1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM4-SPLIT-YEAR-SIGNAL.1">The entry in [NRD3] must not be present as there is an entry in [NRD1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-MULTIPLE-SPLIT-YEAR-SIG.0">8318</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-MULTIPLE-SPLIT-YEAR-SIG.0">[NRD3] must be present if [NRD3.1] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-MULTIPLE-SPLIT-YEAR-SIG.0">[NRD3] must be present if [NRD3.1] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-PARTIAL-YEAR-DATE.0">8319</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-PARTIAL-YEAR-DATE.0">[NRD3] must be present if [NRD6] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-PARTIAL-YEAR-DATE.0">[NRD3] must be present if [NRD6] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-PARTIAL-YEAR-DATE.1">8320</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-PARTIAL-YEAR-DATE.1">[NRD6] must be within the current return year</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-PARTIAL-YEAR-DATE.1">[NRD6] must be within the current return year</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-AUTO-OVERSEAS-TEST-SIG.0">8321</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-AUTO-OVERSEAS-TEST-SIG.0">[NRD1] must be present if [NRD7] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-AUTO-OVERSEAS-TEST-SIG.0">[NRD1] must be present if [NRD7] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-GAP-IN-EMPLOYMENTS-SIG.0">8448</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-GAP-IN-EMPLOYMENTS-SIG.0">The entry in box [NRD8] should not be present as there is not an entry in [NRD7] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-GAP-IN-EMPLOYMENTS-SIG.0">The entry in box [NRD8] should not be present as there is not an entry in [NRD7] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-UK-DAYS-EXCPTL-CIRC-IN-CY.2">6723</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-UK-DAYS-EXCPTL-CIRC-IN-CY.2">The entry in box [NRD11] exceeds the entry in box [NRD10]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-UK-DAYS-EXCPTL-CIRC-IN-CY.2">The entry in box [NRD11] exceeds the entry in box [NRD10]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-UK-DAYS-EXCPTL-CIRC-IN-CY.3">6724</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-UK-DAYS-EXCPTL-CIRC-IN-CY.3">There is an entry in box [NRD11], an entry must be present in [NRD10].Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-UK-DAYS-EXCPTL-CIRC-IN-CY.3">There is an entry in box [NRD11], an entry must be present in [NRD10].Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-UK-RES-PRIOR-ARRIVAL.0">8804</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-UK-RES-PRIOR-ARRIVAL.0">The entry must be a valid pair of consecutive years in the format YYYY YY. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-UK-RES-PRIOR-ARRIVAL.0">The entry must be a valid pair of consecutive years in the format YYYY YY. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-FIG-QAHC-DEEMED-SIG.0">8805</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-FIG-QAHC-DEEMED-SIG.0">[NRD30] is present so one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-FIG-QAHC-DEEMED-SIG.0">[NRD30] is present so one of [NRD28] or [NRD29] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-OWR.0">8806</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-OWR.0">[NRD47] must be present if [NRD41] is present and [NRD43] is not present. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-OWR.0">[NRD47] must be present if [NRD41] is present and [NRD43] is not present. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-OWR-CLAIM.0">8807</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-OWR-CLAIM.0">[NRD41] is present, [NRD44] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-OWR-CLAIM.0">[NRD41] is present, [NRD44] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-OWR-CLAIM.1">8808</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-OWR-CLAIM.1">[NRD41] is present, [NRD46] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-OWR-CLAIM.1">[NRD41] is present, [NRD46] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-OWR-CLAIM.2">8809</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-OWR-CLAIM.2">If [NRD41] is present [NRD48] must be present. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-OWR-CLAIM.2">If [NRD41] is present [NRD48] must be present. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-OWR-CLAIM.3">8810</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-OWR-CLAIM.3">If [NRD41] is present [NRD49] must be present. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-OWR-CLAIM.3">If [NRD41] is present [NRD49] must be present. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-OWR-QUAL-EI-AFT-DED.0">8811</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-OWR-QUAL-EI-AFT-DED.0">[NRD44] is present so [NRD41] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-OWR-QUAL-EI-AFT-DED.0">[NRD44] is present so [NRD41] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-OWR-QUAL-EI-AFT-DED.1">8812</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-OWR-QUAL-EI-AFT-DED.1">[NRD44] must not exceed by more than £1 the total of all instances of ([EMP1] + [EMP3] + [EMP9] + [EMP10] + [EMP11] + [EMP12] + [EMP13] + [EMP14] + [EMP15] + [EMP16] + [MOR38]) + [ASE1] + [ASE3] + [ASE4] + [ASE5]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-OWR-QUAL-EI-AFT-DED.1">[NRD44] must not exceed by more than £1 the total of all instances of ([EMP1] + [EMP3] + [EMP9] + [EMP10] + [EMP11] + [EMP12] + [EMP13] + [EMP14] + [EMP15] + [EMP16] + [MOR38]) + [ASE1] + [ASE3] + [ASE4] + [ASE5]</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-OWR-QUAL-FOR-EI-AFT-DED.0">8813</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-OWR-QUAL-FOR-EI-AFT-DED.0">[NRD46] is present so [NRD41] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-OWR-QUAL-FOR-EI-AFT-DED.0">[NRD46] is present so [NRD41] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-OWR-QUAL-FOR-EI-AFT-DED.1">8814</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-OWR-QUAL-FOR-EI-AFT-DED.1">[NRD46] is valid only if this does not exceed [NRD44]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-OWR-QUAL-FOR-EI-AFT-DED.1">[NRD46] is valid only if this does not exceed [NRD44]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-OWR-MAX-REL.0">8815</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-OWR-MAX-REL.0">[NRD47] is present so [NRD41] must be present. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-OWR-MAX-REL.0">[NRD47] is present so [NRD41] must be present. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-OWR-MAX-REL.1">8816</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-OWR-MAX-REL.1">[NRD43] is not present, [NRD47] must be less than or equal to the lower of ([NRD44] x [30%]) + £1 and [£300,000]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-OWR-MAX-REL.1">[NRD43] is not present, [NRD47] must be less than or equal to the lower of ([NRD44] x [30%]) + £1 and [£300,000]</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-OWR-CLAIMED-EMP-INC.0">8817</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-OWR-CLAIMED-EMP-INC.0">[NRD48] is present so [NRD41] must be present. Please check</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-OWR-CLAIMED-EMP-INC.0">[NRD48] is present so [NRD41] must be present. Please check</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-OWR-CLAIMED-EMP-INC.1">8818</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-OWR-CLAIMED-EMP-INC.1">[NRD43] is not present, [NRD48] must be less than or equal to the lower of [NRD46] and [NRD47]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-OWR-CLAIMED-EMP-INC.1">[NRD43] is not present, [NRD48] must be less than or equal to the lower of [NRD46] and [NRD47]</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-OWR-CLAIMED-EMP-INC.2">8819</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-OWR-CLAIMED-EMP-INC.2">[NRD43] is present, [NRD48] must be less than or equal to [NRD46]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-OWR-CLAIMED-EMP-INC.2">[NRD43] is present, [NRD48] must be less than or equal to [NRD46]</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-OWR-TOT-CLAIMED.0">8820</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-OWR-TOT-CLAIMED.0">[NRD49] is present so [NRD41] must be present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-OWR-TOT-CLAIMED.0">[NRD49] is present so [NRD41] must be present</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-OWR-TOT-CLAIMED.1">8821</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-OWR-TOT-CLAIMED.1">[NRD49] is valid only when it is not less than [NRD48]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-OWR-TOT-CLAIMED.1">[NRD49] is valid only when it is not less than [NRD48]</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-TRF-ELECTION.0">8822</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-TRF-ELECTION.0">[NRD50] must not be present if [NRD1] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-TRF-ELECTION.0">[NRD50] must not be present if [NRD1] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-TRF-AMT-PERS-DES.0">8823</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-TRF-AMT-PERS-DES.0">[NRD51] must not be present if [NRD1] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-TRF-AMT-PERS-DES.0">[NRD51] must not be present if [NRD1] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-TRF-CP-BEN-TRUSTS.0">8824</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-TRF-CP-BEN-TRUSTS.0">[NRD52] must not be present if [NRD1] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-TRF-CP-BEN-TRUSTS.0">[NRD52] must not be present if [NRD1] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-TRF-AMT-PERS-DES-REMT.0">8825</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-TRF-AMT-PERS-DES-REMT.0">[NRD53] must not be present if [NRD1] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-TRF-AMT-PERS-DES-REMT.0">[NRD53] must not be present if [NRD1] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.DOM-TRF-AMT-PERS-DES-REMT.1">8826</sch:diagnostic>
    <sch:diagnostic id="transactional.DOM-TRF-AMT-PERS-DES-REMT.1">[NRD53] is valid only if this does not exceed ( [NRD51] plus [NRD52] )</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.DOM-TRF-AMT-PERS-DES-REMT.1">[NRD53] is valid only if this does not exceed ( [NRD51] plus [NRD52] )</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF4-STUDENT-LOAN-REPAYT-AMO.0">6158</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF4-STUDENT-LOAN-REPAYT-AMO.0">Box [CAL3] completed including an entry of zero. Box [SLR1] must also be completed. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF4-STUDENT-LOAN-REPAYT-AMO.0">Box [CAL3] completed including an entry of zero. Box [SLR1] must also be completed. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-SELF-CALC-NIC-DUE-TOTAL.1">6595</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-SELF-CALC-NIC-DUE-TOTAL.1">There is an entry in one of boxes [FSE101], [LUN64], [SPS26], [FPS26] or [SSE37]. Box [CAL4] must be zero or absent. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-SELF-CALC-NIC-DUE-TOTAL.1">There is an entry in one of boxes [FSE101], [LUN64], [SPS26], [FPS26] or [SSE37]. Box [CAL4] must be zero or absent. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-SELF-CALC-CLASS2-NIC-TOTAL.0">8369</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-SELF-CALC-CLASS2-NIC-TOTAL.0">The amount in box [CAL4.1] exceeds [£219.95]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-SELF-CALC-CLASS2-NIC-TOTAL.0">The amount in box [CAL4.1] exceeds [£219.95]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF3-AUTO-CALC-POA-AMT.1">6524</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF3-AUTO-CALC-POA-AMT.1">Box [CAL10] completed. An entry is required in box [CAL11]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF3-AUTO-CALC-POA-AMT.1">Box [CAL10] completed. An entry is required in box [CAL11]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF3-AUTO-CALC-POA-AMT.2">6730</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF3-AUTO-CALC-POA-AMT.2">Entry must not be zero except where a claim to reduce payments on account has been made by ticking box [CAL10] and the claim is to reduce the payments on account to zero. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF3-AUTO-CALC-POA-AMT.2">Entry must not be zero except where a claim to reduce payments on account has been made by ticking box [CAL10] and the claim is to reduce the payments on account to zero. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-BPA-AMOUNT.1">6243</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-BPA-AMOUNT.1">The amount in box [CAL12] exceeds Blind Person's allowance for the year. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-BPA-AMOUNT.1">The amount in box [CAL12] exceeds Blind Person's allowance for the year. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF4-MCA-AMOUNT.0">8236</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF4-MCA-AMOUNT.0">The amount in box [CAL13] exceeds [£11,270] for the year. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF4-MCA-AMOUNT.0">The amount in box [CAL13] exceeds [£11,270] for the year. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.X-SCHEDULE.o">6277</sch:diagnostic>
    <sch:diagnostic id="transactional.X-SCHEDULE.o">There is an entry in box [CAL14]. Please complete [AOI14] or [LUN28] or [FSE71] or [FSE72] or [FPS11] or [SPS11].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.X-SCHEDULE.o">There is an entry in box [CAL14]. Please complete [AOI14] or [LUN28] or [FSE71] or [FSE72] or [FPS11] or [SPS11].</sch:diagnostic>
    <sch:diagnostic id="errorCode.ITF-TAX-OP-FOR-EY-TOT.0">6597</sch:diagnostic>
    <sch:diagnostic id="transactional.ITF-TAX-OP-FOR-EY-TOT.0">There is an amount in box [CAL15], there must be an entry in at least one of the loss to carry back boxes: [FSE79], [SSE34], [LUN57], [FPS23], [SPS23], [CGT48] or [CGT43], or an entry in at least one of the adjustment boxes [FSE72], [FPS11] or [SPS11]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.ITF-TAX-OP-FOR-EY-TOT.0">There is an amount in box [CAL15], there must be an entry in at least one of the loss to carry back boxes: [FSE79], [SSE34], [LUN57], [FPS23], [SPS23], [CGT48] or [CGT43], or an entry in at least one of the adjustment boxes [FSE72], [FPS11] or [SPS11]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.MTR-ATTACHMENT.1">6790</sch:diagnostic>
    <sch:diagnostic id="transactional.MTR-ATTACHMENT.1">The attachment content must be a PDF file.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.MTR-ATTACHMENT.1">The attachment content must be a PDF file.</sch:diagnostic>
  </sch:diagnostics>
</sch:schema>
